﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
 
componentDateAndTime = function(name)
{
	this.componentDateAndTime = __componentText;
	this.componentDateAndTime(name);
	
	this.arrDayShort = new Array('Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun','Error');
	this.arrMonthShort = new Array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec','Error'); 
	this.timerID = null;
	this.source = '';
};

componentDateAndTime.prototype = new __componentText;
componentDateAndTime.prototype.type = "componentDateAndTime";

componentDateAndTime.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();

	this.arrDay = this.textDays.split(",");
	this.arrMonth = this.textMonths.split(",");
	
	this.source = this.text;
	
	var pageState = PageInterface.GetValue("state");
	if (pageState != psDesigning) { 
		this.text = this.makeDateTime(this.source);
	};
};

componentDateAndTime.prototype.onLoad = function(obj)
{
	this.go();
};

componentDateAndTime.prototype.findIndex = function(arr, text)
{
	for (var i=0; i < arr.length; i++)
		if (text == arr[i]) return i;
	return arr.length;
};

componentDateAndTime.prototype.replaceAll = function(arr1, arr2, text)
{

	if (arr1.length == arr2.length) {
		var regex = null;
		for (var i=0; i<arr1.length; i++) {
			regex = new RegExp(arr1[i], "g");
			text = text.replace(regex,arr2[i]);
		};
		return text;
	} else return false;
};

componentDateAndTime.prototype.makeDateTime = function(text)
{
	var data = new Date();
	var arrData = data.toString().split(' ');
	
	var D = this.arrDay[this.findIndex(this.arrDayShort, arrData[0])];
	var M = this.arrMonth[this.findIndex(this.arrMonthShort, arrData[1])];
	
	var m = data.getMonth() + 1;
	var mm = ("0" + m).slice(-2); 
	
	var dd = arrData[2];
	var d = parseInt(arrData[2]);
	
	var time = arrData[3].toString().split(":");
	if (is.moz) {
		var hh = data.getHours();
		var ii = data.getMinutes();
		var ss = data.getSeconds();
		
		var h = parseInt(hh);
		var i = parseInt(ii);
		var s = parseInt(ss);		

		var Y = arrData[3];
		var y = Y.substring(2);
	} else {
		var hh = time[0];
		var ii = time[1];
		var ss = time[2];
		
		var h = parseInt(time[0]);
		var i = parseInt(time[1]);
		var s = parseInt(time[2]);
		
		var Y = arrData[5];
		var y = arrData[5].substring(2);		
	};
	
	var from = new Array(
						"\\[D\\]", 
						"\\[M\\]", 
						"\\[dd\\]", 
						"\\[d\\]", 
						"\\[hh\\]", 
						"\\[ii\\]", 
						"\\[ss\\]", 
						"\\[h\\]", 
						"\\[i\\]", 
						"\\[s\\]", 
						"\\[y\\]", 
						"\\[Y\\]", 
						"\\[m\\]", 
						"\\[mm\\]" 
						);
						
	var to   = new Array(
						D,
						M, 
						dd, 
						d, 
						hh, 
						ii, 
						ss, 
						h, 
						i, 
						s, 
						y, 
						Y, 
						m, 
						mm );						
	text = this.replaceAll(from, to, text);
	return text;
};

componentDateAndTime.prototype.onRepaint = function(obj)
{
	return;
}

componentDateAndTime.prototype.go = function()
{
	if (this.execution) {
		var content = this.findContentObj();
		if (content){
			content.innerHTML = this.makeDateTime(this.source);
			this.timerID = setTimeout("page.all['"+this.id+"'].go()",900);
		}
	} else {
		var thisInner = document.getElementById(this.id+"SPAN");
		if(thisInner!=null){
			document.getElementById(this.id+"SPAN").innerHTML = this.makeDateTime(this.source);
			this.timerID = setTimeout("page.all['"+this.id+"'].go()",900);
		};
	};
};

componentDateAndTime.prototype.onFree = function()
{
	if (this.timerID != null) window.clearTimeout(this.timerID);
};
