﻿
var treeImagesPath = '../tree/';

var TreeConfig = {
	rootIcon        : treeImagesPath + 'course.gif',
	pageBrowsedIcon : treeImagesPath + 'page_not_att.gif',
	pageCompleted   : treeImagesPath + 'page_completed.gif',
	pageDisabled    : treeImagesPath + 'page_disabled.gif',
	pageEnabled     : treeImagesPath + 'page_enabled.gif',
	pageFail        : treeImagesPath + 'page_fail.gif',
	pageIncomplete  : treeImagesPath + 'page_incomplete.gif',
	pageNotAtt      : treeImagesPath + 'page_not_att.gif',
	pagePass        : treeImagesPath + 'page_pass.gif',
	blankIcon       : treeImagesPath + 'blank.gif',
	plusIcon       : treeImagesPath + 'plus.gif',
	minusIcon       : treeImagesPath + 'minus.gif',
	defaultText     : 'Tree Item',
	defaultAction   : '',
	defaultTarget   : '_self',
	defaultBehavior : 'classic'
};

var TreeHandler = {
	idCounter : 0,
	idPrefix  : "tree-object-",
	all       : new Array(),
	behavior  : null,
	selected  : null,
	getId     : function() { return this.idPrefix + this.idCounter++; },
	toggle    : function (oItem) { this.all[oItem.id.replace('-plus','')].toggle(); },
	select    : function (oItem) { this.all[oItem.id.replace('-icon','')].select(); },
	focus     : function (oItem) { this.all[oItem.id.replace('-anchor','')].focus(); },
	blur      : function (oItem) { this.all[oItem.id.replace('-anchor','')].blur(); },
	cookies   : new WebFXCookie(),
	showRoot: false
};

/*
 * WebFXCookie class
 */

function WebFXCookie() {
	if (document.cookie.length) { this.cookies = ' ' + document.cookie; }
};

WebFXCookie.prototype.setCookie = function(key, value) {
	document.cookie = key + "=" + escape(value);
};

WebFXCookie.prototype.getCookie = function(key) {
	if (this.cookies) {
		var start = this.cookies.indexOf(' ' + key + '=');
		if (start == -1) { return null; }
		var end = this.cookies.indexOf(";", start);
		if (end == -1) { end = this.cookies.length; }
		end -= start;
		var cookie = this.cookies.substr(start,end);
		return unescape(cookie.substr(cookie.indexOf('=') + 1, cookie.length - cookie.indexOf('=') + 1));
	} else { return null; }
};

/*
 * TreeAbstractNode class
 */

function TreeAbstractNode(sText, sAction, sTarget) {
	this.childNodes  = [];
	this.id     = TreeHandler.getId();
	this.text   = sText || TreeConfig.defaultText;
	this.action = sAction || TreeConfig.defaultAction;
	this.targetWindow = sTarget || TreeConfig.defaultTarget;
	this._last  = false;
	TreeHandler.all[this.id] = this;
};

TreeAbstractNode.prototype.add = function(node) {
	node.parentNode = this;
	this.childNodes[this.childNodes.length] = node;
	var root = this;
	if (this.childNodes.length >=2) {
		this.childNodes[this.childNodes.length -2]._last = false;
	};
	while (root.parentNode) { root = root.parentNode; }
	if (root.rendered) {
		if (this.childNodes.length >= 2) {
			document.getElementById(this.childNodes[this.childNodes.length -2].id + '-plus').src = ((this.childNodes[this.childNodes.length -2].folder)?TreeConfig.minusIcon:TreeConfig.blankIcon);
			if (this.childNodes[this.childNodes.length -2].folder) {
				this.childNodes[this.childNodes.length -2].plusIcon = TreeConfig.plusIcon;
				this.childNodes[this.childNodes.length -2].minusIcon = TreeConfig.minusIcon;
			};
			this.childNodes[this.childNodes.length -2]._last = false;
		};
		this._last = true;
		var foo = this;
		while (foo.parentNode) {
			for (var i = 0; i < foo.parentNode.childNodes.length; i++) {
				if (foo.id == foo.parentNode.childNodes[i].id) { break; }
			};
			if (++i == foo.parentNode.childNodes.length) {
				foo.parentNode._last = true;
			} else {
				foo.parentNode._last = false;
			};
			foo = foo.parentNode;
		};
		document.getElementById(this.id + '-cont').insertAdjacentHTML("beforeEnd", node.toString());
		this.folder = true;
		this.indent();
		this.expand();
	};
	return node;
};

TreeAbstractNode.prototype.toggle = function() {
	if (this.folder) {
		if (this.open) {
			this.collapse();
		} else {
			this.expand();
		};
	};
};

TreeAbstractNode.prototype.select = function() {
//	document.getElementById(this.id + '-anchor').focus();
};

TreeAbstractNode.prototype.focus = function() {
	TreeHandler.selected = this;
	if (typeof(TreeItemEventHandler) == 'function') TreeItemEventHandler('focus'); //pg2-pga autoscroll tree
};

TreeAbstractNode.prototype.blur = function() {
//	document.getElementById(this.id + '-anchor').style.backgroundColor = 'transparent';
//	document.getElementById(this.id + '-anchor').style.color = 'menutext';
};

TreeAbstractNode.prototype.doExpand = function() {
	if (this.childNodes.length) {
		document.getElementById(this.id + '-cont').style.display = 'block';
	};
	this.open = true;
	TreeHandler.cookies.setCookie(this.id.substr(18,this.id.length - 18), '1');
};

TreeAbstractNode.prototype.doCollapse = function() {
//	if (TreeHandler.behavior == 'classic') { document.getElementById(this.id + '-icon').src = this.icon; }
	if (this.childNodes.length) {
		document.getElementById(this.id + '-cont').style.display = 'none';
	};
	this.open = false;
	TreeHandler.cookies.setCookie(this.id.substr(18,this.id.length - 18), '0');
};

TreeAbstractNode.prototype.expandAll = function() {
	this.expandChildren();
	if ((this.folder) && (!this.open)) {
		this.expand();
	};
};

TreeAbstractNode.prototype.expandChildren = function() {
	for (var i = 0; i < this.childNodes.length; i++) {
		this.childNodes[i].expandAll();
	};
};

TreeAbstractNode.prototype.collapseAll = function() {
	if ((this.folder) && (this.open)) {
		this.collapse();
	};
	this.collapseChildren();
};

TreeAbstractNode.prototype.collapseChildren = function() {
	for (var i = 0; i < this.childNodes.length; i++) {
		this.childNodes[i].collapseAll();
	};
};

TreeAbstractNode.prototype.indent = function(lvl, del, last, level) {
	/*
	 * Since we only want to modify items one level below ourself,
	 * and since the rightmost indentation position is occupied by
	 * the plus icon we set this to -2
	 */
	if (lvl == null) { lvl = -2; }
	var state = 0;
	for (var i = this.childNodes.length - 1; i >= 0 ; i--) {
		state = this.childNodes[i].indent(lvl + 1, del, last, level);
		if (state) {
			return;
		};
	};
	if (del) {
		if (level >= this._level) {
			if (this.folder) {
				document.getElementById(this.id + '-plus').src = (this.open)?TreeConfig.minusIcon:TreeConfig.plusIcon;
				this.plusIcon = TreeConfig.plusIcon;
				this.minusIcon = TreeConfig.minusIcon;
			} else {
				document.getElementById(this.id + '-plus').src = TreeConfig.blankIcon;
			};
			return 1;
		};
	};
	var foo = document.getElementById(this.id + '-indent-' + lvl);
	if (foo) {
		if ((del) && (last)) {
			foo._last = true;
		};
		foo.src =  TreeConfig.blankIcon;
	};
	return 0;
};

/*
 * Tree class
 */

function Tree(sText, sAction, sBehavior, sIcon) {
	this.base = TreeAbstractNode;
	this.base(sText, sAction);
	this.icon      = sIcon || TreeConfig.rootIcon;
	/* Defaults to open */
	this.open      = (TreeHandler.cookies.getCookie(this.id.substr(18,this.id.length - 18)) == '0')?false:true;
	this.folder    = true;
	this.rendered  = false;
	if (!TreeHandler.behavior) {  TreeHandler.behavior = sBehavior || TreeConfig.defaultBehavior; }
	this.targetWindow = 'MainFrame';
};

Tree.prototype = new TreeAbstractNode;

Tree.prototype.setBehavior = function(sBehavior) {
	TreeHandler.behavior = sBehavior;
};

Tree.prototype.getBehavior = function(sBehavior) {
	return TreeHandler.behavior;
};

Tree.prototype.getSelected = function() {
	if (TreeHandler.selected) {
		return TreeHandler.selected;
	} else {
		return null;
	};
};

Tree.prototype.remove = function() { };

Tree.prototype.expand = function() {
	this.doExpand();
};

Tree.prototype.collapse = function() {
	this.focus();
	this.doCollapse();
};

Tree.prototype.getFirst = function() {
	return null;
};

Tree.prototype.getLast = function() {
	return null;
};

Tree.prototype.getNextSibling = function() {
	return null;
};

Tree.prototype.getPreviousSibling = function() {
	return null;
};

Tree.prototype.toString = function() {
	var str = "";
	if (TreeHandler.showRoot) {
		str += "<div id=\"" + this.id + "\" ondblclick=\"TreeHandler.toggle(this);\" class=\"tree-item\" >";
		str += "<img id=\"" + this.id + "-icon\" class=\"tree-icon\" src=\"" + this.icon + "\" onclick=\"TreeHandler.select(this);\">";
		if (this.action != "") {
			str += "<a href=\"" + this.action + "\" id=\"" + this.id + "-anchor\" target=\"" + this.targetWindow + "\" onfocus=\"TreeHandler.focus(this);\" onblur=\"TreeHandler.blur(this);\"><span id=\"" + this.id + "-title\">" + this.text + "</span></a>";
		} else {
			str += "<span class=\"norco\">" + this.text + "</span>";
		};
		str += "</div>";
	};
	str += "<div id=\"" + this.id + "-cont\" class=\"tree-container\" style=\"display: " + ((this.open)?'block':'none') + ";\">";
	for (var i = 0; i < this.childNodes.length; i++) {
		str += this.childNodes[i].toString(i, this.childNodes.length);
	};
	str += "</div>";
	this.rendered = true;
	return str;
};

/*
 * TreeItem class
 */

function TreeItem(sText, sAction, eParent, sIcon) {
	this.base = TreeAbstractNode;
	this.base(sText, sAction);
	/* Defaults to close */
	this.open = (TreeHandler.cookies.getCookie(this.id.substr(18,this.id.length - 18)) == '1')?true:false;
	if (eParent) {
		eParent.add(this);
	};
	if (sIcon) {
		this.icon = sIcon;
	};
};

TreeItem.prototype = new TreeAbstractNode;

TreeItem.prototype.remove = function() {
	var parentNode = this.parentNode;
	var prevSibling = this.getPreviousSibling(true);
	var nextSibling = this.getNextSibling(true);
	var folder = this.parentNode.folder;
	var last = ((nextSibling) && (nextSibling.parentNode) && (nextSibling.parentNode.id == parentNode.id))?false:true;
	this.getPreviousSibling().focus();
	this._remove();
	if (parentNode.childNodes.length == 0) {
		parentNode.folder = false;
		parentNode.open = false;
	};
	if (last) {
		if (parentNode.id == prevSibling.id) {
			document.getElementById(parentNode.id + '-icon').src = TreeConfig.pageNotAtt;
		} else { }; //pg2- ???
	};
	if ((!prevSibling.parentNode) || (prevSibling.parentNode != parentNode)) {
		parentNode.indent(null, true, last, this._level);
	};
	if (document.getElementById(prevSibling.id + '-plus')) {
		document.getElementById(prevSibling.id + '-plus').src = TreeConfig.blankIcon;
//		if (nextSibling) {
//			if ((parentNode == prevSibling) && (parentNode.getNextSibling))  { document.getElementById(prevSibling.id + '-plus').src = TreeConfig.tIcon; }
//			else if (nextSibling.parentNode != prevSibling) { document.getElementById(prevSibling.id + '-plus').src = TreeConfig.lIcon; }
//		}
//		else { document.getElementById(prevSibling.id + '-plus').src = TreeConfig.lIcon; }
	};
};

TreeItem.prototype._remove = function() {
	for (var i = this.childNodes.length - 1; i >= 0; i--) {
		this.childNodes[i]._remove();
 	};
	for (var i = 0; i < this.parentNode.childNodes.length; i++) {
		if (this.id == this.parentNode.childNodes[i].id) {
			for (var j = i; j < this.parentNode.childNodes.length; j++) {
				this.parentNode.childNodes[i] = this.parentNode.childNodes[i+1]
			};
			this.parentNode.childNodes.length = this.parentNode.childNodes.length - 1;
			if (i + 1 == this.parentNode.childNodes.length) {
				this.parentNode._last = true;
			};
		};
	};
	TreeHandler.all[this.id] = null;
	if (document.getElementById(this.id)) {
		document.getElementById(this.id).innerHTML = "";
		document.getElementById(this.id).removeNode();
	};
};

TreeItem.prototype.expand = function() {
	this.doExpand();
	document.getElementById(this.id + '-plus').src = this.minusIcon;
};

TreeItem.prototype.collapse = function() {
	this.focus();
	this.doCollapse();
	document.getElementById(this.id + '-plus').src = this.plusIcon;
};

TreeItem.prototype.getFirst = function() {
	return this.childNodes[0];
};

TreeItem.prototype.getLast = function() {
	if (this.childNodes[this.childNodes.length - 1].open) {
		return this.childNodes[this.childNodes.length - 1].getLast();
	} else {
		return this.childNodes[this.childNodes.length - 1];
	};
};

TreeItem.prototype.getNextSibling = function() {
	for (var i = 0; i < this.parentNode.childNodes.length; i++) {
		if (this == this.parentNode.childNodes[i]) { break; }
	};
	if (++i == this.parentNode.childNodes.length) {
		return this.parentNode.getNextSibling();
	} else {
		return this.parentNode.childNodes[i];
	};
};

TreeItem.prototype.getPreviousSibling = function(b) {
	for (var i = 0; i < this.parentNode.childNodes.length; i++) {
		if (this == this.parentNode.childNodes[i]) break;
	};
	if (i == 0) {
		return this.parentNode; 
	} else {
		if ((this.parentNode.childNodes[--i].open) || (b && this.parentNode.childNodes[i].folder)) {
			return this.parentNode.childNodes[i].getLast(); 
		} else { 
			return this.parentNode.childNodes[i]; 
		};
	};
};

TreeItem.prototype.toString = function(nItem, nItemCount) {
	var foo = this.parentNode;
	var indent = '';
	if (nItem + 1 == nItemCount) {
		this.parentNode._last = true;
	};
	var i = 0;
	while (foo.parentNode) {
		foo = foo.parentNode;
		indent = "<img id=\"" + this.id + "-indent-" + i + "\" src=\"" + TreeConfig.blankIcon + "\">" + indent;
		i++;
	};
	this._level = i;
	if (this.childNodes.length) {
		this.folder = 1;
	} else {
		this.open = false;
	};
	this.icon = TreeConfig.pageNotAtt;
	var label = this.text;
	label = label.replace('<', '<');
	label = label.replace('>', '>');
	var str = "<div id=\"" + this.id + "\" ondblclick=\"TreeHandler.toggle(this);\" class=\"tree-item\" >";
	str += indent;
	str += "<img id=\"" + this.id + "-plus\" src=\"" + ((this.folder)?((this.open)?((this.parentNode._last)?TreeConfig.minusIcon:TreeConfig.minusIcon):((this.parentNode._last)?TreeConfig.plusIcon:TreeConfig.plusIcon)):TreeConfig.blankIcon) + "\" onclick=\"TreeHandler.toggle(this);\">"
	str += "<img id=\"" + this.id + "-icon\" src=\"" + this.icon + "\" onclick=\"TreeHandler.select(this);\">";
	if (this.action == "") {
		str += "<span class=\"norco\">" + label + "</span>";
	} else {
		str += "<a href=\"" + this.action + "\" id=\"" + this.id + "-anchor\" target=\"" + this.targetWindow + "\" onfocus=\"TreeHandler.focus(this);\" onblur=\"TreeHandler.blur(this);\" title=\"" + label + "\"><span id=\"" + this.id + "-title\">" + label + "</span></a>";
	};
	str += "</div>";
	str += "<div id=\"" + this.id + "-cont\" class=\"tree-container\" style=\"display: " + ((this.open)?'block':'none') + ";\">";
	for (var i = 0; i < this.childNodes.length; i++) {
		str += this.childNodes[i].toString(i,this.childNodes.length);
	};
	str += "</div>";
	this.plusIcon = ((this.parentNode._last)?TreeConfig.plusIcon:TreeConfig.plusIcon);
	this.minusIcon = ((this.parentNode._last)?TreeConfig.minusIcon:TreeConfig.minusIcon);
	return str;
};
