﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentTypeWriter = function(name)
{
	this.componentText = componentText;
	this.componentText(name);
	
	this.timer = null;
	this.matches = new Array();
	this.newText = "";
	this.alreadyRun = false;
	
	this.lastObject = null;
	this.contentObj = null;
};

componentTypeWriter.prototype = new componentText();
componentTypeWriter.prototype.type = "componentTypeWriter";

componentTypeWriter.prototype.componentBaseTypeWriterOnCreate = componentTypeWriter.prototype.onCreate;
componentTypeWriter.prototype.onCreate = function(obj)
{
	if (PageInterface.GetValue("state") != psDesigning)	{
		var m = this.text.match(/(<[^<>]*>)|([^<>]*)/g);

		for (var i = 0; i < m.length; i++) {
			if (m[i].charAt(0) == "<") {
				this.matches.push(m[i]);
			} else {
				m[i] = m[i].replace("&nbsp;"," ");
				for (var j = 0; j < m[i].length; j++) {
					this.matches.push(m[i].charAt(j));
				};
			};
		};
	};
	this.componentBaseTypeWriterOnCreate(obj);
};

componentTypeWriter.prototype.typeWriter = function(count)
{
	if (!this.visible) return;
	var content = this.findContentObj();
	if	(content) {
		this.newText += this.matches[count];
		content.innerHTML = this.newText;
		count++;
	};
	
	if (count < this.matches.length) {	
		this.timer = setTimeout("page.all['"+this.id+"'].typeWriter("+count+");", this.textShowTimeInterval);
	};
};

componentTypeWriter.prototype.onShow = function()
{	
	this.clearTypeWriter();
};

componentTypeWriter.prototype.componentTypeWriterBaseShow = componentTypeWriter.prototype.show;
componentTypeWriter.prototype.show = function()
{
	this.componentTypeWriterBaseShow();
	if (PageInterface.GetValue("state") != psDesigning && this.timer == null) {
		if (!this.alreadyRun) {
			this.alreadyRun = true;
			this.typeWriter(0);
		};
	};
};

componentTypeWriter.prototype.clearTypeWriter = function()
{
	this.alreadyRun = false;
	this.newText = "";
	this.onFree();
};

componentTypeWriter.prototype.onHide = function()
{
	this.clearTypeWriter();
};

componentTypeWriter.prototype.onFree = function()
{
	if (this.timer != null){
		window.clearTimeout(this.timer);
		this.timer = null;
	};
};
