var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Clock;
var zad_zaliczone = 0;
(function (_Clock) {
    var Clock = (function (_super) {
        __extends(Clock, _super);
        function Clock(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Clock.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        Clock.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Clock.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            this.createClocks();
        };
        Clock.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Clock.prototype.createClocks = function () {
            this.Clocks = [];
            this.ClickedHand = null;
            for (var i = 0; i < this.Elements.Clocks.length; i++) {
                var face, hand1, hand2;
                face = this.game.add.sprite(0, 0, this.PREFIX + this.Elements.Clocks[i].Face.key);
                hand1 = this.game.add.sprite(0, 0, this.PREFIX + this.Elements.Clocks[i].Hand2.key);
                hand2 = this.game.add.sprite(0, 0, this.PREFIX + this.Elements.Clocks[i].Hand1.key);
                face.scale.set(0.6, 0.6);
                hand1.scale.set(0.6, 0.6);
                hand2.scale.set(0.6, 0.6);
                hand1.anchor.set(0.5, 0.95);
                hand2.anchor.set(0.5, 0.9);
                hand1.name = 2 * i;
                hand2.name = 2 * i + 1;
                hand2.inputEnabled = true;
                hand2.events.onInputOver.add(this.onInputOver, this);
                hand2.events.onInputOut.add(this.onInputOut, this);
                hand2.events.onInputDown.add(this.onInputDown, this);
                if (this.Elements.Snap == true)
                    hand2.events.onInputUp.add(this.onInputUpSnap, this);
                else
                    hand2.events.onInputUp.add(this.onInputUp, this);
                hand1.inputEnabled = true;
                hand1.events.onInputOver.add(this.onInputOver, this);
                hand1.events.onInputOut.add(this.onInputOut, this);
                hand1.events.onInputDown.add(this.onInputDown, this);
                if (this.Elements.Snap == true)
                    hand1.events.onInputUp.add(this.onInputUpSnap, this);
                else
                    hand1.events.onInputUp.add(this.onInputUp, this);
                var posX = this.Elements.Clocks[i].Position.x;
                var posY = this.Elements.Clocks[i].Position.y;
                if (this.Elements.Options.Just) {
                    switch (this.Elements.Options.Just.x) {
                        case "center":
                            posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                            face.anchor.x = 0.5;
                            break;
                        case "right":
                            posX += Global.Main.mainContainerDims.wd - 120;
                            face.anchor.x = 1;
                            break;
                    }
                    switch (this.Elements.Options.Just.y) {
                        case "center":
                            posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                            face.anchor.y = 0.5;
                            break;
                        case "bottom":
                            posY += Global.Main.mainContainerDims.hg - 65;
                            face.anchor.y = 1;
                            break;
                    }
                }
                face.position.set(posX - 25, posY);
                this.addChild(face);
                hand1.position.set(posX, posY + face.height / 2);
                this.addChild(hand1);
                hand2.position.set(posX, posY + face.height / 2);
                this.addChild(hand2);
                this.Clocks.push({ "hand": hand1, "value": 12 });
                this.Clocks.push({ "hand": hand2, "value": 12 });
            }
        };
        Clock.prototype.update = function () {
            if (this.ClickedHand != null) {
                EU.Log(this.Clocks[this.ClickedHand].hand.angle);
                this.Clocks[this.ClickedHand].hand.angle = Phaser.Math.radToDeg(Phaser.Math.angleBetween(-this.Clocks[this.ClickedHand].hand.position.x, -this.Clocks[this.ClickedHand].hand.position.y, -(this.game.input.x - 120), -(this.game.input.y - 200))) - 90;
            }
        };
        Clock.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        Clock.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        Clock.prototype.onInputDown = function (el, pointer) {
            this.ClickedHand = el.name;
        };
        Clock.prototype.onInputUpSnap = function (el, pointer) {
            this.ClickedHand = null;
            if (el.angle > 0) {
                if ((el.angle % 30 - 15) < 0)
                    el.angle = 30 * Phaser.Math.floor(el.angle / 30);
                else
                    el.angle = 30 * (Phaser.Math.floor(el.angle / 30) + 1);
            }
            else {
                if ((el.angle % 30) > -15)
                    el.angle = -30 * Phaser.Math.floor(el.angle / -30);
                else
                    el.angle = -30 * (Phaser.Math.floor(el.angle / -30) + 1);
            }
            this.setHandValue(el);
            this.checkIfEverythingIsCorrect();
        };
        Clock.prototype.onInputUp = function (el, pointer) {
            this.ClickedHand = null;
            this.setHandValue(el);
            this.checkIfEverythingIsCorrect();
        };
        Clock.prototype.setHandValue = function (el) {
            if (el.angle > 0) {
                if ((el.angle % 30 - 15) < 0)
                    this.Clocks[el.name].value = Phaser.Math.floor(el.angle / 30);
                else
                    this.Clocks[el.name].value = (Phaser.Math.floor(el.angle / 30) + 1);
            }
            else {
                if ((el.angle % 30) > -15)
                    this.Clocks[el.name].value = 12 - Phaser.Math.floor(el.angle / -30);
                else
                    this.Clocks[el.name].value = 12 - (Phaser.Math.floor(el.angle / -30) + 1);
            }
            EU.Log(this.Clocks[el.name].value);
        };
        Clock.prototype.checkIfHourCorrect = function () {
            for (var i = 0; i < this.Elements.Clocks.length; i++) {
                if (this.Elements.Clocks[i].CorrectHours % 12 != this.Clocks[2 * i + 1].value)
                    return false;
                if (this.Elements.Clocks[i].CorrectMinutes / 5 != this.Clocks[2 * i].value)
                    return false;
            }
            return true;
        };
		Clock.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).pageChange();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
		Clock.prototype.prevScreen = function () {
			if(zad_zaliczone == 1){
				if (this.game.camera.x - Global.Main.dims.x > 0) {
					this.game.input.enabled = false;
					var tw = this.game.add.tween(this.game.camera);
					tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
					tw.onComplete.add(function () {
						this.game.input.enabled = true;
					}, this);
					tw.start();
					Global.Main.currentPageNumber--;
					if (this.json.Lector)
						Global.Main.returnPage(Global.Main.currentPageNumber).pageChange();
					console.log(Global.Main.currentPageNumber);
				}
			}
			else {
				//nic nie rób
			}
        };
        Clock.prototype.checkIfEverythingIsCorrect = function () {
            if (this.checkIfHourCorrect() && EU.checkIfFillsAreCorrect(this) && EU.checkIfSelectablesAreCorrect(this)) {
                //EU.setGameCompletion(this.parent, 1);
                if (TYPE === "gm") {
					var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
					var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
					prev.scale.setTo(0.8,0.8);
					this.addChild(prev);
                    _super.prototype.nextTask.call(this);
                }
                //EU.Log("Correct!");
				zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                return true;
            }
            //EU.setGameCompletion(this.parent, 0);
			zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            return false;
        };
        return Clock;
    })(Base.BasicGroup);
    _Clock.Clock = Clock;
})(Clock || (Clock = {}));
//# sourceMappingURL=Clock.js.map