var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Base;
(function (Base) {
    var BasicGroup = (function (_super) {
        __extends(BasicGroup, _super);
        function BasicGroup(game, name, x, y, json) {
            _super.call(this, game, null, name);
            this.x = x;
            this.y = y;
            this.init(json);
        }
        BasicGroup.prototype.init = function (json) {
            this.json = json;
        };
        BasicGroup.prototype.create = function () {
            this.gameCompletion = 0;
            if (this.json.MaxPoints)
                this.maxPoints = this.json.MaxPoints;
            else {
                this.maxPoints = 1;
            }
            this.width = 1920;
            this.height = 1080;
            this.backgroundImage = this.game.add.sprite(0, 0, "background");
            this.backgroundImage.scale.setTo(this.game.width / this.backgroundImage.width, this.game.height / this.backgroundImage.height);
            this.addChild(this.backgroundImage);
            this.page;
            var game_bg;
            switch (TYPE) {
                case "wc":
                    this.page = this.game.add.image(36, 20, "page");
                    break;
                case "ex":
                    this.page = this.game.add.image(36, 20, "examPage");
                    break;
                case "fi":
                    this.page = this.game.add.image(0, 0, "background");
                    break;
                case "gm":
                    if (this.json.altTexture != null) {
                        this.page = this.game.add.image(0, 0, this.json.altTexture.key);
                    }
                    else
                        this.page = this.game.add.image(0, 0, "background");
                    var tmp1 = MODULE.split("_");
                    if (tmp1[0] == "OB") {
                        var bookCover = this.game.add.image(0, 0, "book_cover");
                    }
                    game_bg = this.game.add.image(300, 45, "game_bg");
                    break;
            }
            this.addChild(this.page);
            if (TYPE === "gm") {
                var tmp1 = MODULE.split("_");
                if (tmp1[0] == "OB")
                    this.addChild(bookCover);
                this.addChild(game_bg);
            }
            if (!this.json.isFirst) {
                var prev = this.game.add.button(95, 960, "prev", this.prevTask, this, 0, 0, 1, 0);
                prev.scale.setTo(0.8, 0.8);
                this.addChild(prev);
            }
            if (TYPE !== "gm" && TYPE !== "fi") {
                this.nxtButton = this.game.add.button(this.game.width - 76 - 120, 960, "next", this.nextTask, this, 0, 0, 1, 0);
                this.nxtButton.scale.setTo(0.8, 0.8);
                this.addChild(this.nxtButton);
            }
            if (TYPE === "gm") {
                var txt = this.game.add.text(0, 59, this.json.description, { font: "42px Arial", wordWrap: true, wordWrapWidth: 1200 });
            }
            else {
                var txt = this.game.add.text(0, 79, this.json.description, { wordWrap: true, wordWrapWidth: 1200 });
            }
            txt.anchor.set(0.5, 0);
            txt.x = this.game.width / 2;
            this.addChild(txt);
            if (this.json.Lector) {
                if (TYPE !== "gm") {
                    var spkr = this.game.add.button(this.game.width - 160, 79, "speaker", this.playLector, this, 0, 0, 1, 0);
                    this.addChild(spkr);
                }
            }
            this.mainContainer = this.game.add.group(this, "mainContainer");
            if (TYPE == "wc" || TYPE == "ex" || TYPE == "fi") {
                this.mainContainer.x = Global.Main.mainContainerDims.x;
                this.mainContainer.y = Global.Main.mainContainerDims.y;
                this.mainContainer.width = Global.Main.mainContainerDims.wd;
                this.mainContainer.height = Global.Main.mainContainerDims.hg;
                this.addChild(this.mainContainer);
            }
            else {
                this.mainContainer.x = 0;
                this.mainContainer.y = 0;
                this.mainContainer.width = 1920;
                this.mainContainer.height = 1080;
                this.addChild(this.mainContainer);
            }
        };
        BasicGroup.prototype.showText = function () {
            console.log(this.description);
        };
        BasicGroup.prototype.preload = function () {
            this.game.load.image("background", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_background.jpg");
            this.game.load.spritesheet("prev", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_button_previous.png", 120, 120, 2);
            this.game.load.spritesheet("next", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_button_next.png", 120, 120, 2);
            this.game.load.spritesheet("speaker", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_button_glosnik.png", 68, 56, 2);
            if (TYPE === "fi")
                this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/I/" + CardChooser.getModule() + "_przewodnik_start.png");
            else
                this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getCardClass() + "/" + CardChooser.getModule() + "_main_przewodnik.png");
            this.game.load.image("title", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_tytul_" + CardChooser.getModule() + ".png");
            this.game.load.image("cloud", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_dymek_" + CardChooser.getModule() + ".png");
            this.game.load.image("page", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_kartka.png");
            this.game.load.image("examPage", "Graphics/GUI/ALL_sprawdzian_kartka.png");
            this.game.load.image("game_bg", "Graphics/GUI/ramka_g_polecenie.png");
            this.game.load.spritesheet("finish", "Graphics/GUI/ALL_sprawdzian_button_zakoncz.png", 280, 100, 2, 0, 0);
            var tmp1 = MODULE.split("_");
            if (tmp1[0] == "OB") {
                this.game.load.image("book_cover", "Graphics/GUI/" + CardChooser.getModule() + "/OB_book.png");
            }
            if (this.json.altTexture != null) {
                this.game.load.image(this.json.altTexture.key, this.json.altTexture.src);
            }
        };
        BasicGroup.prototype.playLector = function () {
            try {
                if (!this.lector) {
                    this.lector = new Audio("Sounds/" + this.json.Lector);
                }
                Global.Main.PlayMusic(this.lector);
            }
            catch (e) {
                EU.Log("ERROR LOADING AUDIO");
            }
        };
		BasicGroup.prototype.pageChange = function () {
			snd = new Audio("Sounds/page.mp3");
			snd.load();
			snd.loop = false;
			snd.play();
		};
        BasicGroup.prototype.nextTask = function () {
            if (this.gameCompletion < 1 && (TYPE === "wc" || TYPE === "gm" || TYPE === "fi"))
                return false;
            EU.Log("game completion: " + this.gameCompletion);
            this.game.input.enabled = false;
            EU.killKeyboard();
            var tw = this.game.add.tween(this.game.camera);
            tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
            tw.onComplete.add(function () {
                this.game.input.enabled = true;
            }, this);
            tw.start();
            Global.Main.currentPageNumber++;
            Global.Main.returnPage(Global.Main.currentPageNumber).pageChange();
            console.log(Global.Main.currentPageNumber);
        };
        BasicGroup.prototype.prevTask = function () {
            if (this.game.camera.x - Global.Main.dims.x > 0) {
                this.game.input.enabled = false;
                var tw = this.game.add.tween(this.game.camera);
                tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
                tw.onComplete.add(function () {
                    this.game.input.enabled = true;
                }, this);
                tw.start();
                Global.Main.currentPageNumber--;
                if (this.json.Lector){
                    Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				} else {
					this.pageChange();
				}
                console.log(Global.Main.currentPageNumber);
            }
        };
        return BasicGroup;
    })(Phaser.Group);
    Base.BasicGroup = BasicGroup;
    var BeginGroup = (function (_super) {
        __extends(BeginGroup, _super);
        function BeginGroup(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        BeginGroup.prototype.create = function () {
            Global.Main.currentPageNumber = 0;
            this.backgroundImage = this.game.add.sprite(0, 0, "background");
            this.backgroundImage.scale.setTo(this.game.width / this.backgroundImage.width, this.game.height / this.backgroundImage.height);
            this.addChild(this.backgroundImage);
            var page;
            switch (TYPE) {
                case "wc":
                    page = this.game.add.image(36, 20, "page");
                    this.addChild(page);
                    var cloud = this.game.add.image(0, 0, "cloud", 0, this);
                    cloud.position.setTo(this.width * 0.28, this.height * 0.25);
                    var txt = this.game.add.text(0, 0, "Kliknij aby rozpocząć", { font: "42pt Arial", wordWrap: true, wordWrapWidth: cloud.width }, this);
                    txt.anchor.set(0.55, 0.5);
                    txt.position.setTo(cloud.width / 2, cloud.height / 2);
                    cloud.addChild(txt);
                    cloud.inputEnabled = true;
                    cloud.events.onInputUp.add(this.begin, this);
                    var guide = this.game.add.image(0, 0, "guide", 0, this);
                    guide.position.setTo(this.width - 50 - guide.width, this.height - guide.height);
                    this.gameCompletion = 1;
                    break;
                case "ex":
                    page = this.game.add.image(36, 20, "examPage");
                    this.addChild(page);
                    var cloud = this.game.add.image(0, 0, "cloud", 0, this);
                    cloud.position.setTo(this.width * 0.28, this.height * 0.25);
                    var txt = this.game.add.text(0, 0, "Kliknij aby rozpocząć", { font: "42pt Arial", wordWrap: true, wordWrapWidth: cloud.width }, this);
                    txt.anchor.set(0.55, 0.5);
                    txt.position.setTo(cloud.width / 2, cloud.height / 2);
                    cloud.addChild(txt);
                    cloud.inputEnabled = true;
                    cloud.events.onInputUp.add(this.begin, this);
                    var guide = this.game.add.image(0, 0, "guide", 0, this);
                    guide.position.setTo(this.width - 50 - guide.width, this.height - guide.height);
                    this.gameCompletion = 1;
                    break;
                case "gm":
                    page = this.game.add.image(0, 0, "background");
                    this.addChild(page);
                    var cloud = this.game.add.image(0, 0, "main_tytul", 0, this);
                    cloud.position.setTo(this.width * 0.23, this.height * 0.15);
                    var playbutton = this.game.add.button(0, 0, "main_button_play", this.begin, this, 1, 0, 2, 0);
                    playbutton.position.setTo(this.width * 0.24, this.height * 0.64);
                    this.addChild(playbutton);
                    var tmp1 = MODULE.split("_");
                    if (tmp1[0] == "OB") {
                        var bookCover = this.game.add.image(0, 0, "book_cover");
                        if (TYPE === "gm") {
                            var tmp1 = MODULE.split("_");
                            if (tmp1[0] == "OB")
                                this.addChild(bookCover);
                        }
                    }
                    var sponsorzy = this.game.add.image(0, 0, "sponsorzy", 0, this);
                    sponsorzy.position.setTo(this.width - sponsorzy.width, this.height - sponsorzy.height);
                    var guide = this.game.add.image(0, 0, "main_przewodnik", 0, this);
                    guide.position.setTo(this.width - 50 - guide.width, this.height - guide.height - sponsorzy.height + 10);
                    this.gameCompletion = 1;
                    break;
                case "fi":
                    page = this.game.add.image(0, 0, "background");
                    this.addChild(page);
                    var cloud = this.game.add.image(0, 0, "main_tytul", 0, this);
                    cloud.position.setTo(this.width * 0.23, this.height * 0.15);
                    var playbutton = this.game.add.button(0, 0, "main_button_play", this.begin, this, 1, 0, 2, 0);
                    playbutton.position.setTo(this.width * 0.24, this.height * 0.64);
                    this.addChild(playbutton);
                    var sponsorzy = this.game.add.image(0, 0, "sponsorzy", 0, this);
                    sponsorzy.position.setTo(this.width - sponsorzy.width, this.height - sponsorzy.height);
                    var guide = this.game.add.image(0, 0, "main_przewodnik", 0, this);
                    guide.position.setTo(this.width - 50 - guide.width, this.height - guide.height - sponsorzy.height + 10);
                    this.gameCompletion = 1;
                    break;
            }
        };
        BeginGroup.prototype.preload = function () {
            this.game.load.image("background", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_background.jpg");
            this.game.load.image("cloud", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_dymek_" + CardChooser.getModule() + ".png");
            this.game.load.image("page", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_kartka.png");
            if (TYPE === "fi")
                this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/I/" + CardChooser.getModule() + "_przewodnik_start.png");
            else
                this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getCardClass() + "/" + CardChooser.getModule() + "_przewodnik_start.png");
            this.game.load.image("sponsorzy", "Graphics/GUI/" + CardChooser.getModule() + "/sponsorzy.png");
            this.game.load.spritesheet("main_button_play", "Graphics/GUI/" + CardChooser.getModule() + "/main_button_play.png", 200, 200, 3);
            this.game.load.image("main_przewodnik", "Graphics/GUI/" + CardChooser.getModule() + "/main_przewodnik.png");
            this.game.load.image("main_tytul", "Graphics/GUI/" + CardChooser.getModule() + "/main_tytul.png");
            var tmp1 = MODULE.split("_");
            if (tmp1[0] == "OB") {
                this.game.load.image("book_cover", "Graphics/GUI/" + CardChooser.getModule() + "/OB_book.png");
            }
        };
        BeginGroup.prototype.begin = function () {
            Global.Main.currentPageNumber = 0;
            this.nextTask();
        };
        return BeginGroup;
    })(Base.BasicGroup);
    Base.BeginGroup = BeginGroup;
    var EndGroup = (function (_super) {
        __extends(EndGroup, _super);
        function EndGroup(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        EndGroup.prototype.create = function () {
            this.backgroundImage = this.game.add.sprite(0, 0, "background");
            this.backgroundImage.scale.setTo(this.game.width / this.backgroundImage.width, this.game.height / this.backgroundImage.height);
            this.addChild(this.backgroundImage);
            var prev = this.game.add.button(95, 930, "prev", this.prevTask, this, 0, 0, 1, 0);
            prev.scale.setTo(0.8, 0.8);
            var page;
            switch (TYPE) {
                case "wc":
                    page = this.game.add.image(36, 20, "page");
                    this.FinishButton = this.game.add.button(page.width / 2, 920, "finish", this.finishWorkCard, this, 0, 0, 1, 0);
                    this.FinishButton.anchor.set(0.5, 0.5);
                    break;
                case "ex":
                    page = this.game.add.image(36, 20, "examPage");
                    this.FinishButton = this.game.add.button(page.width / 2, 920, "finish", this.finishExam, this, 0, 0, 1, 0);
                    this.FinishButton.anchor.set(0.5, 0.5);
                    break;
                case "gm":
                    page = this.game.add.image(36, 20, "page");
                    this.FinishButton = this.game.add.button(page.width / 2, 920, "finish", this.finishGame, this, 0, 0, 1, 0);
                    this.FinishButton.anchor.set(0.5, 0.5);
                    break;
                case "fi":
                    page = this.game.add.image(36, 20, "page");
                    this.FinishButton = this.game.add.button(page.width / 2, 920, "finish", this.finishGame, this, 0, 0, 1, 0);
                    this.FinishButton.anchor.set(0.5, 0.5);
                    break;
            }
            this.addChild(page);
            this.addChild(prev);
            this.cloud = this.game.add.image(0, 0, "cloud", 0, this);
            this.cloud.position.setTo(this.width * 0.28, this.height * 0.25);
            this.guide = this.game.add.image(0, 0, "guide", 0, this);
            this.guide.position.setTo(this.width - 50 - this.guide.width, this.height - this.guide.height);
            this.addChild(this.FinishButton);
            var txt;
            switch (TYPE) {
                case "wc":
                    txt = this.game.add.text(10, 0, "Kliknij ZAKOŃCZ, aby ukończyć kartę pracy", { font: "32pt Arial", wordWrap: true, wordWrapWidth: this.cloud.width - 80 }, this);
                    txt.anchor.set(0.55, 0.5);
                    txt.position.setTo(this.cloud.width / 2, this.cloud.height / 2);
                    break;
                case "ex":
                    txt = this.game.add.text(0, 0, "To już koniec.Cofnij się by sprawdzić odpowiedzi lub kliknij zakończ", { font: "32pt Arial", wordWrap: true, wordWrapWidth: this.cloud.width - 80 }, this);
                    txt.anchor.set(0.55, 0.5);
                    txt.position.setTo(this.cloud.width / 2, this.cloud.height / 2);
                    break;
                case "gm":
                    txt = this.game.add.text(10, 0, "Kliknij ZAKOŃCZ, aby ukończyć grę.", { font: "32pt Arial", wordWrap: true, wordWrapWidth: this.cloud.width - 80 }, this);
                    txt.anchor.set(0.55, 0.5);
                    txt.position.setTo(this.cloud.width / 2, this.cloud.height / 2);
                    break;
                case "fi":
                    txt = this.game.add.text(10, 0, "Kliknij ZAKOŃCZ, aby ukończyć grę.", { font: "32pt Arial", wordWrap: true, wordWrapWidth: this.cloud.width - 80 }, this);
                    txt.anchor.set(0.55, 0.5);
                    txt.position.setTo(this.cloud.width / 2, this.cloud.height / 2);
                    break;
            }
            this.cloud.addChild(txt);
        };
        EndGroup.prototype.finishWorkCard = function () {
            var txt = this.game.add.text(this.game.width / 2, this.game.height / 2, "Ukończono kartę pracy! ", { font: "50pt Arial", wordWrap: true, wordWrapWidth: 1200 });
            txt.anchor.set(0.5, 0.5);
            txt.addColor("#2d842d", 0);
            this.addChild(txt);
            this.FinishButton.visible = false;
            this.cloud.visible = false;
            this.guide.visible = false;
            ScormHelper.ScormHelper.setWorkCardCompleted();
        };
        EndGroup.prototype.finishGame = function () {
            var txt = this.game.add.text(this.game.width / 2, this.game.height / 2, "Ukończono grę! ", { font: "50pt Arial", wordWrap: true, wordWrapWidth: 1200 });
            txt.anchor.set(0.5, 0.5);
            txt.addColor("#2d842d", 0);
            this.addChild(txt);
            this.FinishButton.visible = false;
            this.cloud.visible = false;
            this.guide.visible = false;
            location.reload();
        };
        EndGroup.prototype.finishExam = function () {
            var result = Global.Main.getExamResult();
            var points = result.Score;
            var wrongAnswersString = "";
            for (var i = 0; i < result.WrongAnswers.length; i++) {
                if (i == result.WrongAnswers.length - 1)
                    wrongAnswersString += result.WrongAnswers[i] + " ";
                else {
                    wrongAnswersString += result.WrongAnswers[i] + ", ";
                }
            }
            var face;
            if (points > 0.7)
                face = "buzka1";
            else if (points > 0.5)
                face = "buzka2";
            else if (points === 0.5)
                face = "buzka3";
            else if (points > 0.3)
                face = "buzka4";
            else
                face = "buzka5";
            var txt = this.game.add.text(this.game.width / 2, 176, "Twój wynik to: ", { font: "50pt Arial", wordWrap: true, wordWrapWidth: 1200 });
            txt.anchor.set(0.5, 0);
            this.addChild(txt);
            var txt2 = this.game.add.text(this.game.width / 2, 342, Math.round(points * 100) + "%", { font: "136pt Arial", fontWeight: "bold", wordWrap: true, wordWrapWidth: 1200 });
            txt2.anchor.set(0.5, 0);
            txt2.addColor("#ff0000", 0);
            this.addChild(txt2);
            if (wrongAnswersString !== "") {
                var txt3 = this.game.add.text(this.game.width / 2, (this.game.height / 2) + 100, "Zadania które zostały wykonane z błędem:", { font: "42pt Arial", wordWrap: true, wordWrapWidth: 1200 });
                txt3.anchor.set(0.5, 0);
                this.addChild(txt3);
                for (var i = 0; i < result.WrongAnswers.length; i++) {
                    var tmp;
                    if (i != result.WrongAnswers.length - 1)
                        tmp = this.game.add.text(this.game.width / 4 + i * 70, (this.game.height / 2) + 200, result.WrongAnswers[i] + ",", { color: "#ff0000", font: "42pt Arial", wordWrap: true, wordWrapWidth: 1200 });
                    else
                        tmp = this.game.add.text(this.game.width / 4 + i * 70, (this.game.height / 2) + 200, result.WrongAnswers[i], { color: "#ff0000", font: "42pt Arial", wordWrap: true, wordWrapWidth: 1200 });
                    tmp.x = tmp.x - tmp.width / 2;
                    tmp.anchor.set(0.5, 0);
                    tmp.addColor("#ff0000", 0);
                    tmp.inputEnabled = true;
                    tmp.events.onInputUp.add(this.addWrongAnswer.bind(this, i, result.WrongAnswers[i]), this);
                    this.addChild(tmp);
                }
            }
            var faceObject = this.game.add.sprite(1287, 236, face);
            this.addChild(faceObject);
            this.FinishButton.visible = false;
            this.cloud.visible = false;
            this.guide.visible = false;
            ScormHelper.ScormHelper.setExamCompleted("0", result.MaxPoints.toString(), result.Acquired.toString());
        };
        EndGroup.prototype.addWrongAnswer = function (i, result) {
            this.game.input.enabled = false;
            var tw = this.game.add.tween(this.game.camera);
            tw.to({ x: Global.Main.dims.x * result }, 2000, Phaser.Easing.Exponential.Out);
            tw.onComplete.add(function () {
                this.game.input.enabled = true;
            }, this);
            tw.start();
            Global.Main.currentPageNumber = result;
        };
        EndGroup.prototype.preload = function () {
            this.game.load.spritesheet("prev", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_button_previous.png", 120, 120, 2);
            this.game.load.image("background", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_background.jpg");
            this.game.load.image("cloud", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_dymek_" + CardChooser.getModule() + ".png");
            this.game.load.image("page", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_kartka.png");
            if (TYPE === "fi")
                this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/I/" + CardChooser.getModule() + "_przewodnik_start.png");
            else
                this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getCardClass() + "/" + CardChooser.getModule() + "_main_przewodnik.png");
            this.game.load.image("buzka1", "Graphics/GUI/ALL_sprawdzian_buzka1.png");
            this.game.load.image("buzka2", "Graphics/GUI/ALL_sprawdzian_buzka2.png");
            this.game.load.image("buzka3", "Graphics/GUI/ALL_sprawdzian_buzka3.png");
            this.game.load.image("buzka4", "Graphics/GUI/ALL_sprawdzian_buzka4.png");
            this.game.load.image("buzka5", "Graphics/GUI/ALL_sprawdzian_buzka5.png");
        };
        return EndGroup;
    })(Base.BasicGroup);
    Base.EndGroup = EndGroup;
})(Base || (Base = {}));
//# sourceMappingURL=Base.js.map