var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Blank;
(function (_Blank) {
    var Blank = (function (_super) {
        __extends(Blank, _super);
        function Blank(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Blank.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        Blank.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Blank.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
			var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
			next.scale.setTo(0.8,0.8);
			this.addChild(next);
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            EU.setGameCompletion(this.parent, 1);
        };
        Blank.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
		Blank.prototype.nextScreen = function () {
			this.game.input.enabled = false;
			EU.killKeyboard();
			var tw = this.game.add.tween(this.game.camera);
			tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
			tw.onComplete.add(function () {
				this.game.input.enabled = true;
			}, this);
			tw.start();
			var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
			prev.scale.setTo(0.8,0.8);
			this.addChild(prev);
			Global.Main.currentPageNumber++;
			Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
			console.log(Global.Main.currentPageNumber);
        };
		Blank.prototype.prevScreen = function () {
			if (this.game.camera.x - Global.Main.dims.x > 0) {
				this.game.input.enabled = false;
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber--;
				if (this.json.Lector)
					Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
        };
        Blank.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this))
                EU.Log("Correct!!!");
        };
        return Blank;
    })(Base.BasicGroup);
    _Blank.Blank = Blank;
})(Blank || (Blank = {}));
//# sourceMappingURL=Blank.js.map