﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentArticlePanel = function(name)
{
	this.componentTextWithScroll  = componentTextWithScroll;
	this.componentTextWithScroll(name);

	this.buttonPadding = 0;
	this.headerHeight = 0;
};

componentArticlePanel.prototype = new componentTextWithScroll();
componentArticlePanel.prototype.type = "componentArticlePanel";

componentArticlePanel.prototype.componentArticlePanelBaseOnCreate = componentArticlePanel.prototype.onCreate;
componentArticlePanel.prototype.onCreate = function(obj)
{
	this.headerHeight = this.headerHeight;

	this.imagesNameArr = [ this.bckgImg, this.buttonMailOut, this.buttonOut ];
	this.getPreloadImagesArr();
	this.componentArticlePanelBaseOnCreate();
};

componentArticlePanel.prototype.componentArticlePanelBaseSetHTMLObiects = componentArticlePanel.prototype.setHTMLObiects;
componentArticlePanel.prototype.setHTMLObiects = function(obj)
{
	this.componentArticlePanelBaseSetHTMLObiects();

	document.getElementById(this.id + "_bckgImg").src = this.resourcesURL + this.bckgImg;
	document.getElementById(this.id + "_buttonMailImg").src = this.resourcesURL + this.buttonMailOut;
	document.getElementById(this.id + "_buttonImg").src = this.resourcesURL + this.buttonOut;
};

componentArticlePanel.prototype.componentArticlePanelBaseShow = componentArticlePanel.prototype.show;
componentArticlePanel.prototype.show = function(obj)
{
	this.componentArticlePanelBaseShow();

	this.mouseIsDown = true;
	this.moveScroll(0);
	this.mouseIsDown = false;
};

componentArticlePanel.prototype.placeHTMLObiects = function(obj)
{
	var buttonDIV = document.getElementById(this.id + "_buttonDIV");
	var arrowTopDiv = document.getElementById(this.id + "_arrowTopDiv");
	var arrowBottomDiv = document.getElementById(this.id + "_arrowBottomDiv");
	var trackBckgDiv = document.getElementById(this.id + "_trackBckgDiv");
	var trackDiv = document.getElementById(this.id + "_trackDiv");
	var tableDiv = document.getElementById(this.id + "_tableDiv");
	var Table = document.getElementById(this.id + "Table");

	arrowTopDiv.style.top = this.headerHeight+this.borderWidth+this.contentPadding;
	if (this.dir == "rtl") {
		arrowTopDiv.style.left = this.borderWidth+this.contentPadding;
	} else {
		arrowTopDiv.style.left = this.w - this.getImageWidth('arrowTopOut')-2*this.borderWidth-this.contentPadding;
	};
	arrowTopDiv.style.width = this.getImageWidth('arrowTopOut');
	arrowTopDiv.style.height = this.getImageHeight('arrowTopOut');
	arrowTopDiv.style.clip = 'rect(0px '+this.getImageWidth('arrowTopOut')+'px '+this.getImageHeight('arrowTopOut')+'px 0px)';

	arrowBottomDiv.style.top = this.h - this.getImageHeight('arrowBottomOut')-2*this.borderWidth-this.contentPadding-this.footerHeight;;
	if (this.dir == "rtl") {
		arrowBottomDiv.style.left = this.borderWidth+this.contentPadding;
	} else {
		arrowBottomDiv.style.left = this.w - this.getImageWidth('arrowBottomOut')-2*this.borderWidth-this.contentPadding;
	};
	arrowBottomDiv.style.width = this.getImageWidth('arrowBottomOut');
	arrowBottomDiv.style.height = this.getImageHeight('arrowBottomOut');
	arrowBottomDiv.style.clip = 'rect(0px '+this.getImageWidth('arrowBottomOut')+'px '+this.getImageHeight('arrowBottomOut')+'px 0px)';

	trackBckgDiv.style.top = this.headerHeight+this.borderWidth+this.contentPadding;
	if (this.dir == "rtl") {
		trackBckgDiv.style.left = this.borderWidth+this.contentPadding;
	} else {
		trackBckgDiv.style.left = this.w - this.getImageWidth('sliderBckg')-2*this.borderWidth-this.contentPadding;
	};
	trackBckgDiv.style.width = this.getImageWidth('sliderBckg');
	trackBckgDiv.style.height = this.h - 2*this.borderWidth - 2*this.contentPadding - this.headerHeight - this.footerHeight;
	trackBckgDiv.style.clip = 'rect(0px '+this.getImageWidth('sliderBckg')+'px '+this.h+'px 0px)';

	this.sliderLowOffset = this.getImageHeight('arrowTopOut') + this.contentPadding + this.headerHeight;
	this.trackHeight = this.h - 2*this.borderWidth - 2*this.contentPadding - this.headerHeight - this.getImageHeight('arrowTopOut') - this.getImageHeight('arrowBottomOut')-this.footerHeight;
	this.sliderHighOffset = this.trackHeight - this.getImageHeight('sliderOut');

	trackDiv.style.top = this.sliderLowOffset;
	if (this.dir == "rtl") {
		trackDiv.style.left = this.borderWidth+this.contentPadding;
	} else {
		trackDiv.style.left = this.w - this.getImageWidth('sliderOut')-2*this.borderWidth-this.contentPadding;
	};
	trackDiv.style.width = this.getImageWidth('sliderOut');
	trackDiv.style.height = this.getImageHeight('sliderOut');
	trackDiv.style.clip = 'rect(0px '+this.getImageWidth('sliderOut')+'px '+this.getImageHeight('sliderOut')+'px 0px)';

	var textFieldW = this.w - 2*this.borderWidth - 2*this.contentPadding - this.getImageWidth('sliderOut') - 2*this.textSpacing;

	if (this.dir == "rtl") {
		tableDiv.style.left = this.borderWidth + this.contentPadding + this.textSpacing + this.getImageWidth('sliderOut');
	} else {
		tableDiv.style.left = this.borderWidth + this.contentPadding + this.textSpacing;
	};
	tableDiv.style.top = this.contentPadding + this.borderWidth + this.headerHeight + this.textSpacing;
	tableDiv.dir = this.dir;

	Table.width = textFieldW;

	if (this.buttonsActive) {
	} else {
		var trackBckgDiv = document.getElementById(this.id + "_trackBckgDiv");
		var arrowTopDiv = document.getElementById(this.id + "_arrowTopDiv");
		var arrowBottomDiv = document.getElementById(this.id + "_arrowBottomDiv");
		var trackDiv = document.getElementById(this.id + "_trackDiv");

		trackBckgDiv.style.display = 'none';
		arrowTopDiv.style.display = 'none';
		arrowBottomDiv.style.display = 'none';
		trackDiv.style.display = 'none';
	};
};

componentArticlePanel.prototype.getTextHeight = function(obj)
{
	var tableDiv = document.getElementById(this.id + "_tableDiv");
	var Table = document.getElementById(this.id + "Table");

	this.textHeight = Table.scrollHeight;

	var textFieldW = this.w - 2*this.borderWidth - 2*this.contentPadding - this.getImageWidth('sliderOut') - 2*this.textSpacing;
	var textFieldH = this.h - 2*this.borderWidth - this.headerHeight - 2*this.contentPadding - 2*this.textSpacing-this.footerHeight;
	this.buttonsActive = (eval(this.h - this.headerHeight) < this.textHeight) ? true : false;

	tableDiv.style.width = textFieldW; 
	tableDiv.style.height = textFieldH; 

	tableDiv.style.clip = 'rect(0px '+tableDiv.style.width+' '+tableDiv.style.height+' 0px)';
};

componentArticlePanel.prototype.changeBtnImage = function(objName, name)
{
	var buttonDIV = document.getElementById(this.id + objName);
	buttonDIV.src = this.resourcesURL + name;
};

//an action in WBTExpress
componentArticlePanel.prototype.scrollContent = function (labelWord)
{
	labelWord = unescape(labelWord);
	var text = this.text;
	if (text.indexOf(labelWord) < 0) return;
	text = text.replace(labelWord, '<span id="'+this.id+'_span" style="background: '+this.spanColor+'">'+labelWord+'</span>');

	var contentObj = document.getElementById(this.id + "_contentObj");
	var tableDiv = document.getElementById(this.id + "_tableDiv");
	var Table = document.getElementById(this.id + "Table");

	contentObj.innerHTML = text;
	var span = document.getElementById(this.id + "_span");

	tableDiv.scrollTop = this.findPosY(span);
	var trackDiv = document.getElementById(this.id + "_trackDiv");

	var distanceFromTopInPerc = (tableDiv.scrollTop/(Table.scrollHeight-tableDiv.offsetHeight-this.footerHeight)).toFixed(2);
	distanceFromTopInPerc = (distanceFromTopInPerc > 1)?1:distanceFromTopInPerc;
	trackDiv.style.top = this.sliderLowOffset + this.sliderHighOffset*distanceFromTopInPerc;
};

componentArticlePanel.prototype.findPosY = function(obj) 
{
	var curtop = 0;
	if (obj.offsetParent) {
		return obj.offsetTop;
	};
	return curtop;
};

componentArticlePanel.prototype.printPreview = function()
{
	var tableDiv = document.getElementById(this.id + "_tableDiv");
	var Table = document.getElementById(this.id + "Table");
	Table.width = '100%'

	var style = '<style type="text/css">.P { margin: 0px;}</style>';
	var printWin = window.open("","_blank","toolbar=no, location=no, directories=no, status=no, menubar=yes, scrollbars=yes, resizable=yes, copyhistory=no, width=600, height=300");
	var inner = tableDiv.innerHTML.replace(/<P /gi, '<P class="P" ')

	printWin.document.write('<html><head><title></title></head>'); 
	printWin.document.write(style);
	printWin.document.write('<body onload="self.print();">');
	printWin.document.write(inner);
	printWin.document.write('</body></html>');
	printWin.document.close();
	printWin.focus();
};
