var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var DragDrop;
var zad_zaliczone = 0;
(function (_DragDrop) {
    var Types;
    (function (Types) {
        Types[Types["OneToMany"] = 0] = "OneToMany";
        Types[Types["ManyToOne"] = 1] = "ManyToOne";
        Types[Types["OneToOne"] = 2] = "OneToOne";
        Types[Types["BigContainer"] = 3] = "BigContainer";
    })(Types || (Types = {}));
    var DragDrop = (function (_super) {
        __extends(DragDrop, _super);
        function DragDrop(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.isExam = false;
            this.allPaired = true;
            this.groupsEnabled = true;
        }
        DragDrop.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
            this.Elements = json.GameData;
        };
        DragDrop.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        DragDrop.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            
            this.createContainerElements();
            this.createDragableElements();
            this.loadGroups();
            this.initOptions();
            EU.createFillElements(this);
            EU.createSelectableElements(this);
            this.createStaticElements();
        };
        DragDrop.prototype.initOptions = function () {
            if (this.GameData.AllPaired === undefined || this.GameData.AllPaired === null)
                this.allPaired = true;
            else
                this.allPaired = this.GameData.AllPaired;
        };
        DragDrop.prototype.loadGraphics = function () {
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Prefix + this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        };
        DragDrop.prototype.createStaticElements = function () {
            var opt = this.GameData.StaticElements.Options;
            var orientation;
            if (opt.Orientation === undefined || opt.Orientation === null) {
                orientation = true;
            }
            else {
                orientation = opt.Orientation;
            }
            var positions = EU.generateGridPositions(opt.Columns, opt.Rows, opt.MaxWidth, opt.MaxHeight, opt.Spacing, opt.Spacing, opt.StartingPos.x, opt.StartingPos.y, orientation);
            var el;
            var posX;
            var posY;
            for (var i = 0; i < this.GameData.StaticElements.el.length; i++) {
                if (this.GameData.StaticElements.Options.isGrid) {
                    posX = positions[i].x;
                    posY = positions[i].y;
                }
                else {
                    posX = this.GameData.StaticElements.el[i].pos.x;
                    posY = this.GameData.StaticElements.el[i].pos.y;
                }
                if (this.GameData.StaticElements.el[i].type) {
                    switch (this.GameData.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(posX, posY, this.GameData.Prefix + this.GameData.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(posX, posY, this.GameData.StaticElements.el[i].text, this.GameData.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = game.game.add.sprite(posX, posY, "speaker");
                            el.inputEnabled = true;
                            el.name = game.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(EU.soundButtonDown, game);
                            break;
                    }
                }
                else
                    el = this.game.add.image(posX, posY, this.GameData.Prefix + this.GameData.StaticElements.el[i].key);
                this.addChild(el);
            }
        };
        DragDrop.prototype.createContainerElements = function () {
            this.containers = [];
            var el;
            var opt = this.GameData.ContainerElements.Options;
            var positions = EU.generateGridPositions(opt.Columns, opt.Rows, opt.MaxWidth, opt.MaxHeight, opt.Spacing, opt.Spacing, opt.StartingPos.x, opt.StartingPos.y, true);
            if (opt.Inverted && opt.Inverted === true)
                positions = EU.generateGridPositions(opt.Columns, opt.Rows, opt.MaxWidth, opt.MaxHeight, opt.Spacing, opt.Spacing, opt.StartingPos.x, opt.StartingPos.y, false);
            for (var i = 0; i < this.GameData.ContainerElements.el.length; i++) {
                if (this.GameData.ContainerElements.Options.isGrid)
                    el = this.game.add.image(positions[i].x, positions[i].y, this.GameData.Prefix + this.GameData.ContainerElements.el[i].key);
                else
                    el = this.game.add.image(this.GameData.ContainerElements.el[i].pos.x, this.GameData.ContainerElements.el[i].pos.y, this.GameData.Prefix + this.GameData.ContainerElements.el[i].key);
                el.name = this.GameData.ContainerElements.el[i].name;
                this.containers.push({
                    "el": el,
                    "startPos": {
                        "x": el.position.x,
                        "y": el.position.y
                    },
                    "name": el.name,
                    "dragElementName": ""
                });
                this.addChild(el);
            }
        };
        DragDrop.prototype.createDragableElements = function () {
            this.dragElements = [];
            var opt = this.GameData.DragableElements.Options;
            var positions = EU.shuffleArray(EU.generateGridPositions(opt.Columns, opt.Rows, opt.MaxWidth, opt.MaxHeight, opt.Spacing, opt.Spacing, opt.StartingPos.x, opt.StartingPos.y, true));
            for (var i = 0; i < this.GameData.DragableElements.el.length; i++) {
                if (this.GameData.DragableElements.Options.isGrid)
                    var el = this.game.add.image(positions[i].x, positions[i].y, this.GameData.Prefix + this.GameData.DragableElements.el[i].key);
                else
                    var el = this.game.add.image(this.GameData.DragableElements.el[i].pos.x, this.GameData.DragableElements.el[i].pos.y, this.GameData.Prefix + this.GameData.DragableElements.el[i].key);
                el.inputEnabled = true;
                el.name = this.GameData.DragableElements.el[i].name;
                el.input.enableDrag();
                el.events.onInputUp.add(this.onInputUp, this);
                el.events.onInputDown.add(this.onInputDown, this);
                this.dragElements.push({
                    "el": el,
                    "startPos": {
                        "x": el.position.x,
                        "y": el.position.y
                    },
                    "paired": false,
                    "correctContainer": this.GameData.DragableElements.el[i].correctContainer,
                    "correctGroup": this.GameData.DragableElements.el[i].correctGroup,
                    "pairedWith": ""
                });
                this.addChild(el);
            }
        };
        DragDrop.prototype.createMissingElement = function () {
            for (var i = 0; i < this.dragElements.length; i++) {
                if (this.dragElements[i].paired === true) {
                    var el = this.game.add.image(this.dragElements[i].startPos.x, this.dragElements[i].startPos.y, this.dragElements[i].el.key);
                    el.inputEnabled = true;
                    el.name = this.dragElements[i].name;
                    el.events.onInputUp.add(this.onInputUp, this);
                    el.events.onInputDown.add(this.onInputDown, this);
                    this.dragElements.push({
                        "el": el,
                        "startPos": {
                            "x": el.position.x,
                            "y": el.position.y
                        },
                        "paired": false,
                        "correctContainer": this.dragElements[i].correctContainer,
                        "correctGroup": this.dragElements[i].correctGroup,
                        "pairedWith": ""
                    });
                }
                this.addChild(el);
            }
        };
        DragDrop.prototype.loadGroups = function () {
            this.groupsEnabled = this.GameData.GroupsEnabled;
            if (this.groupsEnabled) {
                this.containersGroups = [];
                if (this.GameData.ContainerGroups != undefined)
                    ;
                for (var i = 0; i < this.GameData.ContainerGroups.length; i++) {
                    var tmp = [];
                    for (var x = 0; x < this.GameData.ContainerGroups[i].el.length; x++) {
                        tmp.push(this.getContainerByName(this.GameData.ContainerGroups[i].el[x].name));
                    }
                    var z = { "name": this.GameData.ContainerGroups[i].name, el: tmp };
                    this.containersGroups.push(z);
                }
            }
        };
        DragDrop.prototype.onInputUp = function (el, pointer) {
            var index = this.getCorrespondingContainerIndex(el);
            for (var i = 0; i < this.containers.length; i++) {
                if (this.overlap(el, this.containers[i].el)) {
                    if (this.GameData.DragType != "BigContainer") {
                        if (this.containers[i].dragElementName === "") {
                            this.containers[i].dragElementName = el.name;
                        }
                        else {
                            var oldDrag = this.getDragElementByName(this.containers[i].dragElementName);
                            oldDrag.pairedWith = "";
                            oldDrag.el.bringToTop();
                            var returnTween = this.game.add.tween(oldDrag.el);
                            returnTween.to({ x: oldDrag.startPos.x, y: oldDrag.startPos.y }, 500, Phaser.Easing.Circular.InOut);
                            returnTween.start();
                            this.containers[i].dragElementName = el.name;
                        }
                        el.x = this.containers[i].startPos.x;
                        el.y = this.containers[i].startPos.y;
                    }
                    this.dragElements[index].paired = true;
                    this.dragElements[index].pairedWith = this.containers[i].name;
                    this.checkIfEverythingIsCorrect();
                    this.CheckIfElementIsInCorrectContainer(el, index, this.containers[i]);
                    if (this.GameData.MultipleDrag && this.GameData.MultipleDrag === true) {
                        this.createMissingElement();
                    }
                    el.input.disableDrag();
                    return;
                }
            }
            this.dragElements[index].paired = false;
            this.dragElements[index].pairedWith = "";
			zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            var tw = this.game.add.tween(el);
            tw.to({ x: this.dragElements[index].startPos.x, y: this.dragElements[index].startPos.y }, 500, Phaser.Easing.Circular.InOut);
            tw.onComplete.add(function () {
                el.input.disableDrag();
            }, this);
            tw.start();
        };
        DragDrop.prototype.CheckIfElementIsInCorrectContainer = function (el, elementIndex, cnt) {
            var tmp = this.getDragElementByName(el.name);
            if (this.groupsEnabled) {
                if (this.isElementInCorrectGroup(tmp)) {
                    if (this.GameData.CorrectSound) {
                        Global.Main.PlayMusic(new Audio("Sounds/win.mp3"));
                    }
                }
                else {
                    if (this.GameData.CorrectSound) {
                        Global.Main.PlayMusic(new Audio("Sounds/err.mp3"));
                    }
                    if (this.GameData.ForceCorrect) {
                        cnt.dragElementName = "";
                        this.dragElements[elementIndex].paired = false;
                        this.dragElements[elementIndex].pairedWith = "";
                        var BackTween = this.game.add.tween(el);
                        BackTween.to({ x: this.dragElements[elementIndex].startPos.x, y: this.dragElements[elementIndex].startPos.y }, 500, Phaser.Easing.Circular.InOut);
                        BackTween.start();
                    }
                }
            }
            else {
                for (var i = 0; i < this.dragElements.length; i++) {
                    if (tmp.correctContainer === tmp.pairedWith) {
                        if (this.GameData.CorrectSound)
                            Global.Main.PlayMusic(new Audio("Sounds/win.mp3"));
                    }
                    else {
                        if (this.GameData.CorrectSound)
                            Global.Main.PlayMusic(new Audio("Sounds/err.mp3"));
                        if (this.GameData.ForceCorrect) {
                            this.dragElements[elementIndex].paired = false;
                            this.dragElements[elementIndex].pairedWith = "";
                            cnt.dragElementName = "";
                            var BackTween = this.game.add.tween(el);
                            BackTween.to({ x: this.dragElements[elementIndex].startPos.x, y: this.dragElements[elementIndex].startPos.y }, 500, Phaser.Easing.Circular.InOut);
                            BackTween.start();
                        }
                    }
                }
            }
        };
        DragDrop.prototype.findCorrectOrders = function (el) {
            var arr = [];
            for (var i = 0; i < this.GameData.DragCorrectOrder.length; i++) {
                for (var j = 0; j < this.GameData.DragCorrectOrder[i].el.length; j++) {
                    if (el === this.GameData.DragCorrectOrder[i].el[j].name) {
                        arr.push(j);
                    }
                }
            }
            return arr;
        };
        DragDrop.prototype.findContainerCorrectOrder = function (el) {
            var arr = [];
            for (var i = 0; i < this.GameData.ContainerGroups.length; i++) {
                for (var j = 0; j < this.GameData.ContainerGroups[i].el.length; j++) {
                    if (el === this.GameData.ContainerGroups[i].el[j].name) {
                        arr.push(j);
                    }
                }
            }
            return arr;
        };
        DragDrop.prototype.onInputDown = function (el, pointer) {
            el.input.enableDrag();
            el.input.startDrag;
            if (this.GameData.DragType != "BigContainer")
                this.getDragElementByName(el.name).pairedWith = "";
            for (var i = 0; i < this.containers.length; i++) {
                if (this.overlap(el, this.containers[i].el)) {
                    this.containers[i].dragElementName = "";
                }
            }
            el.bringToTop();
        };
        DragDrop.prototype.checkIfEverythingIsCorrect = function () {
            switch (this.GameData.DragType) {
                case "GroupsWithOrder":
                    this.checkCompletedGroupsWithOrder(this.allPaired);
                    break;
                case "NotAllPaired":
                    this.checkCompletedFilledContainers();
                    break;
                default:
                    this.checkCompleted(this.allPaired);
                    break;
            }
        };
		DragDrop.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
		DragDrop.prototype.prevScreen = function () {
			if(zad_zaliczone == 1){
				if (this.game.camera.x - Global.Main.dims.x > 0) {
					this.game.input.enabled = false;
					var tw = this.game.add.tween(this.game.camera);
					tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
					tw.onComplete.add(function () {
						this.game.input.enabled = true;
					}, this);
					tw.start();
					Global.Main.currentPageNumber--;
					if (this.json.Lector)
						Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
					console.log(Global.Main.currentPageNumber);
				}
			}
			else {
				//nic nie rób
			}
        };
        DragDrop.prototype.checkCompleted = function (allPaired) {
			zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            var i = 0;
            if (allPaired)
                for (i = 0; i < this.dragElements.length; i++) {
                    if (!this.dragElements[i].paired)
                        return false;
                }
            if (this.groupsEnabled) {
                for (i = 0; i < this.dragElements.length; i++) {
                    if (!this.isElementInCorrectGroup(this.dragElements[i]))
                        return false;
                }
            }
            else {
                for (i = 0; i < this.dragElements.length; i++) {
                    if (this.dragElements[i].correctContainer !== this.dragElements[i].pairedWith)
                        return false;
                }
            }
            if (EU.checkIfFillsAreCorrect(this)) {
                if (TYPE === "gm") {
                    if (this.GameData.NoSkip && this.GameData.NoSkip == true) {
                    }
                    else
						var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
						next.scale.setTo(0.8,0.8);
						this.addChild(next);
						var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
						prev.scale.setTo(0.8,0.8);
						this.addChild(prev);
                        _super.prototype.nextTask.call(this);
                }
				zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);	
            }
        };
        DragDrop.prototype.checkCompletedGroupsWithOrder = function (allPaired) {
			zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            var i = 0;
            if (allPaired)
                for (i = 0; i < this.dragElements.length; i++) {
                    if (!this.dragElements[i].paired)
                        return false;
                }
            for (var i = 0; i < this.dragElements.length; i++) {
                var x = this.findCorrectOrders(this.dragElements[i].el.name);
                var y = this.findContainerCorrectOrder(this.dragElements[i].pairedWith);
                for (var j = 0; j < x.length; j++)
                    if (x[j] !== y[j])
                        return false;
            }
            if (EU.checkIfFillsAreCorrect(this)) {
                if (TYPE === "gm") {
                    if (this.GameData.NoSkip && this.GameData.NoSkip == true) {
                    }
                    else
						var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
						next.scale.setTo(0.8,0.8);
						this.addChild(next);
						var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
						prev.scale.setTo(0.8,0.8);
						this.addChild(prev);
                        _super.prototype.nextTask.call(this);
                }
				zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
            }
        };
        DragDrop.prototype.checkCompletedFilledContainers = function () {
            EU.Log(this.containers);
            for (var i = 0; i < this.containers.length; i++) {
                if (this.containers[i].dragElementName === "")
                    return false;
            }
            for (var i = 0; i < this.containers.length; i++) {
                var temp = this.getDragElementByName(this.containers[i].dragElementName).correctContainer;
                EU.Log(temp);
                if (temp !== this.containers[i].name)
                    return false;
            }
            if (EU.checkIfFillsAreCorrect(this)) {
                if (TYPE === "gm") {
                    if (this.GameData.NoSkip && this.GameData.NoSkip == true) {
                    }
                    else
						var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
						next.scale.setTo(0.8,0.8);
						this.addChild(next);
						var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
						prev.scale.setTo(0.8,0.8);
						this.addChild(prev);
                        _super.prototype.nextTask.call(this);
                }
				zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
            }
            return true;
        };
        DragDrop.prototype.overlap = function (a, b) {
            var bA = a.getBounds();
            var bB = b.getBounds();
            return Phaser.Rectangle.intersects(bA, bB);
        };
        DragDrop.prototype.isElementInCorrectGroup = function (el) {
            for (var i = 0; i < this.containersGroups.length; i++) {
                if (el.correctGroup === "")
                    return true;
                if (this.containersGroups[i].name === el.correctGroup) {
                    for (var j = 0; j < this.containersGroups[i].el.length; j++) {
                        if (this.containersGroups[i].el[j].name === el.pairedWith)
                            return true;
                    }
                }
            }
            return false;
        };
        DragDrop.prototype.getContainerByName = function (name) {
            for (var i = 0; i < this.containers.length; i++)
                if (this.containers[i].el.name === name)
                    return this.containers[i].el;
        };
        DragDrop.prototype.getDragElementByName = function (name) {
            for (var i = 0; i < this.dragElements.length; i++)
                if (this.dragElements[i].el.name === name)
                    return this.dragElements[i];
        };
        DragDrop.prototype.getCorrespondingContainerIndex = function (el) {
            for (var i = 0; i < this.dragElements.length; i++) {
                if (el === this.dragElements[i].el)
                    return i;
            }
        };
        return DragDrop;
    })(Base.BasicGroup);
    _DragDrop.DragDrop = DragDrop;
})(DragDrop || (DragDrop = {}));
//# sourceMappingURL=DragDrop.js.map