var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Memo;
var zad_zaliczone = 0;
(function (_Memo) {
    var Memo = (function (_super) {
        __extends(Memo, _super);
        function Memo(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.unhide = 0;
            this.cards = [];
        }
        Memo.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Memo.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Memo.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++) {
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
                if (this.Elements.Graphics[i].key != 'memo')
                    this.cards.push(this.Elements.Graphics[i].key);
            }
        };
        Memo.prototype.shuffle = function (o) {
            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x)
                ;
            return o;
        };
        Memo.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.rows = this.Elements.Options[0].Rows;
            this.columns = this.Elements.Options[0].Columns;
            this.top = this.Elements.Options[0].Top;
            this.left = this.Elements.Options[0].Left;
            this.cardWidth = this.Elements.Options[0].CardWidth;
            this.cardHeight = this.Elements.Options[0].CardHeight;
            this.innerSpace = this.Elements.Options[0].InnerSpace;
            this.totalPair = (this.Elements.Graphics.length - 1) / 2;
            this.shuffle(this.cards);
            var variant = 1;
            for (var i = 0; i < this.columns; i++)
                for (var j = 0; j < this.rows; j++) {
                    var m = new MemoCard(this.game, this.left + i * this.cardWidth + this.innerSpace, this.top + j * this.cardHeight + this.innerSpace, this.cards[0]);
                    m.inputEnabled = true;
                    m.events.onInputDown.add(this.clickCard, this);
                    this.cards.shift();
                    this.addChild(m);
                }
        };
        Memo.prototype.clickCard = function (obj) {
            this.unhide++;
            if (this.unhide == 1) {
                this.firstCard = obj;
                this.firstCard.inputEnabled = false;
                this.firstCard.showKey();
            }
            if (this.unhide == 2) {
                this.secondCard = obj;
                this.secondCard.inputEnabled = false;
                this.secondCard.showKey();
                this.game.time.events.add(Phaser.Timer.SECOND * 1, this.checkPair, this);
            }
        };
		Memo.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
		Memo.prototype.prevScreen = function () {
			if(zad_zaliczone == 1){
				if (this.game.camera.x - Global.Main.dims.x > 0) {
					this.game.input.enabled = false;
					var tw = this.game.add.tween(this.game.camera);
					tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
					tw.onComplete.add(function () {
						this.game.input.enabled = true;
					}, this);
					tw.start();
					Global.Main.currentPageNumber--;
					if (this.json.Lector)
						Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
					console.log(Global.Main.currentPageNumber);
				}
			}
			else {
				//nic nie rób
			}
        };
		Memo.prototype.playGood = function () {
			snd_g = new Audio("Sounds/win.mp3");
			snd_g.load();
			snd_g.loop = false;
			snd_g.play();
		};
		Memo.prototype.playWrong = function () {
			snd_w = new Audio("Sounds/err.mp3");
			snd_w.load();
			snd_w.loop = false;
			snd_w.play();
		};
        Memo.prototype.checkPair = function () {
            if (this.firstCard.group == this.secondCard.group) {
                this.firstCard.done = true;
                this.secondCard.done = true;
                this.unhide = 0;
                this.totalPair--;
                console.log(this.totalPair);
                if (this.totalPair == 0) {
					zad_zaliczone = 1;
					console.log("zad_zaliczone = "+zad_zaliczone);
					var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
					var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
					prev.scale.setTo(0.8,0.8);
					this.addChild(prev);
                    _super.prototype.nextTask.call(this);
                }
                EU.Log('Pair');
				this.playGood();
            }
            else {
				zad_zaliczone = 0;
				console.log("zad_zaliczone = "+zad_zaliczone);
                this.firstCard.back();
                this.secondCard.back();
				this.playWrong();
                this.unhide = 0;
            }
        };
        return Memo;
    })(Base.BasicGroup);
    _Memo.Memo = Memo;
    var MemoCard = (function (_super) {
        __extends(MemoCard, _super);
        function MemoCard(game, x, y, key) {
            _super.call(this, game, x, y, 'memo');
            this.done = false;
            this.group = key.substring(0, key.length - 1);
            this.imgKey = key;
            this.game = game;
        }
        MemoCard.prototype.showKey = function () {
            this.loadTexture(this.imgKey, 0, true);
        };
        MemoCard.prototype.back = function () {
            this.loadTexture('memo', 0, true);
            this.inputEnabled = true;
        };
        return MemoCard;
    })(Phaser.Sprite);
})(Memo || (Memo = {}));
//# sourceMappingURL=Memo.js.map