var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var KB;
(function (KB) {
    var Keyboard = (function (_super) {
        __extends(Keyboard, _super);
        function Keyboard(game, name, x, y, hideable, keyMargin) {
            _super.call(this, game, null, name);
            this.textStyle = { font: "normal 40pt Arial", fill: "white" };
            this.arrSeparator = "|&|";
            this.margin = 5;
            this.hideable = true;
            this.inputBoxStyle = { font: "normal 80pt Arial", fill: "black" };
            this.maxLetters = 90;
            this.BigLetters = true;
            this.SpecialLetters = true;
            this.currInput = null;
            this.keys = [];
            this.isSpaceEnabled = false;
            this.x = x;
            this.y = y;
            if (hideable !== undefined && hideable !== null) {
                this.hideable = hideable;
            }
            if (keyMargin !== undefined && keyMargin !== null) {
                this.margin = keyMargin;
            }
        }
        Keyboard.prototype.initialize = function (keyArr, btnKey, navKey) {
            var arr = keyArr.split(this.arrSeparator);
            var len = arr.length;
            this.keyInputGroup = this.game.add.group();
            this.addChild(this.keyInputGroup);
            var keys = 0;
            var m = 0;
            if (this.hideable) {
                m = this.addHideBtn(navKey || btnKey);
                m += this.addinputBox(m);
            }
            for (var i = 0; i < arr.length; i++) {
                keys += arr[i].length;
            }
            if (keys < len) {
                throw new RangeError("Not enough space for all keys");
            }
            var j = 1;
            var b = this.game.add.button(0, m, btnKey, this.keyClick, this, 0, 0, 1, 0, this);
            var txt = this.game.add.text(0, 0, arr[0][0], this.textStyle);
            txt.x = (b.width - txt.width) / 2;
            txt.y = (b.height - txt.height) / 2;
            b.addChild(txt);
            this.keys.push(b);
            this.keyInputGroup.add(b);
            for (var i = 0; i < arr.length; i++) {
                var row = arr[i];
                for (; j < row.length; j++) {
                    var t = this.game.add.button(j * (b.width + this.margin), m + i * (b.height + this.margin), btnKey, this.keyClick, this, 0, 0, 1, 0, this);
                    if (row[j] == "^" || row[j] == "&" || row[j] == " ") {
                        if (row[j] == "&") {
                            var txt = this.game.add.text(0, 0, 'alt', this.textStyle);
                        }
                        if (row[j] == "^") {
                            var txt = this.game.add.text(0, 0, 'shift', this.textStyle);
                        }
                        if (row[j] == " ") {
                            var txt = this.game.add.text(0, 0, 'spacja', { font: "normal 25pt Arial", fill: "white" });
                            this.isSpaceEnabled = true;
                        }
                    }
                    else
                        var txt = this.game.add.text(0, 0, row[j], this.textStyle);
                    txt.x = (t.width - txt.width) / 2;
                    txt.y = (t.height - txt.height) / 2;
                    t.addChild(txt);
                    this.keys.push(t);
                    this.keyInputGroup.add(t);
                }
                j = 0;
            }
            this.addKeyboardListener();
            if (this.hideable) {
                this.input.parent.width = this.width - this.margin - this.confirmBtn.width;
                this.nav.width = 0.2 * this.width;
                this.nav.x = 0.4 * this.width;
                this.y = this.game.world.height - this.nav.height;
                this.keyInputGroup.visible = false;
            }
        };
        Keyboard.prototype.addHideBtn = function (key) {
            var y = 0;
            EU.Log("klucz" + key);
            this.nav = this.game.add.button(0, 0, key, this.navClick, this, 0, 0, 1, 0, this);
            this.nav.scale.y = 0.4;
            y = this.nav.height + this.margin;
            this.addChild(this.nav);
            return y;
        };
        Keyboard.prototype.addinputBox = function (m) {
            var fontSize = 20;
            this.inputBoxStyle.font = "normal " + fontSize + "pt Arial";
            var y = 0;
            this.confirmBtn = this.game.add.button(0, m, "key", this.confirm, this, 0, 0, 1, 0, this.keyInputGroup);
            this.confirmBtn.frame = 2;
            this.confirmBtn.inputEnabled = true;
            var txt = this.game.add.text(0, 0, "OK", this.textStyle);
            txt.x = (this.confirmBtn.width - txt.width) / 2;
            txt.y = (this.confirmBtn.height - txt.height) / 2;
            this.confirmBtn.addChild(txt);
            var bmd = this.game.add.bitmapData(400, 400);
            bmd.ctx.rect(0, 0, 400, 400);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();
            var box = this.game.add.sprite(this.confirmBtn.width + this.margin, m, bmd);
            box.alpha = 0.5;
            box.height = this.confirmBtn.height;
            this.input = this.game.add.text(0, 0, "", this.inputBoxStyle);
            this.input.y = (box.height - this.input.height) / 2;
            this.input.scale.setTo(1, 6);
            box.addChild(this.input);
            this.keyInputGroup.addChild(box);
            y = this.confirmBtn.height + this.margin;
            return y;
        };
        Keyboard.prototype.addKeyboardListener = function () {
            this.game.input.keyboard.reset();
            var bspace = this.game.input.keyboard.addKey(Phaser.Keyboard.BACKSPACE);
            var space = this.game.input.keyboard.addKey(Phaser.Keyboard.SPACEBAR);
            var alt = this.game.input.keyboard.addKey(Phaser.Keyboard.ALT);
            var shift = this.game.input.keyboard.addKey(Phaser.Keyboard.SHIFT);
            var enter = this.game.input.keyboard.addKey(Phaser.Keyboard.ENTER);
            this.game.input.keyboard.addKeyCapture(Phaser.Keyboard.BACKSPACE);
            this.game.input.keyboard.addKeyCapture(Phaser.Keyboard.SHIFT);
            this.game.input.keyboard.addKeyCapture(Phaser.Keyboard.SPACEBAR);
            this.game.input.keyboard.addKeyCapture(Phaser.Keyboard.ALT);
            this.game.input.keyboard.addKeyCapture(Phaser.Keyboard.ENTER);
            this.game.input.keyboard.addCallbacks(this, null, null, this.keyPress);
            space.onDown.add(this.keyPress, this);
            bspace.onDown.add(this.keyPress, this);
            alt.onDown.add(this.keyPress, this);
            alt.onUp.add(this.keyUp, this);
            shift.onDown.add(this.keyPress, this);
            shift.onUp.add(this.keyUp, this);
            enter.onDown.add(this.keyPress, this);
        };
        Keyboard.prototype.navClick = function () {
            if (this.nav.exists) {
                var pt = this.game.world.height - this.nav.height;
                var vis = false;
                if (!this.keyInputGroup.visible) {
                    vis = true;
                    this.keyInputGroup.visible = vis;
                    pt = this.game.world.height - this.height;
                }
                else {
                    this.keyInputGroup.visible = vis;
                }
                var tw = this.game.add.tween(this.cameraOffset);
                tw.to({ y: pt }, 500, Phaser.Easing.Cubic.InOut, true, 0, 0);
            }
        };
        Keyboard.prototype.keyClick = function (e) {
            var len = this.keys.length;
            if (e.children[0].text == "shift" || e.children[0].text == "alt" || e.children[0].text == "spacja") {
                if (e.children[0].text == "shift") {
                    for (var i = 0; i < len; i++) {
                        var s = this.keys[i].children[0];
                        if (s.text == "shift" || s.text == "alt" || s.text == "spacja") {
                        }
                        else {
                            if (s.text.length > 0)
                                if (this.BigLetters) {
                                    s.text = s.text.toLocaleUpperCase();
                                }
                                else {
                                    s.text = s.text.toLocaleLowerCase();
                                }
                        }
                    }
                    this.BigLetters = !this.BigLetters;
                }
                if (e.children[0].text == "alt") {
                    for (var i = 0; i < len; i++) {
                        var s = this.keys[i].children[0];
                        if (s.text == "shift" || s.text == "alt" || s.text == "spacja") {
                        }
                        else {
                            if (s.text.length > 0)
                                if (this.SpecialLetters) {
                                    s.text = this.swapToDiactric(s.text);
                                }
                                else {
                                    s.text = this.swapFromDiactric(s.text);
                                }
                        }
                    }
                    this.SpecialLetters = !this.SpecialLetters;
                }
                if (e.children[0].text == "spacja") {
                    this.input.text = this.input.text + " ";
                }
            }
            else {
                if (this.input.text.length <= this.maxLetters) {
                    this.input.text = this.input.text + e.children[0].text;
                }
                else {
                    this.input.text = "";
                }
            }
        };
        Keyboard.prototype.keyPress = function (e) {
            var len = this.keys.length;
            if (this.input.exists)
                switch (e.keyCode) {
                    case 8:
                        EU.Log('backspace');
                        this.input.text = this.input.text.slice(0, this.input.text.length - 1);
                        break;
                    case 13:
                        EU.Log("enter");
                        this.confirm(this.confirmBtn);
                        break;
                    case 16:
                        for (var i = 0; i < len; i++) {
                            var s = this.keys[i].children[0];
                            if (s.text.length > 0)
                                s.text = s.text.toLocaleUpperCase();
                        }
                        break;
                    case 18:
                        for (var i = 0; i < len; i++) {
                            var s = this.keys[i].children[0];
                            if (s.text.length > 0)
                                s.text = this.swapToDiactric(s.text);
                        }
                        break;
                    case 32:
                        EU.Log('spacja');
                        if (this.isSpaceEnabled == true) {
                            this.input.text = this.input.text + " ";
                        }
                        break;
                    default:
                        var cl = this.getKey(e);
                        if (cl !== null)
                            if (this.input.text.length <= this.maxLetters) {
                                this.input.text = this.input.text + e;
                            }
                            else {
                                this.input.text = "";
                            }
                        if (this.currInput !== null) {
                        }
                        break;
                }
        };
        Keyboard.prototype.keyUp = function (e) {
            var len = this.keys.length;
            if (this.input.exists)
                switch (e.keyCode) {
                    case 16:
                        for (var i = 0; i < len; i++) {
                            var s = this.keys[i].children[0];
                            if (s.text.length > 0)
                                s.text = s.text.toLocaleLowerCase();
                        }
                        break;
                    case 18:
                        for (var i = 0; i < len; i++) {
                            var s = this.keys[i].children[0];
                            if (s.text.length > 0)
                                s.text = this.swapFromDiactric(s.text);
                        }
                        break;
                }
        };
        Keyboard.prototype.confirm = function (e) {
            if (this.controller !== null) {
                if (this.input.text == " "){
					if (fillaltsignal == true){
						this.input.text = "  ";
					} else {
						this.input.text = " ?";
					}
				}
				console.log("GameType = "+GameTypes[34]);
                this.input.text = this.input.text.slice(1, this.input.text.length);
                this.controller.setText(this.input.text);
                this.controller.father.width = this.controller.width + 10;
                this.controller.x = this.controller.father.x;
                this.controller.x = (this.controller.parent.width / 2 - this.controller.width / 2);
                this.controller.x = this.controller.father.x;
                this.navClick();
                this.input.text = "";
            }
            if (this.currInput !== null) {
                e.frame = 2;
                this.confirmBtn.inputEnabled = false;
            }
            if (this.RootController != null) {
                if (this.RootController.checkComplition)
                    this.RootController.checkComplition(this);
                else
                    this.RootController.checkIfEverythingIsCorrect();
            }
        };
        Keyboard.prototype.setCurrentInput = function (txt) {
            this.confirm(this.confirmBtn);
            this.currInput = txt;
            this.confirmBtn.inputEnabled = true;
            this.confirmBtn.frame = 0;
        };
        Keyboard.prototype.getKey = function (e) {
            var ret = null;
            var len = this.keys.length;
            for (var i = 0; i < len; i++) {
                if (this.keys[i].children[0].text === e) {
                    ret = this.keys[i];
                }
            }
            return ret;
        };
        Keyboard.prototype.swapToDiactric = function (txt) {
            var ret = txt.replace(/a/g, 'ą').replace(/A/g, 'Ą').replace(/c/g, 'ć').replace(/C/g, 'Ć').replace(/e/g, 'ę').replace(/E/g, 'Ę').replace(/l/g, 'ł').replace(/L/g, 'Ł').replace(/n/g, 'ń').replace(/N/g, 'Ń').replace(/o/g, 'ó').replace(/O/g, 'Ó').replace(/s/g, 'ś').replace(/S/g, 'Ś').replace(/z/g, 'ż').replace(/Z/g, 'Ż').replace(/x/g, 'ź').replace(/X/g, 'Ź');
            ;
            return ret;
        };
        Keyboard.prototype.swapFromDiactric = function (txt) {
            var ret = txt.replace(/ą/g, 'a').replace(/Ą/g, 'A').replace(/ć/g, 'c').replace(/Ć/g, 'C').replace(/ę/g, 'e').replace(/Ę/g, 'E').replace(/ł/g, 'l').replace(/Ł/g, 'L').replace(/ń/g, 'n').replace(/Ń/g, 'N').replace(/ó/g, 'o').replace(/Ó/g, 'O').replace(/ś/g, 's').replace(/Ś/g, 'S').replace(/ż/g, 'z').replace(/Ż/g, 'Z').replace(/ź/g, 'x').replace(/Ź/g, 'X');
            ;
            return ret;
        };
        return Keyboard;
    })(Phaser.Group);
    KB.Keyboard = Keyboard;
})(KB || (KB = {}));
//# sourceMappingURL=Keyboard.js.map