﻿module ListenAndWrite {
    export class ListenAndWrite extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        categoryIndex: number;
        wordIndex: number;

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            if (this.json.isFirst == true) {
                EU.loadVocabulary(this);
            };
            this.createFillQuestion();
            this.createButtons();
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }


        createFillQuestion() {
            var question;
            var flag = false;
            while (flag == false) {
                flag = true;
                this.categoryIndex = Math.floor((Math.random() * EU.groups.length));
                this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                EU.Log(this.categoryIndex + " " + this.wordIndex);
                question = EU.groups[this.categoryIndex].vocabulary[this.wordIndex].en;
                EU.Log(question);
                for (var i = 0; i < EU.usedWords.length; i++) {
                    if (EU.usedWords[i] == question) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            EU.usedWords.push(question);
           // this.Qtext = this.game.add.text(0, 0, question, this.Elements.Style);
            this.json.Lector = EU.groups[this.categoryIndex].vocabulary[this.wordIndex].lec;
            this.Elements.FillElements.el.push({
                "pos": this.Elements.Position,
                "Answer": question
            });
        }
        
        createButtons() {
            var el = this.game.add.text(1200, 770, "NEXT WORD", { font: "60px Arial", fill: 'blue', });
            el.setShadow(5, 5, "lightblue");
            el.inputEnabled = true;
            el.events.onInputDown.add(this.nextTask, this);
            this.addChild(el);

            if (this.json.isFirst != true) {
                var el2 = this.game.add.text(100, 770, "PREVIOUS WORD", { font: "60px Arial", fill: 'blue', });
                el2.setShadow(5, 5, "lightblue");
                el2.inputEnabled = true;
                el2.events.onInputDown.add(this.prevTask, this);
                this.addChild(el2);
            }

            var el3 = this.game.add.text(670, 200, "SAY AGAIN", { font: "60px Arial", fill: 'blue', });
            el3.setShadow(5, 5, "lightblue");
            el3.inputEnabled = true;
            el3.events.onInputDown.add(this.playLector, this);
            this.addChild(el3);

        }

        checkIfEverythingIsCorrect() {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this)) EU.Log("Correct!!!");
        }
    }
} 