﻿module Sequence {

    export class Sequence extends Base.BasicGroup {

        Elements: any;
        topSeq: Array<any> = [];
        bottomSeq: Array<any> = [];
        correctSeq: Array<any> = [];
        icons: Array<Icon> = [];
        slots: Array<Icon> = [];
        xPos: number = 0;
        frames: number;

        btnStart: Phaser.Button;


        init(json) {
            super.init(json);
            this.Elements = json.GameData;

        }

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
                
            }

            this.frames = this.Elements.Icons;

            this.xPos = (1920 / 2 - (this.frames * 300 + (this.frames - 1) * 20) / 2) - 120; // 120 is magic number

            for (var i = 0; i < this.frames; i++)
                this.addChild(this.slots[i] = new Icon(this.game, this.xPos + i * 300 + i * 20, 40, 'OS_g_II_12_empty', i * -1));

            this.btnStart = this.game.add.button(690 , 500, 'button', this.btnHit, this);
            this.addChild(this.btnStart);
            
        }

        btnHit() {
            this.btnStart.visible = false;
            this.prepare();
        }

        prepare() {

            for (var i = 0; i < this.frames; i++)
                this.topSeq.push(0);

            for (var i = 1; i < 37; i++)
                this.correctSeq.push(i);

            this.correctSeq = this.shuffle(this.correctSeq);
            this.correctSeq = this.correctSeq.slice(0, this.frames);
            


            for (var i = 0; i < this.frames; i++) {
                this.icons[i] = new Icon(this.game, this.xPos + i * 300 + i * 20, 40, 'OS_g_II_12_' + this.correctSeq[i].toString(), this.correctSeq[i]);
                this.addChild(this.icons[i]);
            }

            this.game.time.events.add(Phaser.Timer.SECOND * this.frames, this.start, this);

        }


        start() {
            for (var i = 0; i < this.frames; i++)
                this.icons[i].kill();

            this.bottomSeq = this.correctSeq.slice(); // copy
            this.bottomSeq = this.shuffle(this.bottomSeq);

            for (var i = 0; i < this.frames; i++) {
                this.icons[i] = new Icon(this.game, this.xPos + i * 300 + i * 20, 400, 'OS_g_II_12_' + this.bottomSeq[i].toString(), this.bottomSeq[i]);
                this.icons[i].name = this.bottomSeq[i];
                this.icons[i].inputEnabled = true;
                this.icons[i].input.enableDrag(false, true);
                this.icons[i].events.onDragStop.add(this.stopDrag, this);
                this.addChild(this.icons[i]);
            }

        }
        
        stopDrag(item: Icon) {
            var out = true;
            for (var slot = 0; slot < this.frames; slot++) {
                if (Phaser.Rectangle.intersects(item.rect, this.slots[slot].rect)) {
                    if (this.topSeq[slot] == 0) {
                        for (var i = 0; i < this.frames; i++) if (this.topSeq[i] == item.id) this.topSeq[i] = 0; // clear
                        this.topSeq[slot] = item.id;

                    }
                    else break;
                    
                    this.game.add.tween(item).to({ x: this.slots[slot].x }, 500, Phaser.Easing.Cubic.Out, true);
                    this.game.add.tween(item).to({ y: this.slots[slot].y }, 500, Phaser.Easing.Cubic.Out, true);

                    out = false;
                    break;
                }
            }

            if (out) {
                for (var i = 0; i < this.frames; i++)
                    if (this.topSeq[i] == item.id) {
                        this.topSeq[i] = 0; // clear
                        break;
                    }
                this.game.add.tween(item).to({ x: item.originX }, 500, Phaser.Easing.Cubic.Out, true);
                this.game.add.tween(item).to({ y: item.originY }, 500, Phaser.Easing.Cubic.Out, true);
            }

            if (this.topSeq.toString() == this.correctSeq.toString()) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Sekwencja poprawna.");
                super.nextTask();
            }
        }

        shuffle(o) {
            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
            return o;
        }


     }

    class Icon extends Phaser.Sprite {

        originX: number;
        originY: number;
        rect: Phaser.Rectangle;
        id: number;

        constructor(game, x, y, key, id) {
            this.originX = x;
            this.originY = y;
            this.id = id;
            this.rect = new Phaser.Rectangle(x, y, 300, 300);

            super(game, x, y, key);

            this.events.onDragStop.add(this.updateCoord, this);
        }

        updateCoord() {
            this.rect = new Phaser.Rectangle(this.x, this.y, 300, 300);
        }
    }
}