var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Coloring;
(function (_Coloring) {
    var Coloring = (function (_super) {
        __extends(Coloring, _super);
        function Coloring(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Coloring.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
        };
        Coloring.prototype.decodeBase64 = function (s) {
            var e = {}, i, b = 0, c, x, l = 0, a, r = '', w = String.fromCharCode, L = s.length;
            var A = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
            for (i = 0; i < 64; i++) {
                e[A.charAt(i)] = i;
            }
            for (x = 0; x < L; x++) {
                c = e[s.charAt(x)];
                b = (b << 6) + c;
                l += 6;
                while (l >= 8) {
                    ((a = (b >>> (l -= 8)) & 0xff) || (x < (L - 2))) && (r += w(a));
                }
            }
            return r;
        };
        Coloring.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.Svg = this.decodeBase64(this.GameData.Svg[0].base64);
            this.task = this.GameData.Options[0].task;
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.game.load.start();
            var htmlHead = document.getElementsByTagName('head');
            var helperScript = document.createElement('script');
            helperScript.setAttribute('src', 'Games/Elements/Coloring/svgHelper.js');
            htmlHead[0].appendChild(helperScript);
            var exam = document.getElementById('exam');
            var coloringBook = document.createElement('div');
            coloringBook.setAttribute('id', MODULE + '_' + this.task);
            coloringBook.setAttribute('style', 'display: none;');
            exam.appendChild(coloringBook);
            var svgContainer = document.createElement('div');
            svgContainer.setAttribute('id', 'svgContainer');
            svgContainer.setAttribute('style', 'position: absolute; z-index: 1000; top: 12%; left: 17%; width:70%; height:80%;');
            coloringBook.appendChild(svgContainer);
            svgContainer.innerHTML = "<svg id=\"" + 'svg_' + MODULE + '_' + this.task + "\" xmlns=\"http://www.w3.org/2000/svg\" width=\"100%\" height=\"100%\" viewBox=\"0 0 900 700\" style=\"fill:#fff; stroke: #000; stroke-opacity: 0.9; \">" + this.Svg + "</svg>";
            var paletteContainer = document.createElement('div');
            paletteContainer.setAttribute('id', 'paletteContainer');
            paletteContainer.setAttribute('style', 'position: absolute; top: 30%; left: 1%; width:100%; height: 34%;');
            coloringBook.appendChild(paletteContainer);
            paletteContainer.innerHTML = "<svg class=\"swatches\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 40 500\" width=\"25%\" height=\"100%\" \" ><rect style=\"fill:#d4213d\" x=\"0\"  y=\"0\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#e9e8e7\" x=\"0\"  y=\"50\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#ff5cae\" x=\"0\" y=\"100\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#6d2bed\" x=\"0\" y=\"150\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#ffe131\" x=\"0\"  y=\"200\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#80ce1b\" x=\"0\" y=\"250\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#f28d20\" x=\"0\" y=\"300\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#843617\" x=\"0\" y=\"350\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#339eff\" x=\"0\" y=\"400\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:undefined\" x=\"0\" y=\"460\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:#339eff\" x=\"0\" y=\"400\" width=\"40px\" height=\"40px\" /> <rect style=\"fill:undefined\" stroke=\"#ffffff\" stroke-width=\"20\"  x=\"0\" y=\"450\" width=\"40px\" height=\"40px\" /> <line x1=\"0\" y1=\"450\" x2=\"40\" y2=\"490\" stroke=\"red\" stroke-width=\"3\" /> <rect id=\"selection\" style=\"stroke: #0000ff; stroke - opacity: 1; fill: none\" x=\"0\" y=\"0\" width=\"40\" height=\"40\"/> </svg>";
            this.vSender = document.createElement('div');
            this.vSender.setAttribute('id', 'vs_' + MODULE + '_' + this.task);
            this.vSender.setAttribute('style', 'display: none;');
            this.vSender.innerHTML = "0";
            exam.appendChild(this.vSender);
        };
        Coloring.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
        };
        Coloring.prototype.update = function () {
            if (this.vSender.innerHTML == '1') {
                EU.setGameCompletion(this.parent, 1);
            }
            else {
                EU.setGameCompletion(this.parent, 0);
            }
            if (this.game.camera.x == this.task * 1920)
                window.document.getElementById(MODULE + '_' + this.task).style.display = 'block';
            else
                window.document.getElementById(MODULE + '_' + this.task).style.display = 'none';
        };
        return Coloring;
    })(Base.BasicGroup);
    _Coloring.Coloring = Coloring;
})(Coloring || (Coloring = {}));
//# sourceMappingURL=Coloring.js.map