var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Labyrinth;
(function (_Labyrinth) {
    var Labyrinth = (function (_super) {
        __extends(Labyrinth, _super);
        function Labyrinth(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Labyrinth.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Labyrinth.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
            this.game.load.tilemap('labyrinth', 'Scripts/Games/OB_G_II_3/labyrinth.js', null, Phaser.Tilemap.TILED_JSON);
        };
        Labyrinth.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Labyrinth.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
        };
        Labyrinth.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        Labyrinth.prototype.createLabirynth = function () {
            this.map = this.game.add.tilemap('labyrinth');
            this.cratesLayer = this.map.createLayer('cratesLayer');
            this.map.setCollisionBetween(1, 100000, true, 'cratesLayer');
            this.cratesLayer.resizeWorld();
        };
        return Labyrinth;
    })(Base.BasicGroup);
    _Labyrinth.Labyrinth = Labyrinth;
})(Labyrinth || (Labyrinth = {}));
//# sourceMappingURL=Labyrinth.js.map