var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var ImageMath_mod;
var zad_zaliczone = 0;
(function (_ImageMath_mod) {
    var ImageMath_mod = (function (_super) {
        __extends(ImageMath_mod, _super);
        function ImageMath_mod(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        ImageMath_mod.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        ImageMath_mod.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        ImageMath_mod.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            EU.createStaticElements(this);
            this.createSelectableElements();
            if (this.Elements.Options.Color)
                this.Color = this.Elements.Options.Color;
            if (this.Elements.Options.ColorText)
                this.ColorText = this.Elements.Options.ColorText;
            EU.createFillElements(this);
        };
        ImageMath_mod.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        ImageMath_mod.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        };
        ImageMath_mod.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        ImageMath_mod.prototype.createSelectableElements = function () {
            this.Selectables = [];
            for (var i = 0; i < this.Elements.SelectableElements.length; i++) {
                var Element = [];
                var tmpline = 0;
                for (var j = 0; j < this.Elements.SelectableElements[i].NumberOfElements; j++) {
                    var el;
                    switch (this.Elements.SelectableElements[i].el.type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.SelectableElements[i].el.key);
                            el.events.onInputDown.add(this.onInputDown, this);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.SelectableElements[i].el.text, this.Elements.Options.Style);
                            el.events.onInputDown.add(this.onInputText, this);
                            break;
                    }
                    var posX = this.Elements.SelectableElements[i].Position.x;
                    var posY = this.Elements.SelectableElements[i].Position.y;
                    if (this.Elements.Options.Just) {
                        switch (this.Elements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2 - ((this.Elements.Options.Spacing + el.width) * this.Elements.SelectableElements[i].NumberOfElements) / 2;
                                el.anchor.x = 0;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120 - (this.Elements.Options.Spacing + el.width) * this.Elements.SelectableElements[i].NumberOfElements;
                                el.anchor.x = 0;
                                break;
                        }
                        switch (this.Elements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    if (this.Elements.SelectableElements[i].NumberOfElementsPeerLine) {
                        if (j % this.Elements.SelectableElements[i].NumberOfElementsPeerLine == 0) {
                            tmpline = tmpline + 1;
                        }
                        posX = posX + (el.width) * (j % this.Elements.SelectableElements[i].NumberOfElementsPeerLine);
                        posY = posY + (el.height) * (tmpline);
                        el.position.set(posX, posY);
                    }
                    else {
                        el.position.set(posX + (this.Elements.Options.Spacing + el.width) * j, posY);
                    }
                    el.inputEnabled = true;
                    el.name = "unchecked";
                    el.events.onInputOver.add(this.onInputOver, this);
                    el.events.onInputOut.add(this.onInputOut, this);
                    this.addChild(el);
                    Element.push(el);
                }
                this.Selectables.push(Element);
            }
        };
        ImageMath_mod.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        ImageMath_mod.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        ImageMath_mod.prototype.onInputDown = function (el, pointer) {
            if (el.name == "unchecked") {
                el.tint = this.Color;
                el.name = "checked";
            }
            else {
                el.name = "unchecked";
                el.tint = 0xFFFFFF;
            }
            this.checkIfEverythingIsCorrect();
        };
        ImageMath_mod.prototype.onInputText = function (el, pointer) {
            if (el.name == "unchecked") {
                el.setShadow(el.height / 25, el.height / 25, this.ColorText);
                el.name = "checked";
            }
            else {
                el.setShadow(0, 0, "black");
                el.name = "unchecked";
            }
            this.checkIfEverythingIsCorrect();
        };
		ImageMath_mod.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
        ImageMath_mod.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log(this.calculatePlayerPoints() + "/" + this.calculateMaxPoints());
            if (this.calculateMaxPoints() == this.calculatePlayerPoints() && EU.checkIfFillsAreCorrect(this)) {
                zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                if (TYPE === "gm")
					var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
                    _super.prototype.nextTaskforImageMath.call(this);
                return true;
            }
            zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            return false;
        };
        ImageMath_mod.prototype.calculatePlayerPoints = function () {
            var points = 0;
            for (var i = 0; i < this.Selectables.length; i++) {
                var checked = 0;
                for (var j = 0; j < this.Selectables[i].length; j++) {
                    if (this.Selectables[i][j].name == "checked") {
                        checked++;
                    }
                }
                if (checked == this.Elements.SelectableElements[i].CorrectNumOfElements) {
                    points++;
                }
            }
            return points;
        };
        ImageMath_mod.prototype.calculateMaxPoints = function () {
            return this.Elements.SelectableElements.length;
        };
        return ImageMath_mod;
    })(Base.BasicGroup);
    _ImageMath_mod.ImageMath_mod = ImageMath_mod;
})(ImageMath_mod || (ImageMath_mod = {}));
//# sourceMappingURL=ImageMath_mod.js.map