﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentPagesList = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.p_checkMarkers = true;
	this.p_checkPNG = true;

	this.buttonVisible = true;
};

componentPagesList.prototype = new componentElement();
componentPagesList.prototype.type = "componentPagesList";

componentPagesList.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
		this.resourcesURL = unescape(this.resourcesURL); 

		this.imagesNameArr = [this.bckgTop, this.bckgMiddle, this.bckgBottom, this.bckgSeparator, this.buttonCloseOut, this.buttonCloseOver];
		this.getPreloadImagesArr();
	};
	this.captureMouseEvents();
};

componentPagesList.prototype.onCreate = function(obj)
{
	this.setImagesIntoHTMLObj();
};

componentPagesList.prototype.setImagesIntoHTMLObj = function()
{
	var bckgTopImg = document.getElementById(this.id + "_bckgTopImg");
	var bckgMiddleImg = document.getElementById(this.id + "_bckgMiddleImg");
	var bckgBottomImg = document.getElementById(this.id + "_bckgBottomImg");
	var addPageImg = document.getElementById(this.id + "_addPageImg");

	if (bckgTopImg) bckgTopImg.src = this.resourcesURL + this.bckgTop;
	if (bckgMiddleImg) bckgMiddleImg.src = this.resourcesURL + this.bckgMiddle;
	if (bckgBottomImg) bckgBottomImg.src = this.resourcesURL + this.bckgBottom;
	if (addPageImg) addPageImg.src = this.resourcesURL + this.buttonCloseOut;
};

componentPagesList.prototype.onPaint = function(obj)
{
	this.setDivElements();
};

componentPagesList.prototype.onAfterLoad = function(obj)
{
	if (PageInterface.GetValue("state") != psDesigning) this.deleteAllRows();
	this.setPagesName();
}

componentPagesList.prototype.setDivElements = function(obj)
{
	var bckgTopDiv = document.getElementById(this.id + "_bckgTopDiv");
	var bckgMiddleDiv = document.getElementById(this.id + "_bckgMiddleDiv");
	var bckgBottomDiv = document.getElementById(this.id + "_bckgBottomDiv");
	var addPageDiv = document.getElementById(this.id + "_addPageDiv");
	var pagesTableDiv = document.getElementById(this.id + "_pagesTableDiv");
	var pagesTableTd = document.getElementById(this.id + "_pagesTableTd");

	if (bckgTopDiv) {
		var bckgTopH = getImageHeight(this.bckgTop);
		var bckgTopW = getImageWidth(this.bckgTop);
		bckgTopDiv.style.left = 0;
		bckgTopDiv.style.top = 0;
		//bckgTopDiv.style.height = bckgTopH;
		bckgTopDiv.style.height = this.bckgTopH;
		bckgTopDiv.style.width = eval(this.w-2*this.borderWidth);
		//bckgTopDiv.style.clip = 'rect(0px '+eval(this.w-2*this.borderWidth)+'px '+bckgTopH+'px 0px)';
		bckgTopDiv.style.clip = 'rect(0px '+eval(this.w-2*this.borderWidth)+'px '+this.bckgTopH+'px 0px)';
	}
	if (bckgBottomDiv) {
		var bckgBottomW = getImageWidth(this.bckgBottom);
		bckgBottomDiv.style.left = 0;
		//bckgBottomDiv.style.top = this.h - this.bckgBottomHeight-2*this.borderWidth;
		bckgBottomDiv.style.top = this.h - this.bckgBottomH-2*this.borderWidth;
		bckgBottomDiv.style.height = this.bckgBottomH;
		bckgBottomDiv.style.width = eval(this.w-2*this.borderWidth);
		//bckgBottomDiv.style.clip = 'rect(0px '+eval(this.w-2*this.borderWidth)+'px '+this.bckgBottomHeight+'px 0px)';
		bckgBottomDiv.style.clip = 'rect(0px '+eval(this.w-2*this.borderWidth)+'px '+this.bckgBottomH+'px 0px)';
	};
	if (bckgMiddleDiv) {
		var bckgMiddleH = getImageHeight(this.bckgMiddle);
		var bckgMiddleW = getImageWidth(this.bckgMiddle);
		bckgMiddleDiv.style.left = 0;
		bckgMiddleDiv.style.top = this.bckgTopH;
		bckgMiddleDiv.style.height = eval(this.h-this.bckgTopH-this.bckgBottomH);
		bckgMiddleDiv.style.width = eval(this.w-2*this.borderWidth);
		bckgMiddleDiv.style.clip = 'rect(0px '+eval(this.w-2*this.borderWidth)+'px '+eval(this.h-bckgTopH-this.bckgBottomH)+'px 0px)';
	};
	if (addPageDiv) {
		var buttonCloseOutH = getImageHeight(this.buttonCloseOut);
		var buttonCloseOutW = getImageWidth(this.buttonCloseOut);
		if (this.dir == "rtl") {
			addPageDiv.style.left = 40-buttonCloseOutW;
		} else {
			addPageDiv.style.left = this.w-40;
		};
		addPageDiv.style.top = 0;
		addPageDiv.style.height = buttonCloseOutH;
		addPageDiv.style.width = buttonCloseOutW;
		addPageDiv.style.clip = 'rect(0px '+buttonCloseOutW+'px '+buttonCloseOutH+'px 0px)';
	};
	if(pagesTableDiv) {
		pagesTableDiv.style.left = 0;
		//pagesTableDiv.style.top = bckgTopH;
		pagesTableDiv.style.top = this.bckgTopH;
		//pagesTableDiv.style.height = eval(this.h-bckgTopH-this.bckgBottomHeight);
		pagesTableDiv.style.height = eval(this.h-this.bckgTopH-this.bckgBottomH);
		pagesTableDiv.style.width = eval(this.w-1);
		//pagesTableDiv.style.clip = 'rect(0px '+eval(this.w-1)+'px '+eval(this.h-bckgTopH-this.bckgBottomHeight)+'px 0px)';
		pagesTableDiv.style.clip = 'rect(0px '+eval(this.w-1)+'px '+eval(this.h-this.bckgTopH-this.bckgBottomH)+'px 0px)';
	};
	if (pagesTableTd) {
		if(this.allowGF && project.globalFormating) {
			pagesTableTd.style.fontFamily = project.font.family;
			pagesTableTd.style.fontSize = getFontSize(project.font.size, 'px');
			pagesTableTd.style.color = project.font.color;
		} else {
			pagesTableTd.style.fontFamily 	= this.fontFamily;
			pagesTableTd.style.fontSize 	= getFontSize(this.fontSize, 'px');
			pagesTableTd.style.color  	= this.fontColor;
		};
	};
};

componentPagesList.prototype.getPageName = function()
{
	return PageInterface.GetValue('pageName');
};

componentPagesList.prototype.buttonAddClick = function(buttonAdd)
{
	var pageN = this.getPageName();
	if (!pageN) pageN =  'Page preview'; else //project.pageRealGlobalIndex;
	if (pageN.length > 50) pageN = pageN.subtring(0,50)+"...";

	this.addPageToList(pageN, project.pageRealGlobalIndex, buttonAdd);
	//this.saveBookmarksName();
};

componentPagesList.prototype.addPageToList = function(pageName, pageGI, buttonAdd)
{
	var table 	= document.getElementById(this.id+"_pagesTable");
	if (!table) return;

	var path = '';
	if (PageInterface.GetValue("state") == psNormal ) path = '../';

	if (table.rows.length > 0) {
		var row 	= table.insertRow(table.rows.length);
		row.id 		= 'row_'+i;
		var cell 	= row.insertCell(0);
		//cell.style.border 	= "1px solid #000000";
		//cell.style.background = "transparent url("+path+"'resources/"+this.bckgSeparator+"') no-repeat";
		cell.innerHTML 	= '<img src="'+this.resourcesURL+this.bckgSeparator+'" height="5px" width="'+eval(this.w-25)+'px">';
	};
	var row 	= table.insertRow(table.rows.length);
	row.id		= 'row_'+i;
	var cell 	= row.insertCell(0);
	cell.id 	= "pGI_"+pageGI;
	cell.name 	= this.id;

	if (this.allowGF && project.globalFormating) {
		cell.style.fontFamily = project.font.family;
		cell.style.fontSize = getFontSize(project.font.size, 'px');
		cell.style.color = project.font.color;
	} else {
		cell.style.fontFamily 	= this.fontFamily;
		cell.style.fontSize 	= getFontSize(this.fontSize, 'px');
		cell.style.color  	= this.fontColor;
	};
	cell.style.textAlign 	= "center";
	cell.style.cursor  	= 'pointer';
	cell.innerHTML 	= pageName;
	cell.onclick = this.gotoPage;

	if (buttonAdd) this.saveBookmarksName();
};

componentPagesList.prototype.gotoPage = function()
{
	var idArr = this.id.split('pGI_');
	page.gotoPage(idArr[1]);
};

componentPagesList.prototype.changeImage = function(obj, fileName)
{
	obj.src = this.resourcesURL + fileName;
}

componentPagesList.prototype.saveBookmarksName = function(e)
{
	var table 	= document.getElementById(this.id+"_pagesTable");
	var length = table.rows.length;

	var t = '';
	var sep = '';
	for (var i=0; i<length; i++) {
		var inner = table.rows[i].cells[0].innerHTML.toUpperCase();
		if (inner.indexOf('<IMG') == -1) {
			if (t != '') sep = '|$|';
			t += sep;
			t += table.rows[i].cells[0].id.replace('pGI_', '')+"#!#";
			t += table.rows[i].cells[0].innerHTML;
		};
	};
	lms.setCourseData('_coursePagesList', t);
};

componentPagesList.prototype.setPagesName = function(e)
{
	var params = lms.getCourseData('_coursePagesList');
	if (params != '' && params != null) {
		var pagesArr = params.split('|$|');
		for (var i=0; i < pagesArr.length; i++) {
			var splited = pagesArr[i].split("#!#");
			this.addPageToList(splited[1], splited[0], false);
		};
	};
};

componentPagesList.prototype.deleteAllRows = function(index)
{
	var table = document.getElementById(this.id+"_pagesTable");
	if (table) {
		var length = table.rows.length;
		for (var i=0; i < length; i++){
			table.deleteRow(0);
		};
	};
};
