﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentStepButton = function(name)
{
	//inherited
	this.__componentImage = __componentImage;
	this.__componentImage(name);
	this.confirmAnswer = false;
};

componentStepButton.prototype = new __componentImage();
componentStepButton.prototype.type = "componentStepButton";

componentStepButton.prototype.componentStepButtonBaseOnCreate = componentStepButton.prototype.onCreate;
componentStepButton.prototype.onCreate = function(obj)
{
	this.componentStepButtonBaseOnCreate();

    this.resourcesURL = unescape(this.resourcesURL);

	this.captureMouseEvents();
	if ( this.stopTimeLine ) {
		page.stepsRunAutomate = false;
		page._stepsTimerStop();
	};
};

componentStepButton.prototype.eventClick = function(e)
{
	if ((this.confirmAnswer) && (page.pageType == "Exercise") && (page._isEveryPageVisited())) {
		PageInterface.Execute("checkAnswer"); 
	} else {
		if (this.onClick && this.onClick(this))     return true;
		if (this.parent && this.parent.eventClick)  this.parent.eventClick(e);

		if (this.resetStepsOnChange) {
			PageInterface.Execute("showSingleStep", page._getLastNotVisitedStep());
		} else PageInterface.Execute("nextStep"); 
	};

	if ((page._isEveryPageVisited()) && (this.hideOnLastStep)) this.hide();
	return false;
};

componentStepButton.prototype.onStep = function() //pg2-BSH_stepButton -if automatic lauch of steps is enabled, the button wouldn't be hidden on last step; also fixed in "page._isEveryPageVisited()"
{
	if (!this.hideOnLastStep || !page) return;

	if (page._isEveryPageVisited()) {
		this.hide();
	} else {
		this.show();
	};
};
