﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentDDElement = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);
	//included
	if (arguments[1]) {
	} else {
		this.image = this.addChild(new __componentImage(null));
		this.text = this.addChild(new __componentText(null));
	};
	this.cai = page.addChild(new __componentImage(null));
	this.cai.src = "empty";
	this.cai.paintLocked = true;	
	this.cai.w = 20;
	this.cai.h = 20;
	//Drag&Drop
	this.backToStart = true;
	this.canDragging = true;
	this.startDrag = false;
	this.orgZ = 0;
	this.paintCAIOutStatus = true;
	this.lockAfterGivenAnswer = true;
	this.myBasket = '';
	this.visibleCAI = false; //pg2-giub_cai_dnd
};

componentDDElement.prototype = new componentElement;
componentDDElement.prototype.type = "componentDDElement";

componentDDElement.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL);

	if (this.srcMove == '___.ddelement.move.gif' && this.src != '___.ddelement.gif') this.srcMove = this.src;

	this.imagesNameArr = [ this.src, this.srcMove, this.caiCorrectSrc, this.caiIncorrectSrc ];
	this.getPreloadImagesArr();

	if (this.canDragging) this.captureMouseEvents();		
};

componentDDElement.prototype.findContentObj = function(obj)
{
	return this.findContentObjByName(this.id + "_imageDIV_contentObj");
}

componentDDElement.prototype.onCreate = function(obj)
{
	if (this.execution) {
		//if (this.displayImage == 1){
		if (this.displayImage){ //pg2- it can be "1" or "true" or "0" or "false"
			document.getElementById(this.id + "_imageDIV").style.visibility = 'inherit';
			this.setImageSrc(this.resourcesURL + this.src);
		};
		//if (this.displayText == 0){
		if (!this.displayText){ //pg2- it can be "1" or "true" or "0" or "false"
			document.getElementById(this.id + "_textDIV").innerHTML = '';
		};
		document.getElementById(this.id + "_textDIV").style.visibility = 'inherit';

		document.getElementById(this.id + "_imageDIV").style.cursor = this.cursor; //pg2
		document.getElementById(this.id + "_textDIV").style.cursor = this.cursor; //pg2
	} else {
		this.text.p_checkMarkers = this.p_checkMarkers;
		this.text.p_checkPNG = this.p_checkPNG;
		this.text.pngFix = this.pngFix;

		this.image.p_checkMarkers = this.p_checkMarkers;
		this.image.p_checkPNG = this.p_checkPNG;
		this.image.pngFix = this.pngFix;

		this.image.visible = false;
		this.text.visible = false;
		if (this.displayImage) {
			this.image.captureMouseEvents();
		};
		if (this.displayText) {
		    this.text.captureMouseEvents();
		} else {
			this.text.text = '';
		};
	};
	this.cai.visible = false;
	this.orgZ = this.z;
	if (this.xPerc != '') this._startX = this.x;
	if (this.yPerc != '') this._startY = this.y;

	this.captureMouseEvents();
};

componentDDElement.prototype.componentDDElementSetSizeScaledElement = componentDDElement.prototype.setSizeScaledElement;
componentDDElement.prototype.setSizeScaledElement = function(x, y, w, h)
{
	this.componentDDElementSetSizeScaledElement(x, y, w, h);
	if (this.execution) {
		document.getElementById(this.id + "_imageDIV").style.clip = 'rect(0px '+this.obj.style.width+' '+this.obj.style.height+' 0px)';	
		document.getElementById(this.id + "_imageDIV").style.width = this.obj.style.width;
		document.getElementById(this.id + "_imageDIV").style.height = this.obj.style.height;
		document.getElementById(this.id + "_textDIV").style.clip = 'rect(0px '+this.obj.style.width+' '+this.obj.style.height+' 0px)';	
		document.getElementById(this.id + "_textDIV").style.width = this.obj.style.width;	
		document.getElementById(this.id + "_textDIV").style.height = this.obj.style.height;	
	};
	this._startX = this.x;
	this._startY = this.y;
};

componentDDElement.prototype.onPaint = function()
{	
	if (!this.execution) {
		this.style.cursor = this.cursor;

		this.image.visible = this.displayImage;
		this.image.cursor = this.cursor;
		this.image.w = parseInt(this.w) - 2*this.borderWidth;
		this.image.h = parseInt(this.h) - 2*this.borderWidth;
			
		this.text.visible = this.displayText;
		this.text.cursor = this.cursor;
		this.text.x = parseInt(this.padding);
		this.text.y = parseInt(this.padding);
		this.text.w = parseInt(this.w);
		this.text.h = parseInt(this.h);
	};

	this.cai.cursor = this.cursor;
	this.cai.w = this.caiImgWidth;
	this.cai.h = this.caiImgHeight;

	this.onRepaint();
};

componentDDElement.prototype.hideCAI = function()
{
	this.cai.hide();
	this.visibleCAI = false; //pg2-giub_cai_dnd
};

componentDDElement.prototype.showCAI = function()
{
	page.setOnTop(this.cai); //pg2- dla WSB

	//pg2-if the element is in a container, it wont be located properly
	var shiftX = 0;
	var shiftY = 0;
	if (this.parent.type == 'componentContainer') {
		shiftX = this.parent.x;
		shiftY = this.parent.y;
	};

	switch (this.caiAlign) {
		case "left": 
			this.cai.x = shiftX + this.x - this.caiImgWidth - 5;
			this.cai.y = shiftY + this.y + ((this.h - this.caiImgHeight) / 2);
			break;
		case "top": 
			this.cai.x = shiftX + this.x + ((this.w - this.caiImgWidth) / 2);
			this.cai.y = shiftY + this.y - this.caiImgWidth - 5;
			break;
		case "right":
			this.cai.x = shiftX + this.x + this.w + 5;
			this.cai.y = shiftY + this.y + ((this.h - this.caiImgWidth) / 2);
			break;
		case "bottom": 
			this.cai.x = shiftX + this.x + ((this.w - this.caiImgWidth) / 2);
			this.cai.y = shiftY + this.y + this.h + 5;
			break;
		default: 
			this.cai.x = shiftX + this.x + ((this.w - this.caiImgWidth) / 2);
			this.cai.y = shiftY + this.y + ((this.h - this.caiImgWidth) / 2);
			break;
	};

	this.cai.h = this.caiImgHeight;
	this.cai.w = this.caiImgWidth;
	this.cai.setZIndex(this.z);

	switch (this.getState()) {
		case 0:
			if (!this.paintCAIOutStatus) {
				this.hideCAI();
				break;
			};
			var isSet = false;
			if (this.isTopCorrect()) {
				this.cai.src = this.caiCorrectSrc;
				isSet = true;
			} else {
				if (!this.isBasketCorrect()) {
					this.cai.src = this.caiIncorrectSrc;
					if (!page.paintIncorrectCAI) {
						this.hideCAI();
						break;
					};
				} else {
					this.cai.src = this.caiCorrectSrc;
				};

				isSet = true;
			};
			if (isSet) {
				this.cai.paintLocked = false;
				this.cai.show();
				this.visibleCAI = true; //pg2-giub_cai_dnd
			};
			break;
		case 1:
			this.cai.src = this.caiCorrectSrc;
			this.cai.paintLocked = false;
			this.cai.show();
			this.visibleCAI = true; //pg2-giub_cai_dnd
			break;
		case 2:
			this.cai.src = this.caiIncorrectSrc;
			if (!page.paintIncorrectCAI) {
				this.hideCAI();
				return;
			};
			this.cai.paintLocked = false;
			this.cai.show();
			this.visibleCAI = true; //pg2-giub_cai_dnd
			break;
	};
};

componentDDElement.prototype.onRepaint = function()
{
	if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) {
		this.showCAI();
	};
};

componentDDElement.prototype.setBackToStart = function(b)
{
	//  this.backToStart = b;
};

componentDDElement.prototype.checkMakeRePaint = function()
{
	if (this.showWhenIsCorrect && PageInterface.GetValue("getPageSolved")){
		this.showCAI();
		this.lock();
	};
};

componentDDElement.prototype.getReturnWhenIncorect = function()
{
	return this.returnWhenIncorect;
};

componentDDElement.prototype.checkMoveToStart = function()
{
	if (this.getReturnWhenIncorect() && PageInterface.GetValue("getPageSolved")){
		this.moveToStart();
	};
};

componentDDElement.prototype.refreshElement = function()
{
	this.moveToStart();
};

componentDDElement.prototype.moveToStart = function()
{	
	this.setZIndex(this.orgZ);
	this.moveTo(this._startX, this._startY);
};

componentDDElement.prototype.getState = function()
{
	//0 - run position
	//1 - correct
	//2 - incorrect
	var parentComp = page; //pg2-FPC -DnD within container
	if (this.parent.type == 'componentContainer') parentComp = this.parent;
	
	for (var i=0; i<parentComp.children.length; i++) {
		var basket = parentComp.children[i];
		if (basket.type == "componentDDBasket") {
			if (basket.checkIfBelongsToMe(this)) {
				return (basket.ElementIsCorrectAnswer(this.id)) ? 1 : 2;
			};
		};
	};
	return 0;
};

componentDDElement.prototype.isTopCorrect = function()
{
	for (var i=0; i<page.children.length; i++) {
		var basket = page.children[i];
		if (basket.type == "componentDDBasket") {
			if (basket.ElementIsCorrectAnswer(this.id)) return false;
		};
	};
	return true;
};

componentDDElement.prototype.isBasketCorrect = function()
{
	var result = true;
	for (var i=0; i<page.children.length; i++) {
		var basket = page.children[i];
		if (basket.type == "componentDDBasket") {
			if (basket.ElementIsCorrectAnswer(this.id)) {
				if (basket.checkAnswer()) result &= true;
					else result &= false;
			};
		};
	};
	return result;
};

componentDDElement.prototype.beginDrag = function()
{
	this.setZIndex(1000);

	this.setImageSrc(this.resourcesURL + this.srcMove);

	this.hideCAI();

	if (page) page.hideFeedbacks(); //pg2-giub_cai_dnd

	if (!this.invokeEvent('BeginDrag')) {
		this.lastX = this.x;
		this.lastY = this.y;
		return true;
	};	
};

componentDDElement.prototype.endDrag = function(obj)
{
	this.setImageSrc(this.resourcesURL + this.src);
	
	if (obj && obj.type == "componentDDBasket") {
		this.setZIndex(obj.z + 1);
		if (this.myBasket != obj.id) this.checkBasketEmpty();
		this.myBasket = obj.id;
	};
	
	if (!this.invokeEvent('EndDrag')) {
		this.checkBasketEmpty();
		if (!obj || obj.type != "componentDDBasket") {
			this.moveToStart();
			this.myBasket = "";
			return false;
		};

		if(obj && obj.type == "componentDDBasket" && !obj.autoCompose) {
			if(this.x < obj.x || this.y < obj.y ||
			  this.x+this.w > obj.x+obj.w || this.y+this.h > obj.y+obj.h) {
				this.moveToStart();
				return false;
			};
		};
	};
	return true;
};

componentDDElement.prototype.checkBasketEmpty = function()
{
	var basket = pc[this.myBasket];
	if (basket){
		var list = basket.getListOfBasketsInsideMe();
		if (list == "") basket.invokeEvent('Empty');
	};
};

componentDDElement.prototype.onLock = function()
{
	this.canDragging = false;
	return true;
};

componentDDElement.prototype.onUnLock = function()
{
	this.canDragging = true;
	return true;
};
