var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var TweenImage;
(function (_TweenImage) {
    var TweenImage = (function (_super) {
        __extends(TweenImage, _super);
        function TweenImage(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.selectedImageList = [];
            this.textureList = [];
            this.groupCount = 0;
            this.cloudList = [];
            this.movingElementsArray = [];
            this.isHelpShown = false;
            this.firstRun = true;
        }
        TweenImage.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadImages();
            this.game.load.start();
        };
        TweenImage.prototype.loadImages = function () {
            for (var i = 0; i < this.elementArr.TaskList.length; i++) {
                this.game.load.image(this.elementArr.TaskList[i].Key, this.elementArr.TaskList[i].Select_img);
            }
            for (var i = 0; i < this.elementArr.StaticElements.length; i++) {
                this.game.load.image(this.elementArr.StaticElements[i].Key, this.elementArr.StaticElements[i].Select_img);
            }
        };
        TweenImage.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.insertStaticImages();
            this.insertImages();
            this.createGuild();
        };
        TweenImage.prototype.createGuild = function () {
            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "TEXT", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);
            this.guide.y = this.game.world.height;
            this.showHelp();
            this.addChild(this.guide);
            this.addChild(this.cloud);
        };
        TweenImage.prototype.changeHelp = function () {
            this.showHelp();
            this.cloudText.y = this.cloud.height * 0.4;
        };
        TweenImage.prototype.showHelp = function () {
            var tw = null;
            this.cloudText.setText("TEXT LEKTORA");
            var point = this.game.world.height;
            this.isHelpShown = !this.isHelpShown;
            if (this.isHelpShown) {
                point -= this.guide.height;
                try {
                    this.instruction.currentTime = 0;
                    this.instruction.play();
                    if (this.firstRun) {
                        var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 8, this.changeHelp, this);
                    }
                }
                catch (e) {
                }
            }
            else {
                try {
                    this.instruction.pause();
                    this.instruction.currentTime = 0;
                }
                catch (e) {
                }
            }
            tw = this.game.add.tween(this.guide);
            tw.to({ y: point }, 800, Phaser.Easing.Cubic.Out);
            tw.start();
        };
        TweenImage.prototype.insertStaticImages = function () {
            for (var i = 0; i < this.elementArr.StaticElements.length; i++) {
                this.staticImage = this.game.add.sprite(this.elementArr.StaticElements[i].PosX, this.elementArr.StaticElements[i].PosY, this.elementArr.StaticElements[i].Key);
                this.addChild(this.staticImage);
            }
        };
        TweenImage.prototype.insertImages = function () {
            for (var i = 0; i < this.elementArr.TaskList.length; i++) {
                this.item = this.game.add.sprite(this.elementArr.TaskList[i].PosX, this.elementArr.TaskList[i].PosY, this.elementArr.TaskList[i].Key);
                this.addChild(this.item);
            }
        };
        TweenImage.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.elementArr = json.GameData;
        };
        return TweenImage;
    })(Base.BasicGroup);
    _TweenImage.TweenImage = TweenImage;
})(TweenImage || (TweenImage = {}));
//# sourceMappingURL=TweenImage.js.map