﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
if (typeof(moduleDone) != "undefined") moduleDone("pageInterface.js");

WBTPageInterface = function()
{
	this.connectedPage = null;

	/* error code */
	this.EC_INTERFACE_NOT_INITIALIZED = "WBTPageInterface error. Interface not initialized.\nYou must initialize the interface first.";
	this.EC_INTERFACE_NOT_SUPPROT_MOP_GET = "WBTPageInterface error. %s. Instruction %s is not suported.";
	this.EC_INTERFACE_NOT_SUPPROT_MOP_SET = "WBTPageInterface error. %s. Instruction %s is not suported.";
	this.EC_EXECUTION_INSTRUCTION = "WBTPageInterface error. %s. Instruction execution error.\nCheck it: [%s]\n%s";
};

WBTPageInterface.prototype.Initialize = function(obj)
{
	this.connectedPage = obj;
};

WBTPageInterface.prototype.GetValue = function(name)
{
	if (!this.connectedPage) {
		error(this.EC_INTERFACE_NOT_INITIALIZED);
		return null;
	};
	switch (name) {
		case "allowCAI":
			if (this.connectedPage.pageType == 'Exercise') {
				return this.connectedPage.showCorrectAnswerIndicator && this.connectedPage.solved;
			} else {
				return this.connectedPage.showCorrectAnswerIndicator;
			};
			break;
		case "getChild":
			try {
				return this.connectedPage.all[arguments[1]];
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "GetValue", arguments[1]));
				return null;
			};
			break;
		case "getChildren":
			return this.connectedPage.children;
			break;
		case "pageType":
			return this.connectedPage.pageType;
			break;
		case "pageGix":
			return this.connectedPage.p_globalIndex;
			break;
		case "pageIndex":
			return this.connectedPage.p_index;
			break;
		case "pageName":
			return this.connectedPage.getName();
			break;
		case "pageStatus":
			return this.connectedPage.getPageStatus();
			break;
		case "state":
			return this.connectedPage.state;
			break;
		case "preloadState":
			return this.connectedPage.preloadState;
			break;
		case "noActiveXErrorShowed":
			return this.connectedPage.warning_NO_ACTIVEX_ERROR_Showed;
			break;
		case "stepIndex":
			return this.connectedPage.stepIndex;
			break;
		case "pageStepsCount":
			return this.connectedPage.steps.length-2;
			break;
		case "isExam":
			return this.connectedPage.isExam;
			break;
		case "userScore":
			return this.connectedPage.userScore;
			break;
		case "masteryScore":
			return this.connectedPage.masteryScore;
			break;
		case "maxScore":
			return this.connectedPage.maxScore;
			break;
		case "answerWeighting":
			return this.connectedPage.answerWeighting;
			break;
		case "countAnswers":
			return this.connectedPage.countAnswers;
			break;
		case "resourcesStatus":
			return (lms && lms.name != "lmsOffline") ? lms.resourcesStatus() : "online";
			break;
		case "resourcesURL":
			return (lms && lms.name != "lmsOffline") ? lms.resourcesURL() : resourcesURL;
			break;
		case "isSLWTypingComponent":
			return this.connectedPage.typingSLWComponentID;
			break;
		case "getFocusedInput":
			return this.connectedPage.focusedInput;
			break;
		case "getTryNumber":
			return this.connectedPage.getTryNumber();
			break;
		case "tryLeft":
			return this.connectedPage.getTryLeft();
			break;
		case "getSlideShowSLWComponent":
			var child = null;
			for (var i=0; i < this.connectedPage.children.length; i++) {
				child = this.connectedPage.children[i];
				if ((child.type == 'componentKeyControler' && child.visible) || (child.type == 'componentSLWSlideShow' && child.userTyping && child.typing == 'isTyping')) return child;
			};
			return null;
			break;
		case "pageIsShow":
			return this.connectedPage.pageIsShow;
			break;
		case "pageWidth":
			return this.connectedPage.pageWidth;
			break;
		case "pageHeight":
			return this.connectedPage.pageHeight;
			break;
		case "baseTryCount":
			return this.connectedPage.getBaseTryCount();
			break;
		case "getPageStatus":
			return this.connectedPage.getPageStatus();
			break;
		case "getPageSolved":
			return this.connectedPage.getPageSolved();
			break;
		default:
			try {
				eval('error("' + formatString(this.EC_INTERFACE_NOT_SUPPROT_MOP_GET, "GetValue", name) + '");');
			} catch(e) {
				if (typeof(page) != "undefined" && page.state == psView) alert('WBTPageInterface.GetValue(), "switch->default:" section eval error\nMessage:\n' + e.message); //pg2
			};
			return null;
			break;
	};
	return null;
};

WBTPageInterface.prototype.SetValue = function(name, value)
{
	if (!this.connectedPage) {
		error(this.EC_INTERFACE_NOT_INITIALIZED);
		return false;
	};
	switch (name) {
		case "noActiveXErrorShowed":
			this.connectedPage.warning_NO_ACTIVEX_ERROR_Showed = value;
			return true;
		case "automateStepsRun": 
			try {
				this.connectedPage.stepsRunAutomate = arguments[1];
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "automateStepsRun", arguments[1] + "\n The second argument should be a boolean value (true, false)"));
				return false;
			};
			return true;
			break;
		case "stepsTimerStop": 
			try {
				this.connectedPage._stepsTimerStop();
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "stepsTimerStop", "This option does not need arguments."));
				return false;
			};
			return true;
			break;
		case "setSLWTypingComponent":
			try {
				this.connectedPage.typingSLWComponentID = arguments[1];
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "setSLWTypingComponent wasn't succesfull please check code."));
				return false;
			};
			break;
		case "setFocusedInput":
			try {
				this.connectedPage.focusedInput = arguments[1];
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "setFocusedInput wasn't succesfull please check code."));
				return false;
			};
			break;
		case "allowGetMaxScore":
			try {
				this.connectedPage.allowGetMaxScore = arguments[1];
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "allowGetMaxScore wasn't succesfull please check code."));
				return false;
			};
			break;
		case "setSLWSimulation":
			try {
				this.connectedPage.setSLWSimulation(arguments[1]);
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "setSLWSimulation wasn't succesfull please check code."));
				return false;
			};
			break;
		default:
			try {
				eval('error("' + formatString(this.EC_INTERFACE_NOT_SUPPROT_MOP_SET, "SetValue", name) + '");');
			} catch(e) {
				if (typeof(page) != "undefined" && page.state == psView) alert('WBTPageInterface.SetValue(), "switch->default:" section eval error\nMessage:\n' + e.message); //pg2
			};
			break;
	};
	return false;
};

WBTPageInterface.prototype.Execute = function(name)
{
	if (!this.connectedPage) {
		error(this.EC_INTERFACE_NOT_INITIALIZED);
		return false;
	};

	switch (name) {
		case "createChild":
			try {
				return eval("new " + arguments[1] + "('" + arguments[2] + "');");
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "Execute", arguments[1] + "\n" + arguments[2],
					"The second argument must be the component type, e.g. componentImage.\nAnd the third is the alpha-numeric element name, e.g. image1."));
				return null;
			};
			break;
		case "addChild":
			if (typeof(arguments[1]) == "object" && arguments[1].isComponentElement) {
				return this.connectedPage.addChild(arguments[1]);
			} else {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "Execute", arguments[1],
					"The second argument must be the element object."));
				return null;
			};
			break;
		case "checkAnswer":
			if (typeof(arguments[1]) == "object" && arguments[1].isComponentElement) {
				return this.connectedPage.checkAnswer(arguments[1]);
			} else {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "Execute", arguments[1],
					"The second argument must be the element object (sender)."));
				return null;
			};
			break;
		case "addScrollText":
			if (typeof(arguments[1]) == "string") {
				return this.connectedPage.addScrollText(arguments[1]);
			} else {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "Execute", arguments[1],
					"The second argument must be text."));
				return null;
			};
			break;
		case "showSingleStep":
			if (!isNaN(arguments[1])) {
				this.connectedPage._showSingleStep(arguments[1]);
			} else {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "showSingleStep", arguments[1],
					"The second argument must be a number of last visited step."));
				return -1;
			};
			break;
		case "skipToChosenStep":
			if (!isNaN(arguments[1])) {
				this.connectedPage.skipToChosenStep(arguments[1]);
			} else {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "skipToChosenStep", arguments[1],
					"The second argument must be a number of last visited step."));
				return -1;
			};
			break;
		case "goToChosenStep":
			if (!isNaN(arguments[1])) {
				this.connectedPage.goToChosenStep(arguments[1]);
			} else {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "goToChosenStep", arguments[1],
					"The second argument must be a number of step."));
				return -1;
			};
			break;
		case "showNextStep":
			if (!isNaN(arguments[1])) {
				this.connectedPage._showSingleStep(arguments[1]);
			} else {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "showNextStep", arguments[1],
					"The second argument must be a number of last visited step."));
				return -1;
			};
			break;
		case "nextStep":
			try{
				this.connectedPage.nextStep();
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "nextStep not work correctlly please check this!."));
			};
			break;
		case "prevStep":
			try {
				this.connectedPage.prevStep();
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "prevStep not work correctlly please check this!."));
			};
			break;
		case "nextPage":
			this.connectedPage.nextPage();
			return true;
		case "prevPage":
			this.connectedPage.prevPage();
			return true;
		case "closeCourse":
			try {
				this.connectedPage.close();
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "CloseCourse wasn't succesfull please check code."));
			};
			break;
		case "setOnTop":
			try {
				this.connectedPage.setOnTop(arguments[1]);
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "setOnTop wasn't succesfull please check code."));
			};
			break;
		case "lock":
			try {
				this.connectedPage.lock();
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "lock page wasn't succesfull please check code."));
			};
			break;
		case "repaintPageElements":
			try {
				this.connectedPage.repaintPageElements();
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "repaint elements wasn't succesfull please check code."));
			};
			break;
		case "repaintAndLockElements":
			try {
				this.connectedPage.repaintAndLockElements(arguments[1]);
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "calling function 'repaintAndLockElements' wasn't succesfull please check code."));
			};
			break;
		case "showSlideShow":
			try {
				if (arguments[1]) arguments[1].checkCorrectKeyPressed(arguments[2]);
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "showSlideShow wasn't succesfull please check code."));
			};
			break;
		case "refreshPage":
			try {
				this.connectedPage.refreshPage();
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "refreshPage wasn't succesfull please check code."));
			};
			break;
		case "runStepAudio":
			try {
				this.connectedPage.runStepAudio();
			} catch(e) {
				error(formatString(this.EC_EXECUTION_INSTRUCTION, "runStepAudio wasn't succesfull please check code."));
			};
			break;
		default:
			try {
				eval('error("' + formatString(this.EC_INTERFACE_NOT_SUPPROT_MOP_SET, "Execute", name) + '");');
			} catch(e) {
				if (typeof(page) != "undefined" && page.state == psView) alert('WBTPageInterface.Execute(), "switch->default:" section eval error\nMessage:\n' + e.message); //pg2
			};
			break;
	};
	return false;
};

WBTPageInterface.prototype.Commit = function(obj)
{
	if (!this.connectedPage) {
		error(this.EC_INTERFACE_NOT_INITIALIZED);
		return;
	};
	//do someting
};

WBTPageInterface.prototype.Terminate = function(obj)
{
	this.connectedPage = null;
};

PageInterface = new WBTPageInterface();
