﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentShowExerciseFeedback = function(name) {
	this.componentButton = componentButton;
	this.componentButton(name);
	this.flashVars = "";
	this.confirmAnswer = true;
	this.multiCallBlock = false;
};

componentShowExerciseFeedback.prototype = new componentButton;
componentShowExerciseFeedback.prototype.type = "componentShowExerciseFeedback";

componentShowExerciseFeedback.prototype.onBaseCreate = function(obj){
	this.resourcesURL = resourcesURL;
	//this.standardButton = this.useFlash; //pg2- used only in MouseOver/Out events, and with this line when element is locked- inherited from button images are shown
	this.resourcesStatus = "online";
	if (lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	if (!this.useFlash) this.standardButton = false; //pg2- without it, mouseOver/Out will not be working, but in case of using flash...
	this.lockedSrc = this.mouseOverSrc; //pg2-inherited from button
	this.mouseOverLockedSrc = this.mouseOverSrc;
	this.imagesNameArr = [this.src,this.mouseOverSrc,this.clickSrc,this.lockedSrc];
	this.getPreloadImagesArr();
	this.captureMouseEvents();
};

//componentShowExerciseFeedback.prototype.onCreate = function(obj){
//	if(this.contentObj.alt == "") this.contentObj.alt=this.altHint;
//};

componentShowExerciseFeedback.prototype.componentShowExerciseFeedbackBaseSetValue = componentShowExerciseFeedback.prototype.setValue;
componentShowExerciseFeedback.prototype.setValue = function(value)
{
	if (this.useFlash) {
		this.createFlashObject(this.resourcesURL + this.flashSrc);
	} else {
		this.componentShowExerciseFeedbackBaseSetValue(value);
	};
};

componentShowExerciseFeedback.prototype.createFlashObject = function(value)
{
	var fv = "";
	if (PageInterface.GetValue("state") != psDesigning) {
		fv = "mediaStatus=" + lms.mediaStatus() + "&" + this.formatVar(this.flashVars);
	};

	var t = "";
	t += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="https://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="'+ this.w +'" height="'+ this.h +'" id="'+ this.id +'flashPlayer" align="middle">';
	t += '  <param name="movie" value="'+ value +'">';
	t += '  <param name="allowScriptAccess" value="sameDomain" />';
	t += '  <param name="BGColor" value="#FFFFFF">';
	t += '  <param name="quality" value="high">';
	t += '  <param name="play" value="false">';
	t += '  <param name="loop" value="true">';
	t += '  <param name="WMode" value="transparent">';
	t += '  <param name="scale" value="exactfit">';
	t += '  <param name="salign" value="CC">';
	t += '  <param name="FlashVars" value="'+fv+'">';
	t += '  <embed wmode="transparent" src="'+ value +'" quality="high" bgcolor="#FFFFFF" name="'+ this.id +'flashPlayer" type="application/x-shockwave-flash" pluginspage="https://www.macromedia.com/go/getflashplayer" width="'+ this.w +'" height="'+ this.h +'" FlashVars="'+fv+'"></embed>';
	t += '</object>';
	this.setHTML(t);
};

componentShowExerciseFeedback.prototype.componentShowExerciseFeedbackBaseEventClick = componentShowExerciseFeedback.prototype.eventClick;
componentShowExerciseFeedback.prototype.eventClick = function(e)
{
	if(this.multiCallBlock) return true;
	this.multiCallBlock = true;
	setTimeout("pc."+this.id+".multiCallBlock=false;",1000);

	if (this.locked) return false;
	//this.invokeEvent('Click'); //pg2-moved below -if there will be assigned event 'click -> page01 -> nextPage' etc, first will be executed jump, and then internal checkAnswer
	if (PageInterface.GetValue("pageType") == "Exercise") {
		PageInterface.SetValue("allowGetMaxScore", true);
		PageInterface.Execute("checkAnswer", this);
		var userScore = PageInterface.GetValue("userScore");
		var masteryScore = PageInterface.GetValue("masteryScore");
		var maxScore = PageInterface.GetValue("maxScore");
		var answerWeighting = PageInterface.GetValue("answerWeighting");
		var countAnswers = PageInterface.GetValue("countAnswers");
		var corAns = (answerWeighting)?(userScore >= masteryScore):(userScore == maxScore);
		var baseCountAnswers = PageInterface.GetValue("baseTryCount");

		this.hideFeedbacks();
		if (userScore == 100) {
			// brillant
			this.showFeedback(this.feedbackBrilliant);
			this.invokeEvent('FeedbackBrilliant');
			this.lockPage();
		} else
		if (corAns) {
			if (countAnswers <= 0) {
				// very good
				this.showFeedback(this.feedbackCorrect);
				this.invokeEvent('FeedbackCorrect');
				this.lockPage();
			} else {
				// good
				this.showFeedback(this.feedbackGood);
				this.invokeEvent('FeedbackGood');
			};
		} else {
			if (countAnswers <= 0) {
				if (baseCountAnswers == 0) { //pg2-in case of wrong answer and infinite try count- display 'try again'
					// try again
					this.showFeedback(this.feedbackAgain);
					this.invokeEvent('FeedbackAgain');
				} else {
					// bad
					this.showFeedback(this.feedbackIncorrect);
					this.invokeEvent('FeedbackIncorrect');
				};
				if (baseCountAnswers > 0) this.lockPage();
			} else {
				// try again
				this.showFeedback(this.feedbackAgain);
				this.invokeEvent('FeedbackAgain');
			};
		};
		PageInterface.SetValue("allowGetMaxScore", false);

		try {
			var s = this.onClick.toString(); //pg2- onClick in this component shouldn't be invoked 'checkAnswer' - despite if user has added this action - component checks answer within it by default;
			                                 //        if action is added - page try count and, components shown after some event, doesn't work
			s = s.replace(new RegExp('.actionCheckAnswer', "g"), '.doNothing');
			var f;
			eval("f=" + s);
			this.onClick = f;
		} catch(e) {};

		this.invokeEvent('Click'); //pg2-moved here
		return true;
	} else {
		this.invokeEvent('Click'); //pg2
		return this.componentShowExerciseFeedbackBaseEventClick(e);
	};
};

componentShowExerciseFeedback.prototype.repaintPageComponents = function()
{
	var isExam = PageInterface.GetValue("isExam");
	if (!isExam) PageInterface.Execute("repaintAndLockElements", this);
};

componentShowExerciseFeedback.prototype.lockPage = function()
{
	PageInterface.Execute("lock");
	this.repaintPageComponents();
};

componentShowExerciseFeedback.prototype.hideFeedbacks = function()
{
	var component = this.getFeedbackComponent(this.feedbackBrilliant); //pg2-action 'hide' was invoked even though component wasn't hidden- calling 'show()' - has invoked 'onHide'
	if (component && component.visible) component.hide();
	var component = this.getFeedbackComponent(this.feedbackCorrect);
	if (component && component.visible) component.hide();
	var component = this.getFeedbackComponent(this.feedbackGood);
	if (component && component.visible) component.hide();
	var component = this.getFeedbackComponent(this.feedbackIncorrect);
	if (component && component.visible) component.hide();
	var component = this.getFeedbackComponent(this.feedbackAgain);
	if (component && component.visible) component.hide();
};

componentShowExerciseFeedback.prototype.showFeedback = function(feedbackName)
{
	var component = this.getFeedbackComponent(feedbackName);
	if (component) component.show();
};

componentShowExerciseFeedback.prototype.getFeedbackComponent = function(feedbackName){
	var component = PageInterface.GetValue("getChild", feedbackName);
	if (component) {
		return component;
	} else {
		component = PageInterface.GetValue("getChild", this.getFeedbackNameWithBckg()+feedbackName);
		return component;
	};
};

componentShowExerciseFeedback.prototype.getFeedbackNameWithBckg = function(feedbackName)
{
	var bckgName = this.id.split("_");
	var bckgStr = ""
	for (var i=0; i<bckgName.length-1; i++) bckgStr += bckgName[i]+"_";
	return bckgStr;
};
