﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentTextWithScroll = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);

	this.imagesCompleteInfo = new Array();
	this.sliderLowOffset = 0;
	this.sliderHighOffset = 0;
	this.dragobject = null;
	this.buttonsActive = true;
	this.mouseIsDown = false;
	this.textHeight = true;
	this.trackHeight = 0;
	this.timer = null;

	this.headerHeight = 0;
	this.footerHeight = 0;
	this.buttonPadding = 3;
	this.textSpacing = 0;
	this.contentPadding = 0;
	this.checkboxesFieldH = 0;
};

componentTextWithScroll.prototype = new __componentText;
componentTextWithScroll.prototype.type = "componentTextWithScroll";

componentTextWithScroll.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL); 

	this.imagesNameArr = [ this.arrowTopOver, this.arrowTopOut, this.arrowBottomOver, this.arrowBottomOut, this.sliderOver, this.sliderOut, this.sliderBckg ];
	this.getPreloadImagesArr();
	this.setCompleteArrayInfo(this.completeInfoStyleImages);

	this.captureMouseEvents();
};

componentTextWithScroll.prototype.componentTextWithScrollBaseShow = componentTextWithScroll.prototype.show;
componentTextWithScroll.prototype.show = function(obj)
{
	this.placeHTMLObiects();
	this.getTextHeight();
	this.setHTMLObiects();

	this.mouseIsDown = true;
	this.moveScroll(0);
	this.mouseIsDown = false;

	this.componentTextWithScrollBaseShow();
}

componentTextWithScroll.prototype.setHTMLObiects = function(obj)
{
	if (this.buttonsActive) {
		var arrowTopImg= document.getElementById(this.id + "_arrowTopImg");
		var arrowBottomImg = document.getElementById(this.id + "_arrowBottomImg");
		if (arrowTopImg) this.setImageSrc(this.resourcesURL + this.arrowTopOut, arrowTopImg);
		if (arrowBottomImg) this.setImageSrc(this.resourcesURL + this.arrowBottomOut, arrowBottomImg);
	} else {
		var arrowTopImg= document.getElementById(this.id + "_arrowTopImg");
		var arrowBottomImg = document.getElementById(this.id + "_arrowBottomImg");
		if (arrowTopImg) this.setImageSrc(this.resourcesURL + this.arrowTopOff, arrowTopImg);
		if (arrowBottomImg) this.setImageSrc(this.resourcesURL + this.arrowBottomOff, arrowBottomImg);
		document.getElementById(this.id + "_trackDiv").style.visibility = "hidden";
		document.getElementById(this.id + "_arrowTopDiv").style.cursor = "default";
		document.getElementById(this.id + "_arrowBottomDiv").style.cursor = "default";
	};
	var trackImg = document.getElementById(this.id + "_trackImg");
	var trackBckgImg = document.getElementById(this.id + "_trackBckgImg");

	if (trackImg) this.setImageSrc(this.resourcesURL + this.sliderOut, trackImg);
	if (trackBckgImg) this.setImageSrc(this.resourcesURL + this.sliderBckg, trackBckgImg);
};

componentTextWithScroll.prototype.getTextHeight = function(obj)
{
	var tableDiv = document.getElementById(this.id + "_tableDiv");
	var Table = document.getElementById(this.id + "Table");

	if (typeof(tableDiv) == 'undefined' || tableDiv == null) return; //pg2
	tableDiv.style.top = 0;

	if (this.dir == "rtl") {
		tableDiv.style.left = this.getImageWidth('sliderBckg');
	} else {
		tableDiv.style.left = 0;
	};
	tableDiv.style.width = this.w - 2*this.borderWidth - this.getImageWidth('sliderBckg'); 
	//########
	this.textHeight = Table.scrollHeight;
	this.buttonsActive = (this.h < this.textHeight) ? true : false;
	//########
	tableDiv.style.height = this.h - 2*this.borderWidth;
	tableDiv.style.clip = 'rect(0px '+eval(this.w - 2*this.borderWidth)+'px '+eval(this.h - 2*this.borderWidth)+'px 0px)';
};

componentTextWithScroll.prototype.placeHTMLObiects = function(obj)
{
	var arrowTopDiv = document.getElementById(this.id + "_arrowTopDiv");
	var arrowBottomDiv = document.getElementById(this.id + "_arrowBottomDiv");
	var trackBckgDiv = document.getElementById(this.id + "_trackBckgDiv");
	var trackDiv = document.getElementById(this.id + "_trackDiv");
	var tableDiv = document.getElementById(this.id + "_tableDiv");
	var Table = document.getElementById(this.id + "Table");

	arrowTopDiv.style.top = 0;
	if (this.dir == "rtl") {
		arrowTopDiv.style.left = this.contentPadding;
	} else {
		arrowTopDiv.style.left = this.w - this.getImageWidth('arrowTopOut')-2*this.borderWidth-this.contentPadding;
	};
	arrowTopDiv.style.width = this.getImageWidth('arrowTopOut');
	arrowTopDiv.style.height = this.getImageHeight('arrowTopOut');
	arrowTopDiv.style.clip = 'rect(0px '+this.getImageWidth('arrowTopOut')+'px '+this.getImageHeight('arrowTopOut')+'px 0px)';

	arrowBottomDiv.style.top = this.h - this.getImageHeight('arrowBottomOut')-2*this.borderWidth;
	if (this.dir == "rtl") {
		arrowBottomDiv.style.left = this.contentPadding;
	} else {
		arrowBottomDiv.style.left = this.w - this.getImageWidth('arrowBottomOut')-2*this.borderWidth-this.contentPadding;
	};
	arrowBottomDiv.style.width = this.getImageWidth('arrowBottomOut');
	arrowBottomDiv.style.height = this.getImageHeight('arrowBottomOut');
	arrowBottomDiv.style.clip = 'rect(0px '+this.getImageWidth('arrowBottomOut')+'px '+this.getImageHeight('arrowBottomOut')+'px 0px)';

	trackBckgDiv.style.top = 0;
	if (this.dir == "rtl") {
		trackBckgDiv.style.left = this.contentPadding;
	} else {
		trackBckgDiv.style.left = this.w - this.getImageWidth('sliderBckg')-2*this.borderWidth-this.contentPadding;
	};
	trackBckgDiv.style.width = this.getImageWidth('sliderBckg');
	trackBckgDiv.style.height = this.h-2*this.borderWidth;
	trackBckgDiv.style.clip = 'rect(0px '+this.getImageWidth('sliderBckg')+'px '+this.h+'px 0px)';

	this.sliderLowOffset = this.getImageHeight('arrowTopOut');
	this.trackHeight = this.h - this.getImageHeight('arrowTopOut') - this.getImageHeight('arrowBottomOut') - 2*this.borderWidth;
	this.sliderHighOffset = this.trackHeight - this.getImageHeight('sliderOut');

	trackDiv.style.top = this.sliderLowOffset;
	if (this.dir == "rtl") {
		trackDiv.style.left = this.contentPadding;
	} else {
		trackDiv.style.left = this.w - this.getImageWidth('sliderOut')-2*this.borderWidth-this.contentPadding;
	};
	trackDiv.style.width = this.getImageWidth('sliderOut');
	trackDiv.style.height = this.getImageHeight('sliderOut');
	trackDiv.style.clip = 'rect(0px '+this.getImageWidth('sliderOut')+'px '+this.getImageHeight('sliderOut')+'px 0px)';

	Table.width = this.w - this.getImageWidth('sliderBckg') - 2*this.borderWidth;
};

componentTextWithScroll.prototype.setCompleteArrayInfo = function(style)
{
	var imagesStr = style;
	var imgArr = imagesStr.split(';');
	for (var i = 0; i < imgArr.length; i++) {
		var oneImg = imgArr[i].split(',');
		if (!this.imagesCompleteInfo[oneImg[0]]) {
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];
		};
	};
};

componentTextWithScroll.prototype.onPaint = function(obj, rep)
{
	return;
};

componentTextWithScroll.prototype.scrollWindow = function(obj)
{
	window.scrollTo(0, this.y);
};

componentTextWithScroll.prototype.moveScroll = function(scrollValue)
{
	if (!this.mouseIsDown) return;

	var tableScrollDiv = document.getElementById(this.id + '_tableScrollDiv');
	var	tableDiv = document.getElementById(this.id + "_tableDiv");
	var	trackDiv = document.getElementById(this.id + "_trackDiv");
	var Table = document.getElementById(this.id + "Table");

	if (tableScrollDiv && trackDiv) { //pg2-new one, independent of the scrollTop property
		var tableScrollDivTop = parseInt(tableScrollDiv.style.top.replace('px', ''));
		var tableScrollDivHeight = parseInt(tableScrollDiv.style.height.replace('px', ''));
		if (isNaN(tableScrollDivHeight)) tableScrollDivHeight = tableScrollDiv.offsetHeight;
		var tableDivHeight = parseInt(tableDiv.style.height.replace('px', ''));
		var trackPos = parseInt(trackDiv.style.top.replace('px', ''));
		var trackMinPos = this.sliderLowOffset;
		var trackMaxPos = this.sliderHighOffset + this.sliderLowOffset;
		//scrollValue < 0  = move down, >0 = move up
		trackPos = trackPos - scrollValue;
		if (trackPos > trackMaxPos) trackPos = trackMaxPos; else
		if (trackPos < trackMinPos) trackPos = trackMinPos;
		trackDiv.style.top = trackPos;
		
		var divDiffHeight = Math.abs(tableScrollDivHeight - tableDivHeight);
		var trackDiffPos = Math.abs(trackMaxPos - trackMinPos);
		if (trackDiffPos == 0) trackDiffPos = 1; //pg2-bi_AF - simplePopup with style
		var factor = divDiffHeight / trackDiffPos;
		tableScrollDiv.style.top = -Math.floor(factor * (trackPos-trackMinPos));
	} else { //pg2-old one, patched up a little bit, but too many strange behaviour (scrollTop) depends on the browser -used only in those components I haven't touched
		//if (!this.mouseIsDown) return;
		
		/*  //pg2-ie11 scroll in lexiconTree didn't work -removed
		var scrollTopTemp = tableDiv.scrollTop;
		var scrollNewPos = tableDiv.scrollTop - scrollValue;
		tableDiv.scrollTop = scrollNewPos;*/
		
		 //pg2-ie11 scroll in lexiconTree didn't work -new
		var tableTop = Table.style.top;
		tableTop = tableTop.replace('px', '');
		tableTop = tableTop.replace('pt', '');
		tableTop = tableTop.replace(';', '');
		if (tableTop == '') tableTop = '0';
		var scrollTopTemp = parseInt(tableTop);
		var scrollNewPos = (scrollTopTemp + scrollValue);
		Table.style.position = 'absolute';
		
		var maxScrollHeight = Table.offsetHeight - this.h + this.headerHeight + 2*this.contentPadding + 2*this.textSpacing + this.footerHeight + this.checkboxesFieldH;
		if (scrollNewPos > 0) scrollNewPos = 0; else
		if (Math.abs(scrollNewPos) > maxScrollHeight) scrollNewPos = -maxScrollHeight;
		Table.style.top = scrollNewPos;
		var trackAreaH = (this.trackHeight-(2*this.sliderLowOffset));//-this.getImageHeight('sliderOut');
		
		var scrollPosAbs = Math.abs(scrollNewPos);
		var trackPos = (trackAreaH/maxScrollHeight)*scrollPosAbs;
		if (trackPos < this.sliderLowOffset) trackPos = this.sliderLowOffset; else
		if (trackPos >= trackAreaH) {
			trackPos = trackAreaH;
			/*var obj = document.getElementById(this.id + '_trackBckgDiv');
			if (obj) { trackPos = obj.offsetHeight - 36; };*/
		};
		trackDiv.style.top = trackPos;
		//...
		
		//pg2-ie11 scroll in lexiconTree didn't work -removed
		//maxScrollHeight = (maxScrollHeight == 0)?1:maxScrollHeight;  //pg2-ie11 scroll in lexiconTree didn't work -removed
		/*var maxScrollHeight = tableDiv.scrollHeight - this.h + this.headerHeight + 2*this.contentPadding + 2*this.textSpacing + this.footerHeight + this.checkboxesFieldH;
		maxScrollHeight = (maxScrollHeight == 0)?1:maxScrollHeight;
		var percScrollPos = (tableDiv.scrollTop/maxScrollHeight);
		if (scrollValue < 0) {
			if (tableDiv.scrollTop == scrollNewPos) {
				var scrollPos = this.sliderLowOffset + this.trackHeight*percScrollPos - this.getImageHeight('sliderOut')*percScrollPos;
				if (scrollPos > this.sliderHighOffset + this.sliderLowOffset) scrollPos = this.sliderHighOffset + this.sliderLowOffset; //pg2-test_scroll button_down
				trackDiv.style.top = scrollPos;
			} else {
				trackDiv.style.top = this.sliderHighOffset + this.sliderLowOffset;
			};
		} else {
			var scrollPos = this.sliderLowOffset + this.trackHeight*percScrollPos - this.getImageHeight('sliderOut')*percScrollPos;
			if (scrollPos < this.sliderLowOffset) scrollPos = this.sliderLowOffset; //pg2-test_scroll button_up
			if (scrollPos > this.sliderHighOffset + this.sliderLowOffset) scrollPos = this.sliderHighOffset + this.sliderLowOffset; //pg2-test_scroll button_up (when scroll is lowerest position)
			trackDiv.style.top = scrollPos;
		};*/
		//this.timer = setTimeout("page.all['"+this.id+"'].moveScroll("+scrollValue+");", 100); //pg2-removed
	};
};

componentTextWithScroll.prototype.moveUp = function(obj)
{
	if (!this.buttonsActive) return;
	this.mouseIsDown = true;
	var scrollValue = 20;
	this.moveScroll(scrollValue);
};

componentTextWithScroll.prototype.moveDown = function(obj)
{
	//alert(this.buttonsActive);
	if (!this.buttonsActive) return;
	this.mouseIsDown = true;
	var scrollValue = -20;
	this.moveScroll(scrollValue);
};

componentTextWithScroll.prototype.moveSlider = function () 
{
	//top.window.document.title = getDateStr();
	this.mouseIsDown = false;
	var tableDiv = document.getElementById(this.id + "_tableDiv");
	var Table = document.getElementById(this.id + "Table");
	var tableScrollDiv = document.getElementById(this.id + '_tableScrollDiv'); //pg2-scroll_test

	if (Table && tableScrollDiv) { //pg2-scroll in IE9 + EIS
		var tableHeight = parseInt(Table.offsetHeight);
	};
	var isSimplePopup = (tableScrollDiv != null && typeof(tableScrollDiv) != 'undefined'); // (this.type == 'componentSimplePopup' || this.type == 'componentTextWithScroll'); //pg2-scroll in IE10 for TextWithScroll

	if (this.dragobject) {
		//top.window.document.title = window.event.clientX + ', ' + window.event.clientY;
		if (window.event.clientX >= 0 && window.event.clientY >= 0) {
			var trackH = this.dragobjectParent.offsetHeight;
			var trackT = this.dragobjectParent.offsetTop;
			var mouseClickPos = window.event.clientY - this.y - this.sliderLowOffset + document.body.scrollTop;

			if (mouseClickPos < trackH/2) {
				if (!isSimplePopup) { //pg2-scroll in IE9 + EIS
					tableDiv.scrollTop = 0;
					//top.window.document.title = window.event.clientX + ', ' + window.event.clientY + ', ' + tableDiv.scrollTop;
				} else {
					tableScrollDiv.style.top = '0px';
					//top.window.document.title = window.event.clientX + ', ' + window.event.clientY + ', ' + tableDiv.scrollHeight;
				};
				this.dragobjectParent.style.top = this.sliderLowOffset;
			} else
			if (mouseClickPos > trackH/2 && mouseClickPos < eval(this.sliderHighOffset + trackH/2)) {
				var divTop = eval(this.sliderLowOffset + mouseClickPos - trackH/2);
				this.dragobjectParent.style.top = divTop;
				var realTrackPos = divTop - this.sliderLowOffset;
				var trackFromTopPrec = (realTrackPos/this.sliderHighOffset).toFixed(3);
				var maxScrollTop = Table.offsetHeight - tableDiv.offsetHeight;
				if (!isSimplePopup) { //pg2-scroll in IE9 + EIS
					var val = Math.floor(maxScrollTop*trackFromTopPrec);// + 'px';
					//tableDiv.scrollTop = val; //maxScrollTop*trackFromTopPrec; //pg2-ie11 scroll in lexiconTree -removed
					Table.style.position = 'absolute'; //pg2-ie11 scroll in lexiconTree -new
					Table.style.top = -val;
					//top.window.document.title = maxScrollTop + ', ' + trackFromTopPrec + ' : ' + val + ' ; ' + tableDiv.scrollTop;
					//tableDiv.setAttribute('scrollTop', val);
				} else {
					tableScrollDiv.style.top = -1*((tableHeight-tableDiv.offsetHeight)*trackFromTopPrec) + 'px';//-1*(tableHeight*trackFromTopPrec) + 'px';
				};
			} else
			if (mouseClickPos > this.sliderHighOffset) {
				this.dragobjectParent.style.top = this.sliderHighOffset + this.sliderLowOffset;
				if (!isSimplePopup) { //pg2-scroll in IE9 + EIS
					//top.window.document.title = window.event.clientX + ', ' + window.event.clientY + ', ' + tableDiv.scrollHeight;
					tableDiv.scrollTop = tableDiv.scrollHeight;
				} else {
					tableScrollDiv.style.top =  -1*(tableHeight-tableDiv.offsetHeight)//-1*(tableHeight*trackFromTopPrec) + 'px'; //-tableDiv.scrollHeight + 'px';
					//top.window.document.title = window.event.clientX + ', ' + window.event.clientY + ', ' + tableDiv.scrollHeight;
				};
			};
		};
		window.event.returnValue = false;
		window.event.cancelBubble = true;
	};
};

componentTextWithScroll.prototype.stopSlider = function() //pg2-test
{
	this.dragobjectParent = null;
	this.dragobject = null;
	this.mouseIsDown = false;
};

componentTextWithScroll.prototype.mouseUp = function()
{
	this.mouseIsDown = false;// alert('mouseUp');
};

componentTextWithScroll.prototype.onSliderFree = function()
{
	var sliderDIV = document.getElementById(this.id + "_trackDiv");
	if (this.dragobject) {
		this.eventMouseUp(event);
		this.dragobject = false;
	};
};

componentTextWithScroll.prototype.onSliderClick = function(obj, objParent)
{
	window.event.returnValue = false;
	window.event.cancelBubble = true;

	this.dragobjectParent = objParent;
	this.dragobject = obj;
	//top.window.document.title = getDateStr(); //obj.id; //pg2-test
};

componentTextWithScroll.prototype.changeImage = function(obj, imageName)
{
	if (!this.buttonsActive) return;
	if (obj) this.setImageSrc(this.resourcesURL + imageName, obj);
	//obj.src = this.resourcesURL + imageName;
};

componentTextWithScroll.prototype.getImageHeight = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][1]);
};

componentTextWithScroll.prototype.getImageWidth = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][0]);
};

componentTextWithScroll.prototype.onFree = function()
{
	if (this.timer != null) {
		window.clearTimeout(this.timer);
		this.timer = null;
	};
};

componentTextWithScroll.prototype.setImageSrc = function(value, obj)
{
	value = unescape(value);
	if (obj) {
		if (this.pngFix && is.ie55UP && !is.ie7UP) {
			var is_span = (obj.tagName.toUpperCase() == 'SPAN');
			if (is_span) {
				var src = ".." + value.substr(value.lastIndexOf("/resources/"), value.length);
				obj.src = value;

				var psArr = this.getPosSize(obj);

				var png_img = new Image();
				png_img.src = value;
				var loaded = this.waitForImage(png_img, 50);

				var sizingMethod = "scale";
				if (loaded || (!isNaN(png_img.width) && !isNaN(png_img.height))) {
					if (parseInt(png_img.width) == parseInt(psArr[2])
							&& "" + parseInt(png_img.height) == parseInt(psArr[3])) {
						sizingMethod = "image";
					};
				};

				obj.style.filter = 'progid:DXImageTransform.Microsoft.AlphaImageLoader (src=\'' + src + '\',sizingMethod=\''+sizingMethod+'\'';
			} else {
				obj.src = value;
			};
		} else {
			obj.src = value;
		};
		return true;
	};
	return false;
};
