var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Fill;
var zad_zaliczone = 0;
(function (_Fill) {
    var Fill = (function (_super) {
        __extends(Fill, _super);
        function Fill(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.HorizontalPlacementArray = [];
            this.VerticalPlacementArray = [];
            this.CaseSensitivity = true;
            this.isGrid = false;
            this.StartingPosX = 0;
            this.StartingPosY = 0;
            this.Columns = 0;
            this.Rows = 0;
            this.Spacing = 0;
            this.initializationKeys = "";
            this.maxCharacters = 0;
            this.FillList = [];
            this.AlwaysGood = false;
            this.inputBoxStyle = { font: "normal 80pt Arial", fill: "black" };
        }
        Fill.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Fill.prototype.killKeyborad = function () {
            if (this.keyboard != undefined) {
                this.keyboard.destroy(false, false);
                this.keyboard = undefined;
            }
        };
        Fill.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.loadInit();
            this.createStaticElements();
            this.createActiveElments();
            EU.createStaticSounds(this);
        };
        Fill.prototype.loadInit = function () {
            this.initializationKeys = this.GameData.AcceptedCharacters;
            this.maxCharacters = this.GameData.MaxCharacters;
            if (this.GameData.CaseSensitivity === true || this.GameData.CaseSensitivity === false) {
                this.CaseSensitivity = this.GameData.CaseSensitivity;
            }
            this.AlwaysGood = this.GameData.AlwaysGood;
            if (this.GameData.isGrid == true) {
                this.isGrid = this.GameData.isGrid;
                this.StartingPosX = this.GameData.StartingPos.x;
                this.StartingPosY = this.GameData.StartingPos.y;
                this.Columns = this.GameData.Columns;
                this.Rows = this.GameData.Rows;
                this.Spacing = this.GameData.Spacing;
            }
        };
        Fill.prototype.loadGraphics = function () {
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        };
        Fill.prototype.createStaticElements = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            if (this.isGrid) {
                var currHeight = this.StartingPosY;
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var currWidth = this.StartingPosX;
                    if (this.GameData.StaticElements[i].HasImage) {
                        var el = this.game.add.image(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].key);
                        currWidth += el.width;
                        currHeight += el.height;
                        this.HorizontalPlacementArray.push(currWidth + this.Spacing);
                        this.VerticalPlacementArray.push(el.height / 2 + this.Spacing);
                        this.addChild(el);
                    }
                    if (this.GameData.StaticElements[i].HasText) {
                        var el_text = this.game.add.text(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.HorizontalPlacementArray.push(el_text.width + (LetterAmountmultipler / 2) + currWidth);
                        this.addChild(el_text);
                        el_text = this.game.add.text(this.HorizontalPlacementArray[i] + LetterAmountmultipler / 2, currHeight + (100 * i), this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        currWidth += el_text.width;
                        this.VerticalPlacementArray.push(currHeight + (100 * i));
                        this.addChild(el_text);
                    }
                }
            }
            else {
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    if (this.GameData.StaticElements[i].HasImage) {
                        var tmptext = this.game.cache.getImage(this.GameData.StaticElements[i].key);
                        var el = this.game.add.image(this.GameData.StaticElements[i].pos.x + (tmptext.width / 2), this.GameData.StaticElements[i].pos.y + (tmptext.height / 2), this.GameData.StaticElements[i].key);
                        el.anchor.set(0.5, 0.5);
                        if (this.GameData.StaticElements[i].rotation) {
                            el.angle = this.GameData.StaticElements[i].rotation;
                        }
                        this.addChild(el);
                    }
                    if (this.GameData.StaticElements[i].HasText) {
                        var el_text = this.game.add.text(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.addChild(el_text);
                        el_text = this.game.add.text(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.addChild(el_text);
                    }
                }
            }
        };
        Fill.prototype.createActiveElments = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
            }
            var BoxSize = 8 / 5 * this.fontSize;
            var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            if (this.GameData.SmallBox && this.GameData.SmallBox == true)
                LetterAmountmultipler = 60;
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            var bmd = this.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();
            var currHeight = this.StartingPosY;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                if (this.isGrid)
                    this.box = this.game.add.sprite(this.HorizontalPlacementArray[i], this.VerticalPlacementArray[i], bmd);
                else
                    this.box = this.game.add.sprite(this.GameData.TaskList[i].pos.x, this.GameData.TaskList[i].pos.y, bmd);
                this.box.anchor.set(0.5, 0.5);
                this.box.alpha = 0.5;
                this.box.width = LetterAmountmultipler;
                this.item = this.game.add.text(0, 0, "?", this.inputBoxStyle);
                this.item.anchor.set(0.5, 0.5);
                this.item.father = this.box;
                this.item.x = this.box.x;
                this.item.y = this.box.y;
                this.addChild(this.item);
                this.box.text = this.item;
                this.item.answer = this.GameData.TaskList[i].Answer;
                this.box.inputEnabled = true;
                this.box.events.onInputUp.add(this.showKeyboard, this);
                this.addChild(this.box);
                this.FillList.push(this.item);
            }
        };
        Fill.prototype.keyboardInit = function () {
            this.keyboard = new KB.Keyboard(this.game, this.initializationKeys, 500, 0, true);
            if (this.initializationKeys.length >= 2) {
                EU.Log(this.keyboard);
                if (this.initializationKeys == "numbersAndChars") {
                    this.keyboard.initialize("1234567890" + this.keyboard.arrSeparator + "qwertyuiop+-" + this.keyboard.arrSeparator + "asdfghjkl:;" + this.keyboard.arrSeparator + "zxcvbnm^& .,", "key", "key");
                }
                else {
                    this.keyboard.initialize(this.initializationKeys, "key", "key");
                }
            }
            else {
                this.keyboard.initialize("qwertyuiop+-" + this.keyboard.arrSeparator + "asdfghjkl" + this.keyboard.arrSeparator + "zxcvbnm^& .,", "key", "key");
            }
            this.keyboard.scale.setTo(0.5, 0.5);
            this.keyboard.alive = false;
            this.keyboard.fixedToCamera = true;
            this.keyboard.maxLetters = this.maxCharacters;
            this.game.add.existing(this.keyboard);
        };
        Fill.prototype.showKeyboard = function (button) {
            if (this.keyboard == undefined)
                this.keyboardInit();
            this.keyboard.controller = button.text;
            this.keyboard.RootController = this;
            this.keyboard.navClick(this.keyboard);
        };
		Fill.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
		Fill.prototype.prevScreen = function () {
			if(zad_zaliczone == 1){
				if (this.game.camera.x - Global.Main.dims.x > 0) {
					this.game.input.enabled = false;
					var tw = this.game.add.tween(this.game.camera);
					tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
					tw.onComplete.add(function () {
						this.game.input.enabled = true;
					}, this);
					tw.start();
					Global.Main.currentPageNumber--;
					if (this.json.Lector)
						Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
					console.log(Global.Main.currentPageNumber);
				}
			}
			else {
				//nic nie rób
			}
        };
        Fill.prototype.checkComplition = function () {
            var TotalAnswers = this.GameData.TaskList.length;
            var GoodAnswers = 0;
            var BadAnswers = 0;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                if (this.AlwaysGood) {
                    if (this.FillList[i].text.toUpperCase() != "?") {
                        GoodAnswers++;
                    }
                }
                else {
                    if (this.CaseSensitivity) {
                        if (this.GameData.TaskList[i].MultipleAnswers) {
                            var istrue = false;
                            for (var j = 0; j < this.GameData.TaskList[i].Answer.length; j++) {
                                if (this.FillList[i].text === this.GameData.TaskList[i].Answer[j]) {
                                    istrue = true;
                                }
                                else {
                                    if (this.FillList[i].text.toUpperCase() != "?" && !istrue)
                                        istrue = false;
                                }
                            }
                            if (istrue) {
                                GoodAnswers++;
                            }
                            else {
                                BadAnswers++;
                            }
                        }
                        else {
                            if (this.FillList[i].text === this.GameData.TaskList[i].Answer || this.GameData.TaskList[i].Answer === "") {
                                if (this.GameData.CorrectSound) {
                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.FillList[i].text.toUpperCase() != "?")
                                    if (this.GameData.CorrectSound) {
                                        Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                    }
                                BadAnswers++;
                            }
                        }
                    }
                    else {
                        if (this.GameData.TaskList[i].MultipleAnswers) {
                            var istrue = false;
                            for (var j = 0; j < this.GameData.TaskList[i].Answer.length; j++) {
                                if (this.FillList[i].text.toUpperCase() === this.GameData.TaskList[i].Answer[j].toUpperCase()) {
                                    istrue = true;
                                }
                                else {
                                    if (this.FillList[i].text.toUpperCase() != "?" && !istrue)
                                        istrue = false;
                                }
                            }
                            if (istrue) {
                                if (this.GameData.CorrectSound) {
                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.GameData.CorrectSound) {
                                    Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                }
                                BadAnswers++;
                            }
                        }
                        else {
                            if (this.FillList[i].text.toUpperCase() === this.GameData.TaskList[i].Answer.toUpperCase() || this.GameData.TaskList[i].Answer === "") {
                                if (this.GameData.CorrectSound) {
                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.FillList[i].text.toUpperCase() != "?")
                                    if (this.GameData.CorrectSound) {
                                        Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                    }
                                BadAnswers++;
                            }
                        }
                    }
                }
            }
            if (TotalAnswers == GoodAnswers) {
                zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                if (TYPE === "gm") {
					var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
					var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
					prev.scale.setTo(0.8,0.8);
					this.addChild(prev);
                    _super.prototype.nextTask.call(this);
                }
            }
            else {
                var complition = GoodAnswers / TotalAnswers;
                var tmpCheck = BadAnswers / TotalAnswers;
                EU.Log(complition + " + " + tmpCheck + " = " + (tmpCheck + complition));
                if (tmpCheck + complition != 1) {
                    EU.Log("zaznacz wszystkie ocje");
                }
                else {
                    zad_zaliczone = 0;
					console.log("zad_zaliczone = "+zad_zaliczone);
                }
            }
            this.killKeyborad();
        };
        Fill.prototype.update = function () {
        };
        Fill.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
        };
        return Fill;
    })(Base.BasicGroup);
    _Fill.Fill = Fill;
})(Fill || (Fill = {}));
//# sourceMappingURL=Fill.js.map