var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Quiz;
var zad_zaliczone = 0;
(function (_Quiz) {
    var Quiz = (function (_super) {
        __extends(Quiz, _super);
        function Quiz(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Quiz.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        Quiz.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Quiz.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            if (this.Elements.Color) {
                this.Color = this.Elements.Color;
            }
            else
                this.Color = "red";
            this.numberOfChecked = 0;
            this.createStaticElements();
            this.createQuestions();
            EU.createSelectableElements(this);
        };
        Quiz.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Quiz.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.el[i].rotation) {
                        el.anchor.set(0.5, 0.5);
                        el.angle = this.Elements.StaticElements.el[i].rotation;
                    }
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        };
        Quiz.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        Quiz.prototype.createQuestions = function () {
            this.Questions = [];
            for (var i = 0; i < this.Elements.Questions.length; i++) {
                var el = this.game.add.text(0, 0, this.Elements.Questions[i].QuestionText, this.Elements.Questions[i].QuestionStyle);
                this.addChild(el);
                var posX = this.Elements.Questions[i].Position.x;
                var posY = this.Elements.Questions[i].Position.y;
                el.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, el), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, el));
                el.align = (this.Elements.Questions[i].Just).toLowerCase();
                var Answers = [];
                for (var j = 0; j < this.Elements.Questions[i].Answers.length; j++) {
                    var ans = this.game.add.text(0, 0, this.Elements.Questions[i].Answers[j].Text, this.Elements.Questions[i].AnswerFont);
                    this.addChild(ans);
                    ans.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, ans), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, ans) + (j + 1) * this.Elements.Questions[i].Spacing + el.height + j * ans.height);
                    ans.inputEnabled = true;
                    ans.align = (this.Elements.Questions[i].Just).toLowerCase();
                    ans.events.onInputOver.add(this.onInputOver, this);
                    ans.events.onInputOut.add(this.onInputOut, this);
                    ans.events.onInputDown.add(this.onInputDown, this);
                    Answers.push({
                        "Element": ans,
                        "isTrue": this.Elements.Questions[i].Answers[j].isTrue
                    });
                }
                this.Questions.push({
                    "Text": this.Elements.Questions[i].QuestionText,
                    "Answers": Answers
                });
            }
        };
        Quiz.prototype.getJustedPositionX = function (just, element) {
            var posX = 0;
            switch (just) {
                case "Center":
                    posX += (Global.Main.mainContainerDims.wd - 120) / 2 - element.width / 2;
                    break;
                case "Right":
                    posX += Global.Main.mainContainerDims.wd - 120 - element.width;
                    break;
            }
            return posX;
        };
        Quiz.prototype.getJustedPositionY = function (just, element) {
            var posY = 0;
            switch (just) {
                case "Center":
                    posY += (Global.Main.mainContainerDims.hg - 65) / 2 - element.height / 2;
                    break;
                case "Bottom":
                    posY += Global.Main.mainContainerDims.hg - 65 - element.height;
                    break;
            }
            return posY;
        };
        Quiz.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        Quiz.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        Quiz.prototype.onInputDown = function (el, pointer) {
            if (el.name == "checked") {
                el.setShadow(0, 0, "black");
                this.numberOfChecked--;
                el.name = "unchecked";
            }
            else {
                el.setShadow(el.height / 25, el.height / 25, this.Color);
                this.numberOfChecked++;
                el.name = "checked";
            }
            this.checkIfEverythingIsCorrect();
        };
		Quiz.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.PlayMusic(new Audio('Sounds/lucky_wheel.mp3'));
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
		Quiz.prototype.prevScreen = function () {
			if(zad_zaliczone == 1){
				if (this.game.camera.x - Global.Main.dims.x > 0) {
					this.game.input.enabled = false;
					var tw = this.game.add.tween(this.game.camera);
					tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
					tw.onComplete.add(function () {
						this.game.input.enabled = true;
					}, this);
					tw.start();
					Global.Main.currentPageNumber--;
					Global.Main.PlayMusic(new Audio('Sounds/lucky_wheel.mp3'));
					console.log(Global.Main.currentPageNumber);
				}
			}
			else {
				//nic nie rób
			}
        };
        Quiz.prototype.checkIfEverythingIsCorrect = function () {
            var srt = "Points: " + this.calculatePlayerPoints() + "/" + this.calculateMaxPoints();
            EU.Log(srt);
            EU.Log("Checked: " + this.numberOfChecked);
            if (this.calculatePlayerPoints() == this.calculateMaxPoints() && this.numberOfChecked == this.calculateMaxPoints() && EU.checkIfSelectablesAreCorrect(this)) {
                zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                if (TYPE === "gm") {
					var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
					var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
					prev.scale.setTo(0.8,0.8);
					this.addChild(prev);
                    _super.prototype.nextTask.call(this);
                }
                return true;
            }
            zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            return false;
        };
        Quiz.prototype.calculateMaxPoints = function () {
            var points = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue)
                        points++;
                }
            }
            return points;
        };
        Quiz.prototype.calculatePlayerPoints = function () {
            var points = 0;
            this.numberOfCorrect = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue && this.Questions[i].Answers[j].Element.name == "checked")
                        points++;
                }
            }
            return points;
        };
        return Quiz;
    })(Base.BasicGroup);
    _Quiz.Quiz = Quiz;
})(Quiz || (Quiz = {}));
//# sourceMappingURL=Quiz.js.map