﻿module Compass {

    export class Compass extends Base.BasicGroup {

        Elements: any;
        player: Phaser.Sprite;
        cursors: Phaser.CursorKeys;
        ready: boolean;
        houses: Array<Phaser.Sprite> = [];
        housesGroup: Phaser.Group;
        line: Phaser.Line;
        target: number = 0;
        dir: Phaser.Sprite;

        init(json) {
            super.init(json);
            this.Elements = json.GameData;

        }

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);

        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
            this.game.load.spritesheet('player', 'Graphics/Games/ZIP_G_III_10/ZIP_g_III_10_gracz.png', 21, 29, 4);
        }

        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);

            this.cursors = this.game.input.keyboard.createCursorKeys();
        }

        create() {
            this.housesGroup = this.game.add.group();



            this.addChild(this.game.add.sprite(100, 0, 'mapa'));
            this.addChild(this.game.add.sprite(1350, 200, 'kompas'));

            this.houses[0] = this.game.add.sprite(860, 320, 'dom1');
            this.houses[1] = this.game.add.sprite(600, 440, 'dom2');
            this.houses[2] = this.game.add.sprite(800, 650, 'dom3');
            this.houses[3] = this.game.add.sprite(280, 440, 'dom4');
            this.houses[4] = this.game.add.sprite(280, 320, 'dom5');
            this.houses[5] = this.game.add.sprite(740, 70, 'dom6');
            this.houses[6] = this.game.add.sprite(900, 160, 'dom7');
            this.houses[7] = this.game.add.sprite(1190, 220, 'dom8');

            for (var i = 0; i < 8; i++) this.houses[i].anchor.setTo(0.5, 0.5);
            for (var i = 0; i < 8; i++) this.addChild(this.houses[i]);

            this.game.physics.startSystem(Phaser.Physics.ARCADE);

            this.player = this.game.add.sprite(670, 290, 'player');
            this.player.anchor.setTo(0.5, 0.5);
            this.player.animations.add('walk', [0, 1, 2, 3], 0, false);
            this.addChild(this.player);

            this.game.physics.enable(this.player, Phaser.Physics.ARCADE);

            for (var i = 0; i < 8; i++) {
                this.game.physics.enable(this.houses[i], Phaser.Physics.ARCADE);
                this.houses[i].body.immovable = true;
            }


            this.line = new Phaser.Line(this.player.x, this.player.y, this.houses[0].x, this.houses[0].y);

            this.dir = this.game.add.sprite(1562, 406, 'E');
            this.dir.anchor.setTo(0.5, 0.5);
            this.addChild(this.dir);
            
            this.ready = true;
        }


        update() {

            if (this.ready) {

                if (this.target == 8) {
                    EU.setGameCompletion(this.parent, 1);
                    EU.Log("Gra ukończona z sukcesem.");
                    super.nextTask();
                    this.ready = false;
                }

                for (var i = 0; i < 8; i++) if (this.game.physics.arcade.collide(this.player, this.houses[i])) {

                    if (this.target == i) {
                        this.houses[this.target].kill();
                        this.target++;
                        if (this.target != 8) this.line.end = new Phaser.Point(this.houses[this.target].x, this.houses[this.target].y)

                    }

                }

                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;

                
                //console.log(this.target);
                if (this.line.angle >= -0.8 && this.line.angle < 0.8) this.dir.loadTexture('E', 0, true); //console.log("Go E");
                if (this.line.angle >= 0.8 && this.line.angle < 1.2) this.dir.loadTexture('SE', 0, true); //console.log("Go SE");
                if (this.line.angle >= 1.2 && this.line.angle < 2) this.dir.loadTexture('S', 0, true); //console.log("Go S");
                if (this.line.angle >= 2 && this.line.angle < 2.4) this.dir.loadTexture('SW', 0, true); //console.log("Go SW");
                if (this.line.angle >= 2.4 && this.line.angle < 3.2 || this.line.angle >= -3.2 && this.line.angle < -2.4) this.dir.loadTexture('W', 0, true); //console.log("Go W");
                if (this.line.angle >= -2.4 && this.line.angle < -2) this.dir.loadTexture('NW', 0, true); //console.log("Go NW");
                if (this.line.angle >= -2 && this.line.angle < -1.2) this.dir.loadTexture('N', 0, true); //console.log("Go N");
                if (this.line.angle >= -1.2 && this.line.angle < -0.8) this.dir.loadTexture('NE', 0, true); //console.log("Go NE");

                if (this.line.length > 50) this.dir.tint = 0xffffff;
                if (this.line.length > 100) this.dir.tint = 0xffbbbb;
                if (this.line.length > 200) this.dir.tint = 0xff8888;
                if (this.line.length > 300) this.dir.tint = 0xff4444;
                if (this.line.length > 400) this.dir.tint = 0xff0000;

                // Left
                if (this.cursors.left.isDown && this.player.x > 180) {
                    this.line.start = new Phaser.Point(this.player.x, this.player.y);
                    this.player.body.velocity.x = -100;
                    if (this.player.body.moves != false) this.player.animations.frame = 3;
                }

                // Right
                else if (this.cursors.right.isDown && this.player.x < 1250) {
                    this.line.start = new Phaser.Point(this.player.x, this.player.y);
                    this.player.body.velocity.x = 100;
                    if (this.player.body.moves != false) this.player.animations.frame = 2;
                }


                // Up
                else if (this.cursors.up.isDown && this.player.y > 50) {
                    this.line.start = new Phaser.Point(this.player.x, this.player.y);
                    this.player.body.velocity.y = -100;
                    if (this.player.body.moves != false) this.player.animations.frame = 1;
                }


                // Down
                else if (this.cursors.down.isDown && this.player.y < 620) {
                    this.line.start = new Phaser.Point(this.player.x, this.player.y);
                    this.player.body.velocity.y = 100;
                    if (this.player.body.moves != false) this.player.animations.frame = 0;
                }

                else this.player.animations.stop();



            }

        }


    }

} 