var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Fill_second;
var game_fill = 0;
var game_fill_second = 0;
(function (_Fill_second) {
    var Fill_second = (function (_super) {
        __extends(Fill_second, _super);
        function Fill_second(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.HorizontalPlacementArray = [];
            this.VerticalPlacementArray = [];
            this.CaseSensitivity = true;
            this.isGrid = false;
            this.StartingPosX = 0;
            this.StartingPosY = 0;
            this.Columns = 0;
            this.Rows = 0;
            this.Spacing = 0;
            this.initializationKeys = "";
            this.maxCharacters = 0;
            this.FillList = [];
            this.AlwaysGood = false;
            this.inputBoxStyle = { font: "normal 80pt Arial", fill: "black" };
        }
        Fill_second.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Fill_second.prototype.killKeyborad = function () {
            if (this.keyboard != undefined) {
                this.keyboard.destroy(false, false);
                this.keyboard = undefined;
            }
        };
        Fill_second.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.loadInit();
            this.createStaticElements();
            this.createActiveElments();
            EU.createStaticSounds(this);
        };
        Fill_second.prototype.loadInit = function () {
            this.initializationKeys = this.GameData.AcceptedCharacters;
            this.maxCharacters = this.GameData.MaxCharacters;
            if (this.GameData.CaseSensitivity === true || this.GameData.CaseSensitivity === false) {
                this.CaseSensitivity = this.GameData.CaseSensitivity;
            }
            this.AlwaysGood = this.GameData.AlwaysGood;
            if (this.GameData.isGrid == true) {
                this.isGrid = this.GameData.isGrid;
                this.StartingPosX = this.GameData.StartingPos.x;
                this.StartingPosY = this.GameData.StartingPos.y;
                this.Columns = this.GameData.Columns;
                this.Rows = this.GameData.Rows;
                this.Spacing = this.GameData.Spacing;
            }
        };
        Fill_second.prototype.loadGraphics = function () {
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        };
        Fill_second.prototype.createStaticElements = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            if (this.isGrid) {
                var currHeight = this.StartingPosY;
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var currWidth = this.StartingPosX;
                    if (this.GameData.StaticElements[i].HasImage) {
                        var el = this.game.add.image(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].key);
                        currWidth += el.width;
                        currHeight += el.height;
                        this.HorizontalPlacementArray.push(currWidth + this.Spacing);
                        this.VerticalPlacementArray.push(el.height / 2 + this.Spacing);
                        this.addChild(el);
                    }
                    if (this.GameData.StaticElements[i].HasText) {
                        var el_text = this.game.add.text(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.HorizontalPlacementArray.push(el_text.width + (LetterAmountmultipler / 2) + currWidth);
                        this.addChild(el_text);
                        el_text = this.game.add.text(this.HorizontalPlacementArray[i] + LetterAmountmultipler / 2, currHeight + (100 * i), this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        currWidth += el_text.width;
                        this.VerticalPlacementArray.push(currHeight + (100 * i));
                        this.addChild(el_text);
                    }
                }
            }
            else {
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    if (this.GameData.StaticElements[i].HasImage) {
                        var tmptext = this.game.cache.getImage(this.GameData.StaticElements[i].key);
                        var el = this.game.add.image(this.GameData.StaticElements[i].pos.x + (tmptext.width / 2), this.GameData.StaticElements[i].pos.y + (tmptext.height / 2), this.GameData.StaticElements[i].key);
                        el.anchor.set(0.5, 0.5);
                        if (this.GameData.StaticElements[i].rotation) {
                            el.angle = this.GameData.StaticElements[i].rotation;
                        }
                        this.addChild(el);
                    }
                    if (this.GameData.StaticElements[i].HasText) {
                        var el_text = this.game.add.text(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.addChild(el_text);
                        el_text = this.game.add.text(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.addChild(el_text);
                    }
                }
            }
        };
        Fill_second.prototype.createActiveElments = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
            }
            var BoxSize = 8 / 5 * this.fontSize;
            var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            if (this.GameData.SmallBox && this.GameData.SmallBox == true)
                LetterAmountmultipler = 60;
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            var bmd = this.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();
            var currHeight = this.StartingPosY;
                
			if (this.isGrid){
                this.box_1 = this.game.add.sprite(this.HorizontalPlacementArray[0], this.VerticalPlacementArray[0], bmd);
				this.box_2 = this.game.add.sprite(this.HorizontalPlacementArray[1], this.VerticalPlacementArray[1], bmd);
				this.box_3 = this.game.add.sprite(this.HorizontalPlacementArray[2], this.VerticalPlacementArray[2], bmd);
				this.box_4 = this.game.add.sprite(this.HorizontalPlacementArray[3], this.VerticalPlacementArray[3], bmd);
				this.box_5 = this.game.add.sprite(this.HorizontalPlacementArray[4], this.VerticalPlacementArray[4], bmd);
				this.box_6 = this.game.add.sprite(this.HorizontalPlacementArray[5], this.VerticalPlacementArray[5], bmd);
				this.box_7 = this.game.add.sprite(this.HorizontalPlacementArray[6], this.VerticalPlacementArray[6], bmd);
				this.box_8 = this.game.add.sprite(this.HorizontalPlacementArray[7], this.VerticalPlacementArray[7], bmd);
				this.box_9 = this.game.add.sprite(this.HorizontalPlacementArray[8], this.VerticalPlacementArray[8], bmd);
				this.box_10 = this.game.add.sprite(this.HorizontalPlacementArray[9], this.VerticalPlacementArray[9], bmd);
				this.box_11 = this.game.add.sprite(this.HorizontalPlacementArray[10], this.VerticalPlacementArray[10], bmd);
				this.box_12 = this.game.add.sprite(this.HorizontalPlacementArray[11], this.VerticalPlacementArray[11], bmd);
				this.box_13 = this.game.add.sprite(this.HorizontalPlacementArray[12], this.VerticalPlacementArray[12], bmd);
				this.box_14 = this.game.add.sprite(this.HorizontalPlacementArray[13], this.VerticalPlacementArray[13], bmd);
				this.box_15 = this.game.add.sprite(this.HorizontalPlacementArray[14], this.VerticalPlacementArray[14], bmd);
				this.box_16 = this.game.add.sprite(this.HorizontalPlacementArray[15], this.VerticalPlacementArray[15], bmd);
				
			}
            else{
                this.box_1 = this.game.add.sprite(this.GameData.TaskList[0].pos.x, this.GameData.TaskList[0].pos.y, bmd);
				this.box_2 = this.game.add.sprite(this.GameData.TaskList[1].pos.x, this.GameData.TaskList[1].pos.y, bmd);
				this.box_3 = this.game.add.sprite(this.GameData.TaskList[2].pos.x, this.GameData.TaskList[2].pos.y, bmd);
				this.box_4 = this.game.add.sprite(this.GameData.TaskList[3].pos.x, this.GameData.TaskList[3].pos.y, bmd);
				this.box_5 = this.game.add.sprite(this.GameData.TaskList[4].pos.x, this.GameData.TaskList[4].pos.y, bmd);
				this.box_6 = this.game.add.sprite(this.GameData.TaskList[5].pos.x, this.GameData.TaskList[5].pos.y, bmd);
				this.box_7 = this.game.add.sprite(this.GameData.TaskList[6].pos.x, this.GameData.TaskList[6].pos.y, bmd);
				this.box_8 = this.game.add.sprite(this.GameData.TaskList[7].pos.x, this.GameData.TaskList[7].pos.y, bmd);
				this.box_9 = this.game.add.sprite(this.GameData.TaskList[8].pos.x, this.GameData.TaskList[8].pos.y, bmd);
				this.box_10 = this.game.add.sprite(this.GameData.TaskList[9].pos.x, this.GameData.TaskList[9].pos.y, bmd);
				this.box_11 = this.game.add.sprite(this.GameData.TaskList[10].pos.x, this.GameData.TaskList[10].pos.y, bmd);
				this.box_12 = this.game.add.sprite(this.GameData.TaskList[11].pos.x, this.GameData.TaskList[11].pos.y, bmd);
				this.box_13 = this.game.add.sprite(this.GameData.TaskList[12].pos.x, this.GameData.TaskList[12].pos.y, bmd);
				this.box_14 = this.game.add.sprite(this.GameData.TaskList[13].pos.x, this.GameData.TaskList[13].pos.y, bmd);
				this.box_15 = this.game.add.sprite(this.GameData.TaskList[14].pos.x, this.GameData.TaskList[14].pos.y, bmd);
				this.box_16 = this.game.add.sprite(this.GameData.TaskList[15].pos.x, this.GameData.TaskList[15].pos.y, bmd);
			}
                
			this.box_1.anchor.set(0.5, 0.5);
            this.box_1.alpha = 0.5;
			this.box_1.width = LetterAmountmultipler;
            this.item_1 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_1.anchor.set(0.5, 0.5);
            this.item_1.father = this.box_1;
            this.item_1.x = this.box_1.x;
            this.item_1.y = this.box_1.y;
            this.addChild(this.item_1);
            this.box_1.text = this.item_1;
            this.item_1.answer = this.GameData.TaskList[0].Answer;
            this.box_1.inputEnabled = true;
            this.box_1.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_1);
            this.FillList.push(this.item_1);
			
			this.box_2.anchor.set(0.5, 0.5);
            this.box_2.alpha = 0.5;
			this.box_2.width = LetterAmountmultipler;
            this.item_2 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_2.anchor.set(0.5, 0.5);
            this.item_2.father = this.box_2;
            this.item_2.x = this.box_2.x;
            this.item_2.y = this.box_2.y;
            this.addChild(this.item_2);
            this.box_2.text = this.item_2;
            this.item_2.answer = this.GameData.TaskList[1].Answer;
            this.box_2.inputEnabled = true;
            this.box_2.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_2);
            this.FillList.push(this.item_2);
			
			this.box_3.anchor.set(0.5, 0.5);
            this.box_3.alpha = 0.5;
			this.box_3.width = LetterAmountmultipler;
            this.item_3 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_3.anchor.set(0.5, 0.5);
            this.item_3.father = this.box_3;
            this.item_3.x = this.box_3.x;
            this.item_3.y = this.box_3.y;
            this.addChild(this.item_3);
            this.box_3.text = this.item_3;
            this.item_3.answer = this.GameData.TaskList[2].Answer;
            this.box_3.inputEnabled = true;
            this.box_3.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_3);
            this.FillList.push(this.item_3);
			
			this.box_4.anchor.set(0.5, 0.5);
            this.box_4.alpha = 0.5;
			this.box_4.width = LetterAmountmultipler;
            this.item_4 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_4.anchor.set(0.5, 0.5);
            this.item_4.father = this.box_4;
            this.item_4.x = this.box_4.x;
            this.item_4.y = this.box_4.y;
            this.addChild(this.item_4);
            this.box_4.text = this.item_4;
            this.item_4.answer = this.GameData.TaskList[3].Answer;
            this.box_4.inputEnabled = true;
            this.box_4.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_4);
            this.FillList.push(this.item_4);
			
			this.box_5.anchor.set(0.5, 0.5);
            this.box_5.alpha = 0.5;
			this.box_5.width = LetterAmountmultipler;
            this.item_5 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_5.anchor.set(0.5, 0.5);
            this.item_5.father = this.box_5;
            this.item_5.x = this.box_5.x;
            this.item_5.y = this.box_5.y;
            this.addChild(this.item_5);
            this.box_5.text = this.item_5;
            this.item_5.answer = this.GameData.TaskList[4].Answer;
            this.box_5.inputEnabled = true;
            this.box_5.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_5);
            this.FillList.push(this.item_5);
			
			this.box_6.anchor.set(0.5, 0.5);
            this.box_6.alpha = 0.5;
			this.box_6.width = LetterAmountmultipler;
            this.item_6 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_6.anchor.set(0.5, 0.5);
            this.item_6.father = this.box_6;
            this.item_6.x = this.box_6.x;
            this.item_6.y = this.box_6.y;
            this.addChild(this.item_6);
            this.box_6.text = this.item_6;
            this.item_6.answer = this.GameData.TaskList[5].Answer;
            this.box_6.inputEnabled = true;
            this.box_6.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_6);
            this.FillList.push(this.item_6);
			
			this.box_7.anchor.set(0.5, 0.5);
            this.box_7.alpha = 0.5;
			this.box_7.width = LetterAmountmultipler;
            this.item_7 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_7.anchor.set(0.5, 0.5);
            this.item_7.father = this.box_7;
            this.item_7.x = this.box_7.x;
            this.item_7.y = this.box_7.y;
            this.addChild(this.item_7);
            this.box_7.text = this.item_7;
            this.item_7.answer = this.GameData.TaskList[6].Answer;
            this.box_7.inputEnabled = true;
            this.box_7.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_7);
            this.FillList.push(this.item_7);
			
			this.box_8.anchor.set(0.5, 0.5);
            this.box_8.alpha = 0.5;
			this.box_8.width = LetterAmountmultipler;
            this.item_8 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_8.anchor.set(0.5, 0.5);
            this.item_8.father = this.box_8;
            this.item_8.x = this.box_8.x;
            this.item_8.y = this.box_8.y;
            this.addChild(this.item_8);
            this.box_8.text = this.item_8;
            this.item_8.answer = this.GameData.TaskList[7].Answer;
            this.box_8.inputEnabled = true;
            this.box_8.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_8);
            this.FillList.push(this.item_8);
			
			this.box_9.anchor.set(0.5, 0.5);
            this.box_9.alpha = 0.5;
			this.box_9.width = LetterAmountmultipler;
            this.item_9 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_9.anchor.set(0.5, 0.5);
            this.item_9.father = this.box_9;
            this.item_9.x = this.box_9.x;
            this.item_9.y = this.box_9.y;
            this.addChild(this.item_9);
            this.box_9.text = this.item_9;
            this.item_9.answer = this.GameData.TaskList[8].Answer;
            this.box_9.inputEnabled = true;
            this.box_9.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_9);
            this.FillList.push(this.item_9);
			
			this.box_10.anchor.set(0.5, 0.5);
            this.box_10.alpha = 0.5;
			this.box_10.width = LetterAmountmultipler;
            this.item_10 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_10.anchor.set(0.5, 0.5);
            this.item_10.father = this.box_10;
            this.item_10.x = this.box_10.x;
            this.item_10.y = this.box_10.y;
            this.addChild(this.item_10);
            this.box_10.text = this.item_10;
            this.item_10.answer = this.GameData.TaskList[9].Answer;
            this.box_10.inputEnabled = true;
            this.box_10.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_10);
            this.FillList.push(this.item_10);
			
			this.box_11.anchor.set(0.5, 0.5);
            this.box_11.alpha = 0.5;
			this.box_11.width = LetterAmountmultipler;
            this.item_11 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_11.anchor.set(0.5, 0.5);
            this.item_11.father = this.box_11;
            this.item_11.x = this.box_11.x;
            this.item_11.y = this.box_11.y;
            this.addChild(this.item_11);
            this.box_11.text = this.item_11;
            this.item_11.answer = this.GameData.TaskList[10].Answer;
            this.box_11.inputEnabled = true;
            this.box_11.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_11);
            this.FillList.push(this.item_11);
			
			this.box_12.anchor.set(0.5, 0.5);
            this.box_12.alpha = 0.5;
			this.box_12.width = LetterAmountmultipler;
            this.item_12 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_12.anchor.set(0.5, 0.5);
            this.item_12.father = this.box_12;
            this.item_12.x = this.box_12.x;
            this.item_12.y = this.box_12.y;
            this.addChild(this.item_12);
            this.box_12.text = this.item_12;
            this.item_12.answer = this.GameData.TaskList[11].Answer;
            this.box_12.inputEnabled = true;
            this.box_12.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_12);
            this.FillList.push(this.item_12);
			
			this.box_13.anchor.set(0.5, 0.5);
            this.box_13.alpha = 0.5;
			this.box_13.width = LetterAmountmultipler;
            this.item_13 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_13.anchor.set(0.5, 0.5);
            this.item_13.father = this.box_13;
            this.item_13.x = this.box_13.x;
            this.item_13.y = this.box_13.y;
            this.addChild(this.item_13);
            this.box_13.text = this.item_13;
            this.item_13.answer = this.GameData.TaskList[12].Answer;
            this.box_13.inputEnabled = true;
            this.box_13.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_13);
            this.FillList.push(this.item_13);
			
			this.box_14.anchor.set(0.5, 0.5);
            this.box_14.alpha = 0.5;
			this.box_14.width = LetterAmountmultipler;
            this.item_14 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_14.anchor.set(0.5, 0.5);
            this.item_14.father = this.box_14;
            this.item_14.x = this.box_14.x;
            this.item_14.y = this.box_14.y;
            this.addChild(this.item_14);
            this.box_14.text = this.item_14;
            this.item_14.answer = this.GameData.TaskList[13].Answer;
            this.box_14.inputEnabled = true;
            this.box_14.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_14);
            this.FillList.push(this.item_14);
			
			this.box_15.anchor.set(0.5, 0.5);
            this.box_15.alpha = 0.5;
			this.box_15.width = LetterAmountmultipler;
            this.item_15 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_15.anchor.set(0.5, 0.5);
            this.item_15.father = this.box_15;
            this.item_15.x = this.box_15.x;
            this.item_15.y = this.box_15.y;
            this.addChild(this.item_15);
            this.box_15.text = this.item_15;
            this.item_15.answer = this.GameData.TaskList[14].Answer;
            this.box_15.inputEnabled = true;
            this.box_15.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_15);
            this.FillList.push(this.item_15);
			
			this.box_16.anchor.set(0.5, 0.5);
            this.box_16.alpha = 0.5;
			this.box_16.width = LetterAmountmultipler;
            this.item_16 = this.game.add.text(0, 0, "?", this.inputBoxStyle);
            this.item_16.anchor.set(0.5, 0.5);
            this.item_16.father = this.box_16;
            this.item_16.x = this.box_16.x;
            this.item_16.y = this.box_16.y;
            this.addChild(this.item_16);
            this.box_16.text = this.item_16;
            this.item_16.answer = this.GameData.TaskList[15].Answer;
            this.box_16.inputEnabled = true;
            this.box_16.events.onInputUp.add(this.showKeyboard, this);
            this.addChild(this.box_16);
            this.FillList.push(this.item_16);
        };
        Fill_second.prototype.keyboardInit = function () {
            this.keyboard = new KB.Keyboard(this.game, this.initializationKeys, 500, 0, true);
            if (this.initializationKeys.length >= 2) {
                EU.Log(this.keyboard);
                if (this.initializationKeys == "numbersAndChars") {
                    this.keyboard.initialize("1234567890" + this.keyboard.arrSeparator + "qwertyuiop+-" + this.keyboard.arrSeparator + "asdfghjkl:;" + this.keyboard.arrSeparator + "zxcvbnm^& .,", "key", "key");
                }
                else {
                    this.keyboard.initialize(this.initializationKeys, "key", "key");
                }
            }
            else {
                this.keyboard.initialize("qwertyuiop+-" + this.keyboard.arrSeparator + "asdfghjkl" + this.keyboard.arrSeparator + "zxcvbnm^& .,", "key", "key");
            }
            this.keyboard.scale.setTo(0.5, 0.5);
            this.keyboard.alive = false;
            this.keyboard.fixedToCamera = true;
            this.keyboard.maxLetters = this.maxCharacters;
            this.game.add.existing(this.keyboard);
        };
        Fill_second.prototype.showKeyboard = function (button) {
			game_fill = 0;
			game_fill_second = 1;
            if (this.keyboard == undefined)
                this.keyboardInit();
            this.keyboard.controller = button.text;
            this.keyboard.RootController = this;
            this.keyboard.navClick(this.keyboard);
        };
        Fill_second.prototype.checkComplition = function () {
            var TotalAnswers = this.GameData.TaskList.length;
            var GoodAnswers = 0;
            var BadAnswers = 0;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                if (this.AlwaysGood) {
                    if (this.FillList[i].text.toUpperCase() != "?") {
                        GoodAnswers++;
                    }
                }
                else {
                    if (this.CaseSensitivity) {
                        if (this.GameData.TaskList[i].MultipleAnswers) {
                            var istrue = false;
                            for (var j = 0; j < this.GameData.TaskList[i].Answer.length; j++) {
                                if (this.FillList[i].text === this.GameData.TaskList[i].Answer[j]) {
                                    istrue = true;
                                }
                                else {
                                    if (this.FillList[i].text.toUpperCase() != "?" && !istrue)
                                        istrue = false;
                                }
                            }
                            if (istrue) {
                                GoodAnswers++;
                            }
                            else {
                                BadAnswers++;
                            }
                        }
                        else {
                            if (this.FillList[i].text === this.GameData.TaskList[i].Answer || this.GameData.TaskList[i].Answer === "") {
                                if (this.GameData.CorrectSound) {
                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.FillList[i].text.toUpperCase() != "?")
                                    if (this.GameData.CorrectSound) {
                                        Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                    }
                                BadAnswers++;
                            }
                        }
                    }
                    else {
                        if (this.GameData.TaskList[i].MultipleAnswers) {
                            var istrue = false;
                            for (var j = 0; j < this.GameData.TaskList[i].Answer.length; j++) {
                                if (this.FillList[i].text.toUpperCase() === this.GameData.TaskList[i].Answer[j].toUpperCase()) {
                                    istrue = true;
                                }
                                else {
                                    if (this.FillList[i].text.toUpperCase() != "?" && !istrue)
                                        istrue = false;
                                }
                            }
                            if (istrue) {
                                if (this.GameData.CorrectSound) {
                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.GameData.CorrectSound) {
                                    Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                }
                                BadAnswers++;
                            }
                        }
                        else {
                            if (this.FillList[i].text.toUpperCase() === this.GameData.TaskList[i].Answer.toUpperCase() || this.GameData.TaskList[i].Answer === "") {
                                if (this.GameData.CorrectSound) {
                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.FillList[i].text.toUpperCase() != "?")
                                    if (this.GameData.CorrectSound) {
                                        Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                    }
                                BadAnswers++;
                            }
                        }
                    }
                }
            }
            if (TotalAnswers == GoodAnswers && this.FillList[0].text !== this.FillList[1].text && this.FillList[0].text !== this.FillList[2].text && this.FillList[1].text !== this.FillList[2].text && this.FillList[3].text !== this.FillList[4].text && this.FillList[5].text !== this.FillList[6].text && this.FillList[5].text !== this.FillList[7].text && this.FillList[6].text !== this.FillList[7].text && this.FillList[8].text !== this.FillList[9].text && this.FillList[8].text !== this.FillList[10].text && this.FillList[9].text !== this.FillList[10].text && this.FillList[11].text !== this.FillList[12].text && this.FillList[13].text !== this.FillList[14].text && this.FillList[13].text !== this.FillList[15].text && this.FillList[14].text !== this.FillList[15].text){
                EU.setGameCompletion(this.parent, 1);
                if (TYPE === "gm") {
                    _super.prototype.nextTask.call(this);
                }
            }
            else {
                var complition = GoodAnswers / TotalAnswers;
                var tmpCheck = BadAnswers / TotalAnswers;
                EU.Log(complition + " + " + tmpCheck + " = " + (tmpCheck + complition));
                if (tmpCheck + complition != 1) {
                    EU.Log("zaznacz wszystkie ocje");
                }
                else {
                    EU.setGameCompletion(this.parent, 0);
                }
            }
            this.killKeyborad();
        };
        Fill_second.prototype.update = function () {
        };
        Fill_second.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
        };
        return Fill_second;
    })(Base.BasicGroup);
    _Fill_second.Fill_second = Fill_second;
})(Fill_second || (Fill_second = {}));
//# sourceMappingURL=Fill_second.js.map