/*
 * Copyright © 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
if (typeof(moduleDone) != "undefined") moduleDone("element.js");

componentElement = function()
{
	this.WBTObject = WBTObject;
	this.WBTObject();

	var a = arguments;
	if (a[0]) this.setID(a[0]);
	this.x = a[1] || 0;
	this.y = a[2] || 0;
	this.w = a[3] || null;
	this.width = this.w;
	this.h = a[4] || null;
	this.height = this.h;
	this.bgColor = a[5] || null;
	this.z = a[7] || 0;
	this.bgImage = a[8] || null;
	this.html = a[9] || null;
	this.beginX = -11111;
	this.beginY = -11111;
	this.dir = "ltr";

	this.step = 0;
	this.visible = false;
	this.visibleIf = "";
	this.contentMode = 0;
	this.enabled = true;
	this.divPreCreated = false;

	this.cursor = "default";
	this.borderWidth = 0;
	this.borderColor = "transparent";

	this.doc = null;
	this.style = null; 
	this.filters = null;
	this.contentObj = null;

	this.eventListeners = [];

	this.p_checkMarkers = false;
	this.p_checkPNG = false;
	this.pngFix = true;

	this.mouseEventsInitialized = false;
	this.canDragging = false;
	this.dockSite = false;

	this.checkloadedCouter = 0;
	this.isLoaded = false;
	this.readonly = false;
	this.locked = false;
	this.isCreated = false;
	this.actionOn = false;
	this.clearIncorectAnswer = false;
	this.checkLock = false;
	this.visual = true;
	this.stayOnTop = false;
	this.stopPropagation = false;
	this.alphaOpacity = null;
	this.altHint = '';
	this.backgroundElement = false;
	this.allowNextStep = true;
	this.isChanged = false;
	this.allowGF = true;
	this.scrollable = false;
	this.vertScrollbars = false;
	this.scrollableVertical = false;

	this.elementFilters = "";
	this.elementFiltersDuration = "3";

	this.anim = [];
	this.anim.timer = null;
	this.anim.ax = 0;
	this.anim.ay = 0;
	this.anim.dx = 0;
	this.anim.dy = 0;
	this.anim.ex = 0;
	this.anim.ey = 0;
	this.anim.totalFrames = 0;
	this.anim.currentFrame = 0;
	this.anim.animated = false;

	this.automaticHideTimer = null;
	this.interactions = false;
	this.interactionsType = "";
	this.globalIndex = -1;

	this.inputFixKeyControl = true;
	this.imWarningPopup = false;
	this.imagesNameArr = new Array();

	this.embeddedActions = new Object();

	this.frameRate = 60;
	this.hideMe = "";
	this.showMe = "";
	this.lastAnswer = null;
	this.isNewAnswer = false;
};

componentElement.prototype = new WBTObject;
componentElement.prototype.isComponentElement = true;
componentElement.prototype.type = "componentElement";
componentElement.prototype.version = "$Revision: 1.17 $";

componentElement.prototype.findContentObj = function()
{
	return this.findContentObjByName(this.id + "_contentObj");
};

componentElement.prototype.findContentObjByName = function(name)
{
	var result = null;
	if (this.obj) {
		result = document.getElementById(name);
		if (!result) {
			result = null;
		};
	};
	return result;
};

componentElement.prototype.getScreenWidth = function()
{
	var width = 0;
	if (parent.content) width = parent.content.document.body.clientWidth; else
	if (top.self.innerWidth) width =  top.self.innerWidth; else
	if (top.document.documentElement && top.document.documentElement.clientWidth) width =  top.document.documentElement.clientWidth; else
	if (top.document.body) width =  top.document.body.clientWidth; else width = 0

	return width;
};

componentElement.prototype.getScreenHeight = function()
{
	var height = 0;
	if (parent.content) height = parent.content.document.body.clientHeight; else
	if (top.self.innerHeight) height = top.self.innerHeight; else
	if (top.document.documentElement && top.document.documentElement.clientHeight) height = top.document.documentElement.clientHeight; else
	if (top.document.body) height = top.document.body.clientHeight;
	else height = 0;

	return height;
};

componentElement.prototype.countDimensions = function()
{
	var newX = this.x;
	var newY = this.y;
	var newWidth = this.w;
	var newHeight = this.h;

	var width = this.getScreenWidth();
	var height = this.getScreenHeight();

	if (typeof(this.wPerc) != 'undefined') {
		var widthPerc = this.wPerc;
		if (widthPerc.toString().indexOf('%') != -1) {
			widthPerc = widthPerc.replace('%', '');
			widthPerc = widthPerc.replace('c', '');
			if (this.w) {
				newWidth = eval(width*widthPerc/100);
			} else
			if (this.popup.w) {
				newWidth = eval(width*widthPerc/100);
			};
		};
	};

	if (typeof(this.hPerc) != 'undefined') {
		var heightPerc = this.hPerc;
		if (heightPerc.toString().indexOf('%') != -1) {
			heightPerc = heightPerc.replace('%', '');
			heightPerc = heightPerc.replace('c', '');
			if (this.h) {
				newHeight = eval(height*heightPerc/100);
			} else
			if (this.popup.h) {
				tnewHeight = eval(height*heightPerc/100);
			};
		};
	};
	if (typeof(this.xPerc) != 'undefined' && this.xPerc != '') {
		var xPerc = this.xPerc;
		if (xPerc.toString().indexOf('%') != -1) {
			xPerc = xPerc.replace('%', '');
			if (xPerc.indexOf('c') != -1) {
				xPerc = xPerc.replace('c', '');
				if (this.w) {
					newX = eval(width*xPerc/100 - parseInt(this.w/2));
				} else
				if (this.popup.x) {
					newX = eval(width*xPerc/100 - parseInt(this.popup.w/2));
				};
			} else {
				if (this.x || this.x == 0) {
					newX = eval(width*xPerc/100);
				} else
				if (this.popup.x) {
					newX = eval(width*xPerc/100);
				};
			};
		};
	};
	if (typeof(this.yPerc) != 'undefined' && this.yPerc != '') {
		var yPerc = this.yPerc;
		if (yPerc.toString().indexOf('%') != -1) {
			yPerc = yPerc.replace('%', '');
			if (yPerc.indexOf('c') != -1) {
				yPerc = yPerc.replace('c', '');
				if (this.h) {
					newY = eval(height*yPerc/100 - parseInt(this.h/2));
				} else
				if (this.popup.y) {
					newY = eval(height*yPerc/100 - parseInt(this.popup.h/2));
				};
			} else {
				if (this.y || this.y == 0) {
					newY = eval(height*yPerc/100);
				} else
				if (this.popup.y) {
					newY = eval(height*yPerc/100);
				};
			};
		};
	};

	this.setSizeScaledElement(newX, newY, newWidth, newHeight);
};

componentElement.prototype.setSizeScaledElement = function(x, y, w, h)
{
	if (this.execution) {
		this.obj.style.left = x;
		this.obj.style.top = y;
		this.obj.style.width = w;
		this.obj.style.height = h;
	};
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
};

componentElement.prototype.setSizes = function()
{
	if (page.state != 1 && ((this.xPerc != '' && typeof(this.xPerc) != 'undefined') 
		|| (this.yPerc != '' && typeof(this.yPerc) != 'undefined') 
		|| (this.hPerc != '' && typeof(this.hPerc) != 'undefined')
		|| (this.wPerc != '' && typeof(this.wPerc) != 'undefined')))
	{
		this.countDimensions();
	};
};

componentElement.prototype.getPosSize = function(obj)
{
	if (typeof(obj) == "undefined") obj = this.obj;

	if (obj) {
		w = obj.offsetWidth;
		h = obj.offsetHeight;
		if (obj.offsetParent) {
			for (var posX = 0, posY = 0; obj.offsetParent; obj = obj.offsetParent) {
				posX += obj.offsetLeft;
				posY += obj.offsetTop;
			};
			return[posX, posY, w, h];
		} else {
			return[obj.x, obj.y, w, h];
		};
	} else {
		return [0, 0, 0, 0];
	};
};

componentElement.prototype.reinit = function()
{
	if (is.ie || is.opera) {
		var ln = this.obj.all;
		if (ln) { //pg2-bsh_ie8 from wl
			for (var i = 0; i < ln.length; i++) ln[i].owner = this;
		};
	} else
	if (is.dom) {
		this.__setOwnerDOM(this.obj);
	};

	this.unselectable();
};

componentElement.prototype.specificCreate = function()
{
	if (this.stayOnTop) {
		this.z = 1000;
	};
	this.backgroundElement = this.isBackgroundElement();
	this.setSizes();

	if (this.execution) {
		this.obj.owner = this;
		this.style = this.obj.style;
		this.setCursor(this.cursor);
		this.doc = this.parent.doc;
		this.style.zIndex = this.z;
		try {
			this.filters = this.obj.filters;
		} catch(e) {
			this.filters = null;
		};
		this.visible = this.isVisible();
		this.className = 'element';

		if (this.scrollable) {
			if (this.vertScrollbars) {
				this.obj.style.cssText += '; overflow-x: hidden; overflow-y: auto;';
			} else {
				this.obj.style.cssText += '; overflow-x: auto; overflow-y: auto;';
			}
		} else {
			this.obj.style.cssText += '; overflow: hidden;';
		};

		if (this.parent.type != "componentPage" && this.parent.type != "componentContainer") {
			this.x = this.obj.style.left.replace("px", "");
			this.y = this.obj.style.top.replace("px", "");
			this.w = this.obj.style.width.replace("px", "");
			this.h = this.obj.style.height.replace("px", "");
		};

		if (is.ie || is.opera) {
			if (this.__img_relay && this.__img_relay == true && this.pngFix && is.ie55UP && !is.ie7UP) {
				var s = '<div style="position:absolute; visibility:inherit; left:' + 0 + 'px; top:' + 0 + 'px; width:' + this.w + 'px; height:' + this.h + 'px;"></div>';
				this.obj.innerHTML += s;
			};

			var ln = this.obj.all;
			if (ln) { //wl - 201401 for config.temp_BSH201401
				for (var i = 0; i < ln.length; i++) ln[i].owner = this;
			};
		} else
		if (is.dom) {
			this.__setOwnerDOM(this.obj);
		};

		this.initFilters(this.elementFilters, this.elementFiltersDuration);
		this.contentObj = this.findContentObj();

		if (this.beginX == -11111) this.beginX = this.x;
		if (this.beginY == -11111) this.beginY = this.y;

		return;
	};

	if (!this.parent || this.obj) return;

	if (is.moz) {
		var parentElement=(this.parent.isComponentElement)?this.parent.obj:this.parent.doc.body;
		var r=parentElement.ownerDocument.createRange();
		r.setStartBefore(parentElement);
		var html = r.createContextualFragment(this.__getOuterHTML());
		parentElement.appendChild(html);
		this.obj = parentElement.lastChild;
		this.style = this.obj.style;
		try {
			this.filters = this.obj.filters;
		} catch(e) {
			this.filters = null;
		};
		this.doc = this.parent.doc;
		this.style.zIndex = this.z;
	} else
	if (is.ie) {
		var parentElement = (this.parent.isComponentElement) ? this.parent.obj : this.parent.doc.body;
		parentElement.insertAdjacentHTML("beforeEnd", this.__getOuterHTML());
		this.obj = parentElement.children[parentElement.children.length-1];
		this.style = this.obj.style;
		this.doc = this.parent.doc;
		this.style.zIndex = this.z;
		try {
			this.filters = this.obj.filters;
		} catch(e) {
			this.filters = null;
		};
	} else
	if (is.opera) {
		var parentElement=(this.parent.isComponentElement)?this.parent.obj:this.parent.doc.body;
		parentElement.insertAdjacentHTML("beforeEnd", this.__getOuterHTML());
		this.obj = parentElement.children[parentElement.children.length-1];
		this.style = this.obj.style;
		this.doc = this.parent.doc;
		this.style.zIndex = this.z;
		try {
			this.filters = this.obj.filters;
		} catch(e) {
			this.filters = null;
		};
	};

	this.obj.owner = this;
	this.visible = this.isVisible();
	this.setHTML(this.html);
	this.setCursor(this.cursor);
	this.setBorder(this.borderColor, this.borderWidth);
	this.initFilters(this.elementFilters, this.elementFiltersDuration);
	this.className = 'element';

	this.contentObj = this.findContentObj();

	if (this.beginX == -11111) this.beginX = this.x;
	if (this.beginY == -11111) this.beginY = this.y;
};

componentElement.prototype.specificRemove = function()
{
	if (is.def && this.obj) {
		this.obj.style.visibility = "hidden";

		this.obj.innerHTML = "";
		this.obj.outerHTML = "";
	};

	this.unloadMouseEvents();
	this.html = null;
	delete this.html;
	this.z = null;
	this.x = null;
	this.y = null;
	this.w = null;
	this.h = null;
	this.beginX = null;
	this.beginY = null;
	this.xPerc = null;
	this.yPerc = null;
	this.wPerc = null;
	this.hPerc = null;
	this.contentObj = null;
	delete this.contentObj;
	this.obj = null;
	delete this.obj;
	this.doc = null;
	delete this.doc;
	this.style = null;
	delete this.style;
	this.filters = null;
	delete this.filters;
	this.anim.timer = null;
	delete this.anim.timer;
	this.anim = null;
	if (typeof(this.preloadImages) != "undefined" && this.preloadImages != null) {
		for (var k in this.preloadImages) {
			this.preloadImages[k] = null;
			delete this.preloadImages[k];
		};
		this.preloadImages = null;
		delete this.preloadImages;
	};

	this.parent = null;
	this.embeddedActions = null;
	this.eventListeners = null;

	this.font = null;
	this.selectionControl = null;
};

componentElement.prototype.__getOuterHTML =function()
{
	if (is.def) {
		var s = '<div id="' + this.id + '"';
		if (this.altHint != null) s += ' title="' + this.altHint + '"';
		s += ' style="';
		s += " visibility:" + ((this.visible) ? "inherit" : "hidden") + ";"; 
		if (this.x!=null) s += ' left:' + this.x + 'px;';
		if (this.y!=null) s += ' top:' + this.y + 'px;';
		if (this.w!=null) s += ' width:' + this.w + 'px;';
		if (this.h!=null) s += ' height:' + this.h + 'px;';
		if (this.z) s += ' z-index=' + this.z + ';';
		if (this.bgColor != null) s += ' background-color:' + this.bgColor + ';';
		s += ' position:absolute;';
		//s += ' filter:blur(add=true, direction=90, strength=6)';
		//s += ' filter:gray;';
		//s += ' filter:alpha(opacity=20, finishopacity=100, style=1, startx=0, starty=0, finishx=140, finishy=270)';
		//s += ' filter:revealTrans(duration=2)';
		if (this.alphaOpacity != null && this.alphaOpacity != 100) {
			s += 'filter:alpha(opacity=' + this.alphaOpacity + ');';
			s += ' -moz-opacity:' + (this.alphaOpacity / 100) + ';';
		} else s += ';';

		if (this.scrollable) {
			if (this.vertScrollbars) {
				s += ' overflow-y: auto; overflow-x: hidden;';
			} else {
				s += ' overflow-y: auto; overflow-x: auto;';
			};
		} else {
			s += ' overflow: hidden;';
		};
		s += '" title="' + this.altHint + '">';
		if (this.html != null) s += this.html;
		s += '</div>';
		return s;
	};
};

componentElement.prototype.getTransition = function(idx)
{
	return idx;
};

componentElement.prototype.translateTransition = function(value, duration)
{
	var result = "";
	duration = duration.replace(/,/g, '.');

	var trans_no = parseInt(value.substr(value.indexOf('f{') + 'f{'.length, value.indexOf('}') - 1));
	if (!isNaN(trans_no)) {
		if (trans_no < 24) {
			result = "revealTrans(duration=" + duration + ", transition=" + this.getTransition(trans_no) + ")";
		} else {
			switch (trans_no) {
				case 24:
					result = "progid:DXImageTransform.Microsoft.Pixelate(duration=" + duration + ")";
					break;
				case 25:
					result = "progid:DXImageTransform.Microsoft.gradientWipe(duration=" + duration + ")";
					break;
				case 26:
					result = "progid:DXImageTransform.Microsoft.Spiral(duration=" + duration + ", GridSizeX=205, GridSizeY=205)";
					break;
				case 27:
					result = "progid:DXImageTransform.Microsoft.Wheel(duration=" + duration + ", spokes=10)";
					break;
				case 28:
					result = "progid:DXImageTransform.Microsoft.RadialWipe(duration=" + duration + ")";
					break;
				case 29:
					result = "progid:DXImageTransform.Microsoft.Iris(duration=" + duration + ")";
					break;
				case 30:
					result = "progid:DXImageTransform.Microsoft.Fade(duration=" + duration + ")";
					break;
			};
		};
	};

	return result;
};

componentElement.prototype.initFilters = function(value, duration)
{
	if (value == "empty") {
		this.elementFilters = "";
		value = "";
	};

	duration = duration.replace(/,/g, '.');
	if (isNaN(duration)) duration = "3";

	if (page.state != psDesigning && this.obj.style && typeof(value) != "undefined" && value != null && value != "" && value != "f{}" ) {
		this.elementFilters = value;
		this.elementFiltersDuration = duration;

		var filtersArr = this.elementFilters.split(';');

		this.obj.style.filter = "";

		if (this.alphaOpacity != null && this.alphaOpacity != 100) {
			this.obj.style.filter += "alpha(opacity=" + this.alphaOpacity + ")";
		};

		for (var i=0; i<filtersArr.length; i++) {
			var trans = filtersArr[i];
			if (trans.indexOf('f{') > -1) trans = this.translateTransition(trans, duration);
			if (trans != "") {
				this.obj.style.filter += trans;
			};
		};
	} else {
		this.elementFilters = "";
	};
};

componentElement.prototype.moveTo = function(x, y, noevt)
{
	if (x != null) this.x = x;
	if (y != null) this.y = y;

	if (this.style == null) return;
	this.__setX(this.x);
	this.__setY(this.y);

	if (noevt != false) this.invokeEvent('Move');
};

componentElement.prototype.moveBy = function(x, y, noevt)
{
	this.moveTo(this.x + x, this.y + y, noevt);
}; 

componentElement.prototype.__setX = function(x)
{
	if (this.obj.style.position == 'fixed') return;
	if (this.execution) {
		this.obj.style.left = x;
	} else {
		if (is.ie) {
			this.style.pixelLeft = x;
		} else {
			this.style.left = x;
		};
	};
};

componentElement.prototype.__setY = function(y)
{
	if (this.obj.style.position == 'fixed') return;
	if (this.execution) {
		this.obj.style.top = y;
	} else {
		if (is.ie) {
			this.style.pixelTop = y;
		} else {
			this.style.top = y;
		};
	};
};

componentElement.prototype.setX = function(x, noevt)
{
	this.moveTo(x, null, noevt);
};

componentElement.prototype.setY=function(y, noevt)
{
	this.moveTo(null, y, noevt);
};

componentElement.prototype.setVisible = function(b)
{
	if (this.style == null || !this.visual) return;
	var prevVisibility = this.visible; //pg2-visIf onHide if hidden
	this.visible = b;
	if (this.type == "componentInput") {
		this.style.visibility = "inherit";
		var content = this.findContentObj();
		if (document.activeElement == content) {
			try{this.obj.focus();}catch(e){};//tryIsIE7Fix
		};
		var mainDiv = document.getElementById(this.id); //pg2-axa_awo -input, layers, even hidden intercepts clicks instead of an image (below it, yet- visible)
		if (b) {
			content.style.display = "";
			content.style.visibility = 'inherit';
			if (mainDiv) mainDiv.style.visibility = 'inherit'; //pg2-axa_awo
		} else {
			content.style.display = "none";
			content.style.visibility = 'hidden';
			if (mainDiv) mainDiv.style.visibility = 'hidden'; //pg2-axa_awo
		};
	} else {
		this.style.visibility = (b) ? "inherit" : (is.ns4 ? "hide":"hidden");
		//pg2-aps
		//if (page.pageIsShow && config && config.FocusManegementForSynthesizer) { //doesn't work with enabled preloader
		if (config && config.FocusManegementForSynthesizer && page.isShown && this.parent && this.parent.p_globalIndex == page.p_globalIndex) { //with preloader
			if (b && typeof(this.obj.tabIndex) != 'undefined') {
				try {
					if (!is.moz && is.ie) this.obj.focus(); //pg2- in Firefox doesn't go to first element- TODO- check it
				} catch(e) {};//tryIsIE7Fix
			} else
			if (!b && typeof(this.obj.tabIndex) != 'undefined') { //&& page.isRunning) {
				window.focus();
				document.body.focus();
				page.setFocusOnFirstTabIndex();
			};
		};
	};

	if (this.actionOn) {
		/*if(b) {
			this.invokeEvent('Show');
		} else {
			this.invokeEvent('Hide');
		}*/
		if (!b) { //pg2
			if (!this.confirmAnswer) {
				if (this.parent && this.parent.type == 'componentPage') { //pg2-while page is loading and setting initial visibility of the components, if one is hidden, do not invoke 'onHide'
					if (this.parent.pageIsShow) {
						if (prevVisibility != this.visible) this.invokeEvent('Hide'); //pg2-visIf onHide if hidden -added 'if'
					};
				} else this.invokeEvent('Hide'); //pg2-events
			};
		};
	};
	if (page.state != psDesigning && this.visible && is.ie && this.elementFilters != "" && this.filters != null) {
		this.playFilters();
	};
};

componentElement.prototype.playFilters = function()
{
	var f_no = -1;
	for (var k in this.obj.filters) {
		if (k == "alpha") {
			f_no = 1;
			break;
		} else {
			f_no = 0;
		};
	};

	if (f_no != -1 && this.obj.filters[f_no]) {
		this.style.visibility = "hidden";
		this.obj.filters[f_no].Apply();
		this.style.visibility = "inherit";
		this.obj.filters[f_no].Play();
	}	;
};

componentElement.prototype.setEnabled = function(b)
{
	this.enabled = b;
	for (var i=0; i<this.children.length;i++) {
		if (this.children[i].isComponentElement) this.children[i].setEnabled(b);
	};
};

componentElement.prototype.getZIndex = function()
{
	if (this.z) return this.z;
	else {
		this.z = this.style.zIndex;
		return this.z;
	};
};

componentElement.prototype.setZIndex=function(z)
{
	this.z = z;
	if (this.style == null) return;
	this.style.zIndex = z;
};

componentElement.prototype.setBgColor = function(color)
{
	if (color == null || color == "null") {
		color = (is.ns4) ? "" : "transparent";
	};

	if (this.style == null) return;
	this.style.backgroundColor = color;
};

componentElement.prototype.setCursor = function(c)
{
	this.cursor = c;
	if (this.style) { 
		if (is.moz && c == 'hand') {
			this.style.cursor = 'pointer';
		} else
		if ((is.ie55 || is.ie5 || is.ie4) && (c == 'pointer')) {
			this.style.cursor = 'hand';
		} else this.style.cursor = c;
	};
};

componentElement.prototype.setBorder = function(c, w)
{
	if (c.match(/^transparent/i)) {
		this.style.borderStyle = "none";
		this.style.borderWidth = "0";
		/*this.style.padding = w;*/
	} else {
		/*this.style.padding = "0";*/
		this.style.borderStyle = "solid";
		this.style.borderColor = c;
		this.style.borderWidth = w;
	};
};

componentElement.prototype.__setOwnerDOM = function(obj)
{
	var ln = obj.childNodes;
	if (ln) { //pg2-bsh_ie8 from wl
		for (var i = 0; i < ln.length; i++) {
			ln[i].owner = this;
			this.__setOwnerDOM(ln[i]);
		};
	};
};

componentElement.prototype.__setHTML=function(html)
{
	if (html) {
		//log.info(this.obj.id+" setHTML");
		//pg2-in case of Flash/SimpleFlash with some flashVars passed to swf, "+" sign isn't passed
		if ((this.type == "componentSimpleFlash" || this.type == "componentFlash") && this.flashVars && this.flashVars != "") {
			var str = unescape(html);
			str = str.replace(new RegExp('_2B_', 'g'), '%2B');
			this.obj.innerHTML = str;
		} else {
			this.obj.innerHTML = unescape(html);
		};
	};

	if (is.ie || is.opera) {
		if (this.__img_relay && this.__img_relay == true && this.pngFix && is.ie55UP && !is.ie7UP) {
			var s = '<div style="position:absolute; visibility:inherit; left:' + 0 + 'px; top:' + 0 + 'px; width:' + this.w + 'px; height:' + this.h + 'px;"></div>';
			this.obj.innerHTML += s;
		};

		var ln = this.obj.all;
		if (ln) { //pg2-bsh_ie8 from wl
			for (var i = 0; i < ln.length; i++) ln[i].owner = this;
		};
	} else
	if (is.dom) {
		this.__setOwnerDOM(this.obj);
	};
};

componentElement.prototype.setHTML = function(html, rpf)
{
	this.html = html ? html : '';
	if (is.platform == "mac") this.html += '\n';
	if (this.style == null) return;
	this.invokeEvent("BeforeLoad");

	this.__setHTML(html);
	if (rpf) {
		if (this.runPNGFix()) {
			this.reinit();
		} else {
			this.unselectable();
		};
	} else {
		this.unselectable();
	};

	this.contentObj = this.findContentObj();
};

componentElement.prototype.setSize = function(w, h, noevt)
{
	this.w = (w == null) ? this.w:w<0 ? 0:w;
	this.h = (h == null) ? this.h:h<0 ? 0:h;
	if (this.w == null && this.h == null) return;
	if (this.style != null) {
		this.setWidth(w);
		this.setHeight(h);
	};
	if (noevt != false) this.invokeEvent('Resize');
}; 

componentElement.prototype.setWidth=function(w, noevt)
{
	this.width = this.w = ( w == null ) ? this.w : w < 0 ? 0 : w;
	if (this.w == null) return;
	if (this.execution) {
		this.style.width = this.w;
	} else {
		if (this.style != null) {
			this.style.width = this.w;
		};
	};
	if (noevt != false) this.invokeEvent('Resize');
};

componentElement.prototype.setHeight=function(h, noevt)
{
	this.height = this.h = ( h == null) ? this.h : h < 0 ? 0 : h;
	if (this.h == null) return;
	if (this.execution) {
		this.style.height = this.h;
	} else {
		if (this.style != null) {
			this.style.height = this.h;
		};
	};
	if (noevt != false) this.invokeEvent( 'Resize' );
};

componentElement.prototype.paint = function()
{
	if (this.created) {
		if (!this.execution) {
			this.moveTo(this.x, this.y, false);
			this.setSize(this.w, this.h, false);
			this.setCursor(this.cursor);
			this.setBgColor(this.bgColor);
		} else {
			this.moveTo(this.x, this.y, false);
			this.setSize(this.w, this.h, false);
		};

		if (this.parent.type == "componentPage" && (page.state==psPreview || page.state==psDesigning)) {
			var showStepElements = parseInt(page.previewElementsInStep);

			if (page.state == psPreview && !page.previewShowHiddenElements) {
				if (this.step != STEPS_HIDDEN 
						&& (isNaN(showStepElements) 
							|| this.step == showStepElements
							|| (this.step < showStepElements && page.previewElementsInStepTo))) {
					this.step = 0;
					this.setVisible(true);
				} else {
					this.setVisible(false);
				};
			} else {
				if (isNaN(showStepElements) || this.step == showStepElements) {
					this.step = 0;
					this.setVisible(true);
				} else {
					this.setVisible(false);
				};
			}
		} else {
			this.setVisible(this.visible);
		};

		this.invokeEvent("Paint");
		if (this.visible && !this.confirmAnswer) { //pg2-events
			this.invokeEvent('Show');
		};
		var l = this.children.length;
		for (var i = 0; i < l; i++) this.children[i].paint();

		if (this.runPNGFix()) {
			this.reinit();
		};
	};
};

componentElement.prototype.repaint = function()
{
	if (this.created) this.invokeEvent("Repaint");
};

componentElement.prototype.lock = function()
{
	this.locked = true;
	this.invokeEvent("Lock");
};

componentElement.prototype.unlock = function()
{
	this.locked = false;
	this.invokeEvent("UnLock");
};

componentElement.prototype.onLock = function()
{
	return(true);
};

componentElement.prototype.onUnLock = function()
{
	return(true);
};

componentElement.prototype.unload = function()
{

};

componentElement.prototype.Step = function()
{
	if (this.invokeEvent("Step") != true) {
		if (this.isVisible()) this.setVisible(true);
	};
};

componentElement.prototype.changeObjectProperties = function(property, value)
{
	value = unescape(value);

	switch (property) {
		case 'width' : property = 'w'; break;
		case 'height' : property = 'h'; break;
		case 'bgColor' : property = 'background'; break;
		case 'fontSize' : value = getFontSize(value, 'px'); break;
		case 'fontColor' : property = 'color'; break;
		case 'fontBold' : 
			property = 'fontWeight'; 
			value = (value)?'bold':'normal';
			break;
		case 'fontItalic' : 
			property = 'fontStyle'; 
			value = (value)?'italic':'normal';
			break;
		case 'fontUnderline' : 
			property = 'textDecoration'; 
			value = (value)?'underline':'none';
			break;
	};
	var execString = "";
	try {
		switch (property) {
			case 'visibility' : execString = "pc." + this.id + ".obj.style." + property; break;
			case 'background' : execString = "pc." + this.id + ".obj.style." + property; break;
			case 'cursor' : execString = "pc." + this.id + ".obj.style." + property; break;
			default :
				if ( typeof(eval("pc." + this.id + "." + property)) == 'undefined' ) {
				var obj = this.findContentObj();
				if (obj) execString = 'obj.style.' + property;
			} else {
				execString = "pc." + this.id + "." + property; break;
			};
		};
		var valueBck = value; //pg2
		if (isNaN(value)) value = '"' + value + '"';
		if (execString != '') execString = execString + " = " + value + ";"; //pg2-if property dosn't exist, then dont add any (example) value = "image.gif"
		eval(execString);
		if ( property == 'borderColor' || property == 'borderWidth' ) {
			this.setBorder(this.borderColor, this.borderWidth);
		} else 
		if (property.indexOf('Perc') > -1) {
			this.setSizes();
		} else 
		if ( property == 'text' || property == 'align' || property == 'valign') {
			if (property == 'text') this.orgText = valueBck; //pg2- otherwise it will be restored from orgText (reinitText)
			this.onPaint(this, true);
		} else {
			this.paint();
		};
	} catch(e) {
		alert("Error in changeObjectProperties, object: " + this.id + ", property: " + property + ", value: " + value);
	};
};

componentElement.prototype.addEventListener=function(listener)
{
	for (var i=0;i<this.eventListeners.length;i++) {
		if (this.eventListeners[i]==listener) return;
	};
	this.eventListeners[this.eventListeners.length]=listener;
}; 

componentElement.prototype.removeEventListener = function(listener)
{
	for (var i = 0; i < this.eventListeners.length; i++) {
		if (this.eventListeners[i]==listener) this.eventListeners.splice(i, 1);
	};
}; 
 
componentElement.prototype.captureMouseEvents = function()
{
	if (!this.obj) return;

	this.obj.onmousedown=mouseEvent.eventMethod;
	this.obj.onmouseup=mouseEvent.eventMethod;
	this.obj.onmouseover=mouseEvent.eventMethod;
	this.obj.onmouseout=mouseEvent.eventMethod;
	this.obj.onclick=mouseEvent.eventMethod;
	this.obj.ondblclick=mouseEvent.eventMethod;

	if (is.mobile) {
		this.obj.ontouchstart=mouseEvent.eventMethod;
		this.obj.ontouchmove=mouseEvent.eventMethod;
		this.obj.ontouchend=mouseEvent.eventMethod;
	};

	this.mouseEventsInitialized = true;
};

componentElement.prototype.unloadMouseEvents = function()
{
	if (!this.obj) return;

	this.obj.onmousedown=null;
	this.obj.onmouseup=null;
	this.obj.onmouseover=null;
	this.obj.onmouseout=null;
	this.obj.onclick=null;
	this.obj.ondblclick=null;

	this.mouseEventsInitialized = false;
};

componentElement.prototype.onMouseMove = function() {return false;};
componentElement.prototype.onMouseDown = function() {return false;};
componentElement.prototype.onMouseUp = function() {return false;};
componentElement.prototype.onMouseOver = function() {return false;};
componentElement.prototype.onMouseOut = function() {return false;};
componentElement.prototype.onClick = function() {return false;};
componentElement.prototype.onDblClick = function() {return false;};
componentElement.prototype.onRightClick = function() {return false;};

componentElement.prototype.eventMouseMove = function(e)
{
	if (this.onMouseMove(this)) return true;
	if (this.parent && this.parent.eventMouseMove) this.parent.eventMouseMove(e);
	return false;
};

componentElement.prototype.eventMouseDown = function(e)
{
	if (this.onMouseDown(this)) return true;
	if (this.parent && this.parent.eventMouseDown) return this.parent.eventMouseDown(e);
	return false;
};

componentElement.prototype.eventMouseUp = function(e)
{
	if (this.onMouseUp(this)) return true;
	if (this.parent && this.parent.eventMouseUp) this.parent.eventMouseUp(e);
	return false;
};

componentElement.prototype.eventMouseOver = function(e)
{
	if (this.confirmAnswer || this.locked) return false; //pg2-events //pg2-coig_page_print
	if (this.onMouseOver(this)) return true;
	if (this.parent && this.parent.eventMouseOver) this.parent.eventMouseOver(e);

	return false;
};

componentElement.prototype.eventMouseOut = function(e)
{
	if (this.confirmAnswer || this.locked) return false; //pg2-events //pg2-coig_page_print
	if (this.onMouseOut(this)) return true;
	if (this.parent && this.parent.eventMouseOut) this.parent.eventMouseOut(e);

	return false;
};

componentElement.prototype.eventClick = function(e)
{
	var tbIndex = this.obj.getAttribute('tabindex');
	//if (this.obj.getAttribute('tabindex') != "") this.focus(); //config.disableRightClick = !config.disableRightClick; //pg2-removed aw's code, the entire line- in this way multiselect on list component is not working under Firefox
	if (tbIndex && tbIndex != '') this.focus(); //pg2-new -if is null, also do not do it
	
	if (e.button == 2 && (!page.enableSelection)) { //pg2-context_menu_test //pg2-context_menu_ON-OFF -removed 'config.disableRightClick'
		document.body.oncontextmenu = function(e) {return false;};

		if (this.confirmAnswer) return false; //pg2-events
		if (!this.onRightClick(this)) return true;
	} else document.body.oncontextmenu = null; //pg2-context_menu_test
	if (page.enableSelection) { //pg2-context_menu_ON-OFF -removed 'config.disableRightClick'
		this.invokeEvent('RestoreContextMenu');
	};

	page.clickOutside(this);

	if (this.confirmAnswer || this.locked) return false; //pg2-events //pg2-coig_page_print
	
	//pg2- prevent from reset/refresh page and next/prevPage and gotoPage within one event onClick
	if (typeof(this.onClick) == 'function') {
		var s = this.onClick.toString();
		if (s.indexOf('.nextPage(') != -1 || s.indexOf('.prevPage(') != -1 || s.indexOf('.gotoPage(') != -1) {
			var overrideFunction = false;
			if (s.indexOf('.resetPage()') != -1) {
				overrideFunction = true;
				s = s.replace(new RegExp('.resetPage', "g"), '.doNothing');
			} else
			if (s.indexOf('.refreshPage(') != -1) {
				overrideFunction = true;
				s = s.replace(new RegExp('.refreshPage', "g"), '.doNothing');
			};
			if (overrideFunction) {
				var f;
				eval("f=" + s);
				this.onClick = f;
			};
		};
	};
	//---
	if (typeof(this.onClick) != 'undefined') { //pg2-itwl_bookmarks
		if (this.onClick(this)) return true;
	};
	if (this.parent && this.parent.eventClick) this.parent.eventClick(e);
	return false;
};

componentElement.prototype.eventDblClick = function(e)
{
	if (this.confirmAnswer) return false; //pg2-events
	if (this.onDblClick(this)) return true;
	if (this.parent && this.parent.eventDblClick) this.parent.eventDblClick(e);
	return false;
};

componentElement.prototype.onRestoreContextMenu = function() 
{
	setTimeout("document.body.oncontextmenu = null;", 1000);
	return false;
};

componentElement.prototype.fnOnClick = function()
{
	this.eventClick(window.event);
};

componentElement.prototype.fnOnMouseOver = function()
{
	this.eventMouseOver(window.event);
};

componentElement.prototype.fnOnMouseOut = function()
{
	this.eventMouseOut(window.event);
};

componentElement.prototype.fnOnFocusIn = function()
{
	this.invokeEvent("FocusIn");
};

componentElement.prototype.fnOnFocusOut = function()
{
	this.invokeEvent("FocusOut");
};

componentElement.prototype.fnOnKeyDown = function()
{
	this.invokeEvent("KeyDown", window.event);
};

componentElement.prototype.fnOnKeyPress = function()
{
	this.invokeEvent("KeyPress", window.event);
};

componentElement.prototype.fnOnKeyUp = function()
{
	this.invokeEvent("KeyUp", window.event);
};

componentElement.prototype.fnOnChange = function()
{
	this.isChanged = true;
	this.invokeEvent("Change");
};

componentElement.prototype.checkIsChanged = function()
{
	return this.isChanged;
};

componentElement.prototype.__checkIsFocused = function(obj)
{
	var ln = obj.childNodes;
	if (ln) { //pg2-bsh_ie8 from wl
		for (var i = 0; i < ln.length; i++) {
			if (ln[i] == document.activeElement || this.__checkIsFocused(ln[i])) return true;
		};
	};
	return false;
};

componentElement.prototype.checkIsFocused = function()
{
	if (this.obj == document.activeElement) return true;
	if (is.ie) {
		var ln = this.obj.all;
		if (ln) { //pg2-bsh_ie8 from wl
			for (var i = 0; i < ln.length; i++) {
				if (ln[i] == document.activeElement) return true;
			};
		};
	} else {
		return this.__checkIsFocused(this.obj);
	};
	return false;
};

componentElement.prototype.focus = function()
{
	try {
		if (this.obj && this.obj.setActive) this.obj.setActive();
	} catch(e) {
		//pg2-IE10 -do nothing -despite that "this.obj" and "this.obj.setActive" exist and are correct type ones, in IE10- an exception is thrown -RPL with audio
	};
};

componentElement.prototype.noDisplay = function() 
{
	this.obj.style.display = 'none';
};

componentElement.prototype.hideConfirmButton = function() 
{
	this.hide();
};

componentElement.prototype.toggleVisible = function() 
{
	if (this.visible) {
		this.hide();
	} else {
		this.show();
	};
};

componentElement.prototype.hideWithoutInvoking = function() 
{
	var t = this.actionOn;
	this.actionOn = false;
	this.hide();
	this.actionOn = t;
};

componentElement.prototype.hide = function() 
{
	this._automaticHideTimerStop();
	this.setVisible(this.isVisible(false));
};

componentElement.prototype.showMyChildren = function() 
{
	for (var i = 0; i < this.children.length; i++) this.children[i].show();
};

componentElement.prototype.show = function() 
{
	this._automaticHideTimerStop();
	var actionOnBCK = this.actionOn;
	this.actionOn = false; //pg2- because "OnShow" is invoked twice, but .setVisible() must stay
	this.setVisible(this.isVisible(true));
	if (this.type != 'componentContainer') this.showMyChildren(); //pg2-audio2fap_container -hidden fap in contaner was played
	this.actionOn = actionOnBCK;
	this.paint();
	this._automaticHideTimerRun();

	if (this.hideMe != "") {
		var a = this.hideMe.split(",");
		for (var i in a) {
			var c = trim(a[i]);
			if (c == "+1" || c == "NS") {
				if (page.stepIndex + 2 >= page.steps.length) {
					page.addStep(1, "");
				};
			};
		};
	};
};

componentElement.prototype.actionHideObject = function() 
{
	this.hide();
};

componentElement.prototype.actionShowObject = function() 
{
	this.show();
};

componentElement.prototype.actionToggleVisibleObject = function() 
{
	this.toggleVisible();
};

componentElement.prototype.setOnTop = function(obj)
{
	if (PageInterface.GetValue("state") != psDesigning) {
		PageInterface.Execute("setOnTop", this);
	};
};

componentElement.prototype.isReady = function()
{
	var isLoaded = true;
	for (var i=0; i < this.imagesNameArr.length; i++) {
		isLoaded = preloadImage(this, "_"+i);
		if (!isLoaded) return false;
	};
	this.isLoaded = isLoaded;
	return this.isLoaded;
};

componentElement.prototype.getPreloadImagesArr = function(obj)
{
	this.preloadImages = {};
	for (var i=0; i < this.imagesNameArr.length; i++) {
		this.preloadImages["pim_"+i] = null;
		this.preloadImages["wtc_"+i] = 0;
		this.preloadImages["cmpl_"+i] = false;
		this.preloadImages["src_"+i] = this.resourcesURL + this.imagesNameArr[i];
	};
};

componentElement.prototype.onPreloadImages = function(obj)
{
	for (var i=0; i < this.imagesNameArr.length; i++) {
		this.preloadImages["pim_"+i] = new Image();
		this.preloadImages["pim_"+i].src  = this.preloadImages["src_"+i];
	};
};

componentElement.prototype.getImages = function(obj)
{
	var result = new Array();
	var ln = obj.childNodes.length;
	for (var i=0; i<ln; i++) {
		child = obj.childNodes[i];
		if (typeof(child.tagName) != "undefined") {
			if (child.childNodes && child.childNodes.length > 0) {
				var chImgs = this.getImages(child);
				for (var j=0; j<chImgs.length; j++) {
					result[result.length] = chImgs[j];
				};
			} else
			if (child.tagName.toUpperCase() == 'IMG') {
				result[result.length] = child;
			};
		};
	};
	return result;
};

componentElement.prototype.cloneEvents = function(obj)
{
	//ONLY IE
	var result = "";
	for (var i=0;i<obj.attributes.length;i++) {
		if (obj.attributes[i].specified
				&& (obj.attributes[i].nodeName.toLowerCase() == "onmousedown"
				|| obj.attributes[i].nodeName.toLowerCase() == "onmouseup"
				|| obj.attributes[i].nodeName.toLowerCase() == "onmouseover"
				|| obj.attributes[i].nodeName.toLowerCase() == "onmouseout"
				|| obj.attributes[i].nodeName.toLowerCase() == "onclick"
				|| obj.attributes[i].nodeName.toLowerCase() == "ondblclick"))
		{
			result += ' ' + obj.attributes[i].nodeName + '="' + obj.attributes[i].nodeValue + '" ';
		};
	};
	return result;
};

componentElement.prototype.waitForImage = function(image, counter)
{
	var result = false;
	while (counter > 0) {
		if (image.complete) {
			result = true;
			break;
		};
		counter--;
	};
	return result;
};

componentElement.prototype.runPNGFix = function(obj)
{
	var imgPath = "..";
	if (config.exportDetails == "wbtserver_multisinglesco"
		|| config.exportDetails == "scorm12_multisinglesco"
		|| config.exportDetails == "scorm2004_multisinglesco"
		|| config.exportDetails == "AICC_multisinglesco"
		|| config.exportDetails == "oracle_multisinglesco"
		|| config.exportDetails == "moodle_multisinglesco")
	{
		imgPath = "../../../pages";
	};

	var result = false;
	if (this.p_checkPNG && this.pngFix && is.ie55UP && !is.ie7UP) {
		var images = this.getImages(this.obj);
		var ln = images.length;
		for (var i=0; i<ln; i++) {
			var img = images[i];
			if (img.tagName.toUpperCase() == 'IMG') {
				var name = img.src.toUpperCase();
				if (name.substring(name.length - 3, name.length) == "PNG") {
					var i_id = (img.id) ? 'id="' + img.id + '" ' : '';
					var i_class = (img.className) ? 'class="' + img.className + '" ' : '';
					var i_title = (img.title) ? 'title="' + img.title + '" ' : '';
					var i_style = trim(img.style.cssText);
					if (i_style != "" && i_style.lastIndexOf(";") != i_style.length) i_style += ";";
					i_style += "display:inline-block;";
					if (img.align == "left") i_style += 'float:left;'; else
					if (img.align == "right") i_style += 'float:right;';

					var e_str = this.cloneEvents(img);
					var psArr = this.getPosSize(img);
					var src = img.src;
					src = imgPath + src.substr(src.lastIndexOf("/resources/"), src.length);

					var png_img = new Image();
					png_img.src = img.src;
					var loaded = this.waitForImage(png_img, 50);

					var sizingMethod = "scale";
					if (loaded || (!isNaN(png_img.width) && !isNaN(png_img.height))) {
						if (parseInt(png_img.width) == parseInt(psArr[2]) && "" + parseInt(png_img.height) == parseInt(psArr[3]))
						{
							sizingMethod = "image";
						};
					};
					//
					// sizingMethod
					//	crop	Clips the image to fit the dimensions of the object.
					//	image	Default. Enlarges or reduces the border of the object to fit the dimensions of the image.
					//	scale	Stretches or shrinks the image to fill the borders of the object.
					//
					var new_html = '<span ' + i_id + i_class + i_title
						+ ' src="' + img.src + '"'
						+ ' style="width:' + psArr[2] + '; height:' + psArr[3] + ';' + i_style
						+ 'filter:progid:DXImageTransform.Microsoft.AlphaImageLoader'
						+ '(src=\'' + src + '\', sizingMethod=\'' + sizingMethod + '\');"' + e_str + '></span>';

					img.outerHTML = new_html;
					result = true;
				};
			};
		};
	};
	return result;
};

componentElement.prototype.setImageSrc = function(value, obj)
{
	if (typeof(value) == "undefined" && value == null) return false;
	if (typeof(obj) == "undefined" && obj == null) {
		obj = this.contentObj;
	};

	value = unescape(value);
	if (obj) {
		if (this.pngFix && is.ie55UP && !is.ie7UP) {
			var to_png = (value.toUpperCase().substring(value.length - 3, value.length) == "PNG");
			var is_span = (obj.tagName.toUpperCase() == 'SPAN');
			var psArr = this.getPosSize(obj);
			var e_str = this.cloneEvents(obj);
			var new_html = '<img id="' + obj.id + '" src="' + value + '" width="' + psArr[2] + '" height="' + psArr[3] + '" border="0"' + e_str + '/>';
			if (to_png || is_span) {
				obj.outerHTML = new_html;
				if (to_png) this.runPNGFix();
				this.reinit();
				this.contentObj = this.findContentObj();
			} else {
				obj.src = value;
			};
		} else {
			obj.src = value;
		};
		return true;
	};
	return false;
};

componentElement.prototype.parseCheckAnswer = function(obj)
{
	if (!obj || page == null) return(false);
	var splitStr = "";
	var isCorrect = false;

	var objAns = obj.getAnswer();
	if (objAns != null) {
		var actAnswer = objAns.toString();
	} else {
		var actAnswer = objAns;
	};
	var arrCorrAns = new Array();

	switch (obj.type) {
		case "componentTrackBar":
			splitStr = ",";
			break;
		case "componentDDBasket":
			splitStr = "|";
			break;
		default: splitStr = "||";
	};

	if (typeof(obj.correctAnswer) != "undefined" || obj.correctAnswer != null) {
		arrCorrAns = obj.correctAnswer.toString().split(splitStr);
		for (var i = 0; i < arrCorrAns.length; i++) {
			if (actAnswer == arrCorrAns[i]) isCorrect = true;
		};
	};
	return(isCorrect);
};

componentElement.prototype._unselectable = function(on)
{
	if (typeof(on) == "undefined") on = true;
	if (is.ie || is.opera) {
		this.obj.unselectable = (on) ? "on" : "";
		if (typeof(this.obj.all) != 'undefined') { //pg2
			for (var i=0; i<this.obj.all.length; i++) {
				var u_obj = this.obj.all[i];
				if (u_obj.isComponentElement) {
					u_obj.unselectable(on);
				} else {
					try {
						if (u_obj.owner == this) {
							u_obj.unselectable = (!page.enableSelection)?'on':''; //u_obj.unselectable = (on) ? "on" : ""; //pg2-select on-off text in all sub-divs //pg2-context_menu_ON-OFF -removed 'config.disableRightClick'
						} else {};
					} catch (e) {};
				};
			};
		}
	} else
	//pg2-context_menu_test
	if ((!page.enableSelection) && !is.ie) { //pg2-context_menu_ON-OFF -removed 'config.disableRightClick'
		this._unselectableChildren(this.obj, "none"); //pg2-select_text in other components
	} else
	if (!is.ie) {
		this._unselectableChildren(this.obj, "auto"); //pg2-select_text in other components
	};
};

componentElement.prototype._unselectableChildren = function(obj, value) //pg2
{
	if (typeof(obj) == 'undefined') return;
	
	try {
		if (is.moz) this.obj.style.setProperty("-moz-user-select", value, "");
		obj.style.setProperty("-khtml-user-select", value, "");
		obj.style.setProperty("-webkit-user-select", value, "");
		obj.style.setProperty("-ms-user-select", value, ""); //pg2-ie11
		obj.style.setProperty("user-select", value, "");
		
		if (typeof(obj.children) != 'undefined') { //pg2- check if exists, it might not
			for (var i=0; i<obj.children.length; i++) {
				var child = obj.children[i];
				if (child) {
					this._unselectableChildren(child, value);
				};
			};
		};
	} catch(e) {};
};

componentElement.prototype.unselectable = function(on)
{
	if (page.state != psDesigning) {
		this._unselectable(on);
	};
};

componentElement.prototype.returnError = function(err)
{
	if (typeof(err) == "object") {
		if (log) log.error(err.message, "Error: " + this.id + " : [" + err.number + "] : ");
	} else {
		if (log) log.error(err.message, "Error: " + this.id + " : " + err);
	};
};

componentElement.prototype.isVisible = function(result)
{
	if (page == null || typeof(page) == "undefined") return false;
	if (page.state == psPreview || page.state == psDesigning) return true;
	if (!this.visual) return (false);

	//if (this.visibleIf == "" && this.confirmAnswer && page.solved && page.lockElementsAfterGivenAnswer) return (false);

	if (typeof(result) == "undefined") {
		result = (page.stepIndex >= this.step && this.step != STEPS_HIDDEN && this.step != STEPS_LAST_STEP);
		if (this.type != 'componentVideo') { //pg2-
			return result;
		};
	};
	result = result && (this.contentMode == sys.contentMode || this.contentMode == 0 || (this.contentMode == -1 && sys.contentMode == 0));
	if (typeof(this.visibleIf) != "undefined" && this.visibleIf != "") {
		try { //pg2- if somebody in component's property 'visibleIf' will type script with errors, all remaining elements within page will not be shown
			result = result && (eval(unescape(this.visibleIf)) == true);
		} catch(e) {
			result = true;
			if (typeof(log) != "undefined" && typeof(this.id) != "undefined") {
				log.error(this.id + '.isVisible() eval visibleIf execution error, message=' + e.message);
			};
			if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.isVisible() eval visibleIf execution error\nMessage:\n' + e.message); //pg2
		};
	};
	return result;
};

componentElement.prototype.animationMoveBy = function(x, y, time)
{
	if (typeof(time) == "undefined") {
		time = page.stepTime;
	};
	this.animationMoveTo(this.x + x, this.y + y, time);
};

componentElement.prototype.animationMoveTo = function(x, y, time, setOnTop) //pg2-set on top
{
	this.anim.animated = true;
	/*if (typeof(time) == "undefined") {
		time = Math.floor(page.steps[(page.stepIndex < page.steps.length)?page.stepIndex + 1:page.steps.length][0]);
	}*/
	
	if (typeof(setOnTop) == "undefined") {
		if (typeof(this.stayOnTop) != 'undefined') setOnTop = this.stayOnTop; else //pg2-pga_animationMoveTo on the same layer
		setOnTop = true; //pg2
	};
	
	if (setOnTop) PageInterface.Execute("setOnTop", this);

	if (typeof(time) == "undefined") {
		time = page.stepTime;
	};
	this.anim.totalFrames = (Math.floor(time / parseInt(1000 / this.frameRate)) == 0)?1:Math.floor(time / parseInt(1000 / this.frameRate));
	this.anim.currentFrame = 0;
	this.anim.ax = this.x;
	this.anim.ay = this.y;
	this.anim.ex = x;
	this.anim.ey = y;
	this.anim.dx = (Math.abs(this.anim.ex - this.anim.ax)) / this.anim.totalFrames;
	this.anim.dy = (Math.abs(this.anim.ey - this.anim.ay)) / this.anim.totalFrames;
	if (this.anim.ex < this.anim.ax) this.anim.dx = -this.anim.dx;
	if (this.anim.ey < this.anim.ay) this.anim.dy = -this.anim.dy;
	this._animationTimerRun();
};

componentElement.prototype._animationNextFrame = function()
{
	this._animationTimerStop();
	this.anim.ax += this.anim.dx;
	this.anim.ay += this.anim.dy;
	this.moveTo(parseInt(Math.abs(this.anim.ax)), parseInt(Math.abs(this.anim.ay)));
	this.anim.currentFrame++;
	if (this.anim.currentFrame >= this.anim.totalFrames) {
		this.animationStop();
		this.sendEventEndMove();
	} else {
		this._animationTimerRun();
	};
};

componentElement.prototype.sendEventEndMove = function()
{
	return;
};

componentElement.prototype._animationTimerRun = function()
{
	this.anim.timer = window.setTimeout("pc." + this.id + "._animationNextFrame()", parseInt(1000 / this.frameRate));
};

componentElement.prototype._animationTimerStop = function()
{
	if (this.anim.timer != null) {
		window.clearTimeout(this.anim.timer);
		this.anim.timer = null;
	};
};

componentElement.prototype.animationStop = function()
{
	this._animationTimerStop();
	if (this.anim && typeof(this.anim.animated) != 'undefined' && this.anim.animated == true) { //pg2- IE9 in document mode IE9- if 'resetExercisePages' was true, all elements were moved to left top 0,0
		this.moveTo(parseInt(Math.abs(this.anim.ex)), parseInt(Math.abs(this.anim.ey)));
	}; // else {
		//this.moveTo(this.x, this.y); //pg2-4 future, 4 now itsn't required
	//};
	this.anim.ax = 0;
	this.anim.ay = 0;
	this.anim.dx = 0;
	this.anim.dy = 0;
//	this.anim.ex = 0;
//	this.anim.ey = 0;
	this.anim.animated = false;
};

componentElement.prototype.stepStop = function()
{
	this.animationStop();
};

componentElement.prototype.getValue = function()
{
	this.contentObj = this.findContentObj();
	if (this.contentObj) {
		return this.contentObj.innerHTML;
	};
	return null;
};

componentElement.prototype.setValue = function(value)
{
	if (typeof(value) == "undefined" && value == null) return false;
	this.contentObj = this.findContentObj();
	if (this.contentObj) {
		this.contentObj.innerHTML = value;
		return true;
	};
	return false;
};

componentElement.prototype._automaticHideTimerRun = function()
{
	if (this.automaticHideTimerInterval && this.automaticHideTimerInterval > 0) {
		this.automaticHideTimer = window.setTimeout("pc." + this.id + ".hide();", this.automaticHideTimerInterval);
	};
};

componentElement.prototype._automaticHideTimerStop = function()
{
	if (this.automaticHideTimer != null) {
		window.clearTimeout(this.automaticHideTimer);
	};
	this.automaticHideTimer = null;
};

componentElement.prototype.getParentsCount = function()
{
	var count = 1;
	var obj = this;
	while (obj.parent.isComponentElement) {
		obj = obj.parent;
		count += 1;
	};

	return count;
};

componentElement.prototype.isBackgroundElement = function()
{
	if (this.id.indexOf("__bckg_") != -1) {
		return true;
	};
	return false;
};

componentElement.prototype.backToStartPosition = function()
{
	this.x = this.beginX;
	this.y = this.beginY;
	this.moveTo(this.x, this.y, false);
};

componentElement.prototype.resetElement = function()
{
	this.backToStartPosition();
	this.anim.ax = 0;
	this.anim.ay = 0;
	this.anim.dx = 0;
	this.anim.dy = 0;
	this.anim.ex = 0;
	this.anim.ey = 0;
};

componentElement.prototype.getProjectFont = function(fontProjectFormating, family, size, color)
{
	var font = {};
	font.family = family;
	font.size = size;
	font.color = color;

	if (fontProjectFormating && project.globalFormating) {
		font.family = project.font.family;
		font.size = project.font.size;
		font.color = project.font.color;
	};

	return font;
};

componentElement.prototype.RTLElement = function(o)
{
	var r = (parseInt(o.style.left) + parseInt(o.style.width));
	o.style.left = this.w - r;
	o.dir = "rtl";
};

componentElement.prototype.innerCtrlFormatText = function(obj, text, font, size, color, style)
{
	var o = obj;
	if (o && o.style) {
		o.innerHTML = text;
		o.style.fontFamily = (font != "") ? unescape(font) : "Arial";
		o.style.fontSize = (size != "") ? unescape(size) + "px" : "9px";
		o.style.color = (color != "") ? unescape(color) : "#000000";
		o.style.fontWeight = (style.indexOf("bold") != -1) ? "bold" : "normal";
		o.style.fontStyle = (style.indexOf("italic") != -1) ? "italic" : "normal";
	};
};

componentElement.prototype.bringToFront = function()
{
	var mz = getMaxZPos();
	if (mz > this.getZIndex()) {
		this.setZIndex(mz + 1);
	};
};

componentElement.prototype.formatVar = function(s)
{
	if (typeof(s) == 'undefined') s = '';
	try {
		var o = null;
		var v = "";
		do {
			o = s.match(/%([A-Za-z0-9.\(\)_\-'"\[\]]+)%/);
			if (o != null) {
				v = ""; //var v=""; //pg2- during debug- problem with newest firebug in mf 12
				try {
					v = eval(o[1]);
					v = v.replace(/&amp;/g, "%26");
					v = v.replace(/%/g, "__perc__");
				} catch(e) {};
				s = s.replace(o[0], v);
			};
		} while (o != null);
		s = s.replace(/__perc__/g, "%");
		return s;
	} catch(e) {
		return '';
	};
};

componentElement.prototype.formatNames = function(s)
{
	try {
		if (typeof(s) == "undefined") s = '';
		s = s.replace(/%name%/g, this.id);
		var sn = this.id.split('_');
		s = s.replace(/%extend_name%/g, sn[sn.length-1]);
		return s;
	} catch(e) {
		return '';
	};
};

/**********************************/

var $EL = {
	eshPageInit: function(e) {
		if (e.hideMe != "") {
			var cosArr = e.hideMe.split(",");
			for (var i in cosArr) {
				var coArr = trim(cosArr[i]).split('&');
				var cos = true;
				for (var j in coArr) { 
					var co = false;
					var c = trim(coArr[j]);
					co |= (c == "INIT.R.ON" && sys.repMode == "on");
					co |= (c == "INIT.R.OFF" && sys.repMode == "off");
					co |= (c == "INIT.R.OUT" && sys.repMode == "return");
					co |= (c == "INIT.R.FIRSTPAGE" && sys.repMode == "on" && page.repeatModeFirstPage);
					co |= (c == "INIT.R.LASTPAGE" && sys.repMode == "on" && page.repeatModeLastPage);
					co |= (c == "INIT.S.PASSED" && page.initPageStatus == 'passed');
					co |= (c == "INIT.S.FAILED" && page.initPageStatus == 'failed');
					co |= (c == "INIT.S.NOTATTEMPTED" && page.initPageStatus == 'not attempted');
					co |= (c == "INIT.S.INCOMPLETE" && page.initPageStatus == 'incomplete');
					co |= (c == "INIT.S.COMPLETED" && page.initPageStatus == 'completed');
					co |= (c == "INIT.P.ISASSESSMENT" && PlayerInterface.connectedUELO.FindPage(page.p_globalIndex).isAssessment);
					cos &= co;
				}
				if (cos) {
					e.hide();
				}
			}
		}
		if (e.showMe != "") {
			var cosArr = e.showMe.split(",");
			for (var i in cosArr) {
				var coArr = trim(cosArr[i]).split('&');
				var cos = true;
				for (var j in coArr) { 
					var co = false;
					var c = trim(coArr[j]);
					co |= (c == "INIT.R.ON" && sys.repMode == "on");
					co |= (c == "INIT.R.OFF" && sys.repMode == "off");
					co |= (c == "INIT.R.OUT" && sys.repMode == "return");
					co |= (c == "INIT.R.FIRSTPAGE" && sys.repMode == "on" && page.repeatModeFirstPage);
					co |= (c == "INIT.R.LASTPAGE" && sys.repMode == "on" && page.repeatModeLastPage);
					co |= (c == "INIT.S.PASSED" && page.initPageStatus == 'passed');
					co |= (c == "INIT.S.FAILED" && page.initPageStatus == 'failed');
					co |= (c == "INIT.S.NOTATTEMPTED" && page.initPageStatus == 'not attempted');
					co |= (c == "INIT.S.INCOMPLETE" && page.initPageStatus == 'incomplete');
					co |= (c == "INIT.S.COMPLETED" && page.initPageStatus == 'completed');
					co |= (c == "INIT.P.ISASSESSMENT" && PlayerInterface.connectedUELO.FindPage(page.p_globalIndex).isAssessment);
					cos &= co;
				}
				if (cos) {
					e.show();
				}
			}
		}
	},
	eshSetStatus: function(e,status) {
		if (e.hideMe != "") {
			var a = e.hideMe.split(",");
			for (var i in a) {
				var c = trim(a[i]);
				if (c == "SET.S.PASSED" && status == 'passed') {
					e.hide();
				} else
				if (c == "SET.S.FAILED" && status == 'failed') {
					e.hide();
				} else
				if (c == "SET.S.INCOMPLETE" && status == 'incomplete') {
					e.hide();
				} else
				if (c == "SET.S.COMPLETED" && status == 'completed') {
					e.hide();
				}
			}
		}
		if (e.showMe != "") {
			var a = e.showMe.split(",");
			for (var i in a) {
				var c = trim(a[i]);
				if (c == "SET.S.PASSED" && status == 'passed') {
					e.show();
				} else
				if (c == "SET.S.FAILED" && status == 'failed') {
					e.show();
				} else
				if (c == "SET.S.INCOMPLETE" && status == 'incomplete') {
					e.show();
				} else
				if (c == "SET.S.COMPLETED" && status == 'completed') {
					e.show();
				}
			}
		}
	},
	eshAnswer: function(e) {
		if (e.hideMe != "") {
			var a = e.hideMe.split(",");
			for (var i in a) {
				var c = trim(a[i]);
				if (/^NA$/.test(c)) {
					if (e.visible) e.hide();
				}
			}
		}
		if (e.hideMe != "") {
			var a = e.hideMe.split(",");
			for (var i in a) {
				var c = trim(a[i]);
				var ps = (page.stepByStepExercise) ? page.sbsStagePassed : page.getPagePassed();
				if (ps) {
					if (/^[0-9\*]*CA[0-9\*]*$/.test(c)) {
						var va = c.split("CA");
						if (va[0] == "*") va[0] = "";
						if (va[1] == "*") va[1] = "";
						if (va[0] != "") {
							if (parseInt(va[0]) != (page.stepIndex - 1)) {
								continue;
							}
						}
						if (page.grantedAnswers == parseInt(va[1]) || va[1] == "") e.hide();
					}
				} else {
					if (/^[0-9\*]*BA[0-9\*]*$/.test(c)) {
						var va = c.split("BA");
						if (va[0] == "*") va[0] = "";
						if (va[1] == "*") va[1] = "";
						if (va[0] != "") {
							if (parseInt(va[0]) != (page.stepIndex - 1)) {
								continue;
							}
						}
						if (page.grantedAnswers == parseInt(va[1]) || va[1] == "") e.hide();
					}
				}
			}
		}
		if (e.showMe != "") {
			var a = e.showMe.split(",");
			for (var i in a) {
				var c = trim(a[i]);
				var ps = (page.stepByStepExercise) ? page.sbsStagePassed : page.getPagePassed();
				if (ps) {
					if (/^[0-9\*]*CA[0-9\*]*$/.test(c)) {
						var va = c.split("CA");
						if (va[0] == "*") va[0] = "";
						if (va[1] == "*") va[1] = "";
						if (va[0] != "") {
							if (parseInt(va[0]) != (page.stepIndex - 1)) {
								continue;
							};
						};
						if (page.grantedAnswers == parseInt(va[1]) || va[1] == "") e.show();
					};
				} else {
					if (/^[0-9\*]*BA[0-9\*]*$/.test(c)) {
						var va = c.split("BA");
						if (va[0] == "*") va[0] = "";
						if (va[1] == "*") va[1] = "";
						if (va[0] != "") {
							if (parseInt(va[0]) != (page.stepIndex - 1)) {
								continue;
							}
						}
						if (page.grantedAnswers == parseInt(va[1]) || va[1] == "") e.show();
					}
				}
			}
		}
	},
	eshStep: function(e){
		if (e.hideMe != "") {
			var a = e.hideMe.split(",");
			for (var i in a) {
				var c = trim(a[i]);
				if (/^[0-9]+$/.test(c)) {
					if (parseInt(c) == page.stepIndex) e.hide();
				} else
				if (c == "NS") {
					e.hide();
				} else
				if (c == "+1") {
					if (page.stepIndex > e.step) {
						e.hide();
					}
				}
			}
		}
		if (e.showMe != "") {
			var a = e.showMe.split(",");
			for (var i in a) {
				var c = trim(a[i]);
				if (/^[0-9]+$/.test(c)) {
					if (parseInt(c) == page.stepIndex) e.show();
				}
			}
		}
	}
};
