/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
 
componentSLWTabs = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);
	
	this.imagesCompleteInfo = new Array();
};

componentSLWTabs.prototype = new componentElement();
componentSLWTabs.prototype.type = "componentSLWTabs";

componentSLWTabs.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		}
	};
	this.captureMouseEvents();
	
	this.setCompleteArrayInfo(this.completeInfoStyleImages);
};

componentSLWTabs.prototype.paint = function(bookmark)
{
	var bookmarksDIV = document.getElementById(this.id + '_bookmarksDIV');
	var bookmarksNamesDIV = document.getElementById(this.id + '_bookmarksNamesDIV');
	
	if (bookmarksDIV)
		bookmarksDIV.innerHTML = this.getBookmarks(0);
		
	if (bookmarksNamesDIV)
		bookmarksNamesDIV.innerHTML = this.getBookmarksNames();
};

componentSLWTabs.prototype.getBookmarks = function(bookmark)
{
	var contentArr = this.content.split("##");
	
	var table = '';
	table += this.makeBookmarks(contentArr, bookmark);
	
	return table;
};

componentSLWTabs.prototype.setCompleteArrayInfo = function(imagesStr)
{
	var imgArr = imagesStr.split(';');
	for (var i = 0; i < imgArr.length; i++){
		var oneImg = imgArr[i].split(',');
		if (!this.imagesCompleteInfo[oneImg[0]]){
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];		
		};
	};
};

componentSLWTabs.prototype.makeBookmarks = function(arr, bookmarkNo)
{
	var table = '';
	table += '<table cellSpacing="0" cellPadding="0" border="0" height="'+this.h+'px" width="100%">';
	table += '<tr>';
	
	this.bookmarkArrLength = parseInt(arr.length-1);
	var bookmarkWasClicked = false;
	var rightImg = '';
	
	for(var i=0; i < arr.length; i++){
		var index = i;
		
		if (i == 0){
			if (i == bookmarkNo){
				var open = this.resourcesURL + this.firstOn;
				bookmarkWasClicked = true
			}else{
				var open = this.resourcesURL + this.firstOff;	
			}
		}else{
			if (i == parseInt(arr.length-1)){//jesli ostatnia zakładka
				if (parseInt(i) == parseInt(bookmarkNo+1)){//jesli ostatnia zakladka jest aktywna
					var middle = this.resourcesURL + this.middleOn;
					var right = this.resourcesURL + this.lastOn;
					rightImg = 'lastOn';
				}else{
					var middle = this.resourcesURL + this.middleOff;
					var right = this.resourcesURL + this.lastOff;
					rightImg = 'lastOff';
				}
			}else{
				if (bookmarkWasClicked){//jesli wczesniejsza zakladka jest aktywna
					var middle = this.resourcesURL + this.middleOn;
					var right = this.resourcesURL + this.joinRightOn;
					rightImg = 'joinRightOn';
					bookmarkWasClicked = false;
				}else{
					var middle = this.resourcesURL + this.middleOff;
					if (i == bookmarkNo){//jesli nast zakladka jest aktywna
						var right = this.resourcesURL + this.joinLeftOn;
						rightImg = 'joinLeftOn';
						bookmarkWasClicked = true;
					}else{
						var right = this.resourcesURL + this.joinLeftOff;
						rightImg = 'joinLeftOff';
					};
				};
			};
		}
				
		if (i == 0){
			table += '<td ';
			table += 'width="'+ this.getImageWidth('firstOff')+'">';
			table += '<img src="'+open+'" width="100%" height="100%">';	
			table += '</td>';	
		}else {
			var splited = arr[i-1].split("&&");			
			table += '<td >';
			table += '<img src="'+middle+'" width="100%" height="100%">';	
			table += '</td>';	
			table += '<td';
			table += ' width="'+ this.getImageWidth(rightImg)+'">';
			table += '<img src="'+right+'" width="100%" height="100%">';	
			table += '</td>';				
		};
	};
	
	table += '</tr>';
	table += '</table>';
	
	return table;
};

componentSLWTabs.prototype.getBookmarksNames = function()
{
	var font = getProjectFont(this.globalFormating == 1, this.fontFamily, this.fontSize, this.fontColor );

	var contentArr = this.content.split("##");
	var joinImgWidth = this.getImageWidth('firstOff') + this.getImageWidth('joinRightOn')*(contentArr.length-2) + this.getImageWidth('lastOff')
	
	var bookmarkWidth = (this.w -joinImgWidth)/(contentArr.length-1);
	
	var table = '';
	table += '<table cellSpacing="0" cellPadding="0" border="0" height="'+this.h+'px" width="'+this.w+'px">';
	table += '<tr>';
	table += '<td width="'+this.getImageWidth('firstOff')+'px">';
	table += '</td>';
	
	for(var i=0; i < contentArr.length-1; i++){
		var splited = contentArr[i].split("&&");
		table += '<td width="'+bookmarkWidth+'px" align="center" style="cursor: '+this.cursor+'"';
		table += ' onClick="pc.'+this.id+'.gotoBookmark('+parseInt(i)+')">';
		table += '<font size="'+font.size+'" face="'+font.family+'" color="'+font.color+'">';
		
		if (this.fontBold == 1) {
			table += '<b>'+splited[0]+'</b>';
		}else{
			table += splited[0];
		};

		table += '</font>';	
		table += '</td>';		
		table += '<td width="'+this.getImageWidth('joinRightOn')+'px">';
		table += '</td>';		
	};
	
	table += '</tr>';
	table += '</table>';

	return table;
}

componentSLWTabs.prototype.gotoBookmark = function(index)
{
	var contentArr = this.content.split("##");	
	var bookmarkActionsArr = contentArr[index].split('&&')
	var actionsArr = bookmarkActionsArr[1].split('||');
	
	for (var i=0; i < actionsArr.length; i++){
		if (actionsArr[i] != '')
		{
			try{
				var actionExecuteArr = actionsArr[i].split('#!#');
				eval('pc.'+actionExecuteArr[0]+';');
			}catch(e)
			{
				showMessage("THIS ACTION CAN'T BE EXECUTED "+ actionsArr[i]);
			};
		};
	}
	
	var bookmarksDIV = document.getElementById(this.id + '_bookmarksDIV');
	
	if (bookmarksDIV)
		bookmarksDIV.innerHTML = this.getBookmarks(index);	
}

componentSLWTabs.prototype.getImageHeight = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][1]);
};

componentSLWTabs.prototype.getImageWidth = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][0]);
};




