﻿module TrueOrFalse {
    export class TrueOrFalse extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        currentAnswer: any;
        categoryIndex: number;
        wordIndex: number;
        Qtext: any;
        isCorrect: any;

        usedAnswers: any[];
        textAnswers: any[];


        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }

            if (this.json.isFirst == true) {
                EU.loadVocabulary(this);
            };

            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            this.createQuestion();
            this.createAnswers();
            this.isCorrect = "isFalse";

        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        createQuestion() {
            var question;
            var flag = false;
            while (flag == false) {
                flag = true;
                this.categoryIndex = Math.floor((Math.random() * EU.groups.length));
                this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                EU.Log(this.categoryIndex + " " + this.wordIndex);
                question = EU.groups[this.categoryIndex].vocabulary[this.wordIndex].en;
                for (var i = 0; i < EU.usedWords.length; i++) {
                    if (EU.usedWords[i] == question) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            EU.usedWords.push(question);
            this.Qtext = this.game.add.text(0, 0, question, this.Elements.Style);
            var posX = this.Elements.Position.x;
            var posY = this.Elements.Position.y;
            if (this.Elements.Just) {
                switch (this.Elements.Just.x) {
                    case "center":
                        posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                        this.Qtext.anchor.x = 0.5;
                        break;
                    case "right":
                        posX += Global.Main.mainContainerDims.wd - 120;
                        this.Qtext.anchor.x = 1;
                        break;
                }
                switch (this.Elements.Just.y) {
                    case "center":
                        posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                        this.Qtext.anchor.y = 0.5;
                        break;
                    case "bottom":
                        posY += Global.Main.mainContainerDims.hg - 65;
                        this.Qtext.anchor.y = 1;
                        break;
                }
            }
            this.Qtext.position.set(posX, posY);
            this.addChild(this.Qtext);
        }

        createAnswers() {
            this.usedAnswers = [];
            this.usedAnswers.push(
                {
                    "answer": EU.groups[this.categoryIndex].vocabulary[this.wordIndex].pl,
                    "name": null
                });
            var answer = { "answer": null, "name": null };
            var flag = false;
            while (flag == false) {
                var answerIndex = this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                answer.answer = EU.groups[this.categoryIndex].vocabulary[answerIndex].pl;
                for (var j = 0; j < this.usedAnswers.length; j++) {
                    if (this.usedAnswers[j].answer == answer.answer) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }

            answer.name = "isFalse";
            this.usedAnswers.push(answer);
            this.usedAnswers[0].name = "isTrue";
            this.usedAnswers = EU.shuffleArray(this.usedAnswers);
            this.textAnswers = [];
            var el = this.game.add.text(0, 0, this.usedAnswers[0].answer, this.Elements.AnswerStyle);
            el.position.set(this.Qtext.position.x, this.Qtext.position.y + 1.5 * this.Qtext.height );
            el.anchor = this.Qtext.anchor;
            el.name = this.usedAnswers[0].name;
            var True = this.game.add.text(this.Qtext.position.x -(this.Qtext.anchor.x * this.Qtext.height*3), this.Qtext.position.y + 3 * this.Qtext.height, "True", this.Elements.AnswerStyle);
            True.anchor = this.Qtext.anchor;
            True.setStyle({ fill: "green", font: this.Elements.AnswerStyle.font});
            this.addChild(True);
            var False = this.game.add.text(this.Qtext.position.x + ((1-this.Qtext.anchor.x) * this.Qtext.height * 3), this.Qtext.position.y + 3 * this.Qtext.height, "False", this.Elements.AnswerStyle);
            False.anchor = this.Qtext.anchor;
            False.setStyle({ fill: "red", font: this.Elements.AnswerStyle.font});
            this.addChild(False);
            True.inputEnabled = true;
            True.events.onInputOver.add(this.onInputOver, this);
            True.events.onInputOut.add(this.onInputOut, this);
            True.events.onInputDown.add(this.onInputDown, this);
            False.inputEnabled = true;
            False.events.onInputOver.add(this.onInputOver, this);
            False.events.onInputOut.add(this.onInputOut, this);
            False.events.onInputDown.add(this.onInputDown, this);
            if (el.name == "isTrue") {
                True.name = "isTrue";
                False.name = "isFalse";
            }
            else {
                True.name = "isFalse";
                False.name = "isTrue";
            }

            this.textAnswers.push(True);
            this.textAnswers.push(False);
            this.addChild(el);
        }

        private onInputOver(el: Phaser.Sprite, pointer) {
            el.alpha = 0.5;
        }

        private onInputOut(el: Phaser.Sprite, pointer) {
            el.alpha = 1.0;
        }


        private clearAnswers() {
            for (var i = 0; i < this.textAnswers.length; i++) {
                this.textAnswers[i].removeChildren();
            }
        }

        private onInputDown(el: Phaser.Text, pointer) {
            this.clearAnswers();
            var rect = EU.drawRect("blue", el.width + 10, el.height, el.height / 10, el.height / 10, this);
            rect.position.x = -el.width / 2 - 5;
            el.addChild(rect);
            this.isCorrect = el.name;
            this.checkIfEverythingIsCorrect();
        }

        checkIfEverythingIsCorrect() {
            if (
                this.isCorrect == "isTrue") {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            };
            EU.setGameCompletion(this.parent, 0);
            EU.Log("NotCorrect!!! :<");
            return false;
        }


    }
}  