/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

__componentTopPanel = function(name)
{
  //inherited
  this.componentElement	= componentElement;
  this.componentElement(name);
  
  this.refText = this.addChild(new __componentText(null));
  
  this.__window = window;
  this.autoSize = false;
};

__componentTopPanel.prototype = new componentElement;
__componentTopPanel.prototype.type = "__componentTopPanel";

__componentTopPanel.prototype.onCreate = function(obj)
{
	this.__popup = this.__window.createPopup();
	this.__document = this.__popup.document;

	this.refText.visible = false;
	this.refText.text = this.text;
};

__componentTopPanel.prototype.onFree = function(obj)
{
	if (this.__popup) {
		this.__popup.hide();
		this.__popup = null;
	}
};

__componentTopPanel.prototype.onPaint = function(obj)
{
};

__componentTopPanel.prototype.show = function()
{
	this.__document.body.style.backgroundColor = this._bgColor;
	this.__document.body.style.border = "solid " + this._borderColor + " " + this._borderWidth + "px";
	this.__document.body.innerHTML = this.refText._getHTMLDef(this.text);
	this.__popup.show(this.x, this.y, this.w, this.h, this.__window.document.body);
};

__componentTopPanel.prototype.hide = function()
{
	if (this.__popup) this.__popup.hide();
};
