/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
 
Detect = function()
{
	this.detectName = "WBTE Detect Errors";
	this.checkLms = true;
	this.isLms = true;
	this.checkPlayer = true;
	this.isPlayer = true;
	this.checkStruct = true;
	this.isStruct = true;
	this.checkPlatformAPI = false;
	this.isPlatformAPI = true;
	
	this.replaceCoursePage = true;
	this.showInAlert = false;
	this.anyErrorOccurs = false;
};

Detect.prototype.setDetectSettings = function(exportType)
{
	switch (exportType) {
		case "offline":
			this.checkLms = false
			this.checkPlatformAPI = false;
			break;
		case "online":
			//do nothing
			break;
		case "exe":
			this.checkLms = false;
			this.checkPlayer = false;
			this.checkStruct = false;
			this.checkPlatformAPI = false;
			break;		
	};
};

Detect.prototype.checkWindowOpenEnabled = function(exportType)
{
	try {
		var oWin = window.open("","WBTEDetect","toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,left=" + parseInt(screen.width/2-150) + ",top=" + parseInt(screen.height/2-150) + ",width=600,height=300");
		if (oWin){
			this.showInAlert = false;
			return null;
		} else {
			this.showInAlert = true;
			return oWin;
		};
	} catch(e) {
		this.showInAlert = true;
		return null;
	};
};

Detect.prototype.check = function(exportType)
{
	this.setDetectSettings(exportType);
	
	if (this.checkLms) {
		this.isLms = this.getLMS();
		this.anyErrorOccurs = !this.isLms;		
	};
	
	if (this.checkPlayer) {
		this.isPlayer = this.getPlayer();
		this.anyErrorOccurs = !this.isPlayer;			
	};

	if (this.checkStruct) {
		this.isStruct = this.getStruct();
		this.anyErrorOccurs = !this.isStruct;			
	};

	if (this.checkPlatformAPI) {
		this.isPlatformAPI = this.getPlatformAPI();
		this.anyErrorOccurs = !this.isPlatformAPI;
	};
	
	this.showDetectResult();
};

Detect.prototype.getLMS = function()
{
	return (typeof(getLMS) != 'undefined' && getLMS()) ? true : false;
};

Detect.prototype.getPlayer = function()
{
	return (typeof(getPlayer) != 'undefined' && getPlayer()) ? true : false;
};

Detect.prototype.getStruct = function()
{
	return (typeof(getStruct) != 'undefined' && getStruct()) ? true : false;
};

Detect.prototype.getPlatformAPI = function()
{	
	return (typeof(getLMS) != 'undefined' && getLMS()) ? ((getLMS().apiHandle) ? true : false) : false;
};

Detect.prototype.getDetectMsg = function(breakLine, separator)
{
	var msg = "";
	
	if (!this.anyErrorOccurs) return msg;
	
	if (this.checkLms && !this.isLms) {
		msg += messages.getMessage('noLMS') + breakLine;
	};
	
	if (this.checkPlayer && !this.isPlayer) {
		msg += messages.getMessage('noPLAYER') + breakLine;
	};

	if (this.checkStruct && !this.isStruct) {
		msg += messages.getMessage('noSTRUCT') + breakLine;
	};

	if (this.checkPlatformAPI && !this.isPlatformAPI){
		msg += messages.getMessage('noAPI')+breakLine; 
	};
	
	msg += separator + messages.getMessage('detectResult');
	return msg;
};

Detect.prototype.showDetectResult = function()
{
	if (!this.anyErrorOccurs) return;
	
	if (this.replaceCoursePage) {
		var content = findFrame("content", top);
		if (content) content.location.href = 'navi/designe/detect.html';
	} else {
		var oWin = this.checkWindowOpenEnabled();
		
		if (this.showInAlert || !oWin) {
			alert(this.getDetectMsg('\n', '\n\n'));
		} else {
			if (oWin) {
				oWin.document.write("<TITLE>" + this.detectName + "</TITLE>")
				oWin.document.write("<BODY>")
				oWin.document.write("<h1>" + this.detectName + "</h1>")
				oWin.document.write(this.getDetectMsg('<br>', '<hr>')); 
				oWin.document.write("</BODY>")
				oWin.document.write("</HTML>")		
			};
		};
	};
};

detect = new Detect();
