 /*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */ 
 
__componentYellowCard = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);
	
	this.canDragging = true;
	//this.isDragging = false;
	
	this.p_checkMarkers = true;
	this.p_checkPNG = true;
	this.__img_relay = false;
	
	this.identifier = "";
	this.cardTypes = new Array("author","public","private","tutor");
	this.cardType = "private";
	this.author = "4system";
	this.title = "";
	this.note = "";
	this.date = '';
	this.w = 297;
	this.h = 160;
	this.src = "___.yellowCard.Bckg.gif";
	this.miniBckg = "___.yellowCard.miniAuthor.gif";	
	this.hourLang = ', ';	
	this.buttonTrashOver = "___.yellowCard.removeOver.gif";
	this.buttonMiniOver = "___.yellowCard.minimizeOver.gif";
	this.buttonHideOver = "___.yellowCard.closeOver.gif";	
	this.buttonTrashOut = "___.yellowCard.removeOut.gif";
	this.buttonMiniOut = "___.yellowCard.minimizeOut.gif";
	this.buttonHideOut = "___.yellowCard.closeOut.gif";		
	this.authorDot = "___.yellowCard.authorDot.gif";	
	this.personImg = "___.yellowCard.author.gif";	
	this.timeImg = "___.yellowCard.time.gif";	
	this.defaultMinimalize = false;
	this.showMouseOver = false;
	this.isMaximalize = false;
	this.buttonAdd = '';
	this.titleText = null;
	this.text = null;
	this.showUserName = true;	
	this.spaceBetweenButtons = 5;
	this.offsetTop = 0; 
	this.offsetLeft = 10;	
};

__componentYellowCard.prototype = new componentElement();
__componentYellowCard.prototype.type = "__componentYellowCard";

__componentYellowCard.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();
	
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	
	this.resourcesURL = unescape(this.resourcesURL);	
	
	this.imagesNameArr = [	this.src, this.miniBckg, this.buttonTrashOver, this.buttonMiniOver, this.buttonHideOver, this.buttonTrashOut, this.buttonMiniOut, this.buttonHideOut, this.authorDot, this.personImg, this.timeImg ];
	this.getPreloadImagesArr();
};

__componentYellowCard.prototype.getButtonAdd = function(buttonID)
{
	var button = PageInterface.GetValue('getChild', buttonID);
	return button;
};

__componentYellowCard.prototype.onCreate = function()
{
	return;
};

__componentYellowCard.prototype.onPaint = function() 
{
	var buttonAdd = this.getButtonAdd(this.buttonAdd);
	
	if (buttonAdd){
		this.w = buttonAdd.bckgW;
		this.h = buttonAdd.bckgH;
		this.dir = buttonAdd.dir;
		this.setSize(this.w, this.h);
	};	
	
	var s = '';
	s += '<div id="'+this.id+'_bckg" style="visibility: inherit; left:0px; top:0px; height:100%; width:100%; position:absolute;">';
	s += '<img src="'+this.resourcesURL+this.src+'" width="100%" height="100%">';
	s += '</div>';
	
	var fromRightBorder = this.offsetLeft;

	if (buttonAdd){
		var hideImgDimArr = new Array(buttonAdd.titleButtonH, buttonAdd.titleButtonW);
	}else{
		var hideImgDimArr = this.getImageHeightWidth(this.buttonHideOver);
	};
	
	fromRightBorder += this.spaceBetweenButtons + hideImgDimArr[1];
	if (buttonAdd && buttonAdd.dir == "rtl") {
		var l = fromRightBorder - hideImgDimArr[1];
	} else {
		var l = this.w-fromRightBorder;
	}
	
 	s += '<div id="'+this.id+'_buttonHide" style="visibility: inherit; left:'+l+'px; top:'+this.offsetTop+'px; height:'+hideImgDimArr[0]+'px; width:'+hideImgDimArr[1]+'px; clip: rect (0px '+hideImgDimArr[1]+'px '+hideImgDimArr[0]+'px 0px); cursor: pointer; position: absolute; background: transparent;" onClick="pc.'+this.id+'.hide();" >';
	s += '<img src="'+this.resourcesURL+this.buttonHideOut+'" width="100%" height="100%" onMouseout="pc.'+this.id+'.mouseOutButton(this, \''+this.buttonHideOut+'\');" onMouseover="pc.'+this.id+'.mouseOverButton(this, \''+this.buttonHideOver+'\');">';
	s += '</div>';
	
	if (buttonAdd){
		var miniImgDimArr = new Array(buttonAdd.titleButtonH, buttonAdd.titleButtonW);
	}else{
		var miniImgDimArr = this.getImageHeightWidth(this.buttonMiniOut);
	};
	
	fromRightBorder += this.spaceBetweenButtons + miniImgDimArr[1];
	if (this.dir == "rtl") {
		var l = fromRightBorder - hideImgDimArr[1];
	} else {
		var l = this.w-fromRightBorder;
	}
	
	s += '<div id="'+this.id+'_buttonMini" style="visibility: inherit; left:'+l+'px; top:'+this.offsetTop+'px; height:'+miniImgDimArr[0]+'px; width:'+miniImgDimArr[1]+'px; clip: rect (0px '+miniImgDimArr[1]+'px '+miniImgDimArr[0]+'px 0px); cursor: pointer; position:absolute; background: transparent;" onClick="pc.'+this.id+'.minimalizeCard();">';
	s += '<img src="'+this.resourcesURL+this.buttonMiniOut+'" width="100%" height="100%" onMouseout="pc.'+this.id+'.mouseOutButton(this, \''+this.buttonMiniOut+'\');" onMouseover="pc.'+this.id+'.mouseOverButton(this, \''+this.buttonMiniOver+'\');">';
	s += '</div>';

	if (buttonAdd){
		var trashImgDimArr = new Array(buttonAdd.titleButtonH, buttonAdd.titleButtonW);
	}else{
		var trashImgDimArr = this.getImageHeightWidth(this.buttonTrashOut);
	};
	
	fromRightBorder += this.spaceBetweenButtons + trashImgDimArr[1];
	if (this.dir == "rtl") {
		var l = fromRightBorder - hideImgDimArr[1];
	} else {
		var l = this.w-fromRightBorder;
	}
	
	s += '<div id="'+this.id+'_buttonTrash" style="visibility: inherit; left:'+l+'px; top:'+this.offsetTop+'px; height:'+trashImgDimArr[0]+'px; width:'+trashImgDimArr[1]+'px; clip: rect (0px '+trashImgDimArr[1]+'px '+trashImgDimArr[0]+'px 0px); cursor: pointer; position:absolute; " onClick="pc.'+this.id+'.deleteYellowCard();">';
	s += '<img src="'+this.resourcesURL+this.buttonTrashOut+'" width="100%" height="100%" onMouseout="pc.'+this.id+'.mouseOutButton(this, \''+this.buttonTrashOut+'\');" onMouseover="pc.'+this.id+'.mouseOverButton(this, \''+this.buttonTrashOver+'\');">';
	s += '</div>';
	
	if (buttonAdd){
		var dotImgDimArr = new Array(buttonAdd.dotH, buttonAdd.dotW);
	}else{
		var dotImgDimArr = this.getImageHeightWidth(this.authorDot);
	};	
	
	if (this.dir == "rtl") {
		var l = this.w - 12 - dotImgDimArr[1];
	} else {
		var l = 12;
	}
	
	s += '<div id="'+this.id+'authorDot" style="visibility: inherit; left:'+l+'px; top:5px; height:'+dotImgDimArr[0]+'px; width:'+dotImgDimArr[1]+'px; clip: rect (0px '+dotImgDimArr[1]+'px '+dotImgDimArr[0]+'px 0px); position:absolute; ">';
	s += this.getImageObiekt(this.authorDot, dotImgDimArr[1], dotImgDimArr[0]);
	s += '</div>';
	
	fromRightBorder += 10 + trashImgDimArr[1];
	
	s += '<div id="'+this.id+'_titleDIV" dir="'+this.dir+'"';
	if (is.ie) {
		s += ((this.id.indexOf('__yc__') > -1) ? ' contenteditable="true" onfocusout="pc.' + this.id + '.updateTitle(this);"' : '');
		//s += ' contenteditable="true" onfocusout="pc.' + this.id + '.updateTitle(this);"';
	}
	
	if (this.dir == "rtl") {
		var l = this.w - 15 - dotImgDimArr[1] - (this.w-fromRightBorder);
	} else {
		var l = dotImgDimArr[1]+15;
	}
	
	s += ' style="font-family: Arial Black; font-size: 10px; color: #000000; left:'+l+'px; top:2px; height:20px;  width:'+eval(this.w-fromRightBorder)+'; background-color:transparent; padding:3; overflow: none; position:absolute; cursor: text;" onMousedown="pc.'+this.id+'._stopPropagation(window.event);">';
	if (is.ie) {
		s += unescape(this.title);		
	} else {
		if (this.id.indexOf('__yc__') > -1) {
			s += '<iframe id="moz_iframe_' + this.id + '_titleDIV" src="" style="width:100%; height:100%" border="0" frameborder="0" framespacing="0" onload="pc.' + this.id + '.mozLoadedTitle(this);"></iframe>';
			//onblur="pc.' + this.id + '.mozUpdateTitle(this);"
		} else {
			s += unescape(this.title);		
		}
	}
	s += '</div>';
	var contentYCTop = 35;
	
	if (this.showUserName.toString() == 'true'){	
		if (buttonAdd){
			var personImgDimArr = new Array(buttonAdd.personGraphicH, buttonAdd.personGraphicW);
		}else{
			var personImgDimArr = this.getImageHeightWidth(this.personImg);
		};	
		if (this.dir == "rtl") {
			var l = this.w-10-personImgDimArr[1];
		} else {
			var l = 10;
		}
		s += '<div id="'+this.id+'personImg" style="left:'+l+'px; top:'+contentYCTop+'px; height:'+personImgDimArr[0]+'px; width:'+personImgDimArr[1]+'px; clip: rect (0px '+personImgDimArr[1]+'px '+personImgDimArr[0]+'px 0px); position:absolute; ">';
		s += this.getImageObiekt(this.personImg, personImgDimArr[1], personImgDimArr[0]);
		s += '</div>';
		
		//var userName = page.getUELO().username;
		var userName = this.author;
		if (userName == '') {
			userName = '[user unknown]';
		};
		if (this.dir == "rtl") {
			var l = this.w-personImgDimArr[1]-15-(this.w-fromRightBorder);
		} else {
			var l = personImgDimArr[1]+15;
		}
		s += '<div id="'+this.id+'_userNameDIV" dir="'+this.dir+'" style="visibility: inherit; font-family: Arial; font-size: 10px; color: #000000; left:'+l+'px; top:35px; height:20px;  width:'+eval(this.w-fromRightBorder)+'; background-color:transparent; padding:3; overflow: none; position:absolute;">';
		s += '<b>'+userName+'</b>';
		s += '</div>';		
		
		contentYCTop += 20;
	}
	
	if (buttonAdd){
		var timeImgDimArr = new Array(buttonAdd.clockGraphicH, buttonAdd.clockGraphicW);
	}else{
		var timeImgDimArr = this.getImageHeightWidth(this.timeImg);	
	};		
	if (this.dir == "rtl") {
		var l = this.w-10-timeImgDimArr[1];
	} else {
		var l = 10;
	}
	s += '<div id="'+this.id+'timeImg" style="left:'+l+'px; top:'+contentYCTop+'px; height:'+timeImgDimArr[0]+'px; width:'+timeImgDimArr[1]+'px; clip: rect (0px '+timeImgDimArr[1]+'px '+timeImgDimArr[0]+'px 0px); position:absolute; ">';
	s += this.getImageObiekt(this.timeImg, timeImgDimArr[1], timeImgDimArr[0]);
	s += '</div>'	
	if (this.dir == "rtl") {
		var l = this.w-timeImgDimArr[1]-15-(this.w-fromRightBorder);
	} else {
		var l = timeImgDimArr[1]+15;
	}
	s += '<div id="'+this.id+'_dateDIV" dir="'+this.dir+'" style="visibility: inherit; font-family: Arial; font-size: 10px; color: #000000; left:'+l+'px; top:'+contentYCTop+'px; height:20px;  width:'+eval(this.w-fromRightBorder)+'; background-color:transparent; padding:3; overflow: none; position:absolute;">';
	//s += this.date;
	//s += this.getDate(buttonAdd);
	s += this.date;
	s += '</div>';
	
	contentYCTop += 20;
	
	if (this.showUserName.toString() == 'true'){
		var contentH = eval(this.h-85)
	}else{
		var contentH = eval(this.h-65)
	}
	
	s += '<div id="'+this.id+'_noteDIV" dir="'+this.dir+'"';
	if (is.ie) {
		s += ((this.id.indexOf('__yc__') > -1) ? ' contenteditable="true"  onfocusout="pc.' + this.id + '.updateNote(this);"' : '');
		//s += ' contenteditable="true" onfocusout="pc.' + this.id + '.updateNote(this);"';
	}
	s += ' style="visibility: inherit; font-family: Arial; font-size: 10px; color: #000000; left:10px; top:'+contentYCTop+'px; height:'+contentH+'px;  width:'+eval(this.w-20)+'; background-color:transparent; padding:3; overflow: auto; position:absolute; cursor: text;" onMousedown="pc.'+this.id+'._stopPropagation(window.event);">';
	if (is.ie) {
		s += unescape(this.note);	
	} else {
		if (this.id.indexOf('__yc__') > -1) {
			s += '<iframe id="moz_iframe_' + this.id + '_noteDIV" dir="'+this.dir+'" src="" style="width:100%; height:100%" border="0" frameborder="0" framespacing="0" onload="pc.' + this.id + '.mozLoadedNote(this);"></iframe>';
			//onblur="pc.' + this.id + '.mozUpdateNote(this);"
		} else {
			s += unescape(this.note);	
		}
	}
	s += '</div>';

	/*
	if (buttonAdd){
		var miniImgDimArr = new Array(buttonAdd.minimalizedCardH, buttonAdd.minimalizedCardW);
	}else{
		var miniImgDimArr = this.getImageHeightWidth(this.miniBckg);
	};		
	s += '<div id="'+this.id+'miniCard" isMini="true" style="visibility: hidden; left:0px; top:0px; height:'+miniImgDimArr[0]+'px; width:'+miniImgDimArr[1]+'px; clip: rect (0px '+miniImgDimArr[1]+'px '+miniImgDimArr[0]+'px 0px); visibility: hidden; position:absolute; " onMouseup="pc.'+this.id+'.maximalizeCard();">';
	s += this.getImageObiekt(this.miniBckg, miniImgDimArr[1], miniImgDimArr[0]);
	s += '</div>';
	*/
	this.setHTML(s);
};

__componentYellowCard.prototype.getImageObiekt = function(imgName, width, height)
{
	var s = '';
	
	var src = this.resourcesURL+imgName;
	var smallLettersName = imgName.toLowerCase();
	src = ".." + src.substr(src.lastIndexOf("/resources/"), src.length);
	if (smallLettersName.indexOf('.png') > -1 && is.ie55UP && !is.ie7UP) {
		s = '<span  src="' + this.resourcesURL+imgName + '"';
		s += ' style="width:' + width + '; height:' + height + '; display:inline-block;';
		s += 'filter:progid:DXImageTransform.Microsoft.AlphaImageLoader';
		s += '(src=\'' + src + '\', sizingMethod=\'image\');" ></span>';
	}else{
		s = '<img src="'+this.resourcesURL+imgName+'" height="'+height+'px" width="'+width+'px" >';
	};
	
	return s;
};

__componentYellowCard.prototype.mozLoadedTitle = function()
{
	if (!is.ie) {
		obj = document.getElementById("moz_iframe_" + this.id + "_titleDIV");
		if (obj) {
			obj.contentDocument.designMode = "on";
			obj.contentDocument.body.style.cssText = "font-family:Arial Black; font-size:10px; color:#000000; margin-left:0px; margin-top:0px; margin-right:0px; margin-bottom:0px;";
			obj.contentDocument.body.innerHTML = unescape(this.title);
			obj.contentDocument.ownerComp = this;
			obj.contentDocument.addEventListener("blur", this.mozUpdateTitle, false);
		}
	}
};

__componentYellowCard.prototype.mozLoadedNote = function()
{
	if (!is.ie) {
		obj = document.getElementById("moz_iframe_" + this.id + "_noteDIV");
		if (obj) {
			obj.contentDocument.designMode = "on";
			obj.contentDocument.body.style.cssText = "font-family:Arial; font-size:10px; color:#000000; margin-left:0px; margin-top:0px; margin-right:0px; margin-bottom:0px;";
			obj.contentDocument.body.innerHTML = unescape(this.note);
			obj.contentDocument.ownerComp = this;
			obj.contentDocument.addEventListener("blur", this.mozUpdateNote, false);
		}
	}
};

__componentYellowCard.prototype.updateTitle = function(obj)
{
	this.title = obj.innerHTML;
	this.saveCard();
};

__componentYellowCard.prototype.updateNote = function(obj)
{
	this.note = obj.innerHTML;
	this.saveCard();
};

__componentYellowCard.prototype.mozUpdateTitle = function(obj)
{
	obj = document.getElementById("moz_iframe_" + this.ownerComp.id + "_titleDIV");
	if (obj) {
		this.ownerComp.title = obj.contentDocument.body.innerHTML;
		this.ownerComp.saveCard();
	}
};

__componentYellowCard.prototype.mozUpdateNote = function(obj)
{
	obj = document.getElementById("moz_iframe_" + this.ownerComp.id + "_noteDIV");
	if (obj) {
		this.ownerComp.note = obj.contentDocument.body.innerHTML;
		this.ownerComp.saveCard();
	}
};

__componentYellowCard.prototype.mouseOutButton = function(obj, fileName)
{
	obj.src = this.resourcesURL+fileName;
};	

__componentYellowCard.prototype.mouseOverButton = function(obj, fileName)
{
	obj.src = this.resourcesURL+fileName;
};

__componentYellowCard.prototype._stopPropagation = function(ev)
{
	ev.cancelBubble = true;
};

__componentYellowCard.prototype.beginDrag = function(obj)
{
	PageInterface.Execute("setOnTop", this);
}

__componentYellowCard.prototype.__componentYellowCardBaseOnHide = __componentYellowCard.prototype.hide;
__componentYellowCard.prototype.hide = function(hideMini) 
{
	this.__componentYellowCardBaseOnHide();
	if (!hideMini){
		var miniCard = PageInterface.GetValue("getChild", this.id+'_mini');
		miniCard.hide();
	}
}

__componentYellowCard.prototype.__componentYellowCardBaseShow = __componentYellowCard.prototype.show;
__componentYellowCard.prototype.show = function() 
{
	PageInterface.Execute("setOnTop", this);

	this.__componentYellowCardBaseShow();
	if (this.defaultMinimalize) {
		this.minimalizeCard();		
	}else{
		if (this.isMaximalize) {
			this.maximalizeCard();
		} else {
			this.minimalizeCard();
		};
	};
};

__componentYellowCard.prototype.maximalizeCard = function() 
{
	if (wasDragging) return;

	//call overwrited method - to NOT loop in infinity
	this.__componentYellowCardBaseShow();
	this.beginDrag();
	
	this.isMaximalize = true;
};

__componentYellowCard.prototype.minimalizeCard = function(obj) 
{
	var miniCard = PageInterface.GetValue("getChild", this.id+'_mini');
	if (miniCard){
		miniCard.x = this.x;
		miniCard.y = this.y;
		miniCard.show();
	}
	this.hide(true);
	this.isMaximalize = false;
};

__componentYellowCard.prototype.deleteYellowCard = function(imgName) 
{
	if (PlayerInterface.Execute("deleteYellowCard", this.id, this)) this.hide();
};

__componentYellowCard.prototype.saveCard = function()
{
	var user = PlayerInterface.GetValue("userName");
	var date = this.date;
	note = unescape(this.note);
	title = unescape(this.title);
	PlayerInterface.Execute("updateYellowCard",
		this.id, date, user, this.x, this.y,
		title, note, this.src, this.miniBckg, this.buttonTrashOver,
		this.buttonTrashOut, this.buttonMiniOver, this.buttonMiniOut, this.buttonHideOver, this.buttonHideOut,
		this.authorDot, this.personImg, this.timeImg, this.defaultMinimalize, this.showMouseOver,
		this.isMaximalize);
};

__componentYellowCard.prototype.getImageHeightWidth = function(imgName) 
{
	var hei = getImageHeight(imgName);
	var wid = getImageWidth(imgName);
	
	return [hei, wid];	
};

__componentYellowCard.prototype.setResImages = function(Bckg, removeOver, removeOut, miniOver, miniOut, closeOver, closeOut, smallBg, titleDot, personImg, timeImg, buttonSpace, offsetLeft, offsetTop, cardW, cardH)
{
	this.src = Bckg;
	this.miniBckg = smallBg;
	this.authorDot = titleDot;
	
	this.buttonTrashOver = removeOver;
	this.buttonTrashOut = removeOut;
	
	this.buttonMiniOver = miniOver;
	this.buttonMiniOut = miniOut;
	
	this.buttonHideOver = closeOver;
	this.buttonHideOut = closeOut;
	
	this.personImg = personImg;
	this.timeImg = timeImg;
	
	this.spaceBetweenButtons = buttonSpace;
	this.offsetTop = offsetLeft;
	this.offsetLeft = offsetTop;
	
	this.w = cardW;
	this.h = cardH;
};

__componentYellowCard.prototype.__componentYellowCardBaseUnselectable = __componentYellowCard.prototype.unselectable;
__componentYellowCard.prototype.unselectable = function()
{
	this.__componentYellowCardBaseUnselectable();
	
	var divTabs = this.obj.getElementsByTagName("DIV");
	
	for (i = 0; i < divTabs.length; i++) {
		if (divTabs[i].id == this.id+'_noteDIV' || divTabs[i].id == this.id+'_titleDIV')
			divTabs[i].unselectable = "";
	};	
};
