/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentMiniStatistics = function(name)
{
	this.componentStatistics = componentStatistics;
	this.componentStatistics(name);

	this.bckgProgressImg = '';
	this.bckgProgressColor = 'transparent';
	this.titleName = '';
	this.progressKind = '';

	this.bigStatistik = null;
	this.chaptersArr = new Array();
	this.pageParentsNames = new Array();
};

componentMiniStatistics.prototype = new componentStatistics();
componentMiniStatistics.prototype.type = "componentMiniStatistics";

componentMiniStatistics.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL); 

	this.imagesNameArr = [this.chapterProgressBckg, this.lessonProgressBckg, this.pageProgressBckg];
	this.getPreloadImagesArr();

	this.progressKind = this.ownProgress;
};

componentMiniStatistics.prototype.onCreate = function(obj)
{
	var st = getStruct();
	this.getChapters(st);
	this.getPagesInChapter();
};

componentMiniStatistics.prototype.writeProgressText = function(title, min, max)
{
	var pageProgressText = document.getElementById(this.id + "_statisticText");
	var font = getProjectFont(this.globalFormating == 1, this.fontFamily, this.fontSize, this.fontColor);

	pageProgressText.style.fontFamily = font.family;
	pageProgressText.style.fontSize = getFontSize(font.size, 'px');
	pageProgressText.style.color = font.color;
	pageProgressText.innerHTML = title +'  '+min+'/'+max;
};

componentMiniStatistics.prototype.onPaint = function(obj)
{
	this.getPageNames();
	this.setImageToObiekt(this.ownProgress);
	this.setDivElements();
};

componentMiniStatistics.prototype.setImageToObiekt = function(progressKind)
{
	var progressBckgImg = document.getElementById(this.id + "_progressBckgImg");
	var progressDiv = document.getElementById(this.id + "_progressDiv");

	switch (progressKind) {
		case 'progressChapter':
			this.bckgProgressImg = this.chapterProgressBckg;
			this.bckgProgressColor = this.chapterProgress;
			this.titleName = this.chapterName;
			break;
		case 'progressLesson':
			this.bckgProgressImg = this.lessonProgressBckg;
			this.bckgProgressColor = this.lessonProgress;
			this.titleName = this.lessonName;
			break;
		case 'progressPage':
			this.bckgProgressImg = this.pageProgressBckg;
			this.bckgProgressColor = this.pageProgress;
			this.titleName = this.pageName;
			break;
	};

	progressBckgImg.src = this.resourcesURL + this.bckgProgressImg;
	progressDiv.style.backgroundColor = this.bckgProgressColor;

	this.progressKind = progressKind;

	if (this.bigStatistik){
		switch (progressKind){
			case 'progressChapter' :
				this.setProgress(this.chapterName, this.bigStatistik.chapterProgress, this.bigStatistik.chapterLength)
				break;
			case 'progressLesson' : 
				this.setProgress(this.lessonName, this.bigStatistik.lessonProgress, this.bigStatistik.lessonLength)
				break;
			case 'progressPage' : 
				this.setProgress(this.pageName, this.bigStatistik.pageProgress, this.bigStatistik.pageLength)
				break;
		};
	} else {
		var lessonName = this.pageParentsNames[this.pageParentsNames.length-2];
		var chapterName = this.pageParentsNames[this.pageParentsNames.length-1];
		if (PageInterface.GetValue("state") != psDesigning) {
			var chapterPagesArr = this.chaptersArr[chapterName];
			if (typeof(chapterPagesArr) != 'undefined') {
				var visitedPagesInChapter = this.findCountVisitedPage(chapterName);
				if (this.chaptersArr[chapterName][2].length > 0) {
					var pagesInChapter = this.chaptersArr[chapterName][2].length
					var visitedPagesInLesson = this.findCountVisitedPageInLesson(chapterName, lessonName);
				};
				switch (progressKind){
					case 'progressChapter':
						this.setProgress(this.chapterName, visitedPagesInChapter, pagesInChapter);
						break;
					case 'progressLesson': 
						if (visitedPagesInLesson){
							this.setProgress(this.lessonName, visitedPagesInLesson[1], visitedPagesInLesson[0]);
						}
						break;
				};
			};
		} else {
			var pageName = PageInterface.GetValue("pageName");
			this.setProgress(pageName, 0, 0);
		};
	};
};

componentMiniStatistics.prototype.getPageNames = function()
{
	var st = getStruct();
	var par1 = null;
	var par2 = null;

	if (st){
		var item = st.findItem(PageInterface.GetValue('pageGix'));
		if (item){
			var pageName = item['title'];
			var parentIndex = item['parent'];

			this.pageParentsNames.push(pageName);
			do {
				par1 = this.getPageParentName(st, parentIndex);
				if (par1 && par1 != par2) {
					parentIndex = par1['parent'];
					par2 = par1;
				} else par2 = null;
			} while (par2);
		};
	};
};

componentMiniStatistics.prototype.setProgress = function(title, actual, maxCount)
{
	var pageProgressText = document.getElementById(this.id + "_statisticText");
	var progressDiv = document.getElementById(this.id + "_progressDiv");

	var stepsCount = (eval(page.steps.length-2) == 0)?1:eval(page.steps.length-2);
	var progressW = getImageWidth(this.chapterProgressBckg);

	var perc = (maxCount == 0) ? 1 : actual/maxCount;
	progressDiv.style.width = eval(this.w*perc);
	var progressH = progressDiv.offsetHeight;
	progressDiv.style.clip = 'rect(0px '+eval(this.w*perc)+'px '+progressH+'px 0px)';
	if (this.showText == 1) {
		this.writeProgressText(title, actual, maxCount);
	};
};

componentMiniStatistics.prototype.setDivElements = function(obj)
{
	var progressDiv = document.getElementById(this.id + "_progressDiv");
	var progressBckgDiv = document.getElementById(this.id + "_progressBckgDiv");
	var statisticDiv = document.getElementById(this.id + "_statisticDiv");
	var sizeDiv = document.getElementById(this.id + "_sizeDiv");
	sizeDiv.innerHTML = this.titleName;

	if (!this.showText || this.showText == 'false' || this.showText == 0) {
		progressDiv.style.left = 0;
		progressDiv.style.top = 0;
		progressDiv.style.height = this.h;
		progressDiv.style.clip = 'rect(0px '+this.w+'px 0px 0px)';
		progressDiv.style.backgroundColor = this.bckgProgressColor;

		progressBckgDiv.style.left = 0;
		progressBckgDiv.style.top = 0;
		progressBckgDiv.style.width = this.w;
		progressBckgDiv.style.height = this.h;
		progressBckgDiv.style.clip = 'rect(0px '+this.w+'px '+this.h+'px 0px)';
	} else {
		var textH = sizeDiv.offsetHeight;
		statisticDiv.style.left = 0;
		statisticDiv.style.top = 0;
		statisticDiv.style.height = textH;
		statisticDiv.style.clip = 'rect(0px '+this.w+'px '+textH+'px 0px)';

		progressDiv.style.left = 0;
		progressDiv.style.top = textH;
		progressDiv.style.height = eval(this.h-textH);
		progressDiv.style.clip = 'rect(0px '+this.w+'px '+eval(this.h-textH)+'px 0px)';
		progressDiv.style.backgroundColor = this.bckgProgressColor;

		progressBckgDiv.style.left = 0;
		progressBckgDiv.style.top = textH;
		progressBckgDiv.style.width = this.w;
		progressBckgDiv.style.height = eval(this.h-textH);
		progressBckgDiv.style.clip = 'rect(0px '+this.w+'px '+eval(this.h-textH)+'px 0px)';
	};
};

componentMiniStatistics.prototype.onStep = function()
{
	if (this.progressKind == 'progressPage') {
		var stepsCount = (eval(page.steps.length-2) == 0)?0:eval(page.steps.length-2);
		this.setProgress(this.titleName, page.stepIndex, stepsCount);
	};
};

componentMiniStatistics.prototype.onAfterLoad = function(obj)
{
	var objStat = null;
	if (this.otherStatisticComp == '' || this.otherStatisticComp == "-") return;

	for (var i =0; i < page.children.length; i++) {
		var obj = page.children[i];
		if (this.otherStatisticComp != '' && this.otherStatisticComp != "-" && obj.id.indexOf(this.otherStatisticComp) > -1) {
			objStat = obj;
			objStat.myMiniStatistic.push(this);
			this.bigStatistik = objStat;

			var progress = lms.getCourseData('_statistic_progress');
			if (progress) {
				objStat.choosenProgress = progress;
				switch (progress) {
					case 'progressChapter' :
						var progObj = document.getElementById(objStat.id + "_radio1Img");
						break;
					case 'progressLesson' :
						var progObj = document.getElementById(objStat.id + "_radio2Img");
						break;
					case 'progressPage' :
						var progObj = document.getElementById(objStat.id + "_radio3Img");
						break;
					default :
						var progObj = null;
						break;
				};
				if (progObj) objStat.changeRadioImg(progObj, progress);
			};
		};
	};
};
