﻿module MazeWater {

    export class MazeWater extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        player: Phaser.Sprite;
        cursors: Phaser.CursorKeys;
        map: Array<number>;
        wall: Phaser.Group;
        koniec: boolean = false;
        fail: boolean = false;
        przewodnik: Phaser.Sprite;
        dymek: Phaser.Sprite;
        polecenie: Phaser.Text;
        ready: boolean = false;

        kran: Phaser.Sprite;
        woda: Phaser.Sprite;
        


        init(json) {
            super.init(json);
            this.Elements = json.GameData;

        }

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);

        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();        

            this.map = this.Elements.Tilemap[0].layers[0].data;
            this.game.load.spritesheet('player', 'Graphics/Games/OB_G_II_3/OB_g_II_3_gracz.png', 29, 29, 4);
        }

        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);

            this.cursors = this.game.input.keyboard.createCursorKeys();
        }

        create() {
            if (this.json.isStandalone) {
                super.create();

            }

            this.game.physics.startSystem(Phaser.Physics.ARCADE);

            this.wall = this.game.add.group();
            this.addChild(this.wall);

            this.woda = this.game.add.sprite(1093, 635, 'woda');
            this.woda.anchor.set(0.5, 1);
            this.woda.scale.y = 0.1;
            this.addChild(this.woda);

            this.game.time.events.loop(Phaser.Timer.SECOND, this.updateWater, this);

            this.kran = this.game.add.sprite(1060, 550, 'kran');
            this.addChild(this.kran);

            this.player = this.game.add.sprite(560, 64, 'player');
            this.player.animations.add('walk', [0, 1, 2, 3], 0, false);
            this.addChild(this.player);

            this.przewodnik = this.game.add.sprite(1150, 255, 'przewodnik');
            this.przewodnik.inputEnabled = true;
            this.przewodnik.events.onInputDown.add(function () {

                this.przewodnik.visible = false;
                if (this.koniec == false) this.ready = true;
                if (this.koniec == true && this.fail == true) this.resetStage();
                 
            }, this);

            this.addChild(this.przewodnik);

            this.dymek = this.game.add.sprite(-700, -200, 'dymek');
            this.przewodnik.addChild(this.dymek);

            this.polecenie = this.game.add.text(150, 200, "Nie pozwól na marnowanie \nwody w Twojej firmie,\nzawsze zakręcaj kran.", { font: "32px Arial", fill: "#000000", wordWrap: true, wordWrapWidth: this.dymek.width, align: "center" })
            this.dymek.addChild(this.polecenie);

            this.game.physics.enable([this.player, this.kran], Phaser.Physics.ARCADE);
 
            var idx = 0;
            for (var i = 0; i < 21; i++)
                for (var j = 0; j < 21; j++) {
                    if (this.map[idx++] == 1) var spr = this.game.add.sprite(500 + (j * 32),(i * 32), 'blok');
                    this.game.physics.enable(spr, Phaser.Physics.ARCADE);
                    this.addChild(spr);
                    this.wall.add(spr);
                }

            this.wall.setAll('body.immovable', true);
            
        }

        resetStage() {
            this.player.x = 560;
            this.player.y = 64;
            this.woda.scale.y = 0.1;
            this.koniec = false;
            this.fail = false;
        }

        updateWater() {
            if (this.woda.scale.y < 1 && this.koniec == false && this.ready) this.woda.scale.y = this.woda.scale.y + 0.02;
        }

        update() {

            if (this.ready) {

                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;

                if (this.woda.scale.y > 0.9) {
                    this.polecenie.setText("Pamiętaj!\nOchrona środowiska\nwymaga wysiłku.\nSpróbuj jeszcze raz.");
                    this.przewodnik.visible = true;
                    this.koniec = true;
                    this.fail = true;
                    EU.Log("Czas się skończył.");
                }

                if (this.game.physics.arcade.collide(this.player, this.kran)) {

                    this.player.body.moves = false;
                    this.koniec = true;
                    this.ready = false;

                    if (this.woda.scale.y < 1) {
                        this.polecenie.setText("Widzę, że ochrona środowiska\nnie jest Ci obca.");
                        this.przewodnik.visible = true;
                        this.fail = false;
                        EU.setGameCompletion(this.parent, 1);
                        EU.Log("Gra ukończona z sukcesem.");
                        super.nextTask();
                    }

                }

                this.game.physics.arcade.collide(this.player, this.wall);

                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;

                if (this.cursors.left.isDown) {
                    this.player.body.velocity.x = -200;
                    if (this.player.body.moves != false) this.player.animations.frame = 3;
                }


                if (this.cursors.right.isDown) {
                    this.player.body.velocity.x = 200;
                    if (this.player.body.moves != false) this.player.animations.frame = 2;
                }

                if (this.cursors.up.isDown) {
                    this.player.body.velocity.y = -200;
                    if (this.player.body.moves != false) this.player.animations.frame = 1;

                }


                if (this.cursors.down.isDown) {
                    this.player.body.velocity.y = 200;
                    if (this.player.body.moves != false) this.player.animations.frame = 0;
                }

            }

        }


    }

}

