var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var GameScreen;
(function (GameScreen) {
    var flags = [];
    var flagArr = [];
    var flagArrLen = 0;
    //sounds
    var goal = null;
    var match = null;
    var winner = null;
    //groups
    var grp = null;
    var dropLvl = null;
    var task = null;
    var MainGameState = (function (_super) {
        __extends(MainGameState, _super);
        function MainGameState() {
            _super.call(this);
        }
        MainGameState.prototype.create = function () {
            /// layout groups
            this.dragLevel = this.game.add.group();
            this.dragLevel.z = 10;
            this.dropLevel = this.game.add.group();
            this.dropLevel.z = 8;
            dropLvl = this.dropLevel;
            this.helpGroup = this.game.add.group();
            this.helpGroup.z = 12;
            this.helpGroup.visible = false;
            // backgrounds
            this.titleScreenImage = this.add.sprite(0, 0, "background");
            this.game.add.image(0, this.game.height * 0.93, "grass");
            this.game.add.button(this.game.width - 158, 50, "help", this.help, this, 0, 0, 1, 0);
            this.game.add.button(50, 50, "retry", this.retry, this, 0, 0, 1, 0);
            /// help
            var cloud = this.game.add.image(this.game.width * 0.6, 150, "cloud");
            var guide = this.game.add.image(this.game.width * 0.7, this.game.height - 432, "help_guide");
            guide.scale.x = 0.75;
            guide.scale.y = 0.75;
            task = this.game.add.text(this.game.width * 0.62, 300, "Pomóż uporządkować flagi państw europejskich.\nDopasuj połówki. Prawidłowo dobrana flaga\nzacznie powiewać na maszcie.", "");
            this.helpGroup.add(cloud);
            this.helpGroup.add(guide);
            this.helpGroup.add(task);
            grp = this.helpGroup;
            // gradient
            var am = 20;
            var grad = this.game.make.sprite(0, 0, "grad");
            this.wave = this.game.add.bitmapData(196, am * 122, "wave");
            var x = -196;
            var y = 0;
            for (var i = 0; i < am; i++) {
                this.wave.draw(grad, x, y);
                x += 20;
                y += 122;
            }
            this.game.cache.addSpriteSheet("wave_anim", '', this.wave.canvas, 196, 122, am, 0, 0);
            //// game elements
            var len = flags.length;
            var pos = generatePositions(450, 200, len);
            for (var i = 0; i < len; i++) {
                var mast = this.game.add.image(120 + i * 300, this.game.height * 0.6, "mast");
                var drop = this.game.add.image(238 + i * 300, this.game.height * 0.63, "drop", 0);
                var left = this.game.add.sprite(140 + i * 300, this.game.height * 0.63, flags[i], 0);
                var full = this.game.add.image(0, 0, flags[i] + "_full");
                full.visible = false;
                this.dropLevel.add(full);
                var drag = this.game.add.sprite(pos[i], this.game.height * 0.20, flags[i], 1);
                drag.inputEnabled = true;
                drag.input.enableDrag();
                this.dragLevel.add(drag);
                flagArr.push({ left: left, drag: drag, dragPos: { x: drag.x, y: drag.y }, drop: drop, full: full });
                var elm = flagArr[flagArr.length - 1];
                drag.events.onDragStop.add(dragStop, this);
                this.dropLevel.add(drop);
                this.dropLevel.add(left);
                this.dropLevel.add(mast);
            }
            this.game.world.sort('z', Phaser.Group.SORT_ASCENDING);
            flagArrLen = flagArr.length;
            this.help();
            $(goal).bind("ended", function () {
                initHelp(grp);
            });
        };
        MainGameState.prototype.preload = function () {
            ///loading flags
            var c = 39;
            var temp = [];
            for (var i = 0; i < 6; i++) {
                var r = Math.floor(Math.random() * c);
                while ($.inArray(r, temp) !== -1 || r === 0) {
                    r = Math.floor(Math.random() * c);
                }
                temp.push(r);
            }
            var tLen = temp.length;
            for (var i = 0; i < tLen; i++) {
                var t = new Image();
                t.src = "./Graphics/cards/" + temp[i] + ".png";
                this.game.load.spritesheet("flag_" + temp[i], "Graphics/cards/" + temp[i] + ".png", 98, 122, 2, 0, 0);
                this.game.load.image("flag_" + temp[i] + "_full", "Graphics/cards/" + temp[i] + ".png");
                flags.push("flag_" + temp[i]);
            }
            this.game.load.image("grass", "Graphics/back/grass.png");
            this.game.load.image("mast", "Graphics/back/mast.png");
            this.game.load.image("drop", "Graphics/cards/drop.png");
            /// loading help
            this.game.load.image("help_guide", "Graphics/gui/guide.png");
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            ///loading buttons
            this.game.load.spritesheet("retry", "Graphics/gui/replay.png", 108, 111, 2, 0, 0);
            this.game.load.spritesheet("help", "Graphics/gui/help.png", 104, 108, 2, 0, 8);
            /// load gradient
            this.game.load.spritesheet("grad", "Graphics/back/gradient3.png", 196, 122, 1, 0, 0);
            //loading sounds
            goal = new Audio("./Sounds/objective.mp3");
            match = new Audio("./Sounds/click.mp3");
            winner = new Audio("./Sounds/win.mp3");
        };
        /// button click event functions
        MainGameState.prototype.help = function () {
            try {
                goal.pause();
                goal.currentTime = 0;
            }
            catch (e) {
            }
            try {
                winner.pause();
                winner.currentTime = 0;
            }
            catch (e) {
            }
            try {
                match.pause();
                match.currentTime = 0;
            }
            catch (e) {
            }
			this.helpGroup.visible = true;
            goal.play();
        };
        MainGameState.prototype.retry = function () {
            try {
                goal.pause();
                goal.currentTime = 0;
            }
            catch (e) {
            }
            try {
                winner.pause();
                winner.currentTime = 0;
            }
            catch (e) {
            }
            try {
                match.pause();
                match.currentTime = 0;
            }
            catch (e) {
            }
            flags = [];
            flagArr = [];
            flagArrLen = 0;
            grp = null;
            dropLvl = null;
            task = null;
            this.game.state.restart(true, false);
        };
        return MainGameState;
    })(Phaser.State);
    GameScreen.MainGameState = MainGameState;
    function initHelp(grp) {
        grp.visible = false;
    }
    ///drag Elements Event Listeners
    function dragStop(sprite) {
        var found = false;
        var flagElm = null;
        for (var i = 0; i < flagArrLen; i++) {
            if (flagArr[i].drag === sprite) {
                flagElm = flagArr[i];
                break;
            }
        }
        for (var i = 0; i < flagArrLen; i++) {
            if (checkOverlap(sprite, flagArr[i].drop)) {
                try {
                    match.pause();
                    match.currentTime = 0;
                }
                catch (ev) {
                }
                match.play();
                sprite.x = flagArr[i].drop.x;
                sprite.y = flagArr[i].drop.y;
                if (flagArr[i].drop === flagElm.drop) {
                    sprite.visible = false;
                    flagElm.left.visible = false;
                    flagElm.drop.visible = false;
                    flagElm.full.visible = true;
                    flagElm.full.x = flagElm.left.x;
                    flagElm.full.y = flagElm.left.y;
                    var test = this.game.add.sprite(flagElm.left.x, flagElm.left.y, 'wave_anim');
                    dropLvl.add(test);
                    test.animations.add('float');
                    test.play('float', 14, true);
                }
                found = true;
                break;
            }
        }
        if (!found) {
            sprite.x = flagElm.dragPos.x;
            sprite.y = flagElm.dragPos.y;
        }
        if (checkWin()) {
            for (var i = 0; i < flagArrLen; i++) {
                var ct = parseInt(flagArr[i].drag.key.split("_")[1]) - 1;
                var txt = this.game.add.text(flagArr[i].full.x, flagArr[i].full.y - 100, COUNTRY_NAMES[ct]);
                dropLvl.add(txt);
            }
            this.game.world.sort();
            winner.play();
        }
    }
    /// game logic functions
    function checkWin() {
        var win = true;
        for (var i = 0; i < flagArrLen; i++) {
            if (flagArr[i].drag.x !== flagArr[i].drop.x || flagArr[i].drag.y !== flagArr[i].drop.y) {
                win = false;
                break;
            }
        }
        return win;
    }
    function checkOverlap(a, b) {
        var bA = a.getBounds();
        var bB = b.getBounds();
        return Phaser.Rectangle.intersects(bA, bB);
    }
    // utility functions
    function generatePositions(leftMargin, width, amount) {
        var ret = [];
        for (var i = 0; i < amount; i++) {
            ret.push({ x: leftMargin + i * width, used: false });
        }
        var temp = [];
        for (var i = 0; i < amount; i++) {
            var c = Math.floor(Math.random() * amount);
            while (ret[c].used) {
                c = Math.floor(Math.random() * amount);
            }
            temp.push(ret[c].x);
            ret[c].used = true;
        }
        return temp;
    }
})(GameScreen || (GameScreen = {}));
//# sourceMappingURL=MainGameState.js.map