﻿module TitleScreen {
    export class TitleScreenState extends Phaser.State {
        game: Phaser.Game;
        titleScreenImage: Phaser.Sprite;

        constructor() {
            super();
        }

        create() {
            this.titleScreenImage = this.add.sprite(0, 0, "background");
            this.titleScreenImage.scale.setTo(this.game.width / this.titleScreenImage.width, this.game.height / this.titleScreenImage.height);

            this.game.add.image(this.game.width / 4, this.game.height / 7, "box");
            this.game.add.image(0, this.game.height - 180, "sponsors");
            this.game.add.image(this.game.width / 2 - 700, this.game.height * 0.49, "introGuide");

            var play = this.game.add.button(this.game.width / 2 + 200, this.game.height*0.55, "play", this.playDown, this, 1, 0, 2,1);

        }

        preload() {
            ///loading background
            this.load.image("background", "Graphics/gui/background.jpg");


            ///loading Intro screen
            this.load.spritesheet("play", "Graphics/gui/play_btn.png", 200, 200, 3);
            this.load.image("box", "Graphics/gui/intro_box.png");
            this.load.image("sponsors", "Graphics/gui/sponsors.png");
            this.load.image("introGuide", "Graphics/gui/guide2.png");

        }

        playDown(play, pointer) {
            this.game.state.start("MainGameState", true, false);
        }
    }
}