﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentFlashExercise = function(name)
{
	//inherited
	this.componentFlash = componentFlash;
	this.componentFlash(name);
	this.resourcesStatus = "online";
	this.resourcesURL = "";
	this.interactions = true;
	this.interactionsType = "matching";
	this.answer = "";
};

componentFlashExercise.prototype = new componentFlash;
componentFlashExercise.prototype.type = "componentFlashExercise";

componentFlashExercise.prototype.onBaseCreate = function(obj)
{
	this.resourcesURL = resourcesURL;
	this.captureMouseEvents();
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
	};
    this.resourcesURL = unescape(this.resourcesURL);
};

componentFlashExercise.prototype.componentBaseOnCreate = componentFlashExercise.prototype.onCreate;
componentFlashExercise.prototype.onCreate = function(obj)
{
	if (PageInterface.GetValue("state") == psDesigning) { //pg2-otherwise in case of new version of FlashPlayer (v11) there is a blank rect
		t = '<img src="' + this.resourcesURL + this.playerBackground + '" width="' + this.w + '" height="' + this.h + '"/>';
		this.setHTML(t);
		return;
	};
	
	this.componentBaseOnCreate();
	this.flashVars = this.getFlashVarsStr(this.variables, this.flashVars);

	var t = "";
	t += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="https://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="'+ this.w +'" height="'+ this.h +'" id="'+ this.id +'flashPlayer" align="middle">';
	t += '  <param name="movie" value="'+ this.resourcesURL + this.src +'">';
	t += '  <param name="allowScriptAccess" value="sameDomain" />';
	t += '  <param name="bgcolor" value="#FFFFFF">';
	t += '  <param name="quality" value="' + this.quality + '">';
	t += '  <param name="loop" value="' + this.loop + '">';
	t += '  <param name="WMode" value="' + this.wmode + '">';
	t += '  <param name="scale" value="' + this.scale + '">';
	t += '  <param name="salign" value="' + this.salign + '">';
	t += '  <param name="FlashVars" value="' + this.flashVars + '">'; //&veriable_1=value_1&veriable_2=value_2
	t += '  <embed wmode="transparent" src="'+ this.resourcesURL + this.src +'" quality="' + this.quality + '" bgcolor="#FFFFFF" name="'+ this.id +'flashPlayer" type="application/x-shockwave-flash" pluginspage="https://www.macromedia.com/go/getflashplayer" width="'+ this.w +'" height="'+ this.h +'"></embed>';
	t += '</object>';

	var variablesArr = this.variables.split(",");
	var corAnswersArr = variablesArr[0].split("=");
	this.correctAnswer = corAnswersArr[1];  

	this.setHTML(t);
	//alert(t);
};

componentFlashExercise.prototype.componentBaseOnPaint = componentFlashExercise.prototype.onPaint;
componentFlashExercise.prototype.onPaint = function(obj)
{
	//if (is.moz) {
		window.setTimeout("pc." + this.id + ".putVariables()", 500);
	//}
	this.componentBaseOnPaint();
};

componentFlashExercise.prototype.setSizeScaledElement = function(x, y, w, h)
{
	if (this.execution){
		this.obj.all[this.id + "flashPlayer"].width = w;
		this.obj.all[this.id + "flashPlayer"].height = h;
		this.obj.style.left = x;
		this.obj.style.top = y;
		this.obj.style.width = w;
		this.obj.style.height = h;
		this.obj.style.clip = 'rect(0px '+w+' '+h+' 0px)';
	};
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
};

componentFlashExercise.prototype.putVariables = function(obj)
{
	//if (is.moz) {
		var flashVarsArr = this.flashVars.split("&");
		for (var i=0; i<flashVarsArr.length; i++) {
			if (flashVarsArr[i] != "") {
				var varArr = flashVarsArr[i].split("=");
				this.setVariable(varArr[0], varArr[1]);
			};
		};
		//hidden variables (pytania do PG)
		this.setVariable("elementID", this.id);
		this.setVariable("zmienne_zostaly_poslane_z_WBTExpressa", true);
		this.setVariable("width_fromWBTExpress", this.w);
		this.setVariable("height_fromWBTExpress", this.h);
		this.setVariable("showAnswer", this.answer); //pg2-new -during initialization pass to the control last answer (or correct - it depends what option is enabled)
		this.setVariable("disableExercise", this.locked); //pg2-course's api decides if component must be locked at startup (page's / course's settings)
	//}
};

componentFlashExercise.prototype.getVariable = function(variable)
{
	try {
		return eval("document." + this.id + "flashPlayer.GetVariable('" + variable + "');");
	} catch(e) {
		var obj = document.getElementById(this.id + "flashPlayer"); //pg2-for Safari and Chrome
		if (obj) {
			try {
				return obj.GetVariable(variable);
			} catch(e) {
				return null;
			};
		};
		return null;
	};
};

componentFlashExercise.prototype.setVariable = function(variable, value)
{
	try {
		eval("document." + this.id + "flashPlayer.SetVariable('" + variable + "', '" + value + "');");
	} catch(e) {
		var obj = document.getElementById(this.id + "flashPlayer"); //pg2-for Safari and Chrome
		if (obj) {
			try {
				obj.SetVariable(variable, value);
			} catch(e) {};
		};
	};
};

componentFlashExercise.prototype.getAnswer = function()
{
	var answer = this.getVariable("answer");
	return answer.toString();
};

componentFlashExercise.prototype.setAnswer = function(value, showCorrect)
{
	if (typeof(showCorrect) == "undefined" || showCorrect == null) showCorrect = true;
	//if (showCorrect && (this.isChanged && this.isCorrectAnswer(this.getAnswer()))) return;
	if (typeof(value) == "undefined" || value == null) value = "";

	if (showCorrect && value == "") {
		var answers = this.getVariable("_correctAnswers");
		if (answers.indexOf('||') > -1) {
			var answersArr = answers.split('||');
			value = answersArr[0];
		};
	};

	//if (value.indexOf('||') > -1) { //pg2-removed
	//	var valueArr = value.split('||');
	//	value = arrAns[0];
	//}

	//this.setVariable("userAnswer", value); //pg2-removed
	this.setVariable("showAnswer", value); //pg2-new
	this.answer = value;

	return value;
};

componentFlashExercise.prototype.lock = function()
{
    this.setVariable("disableExercise", true);
	this.locked = true;
};

componentFlashExercise.prototype.isCorrectAnswer = function(v)
{
	var isCorrect = false;
	isCorrect = (this.getVariable("isCorrectAnswer") == "true");
	return isCorrect;
};

componentFlashExercise.prototype.checkAnswer = function()
{
	var result = this.isCorrectAnswer();
	return result;
};

componentFlashExercise.prototype.getFlashVarsStr = function(variables, flashVars)
{
	var result = "";
	var flashVarsArr = new Array();
	if (flashVars != "") {
		flashVarsArr = flashVars.split("&");
	};
	var variablesArr = variables.split(",");
	for (var i=0; i<variablesArr.length; i++) {
		var exists = false;
		var vars = variablesArr[i].split("=");
		for (var j=0; j<flashVarsArr.length; j++) {
			var fVars = flashVarsArr[j].split("=");
			if (fVars[0] == vars[0]) {
				flashVarsArr[j] = variablesArr[i];
				exists = true;
				break;
			};
		};
		if (!exists) {
			flashVarsArr[flashVarsArr.length] = variablesArr[i];
		};
	};

	for (var i=0; i<flashVarsArr.length; i++) {
		if (flashVarsArr[i] != "") {
			result += "&" + flashVarsArr[i];
		};
	};
	return result;
};

componentFlashExercise.prototype.eventFlashChanged = function(e)
{
	this.invokeEvent("Change");
};

componentFlashExercise.prototype.parseCheckAnswer = function(obj) {
	var result = this.isCorrectAnswer();
	return result;
};

componentFlashExercise.prototype.interactionsCorrectResponsesCount = function()
{
	return 1;
};

componentFlashExercise.prototype.interactionsStudentResponse = function() {
	return this.getAnswer();
}; 

componentFlashExercise.prototype.interactionsStudentResponseAsText = function() {
	return this.getAnswer().toString();
}; 

componentFlashExercise.prototype.interactionsCorrectResponses = function() {
	return this.correctAnswer;
};

componentFlashExercise.prototype.interactionsCorrectResponsesAsText = function(index) {
	return this.correctAnswer.toString();
};
