﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentButtonWithText = function(name)
{
	//inherited	
  	this.componentElement = componentElement;
  	this.componentElement(name); 	
	
	//included
	if (arguments[1]) {
	} else {
		this.image = this.addChild(new __componentImage(null));
		this.text = this.addChild(new __componentText(null));
	};
	this.confirmAnswer = false;
	this.lockAfterGivenAnswer = true;
	this.orgCursor = null;
};

componentButtonWithText.prototype = new componentElement;
componentButtonWithText.prototype.type = "componentButtonWithText";

componentButtonWithText.prototype.onBaseCreate = function(obj)
{
	this.resourcesURL = resourcesURL;
	this.captureMouseEvents();
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
		this.resourcesURL = unescape(this.resourcesURL);
		this.imagesNameArr = [this.src, this.mouseOverSrc, this.clickSrc, this.lockedSrc, this.mouseOverLockedSrc ];
		this.getPreloadImagesArr();
	};
};

componentButtonWithText.prototype.onCreate = function(obj)
{
	if (this.execution) {
		if (this.displayImage) {
			this.setImageSrc(this.resourcesURL + this.src);
		} else {
			document.getElementById(this.id + "_contentObj").style.display = "none";
		};
		if (this.displayText) {
			document.getElementById(this.id + "_textContentObj").innerHTML = this.textText;
			this.reinit();
		} else {
			document.getElementById(this.id + "_textContentObj").style.display = "none";
		};
	} else {
		this.text.p_checkMarkers = this.p_checkMarkers;
		this.text.p_checkPNG = this.p_checkPNG;
		this.text.pngFix = this.pngFix;

		this.image.p_checkMarkers = this.p_checkMarkers;
		this.image.p_checkPNG = this.p_checkPNG;
		this.image.pngFix = this.pngFix;

		this.text.visible = this.displayText;
		this.image.visible = this.displayImage;
	};
	//if there is no images 
    if (this.clickSrc == "") this.clickSrc = this.src;
    if (this.lockedSrc == "") this.lockedSrc = this.src;
	if (this.mouseOverSrc == "") this.mouseOverSrc = this.src;
    if (this.mouseOverLockedSrc == "") this.mouseOverLockedSrc = this.src;

	if (!this.confirmAnswer) this.lockAfterGivenAnswer = false;
};

componentButtonWithText.prototype.onPaint = function()
{
	if (this.execution) {
		document.getElementById(this.id + "_contentObj").style.cursor = this.cursor;
		document.getElementById(this.id + "_textContentObj").style.cursor = this.cursor;
		this.setValue(this.resourcesURL, this.src);
	} else {
		this.text.cursor = this.cursor;
		this.image.cursor = this.cursor;

		this.image.w = this.w;
		this.image.h = this.h;

		this.text.x = this.padding;
		this.text.y = this.padding;
		this.text.w = this.w;
		this.text.h = this.h;
	};
};

componentButtonWithText.prototype.componentButtonWithTextBaseSetSizeScaledElement = componentButtonWithText.prototype.setSizeScaledElement;
componentButtonWithText.prototype.setSizeScaledElement = function(x, y, w, h)
{
	if (this.execution) {
		document.getElementById(this.id + "_imageDIV").style.width = w;	
		document.getElementById(this.id + "_imageDIV").style.height = h;	
		document.getElementById(this.id + "_imageDIV").style.clip = 'rect(0px '+w+'px '+h+'px 0px)';	
		document.getElementById(this.id + "_textDIV").style.width = w;	
		document.getElementById(this.id + "_textDIV").style.height = h;	
		document.getElementById(this.id + "_textDIV").style.clip = 'rect(0px '+w+'px '+h+'px 0px)';				
	} else {
		this.image.w = w;
		this.image.h = h;
		this.text.w = w;
		this.text.h = h;
	};
	this.componentButtonWithTextBaseSetSizeScaledElement(x, y, w, h);
};

componentButtonWithText.prototype.isReady = function()
{
	if (!this.displayImage) return true;
	if (this.execution) {
		var isLoaded = false
		for (var i=0; i < this.imagesNameArr.length; i++){
			isLoaded = preloadImage(this, "_"+i);
			if (!isLoaded) return false;
		};
		this.isLoaded = isLoaded;
		return this.isLoaded;
	} else {
		return (this.image.isReady());
	};
};

componentButtonWithText.prototype.componentButtonWithTextBaseLock = componentButtonWithText.prototype.lock;
componentButtonWithText.prototype.lock = function()
{
	this.setCursor("default");
	if (this.displayImage) {
		if (this.execution) {
			document.getElementById(this.id + "_contentObj").style.cursor = "default";
			this.setValue(this.resourcesURL, this.src);
		} else {
			this.image.setCursor("default");
			this.image.src = this.lockedSrc;
			this.image.paint();
		};
	};
	if (this.displayText) {
		if (this.execution) {
			document.getElementById(this.id + "_textContentObj").style.cursor = "default";
		} else {
			this.text.setCursor("default");
		};	
	};
	this.componentButtonWithTextBaseLock();
	this.eventMouseOut();	
};

componentButtonWithText.prototype.componentButtonWithTextBaseUnLock = componentButtonWithText.prototype.unlock;
componentButtonWithText.prototype.unlock = function()
{
	this.setCursor(this.orgCursor);
	if (this.displayImage) {
		if (this.execution){
			document.getElementById(this.id + "_contentObj").style.cursor = this.orgCursor;
			this.setValue(this.resourcesURL, this.src);
		} else {
			this.image.setCursor(this.orgCursor);
			this.image.src = this.src;
			this.image.paint();
		};
	};
	if (this.displayText) {
		if (this.execution){
			document.getElementById(this.id + "_textContentObj").style.cursor = this.orgCursor;
		} else {	
			this.text.setCursor(this.orgCursor);
		};
	};
	this.componentButtonWithTextBaseUnLock();
};

componentButtonWithText.prototype.componentButtonWithTextBaseEventClick = componentButtonWithText.prototype.eventClick;
componentButtonWithText.prototype.eventClick = function(e)
{
	if (this.locked) return false;
	var pageType = PageInterface.GetValue("pageType");
	if (this.confirmAnswer &&  (pageType == "Exercise" || pageType == "Poll")) {
		PageInterface.Execute("checkAnswer", this);
		return true;
	} else {
		return this.componentButtonWithTextBaseEventClick(e);
	};
};

componentButtonWithText.prototype.componentButtonWithTextBaseEventMouseDown = componentButtonWithText.prototype.eventMouseDown;
componentButtonWithText.prototype.eventMouseDown = function(e)
{
	if (this.locked) return false;
	if (this.displayImage) {
		if (this.clickSrc) this.setValue(this.resourcesURL, this.clickSrc);
		else this.setValue(this.resourcesURL, this.standardSrc);
	};
};

componentButtonWithText.prototype.componentButtonWithTextBaseEventMouseUp = componentButtonWithText.prototype.eventMouseUp;
componentButtonWithText.prototype.eventMouseUp = function(e)
{
	if (this.displayImage) {
		if (this.locked) this.setValue(this.resourcesURL, this.mouseOverLockedSrc);
		else this.eventMouseOver();
	};
	return this.componentButtonWithTextBaseEventMouseUp(e);
};

componentButtonWithText.prototype.componentButtonWithTextEventMouseOver = componentButtonWithText.prototype.eventMouseOver;
componentButtonWithText.prototype.eventMouseOver = function(e)
{
	if (this.locked){
		if (this.displayImage) {
			if (this.mouseOverLockedSrc) this.setValue(this.resourcesURL, this.mouseOverLockedSrc);
			else this.setValue(this.resourcesURL, this.standardSrc);
		};	
	} else {
		if (this.displayImage) {
			if (this.mouseOverSrc) this.setValue(this.resourcesURL, this.mouseOverSrc);
			else this.setValue(this.resourcesURL, this.standardSrc);
		};
	};
	return this.componentButtonWithTextEventMouseOver(e);
};

componentButtonWithText.prototype.componentButtonWithTextEventMouseOut = componentButtonWithText.prototype.eventMouseOut;
componentButtonWithText.prototype.eventMouseOut = function(e)
{
	if (this.displayImage) {
		if (this.locked) this.setValue(this.resourcesURL, this.lockedSrc);
		else this.setValue(this.resourcesURL, this.src);
	};
	return this.componentButtonWithTextEventMouseOut(e);
};

componentButtonWithText.prototype.setValue = function(path, fileName)
{
	if (typeof(path) == "undefined" && path == null) return false;
	this.contentObj = this.findContentObj();
	if (this.contentObj) {
		this.setImageSrc(path + fileName);
		return true;
	} else {
		this.image.src = fileName;
		this.image.paint();
	};
	return false;
};
