﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
componentChoice = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.resourcesStatus = "online";
	this.resourcesURL = "";
	this.setAnswerFromPage = "";
	this.correctAnswersList = "";
	this.displayIndexes = new Array();
	this.indexAnswers = new Array();
	this.optCount = 0;

	this.interactions = true;
	this.interactionsType = "choice";
	this.interactionsStudentScore = 0;
	this.lockedFields = 0;
	this.visibleCAI = false; //pg2-giub_cai
	this.confirmedAns = -1; //pg2-giub_cai2 -confirmed answers (instead of array 0101010...); if -1 -page after load is blocked, component as well, no new elements will be added to this 'array'
};

componentChoice.prototype = new componentElement;
componentChoice.prototype.type = "componentChoice";

componentChoice.prototype.onBaseCreate = function(obj)
{
    this.captureMouseEvents();
};

componentChoice.prototype.onCreate = function(obj)
{
	if (!this.imgCheckedArrow) this.imgCheckedArrow = this.imgChecked;
	if (!this.imgNotCheckedArrow) this.imgNotCheckedArrow = this.imgNotChecked;
	if (!this.imgCheckedIncorrectSrc) this.imgCheckedIncorrectSrc = this.imgChecked;
	if (!this.imgNotCheckedIncorrectSrc) this.imgNotCheckedIncorrectSrc = this.imgNotChecked;

	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};

	this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [ this.imgChecked, this.imgNotChecked, this.imgCheckedArrow, this.imgNotCheckedArrow, this.imgCheckedIncorrectSrc, this.imgNotCheckedIncorrectSrc ];
	this.getPreloadImagesArr();
    this.correctAnswersList = this.correctAnswer;
};

componentChoice.prototype.onAfterLoad = function()
{
	if (PageInterface.GetValue("state") != psDesigning) {
		if ((page.isExec && PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) ||
			(this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt && page.countAnswers != page.baseTryCount)) //pg2-giub_cai
		{
			this.showCAI();
		};
	};
};

componentChoice.prototype.onPaint = function(obj)
{
	var changed = unquotedString(this.choiceValues);
	var prevAnswer = this.getAnswer(); //pg2

	var arrOpt = changed.split("||");
	var arrLength = arrOpt.length;

	this.optCount = arrLength;

	var font = getProjectFont(this.allowGF == 1, this.fontFamily, this.fontSize, this.fontColor );

	var indexes = "";
	var j;
	var brk = "";
	var width = this.w - this.borderWidth * 2;
	var height = this.h - this.borderWidth * 2;
	var colgrB = '<colgroup>';
	var colgrE = '</colgroup>';
	var colW = '<col width="' + this.imageWidth + '"><col width="' + eval(this.w - this.imageWidth) + '">';
	var tableW = 'width:' + width + 'px;';
	var tableH = 'height:' + height + 'px;';
	var trB = '<tr>';
	var trE = '</tr>';

	if (this.elementsAlign == 'horizontally') {
		colW = '<col width="' + this.imageWidth + '"><col width="' + eval(this.colsWidth - this.imageWidth) + '">';
		tableW = '';
		tableH = '';
		trB = '';
		trE = '';
	};
	var t = '<table border="0" style="' + tableW + ' ' + tableH + ' " id="choice_tab_' + this.id + '" >';
	t += colgrB
	if (this.elementsAlign == 'horizontally') {
		for (var i = 0; i < arrLength; i++) {
			indexes += brk + i.toString();
			brk = "||";
			t += colW;
		};
	} else {
		for (var i = 0; i < arrLength; i++) {
			indexes += brk + i.toString();
			brk = "||";
		};
		t += colW;
	};
	t += colgrE;

	this.indexAnswers = "";
	var tempArr = indexes.split("||");
	brk = "";

	var setAnsArray = this.setAnswerFromPage.split("||");
	var imageSrc = "";

	if (page.state == psDesigning) {
		var correctAnswerTmp = this.changeFromInt(this.correctAnswer).split("");
		for (var i = 0; i < arrLength; i++) {
			//pg2-rub
			var opt = arrOpt[i];

			if (!this.useHTML_tags) { //pg2-MBR, AF
				while (opt.indexOf('<') > -1) opt = opt.replace('<', '&lt;');
				while (opt.indexOf('>') > -1) opt = opt.replace('>', '&gt;');
			};

			/*while (opt.indexOf('&lt;br&gt;') > -1) opt = opt.replace('&lt;br&gt;', '<br>'); //pg2-MBR
			while (opt.indexOf('&lt;BR&gt;') > -1) opt = opt.replace('&lt;BR&gt;', '<BR>');
			while (opt.indexOf('&lt;br/&gt;') > -1) opt = opt.replace('&lt;br/&gt;', '<br/>');
			while (opt.indexOf('&lt;BR/&gt;') > -1) opt = opt.replace('&lt;BR/&gt;', '<BR/>');
			
			while (opt.indexOf('&lt;i&gt;') > -1) opt = opt.replace('&lt;i&gt;', '<i>'); //pg2-AF
			while (opt.indexOf('&lt;I&gt;') > -1) opt = opt.replace('&lt;I&gt;', '<I>');
			while (opt.indexOf('&lt;/i&gt;') > -1) opt = opt.replace('&lt;/i&gt;', '</i>');
			while (opt.indexOf('&lt;/I&gt;') > -1) opt = opt.replace('&lt;/I&gt;', '</I>');*/
			//

			t += trB + '<td style="width: ' + this.imageWidth + ' px;"><img src="' + this.resourcesURL +
			((correctAnswerTmp[eval(arrLength - 1 - i)].toString() == '1') ? (this.imgChecked) : (this.imgNotChecked)) +
			'" id="' +
			this.id +
			'_img_' +
			i.toString() +
			'"></td><td style="color:' +
			font.color +
			'; font-family:' +
			font.family +
			'; font-size:' +
			getFontSize(font.size, "px") +
			'px;" align="left">' +
			opt + //arrOpt[i] + //pg2-rub
			'</td>' +
			trE;
		};
	} else
	if (this.randAns) {
		for (var i = 0; i < arrLength; i++) {
			j = Math.round(Math.random() * (arrOpt.length - 1));
			imageSrc = this.imgNotChecked;
			if (this.findInArray(tempArr[j], setAnsArray)) {
				imageSrc = this.imgChecked;
			};

			t += trB + '<td style="width: ' + this.imageWidth + 'px; cursor: pointer;" ';
			t += ' onclick="pc.' + this.id + '.multipleChoiceChangeImg(document.getElementById(\''+ this.id + '_img_' + tempArr[j].toString() +'\'), ' + tempArr[j] + ', ' + i + '); "';
			t += '>';
			t += '<img src="' + this.resourcesURL + imageSrc + '" id="' + this.id + '_img_' + tempArr[j].toString() + '"></td>';
			t += '<td style="color:' + font.color + '; font-family:' + font.family + '; font-size:' + getFontSize(font.size, "px") + 'px;"';
			if (this.imageClick == 0) t += ' onclick="pc.' + this.id + '.setImage(this, ' + tempArr[j] + ', ' + i + ');"';

			//pg2-rub
			var opt = arrOpt[j];
			if (!this.useHTML_tags) { //pg2-MBR, AF
				while (opt.indexOf('<') > -1) opt = opt.replace('<', '&lt;');
				while (opt.indexOf('>') > -1) opt = opt.replace('>', '&gt;');
			};

			/*while (opt.indexOf('&lt;br&gt;') > -1) opt = opt.replace('&lt;br&gt;', '<br>'); //pg2-MBR
			while (opt.indexOf('&lt;BR&gt;') > -1) opt = opt.replace('&lt;BR&gt;', '<BR>');
			while (opt.indexOf('&lt;br/&gt;') > -1) opt = opt.replace('&lt;br/&gt;', '<br/>');
			while (opt.indexOf('&lt;BR/&gt;') > -1) opt = opt.replace('&lt;BR/&gt;', '<BR/>');
			
			while (opt.indexOf('&lt;i&gt;') > -1) opt = opt.replace('&lt;i&gt;', '<i>'); //pg2-AF
			while (opt.indexOf('&lt;I&gt;') > -1) opt = opt.replace('&lt;I&gt;', '<I>');
			while (opt.indexOf('&lt;/i&gt;') > -1) opt = opt.replace('&lt;/i&gt;', '</i>');
			while (opt.indexOf('&lt;/I&gt;') > -1) opt = opt.replace('&lt;/I&gt;', '</I>');*/
			//
			t += ' id="' + this.id + '_text_' + tempArr[j].toString() + '" align="left">' + opt /*arrOpt[j]*/ + '</td>' + trE; //pg2-rub

			this.indexAnswers += brk + tempArr[j];
			this.displayIndexes['opt' + i] = new Array();
			this.displayIndexes['opt' + i][1] = tempArr[j];
			this.displayIndexes['opt' + i][0] = 0;
			brk = "||";
			arrOpt.splice(j, 1);
			tempArr.splice(j, 1);
		};
	} else {
		for (var i = 0; i < arrLength; i++) {
			imageSrc = this.imgNotChecked;
			if (this.findInArray(i, setAnsArray)) 
				imageSrc = this.imgChecked;
			t += trB + '<td style="width: ' + this.imageWidth + 'px; cursor: pointer;"';
			t += ' onclick="pc.' + this.id + '.multipleChoiceChangeImg(document.getElementById(\''+ this.id + '_img_' + i +'\'), ' + i + ', ' + i + ');"';
			t += ' >';
			t += '<img src="' + this.resourcesURL + imageSrc + '" id="' + this.id + '_img_' + i.toString() + '" ></td>';
			t += '<td style="color:' + font.color + '; font-family:' + font.family + '; font-size:' + getFontSize(font.size, "px") + 'px;"';
			if (this.imageClick == 0) t += ' onclick="pc.' + this.id + '.setImage(this, ' + i + ', ' + i + ');"';

			//pg2-rub
			var opt = arrOpt[i];
			if (!this.useHTML_tags) { //pg2-MBR, AF
				while (opt.indexOf('<') > -1) opt = opt.replace('<', '&lt;');
				while (opt.indexOf('>') > -1) opt = opt.replace('>', '&gt;');
			};

			/*while (opt.indexOf('&lt;br&gt;') > -1) opt = opt.replace('&lt;br&gt;', '<br>'); //pg2-MBR
			while (opt.indexOf('&lt;BR&gt;') > -1) opt = opt.replace('&lt;BR&gt;', '<BR>');
			while (opt.indexOf('&lt;br/&gt;') > -1) opt = opt.replace('&lt;br/&gt;', '<br/>');
			while (opt.indexOf('&lt;BR/&gt;') > -1) opt = opt.replace('&lt;BR/&gt;', '<BR/>');
			
			while (opt.indexOf('&lt;i&gt;') > -1) opt = opt.replace('&lt;i&gt;', '<i>'); //pg2-AF
			while (opt.indexOf('&lt;I&gt;') > -1) opt = opt.replace('&lt;I&gt;', '<I>');
			while (opt.indexOf('&lt;/i&gt;') > -1) opt = opt.replace('&lt;/i&gt;', '</i>');
			while (opt.indexOf('&lt;/I&gt;') > -1) opt = opt.replace('&lt;/I&gt;', '</I>');*/
			//
			t += ' id="' + this.id + '_text_' + i.toString() + '" align="left">' + opt /*arrOpt[i]*/ + '</td>' + trE; //pg2-rub

			this.indexAnswers = indexes;
			this.displayIndexes['opt' + i] = new Array();
			this.displayIndexes['opt' + i][1] = i;
			this.displayIndexes['opt' + i][0] = 0;
		};
	};

	t += '</table>';
	this.setHTML(t);
	//this.setAnswer(prevAnswer, false); //pg2
};

componentChoice.prototype.clickOptionChangeGIUB = function(optNo) //pg2-giub_cai2
{
	page.hideFeedbacks();

	var cAns = this.confirmedAns;
	if (cAns == -1) cAns = 0;
	var arrCAns = this.changeFromInt(cAns).split('').reverse();

	var correctAnswer = this.changeFromInt(this.correctAnswer).split("").reverse();
	var checked = false;
	var correct = false;

	j = 0;
	while (this.displayIndexes['opt' + j][1] != optNo.toString() && j < this.optCount) j++;

	obj = document.getElementById(this.id + "_img_" + optNo.toString());
	if (obj) {
		if (this.displayIndexes['opt' + j][0].toString() == '1') checked = true; else checked = false;
		if (correctAnswer[eval(optNo)].toString() == '1') correct = true; else correct = false; //
		var prevChecked = (arrCAns[optNo] == '1'); //checked now, or- previously even though now is unchecked

		var src = '';
		if (prevChecked) { // && this.confirmedAns != -1) {
			if (!checked && !correct) src = this.imgNotCheckedIncorrectSrc; else
			if (!checked && correct) {
				//this.displayIndexes['opt' + optNo][0] = 1; //check it again- do not allow to uncheck it //TEST
				if (this.randAns) {
					this.displayIndexes['opt' + j][0] = 1;
				} else {
					this.displayIndexes['opt' + optNo][0] = 1;
				};
				src = this.imgCheckedArrow;
			} else
			if (checked && !correct) src = this.imgCheckedIncorrectSrc; else
			if (checked && correct) src = this.imgCheckedArrow;
		} else {
			if (checked) src = this.imgChecked; else src = this.imgNotChecked;
		};
		if (src != '') this.setImageSrc(this.resourcesURL + src, obj);
	};
	delete arrCAns;
};

componentChoice.prototype.showCAI = function(obj)
{
	var correctAnswer = this.changeFromInt(this.correctAnswer).split("");
	var checked = false;
	var correct = false;
	var j = 0;
	if (!this.showCAIOnEachAttempt && !PageInterface.GetValue("allowCAI")) return; //pg2-giub_cai2 -do not check it within loop for each option; here it will be faster

	//this.confirmedAns, this.correctAnswer
	if (this.showCAIOnEachAttempt) {
		var cAns = this.confirmedAns;
		if (this.confirmedAns == -1) return; //pg2-giub_cai3 -after navigation out of the page (after checking answer+showCAI) and returning back, no CAI will be show- there is no info about previously selected and later unchecked options
		if (cAns == -1) cAns = 0;
		var arrCAns = this.changeFromInt(cAns).split('').reverse();
	};

	var result = false; //pg2-giub_cai_infinity
	if (this.showCAIOnEachAttempt) result = this.parseCheckAnswer(this);
	var src = '';

	for (var i = 0; i < this.optCount; i++) {
		obj = document.getElementById(this.id + "_img_" + i.toString());
		if (obj) {
			j = 0;
			while (this.displayIndexes['opt' + j][1] != i.toString() && j < this.optCount) j++;

			if (this.displayIndexes['opt' + j][0].toString() == '1') checked = true; else checked = false;
			if (correctAnswer[eval(this.optCount - 1 - i)].toString() == '1') correct = true; else correct = false;

			if (this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt && !this.locked && (page.countAnswers > 0 || (page.baseTryCount == 0 && !result))) { // && this.confirmedAns != -1) { //pg2-giub_cai //pg2-giub_cai_infinity
				if (this.randAns) {
					var prevChecked = (arrCAns[i] == '1');
				} else {
					var prevChecked = (arrCAns[j] == '1'); //(arrCAns[j] == '1'); //checked now, or- previously even though now is unchecked
				};
				//000,001,010,011,100,101,110,111
				src = '';
				if (!checked && !prevChecked && !correct) ; else
				if (!checked && !prevChecked && correct) ; else
				if (!checked && prevChecked && !correct) src = this.imgNotCheckedIncorrectSrc; else
				if (!checked && prevChecked && correct)  src = this.imgNotCheckedArrow; else
				if (checked && !prevChecked && !correct) src = this.imgCheckedIncorrectSrc; else
				if (checked && !prevChecked && correct)  src = this.imgCheckedArrow; else
				if (checked && prevChecked && !correct)  src = this.imgCheckedIncorrectSrc; else
				if (checked && prevChecked && correct)   src = this.imgCheckedArrow;

				if (src != '') this.setImageSrc(this.resourcesURL + src, obj);
			} else {
			//if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) { //pg2-giub_cai2 -if disabled on each attempt, do not show on each attempt -this condition was missing
				if (this.overwriteCAIInLastTry && this.showCAIOnEachAttempt) { //pg2-giub_cai3
					src = '';
					if (checked && correct) src = this.imgCheckedArrow; else
					if (!checked && correct) src = this.imgNotCheckedArrow; else
					if (checked && !correct) src = this.imgCheckedIncorrectSrc; else
					if (!checked && !correct) src = this.imgNotCheckedIncorrectSrc;
					
					if (src != '') this.setImageSrc(this.resourcesURL + src, obj);
				} else { //pg2-old one, standard
					src = '';
					if (checked && correct) src = this.imgCheckedArrow; else
					if (!checked && correct) src = this.imgNotCheckedIncorrectSrc; else
					if (!checked && !correct) src = this.imgNotCheckedArrow; else
					if (checked && !correct) src = this.imgCheckedIncorrectSrc;

					if (src != '') this.setImageSrc(this.resourcesURL + src, obj);
				};
			};
		};
	};

	if (typeof(arrCAns) != 'undefined') delete arrCAns; //pg2-giub_cai
	this.visibleCAI = true; //pg2-giub_cai
};

componentChoice.prototype.onRepaint = function(obj)
{
	if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) {
		this.showCAI();
	};
};

componentChoice.prototype.findInArray = function(item, itemArray)
{
	for (var k = 0; k < itemArray.length; k++) {
		if (itemArray[k].toString() == item.toString()) return true;
	};
	return false;
};

componentChoice.prototype.isInArray = function(array, value)
{
	for (var i = 0; i < array.length; i++) {
		if (array[i].toString() == value.toString()) return true;
	};
	return false;
};

componentChoice.prototype.getUserCorrCheckedAndCorrCount = function(obj)
{
	var corrAns = this.changeFromInt(obj.correctAnswer).split('');
	var userAns = this.getBinAnswer().split('');
	var userAnsCorrCount = 0;

	for (var i = 0; i < corrAns.length; i++) {
		if (corrAns[i] == userAns[i]) { 
			userAnsCorrCount++;
		};
	};
	return [userAnsCorrCount, corrAns.length];
};

componentChoice.prototype.parseCheckAnswer = function(obj)
{
	if (!obj) return (false);

	if (this.useCheckboxesSeparately) {
		var arr = this.getUserCorrCheckedAndCorrCount(obj);
		this.changeValuesInUELO(arr[0], arr[1]);
		return ((arr[0] / arr[1]) * 100) >= this.passLevel;
	} else {
		if (obj.getAnswer().toString() == obj.correctAnswer) return true;
		else return false;
	};
};

componentChoice.prototype.changeValuesInUELO = function(usrScore, maxScore)
{
	var UELO = page.getUELO();
	if (UELO) {
		var pGI = PageInterface.GetValue("pageGix");
		var iterPage = UELO.FindPage(pGI);
		var inter = null;
		if (iterPage) {
			for (var i = 0; i < iterPage.interactions.length; i++) {
				inter = iterPage.interactions[i];
				if (inter.elementId == this.id) {
					inter.maxScore = maxScore;
					break;
				};
			};
		};
		this.interactionsStudentScore = usrScore;
	};
};

componentChoice.prototype.checkAnswer = function()
{
	var result = this.parseCheckAnswer(this);
	var ans = this.getAnswer();
	if (typeof(ans) == 'string') ans = parseInt(ans);
	//alert(ans + ' : ' + typeof(ans));
	if (this.confirmedAns == -1) this.confirmedAns = ans; else this.confirmedAns = this.confirmedAns | ans;
	//alert(this.changeFromInt(this.confirmedAns));
	//alert(this.correctAnswer + ' : ' + typeof(this.correctAnswer));

	if (this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt) { // && page.countAnswers > 0) { //pg2-giub_cai
		this.showCAI();
	};

	return result;
};

componentChoice.prototype.getBinAnswer = function()
{
	valStr = "";
	var j = 0;
	for (var i = 0; i < this.optCount; i++) {
		j = 0;
		while (this.displayIndexes['opt' + j][1] != i.toString() && j < this.optCount) j++;
		valStr = this.displayIndexes['opt' + j][0] + valStr;
	};
	return valStr;
};

componentChoice.prototype.getAnswer = function()
{
	if (this.ignoreAnswer) return "";

	valStr = this.getBinAnswer();
	valStr = valStr.split("").join("||");
	valStr = this.changeToInt(valStr);

	return (valStr);
};

componentChoice.prototype.setAnswer = function(valStr, showCorrect)
{
	if (showCorrect == null || showCorrect == "undefined") showCorrect = true;
	//if ((valStr == "" || valStr == null || typeof(valStr) == "undefined" || valStr == "null") && !showCorrect) return (valStr); //pg2- replaced with the code below
	if (valStr == "" || valStr == null || typeof(valStr) == "undefined" || valStr == "null") { //pg2
		valStr = "0";
		this.visibleCAI = false; //pg2-giub_cai
		this.confirmedAns = -1;
	};

	var obj = null;
	var arrValStr = this.changeFromInt(valStr).split("");
	var correct = this.changeFromInt(this.correctAnswer).split("");

	var checked = false;

	if (showCorrect) {
		arrValStr = correct;
	};

	var j = 0;

	for (var i = 0; i < this.optCount; i++) {
		j = 0;
		while (this.displayIndexes['opt' + j][1] != i.toString() && j < this.optCount - 1) j++;
		obj = document.getElementById(this.id + "_img_" + i);
		if (obj) {
			if (arrValStr[ eval(this.optCount-1-i) ].toString() == '1') {
				checked = true;
				this.displayIndexes['opt' + j][0] = 1;
			} else {
				checked = false;
				this.displayIndexes['opt' + j][0] = 0;
			};
			this.setImageSrc(this.resourcesURL + (checked ? this.imgChecked : this.imgNotChecked), obj);
		};
	};

	this.onRepaint();
	return (valStr);
};

componentChoice.prototype.setBinAnswer = function(valStr) //pg2
{
	if (typeof(valStr) == 'undefined') return;

	while (valStr.length < this.optCount) {
		valStr = '0' + valStr;
	};

	if (this.optCount < valStr.length) {
		valStr = valStr.substring(valStr.length-this.optCount);
	};

	var arrValStr = valStr.split('');
	var j = 0;
	for (var i = 0; i < this.optCount; i++) {
		j = 0;
		while (this.displayIndexes['opt' + j][1] != i.toString() && j < this.optCount - 1) j++;
		obj = document.getElementById(this.id + "_img_" + i);
		if (obj) {
			if (arrValStr[ eval(this.optCount-1-i) ].toString() == '1') {
				checked = true;
				this.displayIndexes['opt' + j][0] = 1;
			} else {
				checked = false;
				this.displayIndexes['opt' + j][0] = 0;
			};
			this.setImageSrc(this.resourcesURL + (checked ? this.imgChecked : this.imgNotChecked), obj);
		};
	};

	this.onRepaint();
	return (valStr);
};

componentChoice.prototype.changeToInt = function(str)
{
	var bin = str.split("||");
	if (bin.length == 1 && str.length > 1 && str.indexOf('||') == -1) { //pg2-if the string was delivered without any separators, simply as '0101'...
		delete bin;
		bin = str.split('');
	};
	var dec = 0;
	var tempPow = 0;

	for (var i = bin.length - 1; i > -1; i--) {
		if (bin[i] != '0' && bin[i] != '1') { //pg2-if there was given for example '0105', itsn't binary
			delete bin;
			return -1;
		};
		tempPow = bin[i] * Math.pow(2, bin.length - 1 - i);
		dec += tempPow;
	};
	delete bin; //pg2-cleaning up
	return dec;
};

componentChoice.prototype.changeFromInt = function(str)
{
	if (isNaN(str) || str == null || typeof(str) == "undefined" || str == "null" || str == "") return "";
	if (str == -1 || str == '-1') return ''; //pg2- in case of -1, here would be an "neverending loop"
	var arrTemp = "", brk = "";

	var dec = parseInt(str);
	var oct = "";

	while (dec != 0) {
		oct = (dec % 2) + oct;
		dec = Math.floor(dec / 2);
	};
	while (oct.length < this.optCount) {
		oct = 0 + oct;
	};
	return oct;
};

componentChoice.prototype.lock = function()
{
	this.locked = true;
};

componentChoice.prototype.unlock = function()
{
	this.locked = false;
};

componentChoice.prototype.checkIsChanged = function()
{
	return this.isChanged;
};

componentChoice.prototype.setImage = function(obj, checkId, checkNo)
{
	if (this.locked) return false;
	var objImg = null;
	var name = obj.id.replace("_text_", "_img_");

	objImg = document.getElementById(name);
	if (objImg) this.multipleChoiceChangeImg(objImg, checkId, checkNo);
};

componentChoice.prototype.multipleChoiceChangeImg = function(obj, checkId, checkNo)
{
	if (this.locked) return false;
	if ((this.lockedFields & (1 << checkId)) != 0) return false;
	this.isChanged = true;
	//obj.src.match(this.imgChecked); //pg2-comment -to jest do d..., trzeba bedzie zmienic
	var isCheckedImg = this.displayIndexes['opt' + checkNo][0] == 1; //pg2-giub_cai3 -"obj.src.match(this.imgChecked)" bylo do d...
	
	if (!isCheckedImg) {
		if (this.toggleName != "") {
			var s = this.toggleName;
			s = s.replace("%answer_num%", (checkId + 1));
			var o = pc[s];
			if (o) o.show();
		};
		this.displayIndexes['opt' + checkNo][0] = 1;
		if (this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt && (page.countAnswers > 0 || page.baseTryCount == 0) && this.visibleCAI) { //pg2-giub_cai3
			this.clickOptionChangeGIUB(checkId); //pg2-giub_cai3
		} else {
			this.setImageSrc(this.resourcesURL + this.imgChecked, obj);
		};
		this.invokeEvent("Marked");
	} else {
		if (this.toggleName != "") {
			var s = this.toggleName;
			s = s.replace("%answer_num%", (checkId + 1));
			var o = pc[s];
			if (o) o.hide();
		};
		this.displayIndexes['opt' + checkNo][0] = 0;
		if (this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt && (page.countAnswers > 0 || page.baseTryCount == 0) && this.visibleCAI) { //pg2-giub_cai3
			this.clickOptionChangeGIUB(checkId); //pg2-giub_cai3
		} else {
			this.setImageSrc(this.resourcesURL + this.imgNotChecked, obj);
		};
		for (var i=0; i < this.optCount; i++) {
			if (this.displayIndexes['opt'+i][0] == 1) return;
		};
		this.invokeEvent("UnMarked");
	};
};

componentChoice.prototype.interactionsCorrectResponsesCount = function()
{
	var answerCount = 1;
	return answerCount;
};

componentChoice.prototype.interactionsCorrectResponses = function()
{
	return this.correctAnswersList;
};

componentChoice.prototype.interactionsStudentResponse = function()
{
	if (this.useCheckboxesSeparately) {
		var arr = this.getUserCorrCheckedAndCorrCount(this);
		return (arr[0] / arr[1]) * 100;
	};
	return this.getAnswer();
};

componentChoice.prototype.interactionsCorrectResponsesAsText = function(index)
{
	if (typeof(this.answerValuesString) != "undefined" && this.answerValuesString != "") {
		var ansArr = this.answerValuesString.split("||");
		var corArr = this.changeFromInt(this.correctAnswer).split("");
		var ans = "";
		var len = corArr.length;
		for (var i = 0; i < len; i++) {
			if (corArr[len-1-i] == 1) {
				if (ans != "") ans += " ";
				ans += escape(ansArr[i]);
			};
		};
		if (typeof(ans) != "undefined" && ans != "") {
			return ans;
		} else {
			return this.interactionsCorrectResponses(index);
		};
	} else {
		return this.interactionsCorrectResponses(index);
	};
};

componentChoice.prototype.interactionsStudentResponseAsText = function()
{
    if (this.useCheckboxesSeparately) {
		var arr = this.getUserCorrCheckedAndCorrCount(this);
		return (arr[0] / arr[1]) * 100 + '%';
	};
	if (typeof(this.answerValuesString) != "undefined" && this.answerValuesString != "") {
        var ans = "";
		var ansArr = this.answerValuesString.split("||");
		var u_ans = this.interactionsStudentResponse();
		if (u_ans == "" || u_ans == "0") return ans;
		//var corArr = this.changeFromInt(this.interactionsStudentResponse()); //.split(''); //pg2-split('') -in ie reference to string as to an array is incorrect, so convert it to array
		var corArr = this.getBinAnswer(); //pg2- after Math.pow(2, 53) there is end of range...
		var len = corArr.length;
		for (var i = 0; i < len; i++) {
            if (corArr.charAt(len-1-i) == '1') { //pg2-added '.charAt' and '1' instead of 1 - in IE reference to chars as to array element is incorrect
				if (ans != "") ans += " ";
				ans += escape(ansArr[i]);
			};
		};
		//alert(ans); //pg2-test
		if (typeof(ans) != "undefined" && ans != "") {
			return ans;
		} else {
			return this.interactionsStudentResponse();
		};
	} else {
		return this.interactionsStudentResponse();
	};
};
