﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentPopup = function(name)
{
	this.componentText = componentText;
	this.componentText(name);

	if (arguments[1]) {
	} else {
		this.text = this.addChild(new componentText(null)); 
		this.button = this.addChild(new componentButton(null));
		this.popupTitle = this.addChild(new __componentText(null));
		this.buttonCross = this.addChild(new componentButton(null));
		this.popupTitle.allowGF = false;
	};

	this.buttonVisible = true;
	//this.buttonCrossVisible = true;
	this.preloadImages = null;
	this._scrollable = false;
	this._vertScrollbars = false;
	this.imagesCompleteInfo = new Array();
	this.popupTitleAlign = "top";
	this.reformatTimer = null;
};

componentPopup.prototype = new componentText();
componentPopup.prototype.type = "componentPopup";

componentPopup.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
		this.resourcesURL = unescape(this.resourcesURL);

		this.imagesNameArr = [	this.leftTop, this.centerTop, this.rightTop, this.topMiddle, this.centerMiddle, this.bottomMiddle, this.leftBottom, this.centerBottom, this.centerMiddle, this.bottomMiddle, this.rightBottom, this.buttonSrc, this.buttonMouseOverSrc, this.buttonCrossSrc, this.buttonCrossSrcOver, this.buttonCrossMouseOverSrc, this.buttonSrc, this.buttonMouseOverSrc ];
		this.getPreloadImagesArr();
	};
	if (!this.popupTitleVisible) this.buttonCrossVisible = false;
	this.setCompleteArrayInfo(this.completeInfoStyleImages);
	this.captureMouseEvents();
};

componentPopup.prototype.componentPopupShow = componentPopup.prototype.show;
componentPopup.prototype.show = function(obj)
{
	this.componentPopupShow();
	if (this.canDragging) {
		if (PageInterface.GetValue("state") != psDesigning) PageInterface.Execute("setOnTop", this);
	};
};

componentPopup.prototype.componentPopupBaseHide = componentPopup.prototype.hide; //pg2
componentPopup.prototype.hide = function()
{
	this.componentPopupBaseHide();
	if (this.reformatTimer != null) window.clearTimeout(this.reformatTimer);
	this.reformatTimer = null;
};

componentPopup.prototype.onCreate = function(obj)
{
	if (this.execution) {
		if (this.isNewPopup){
			this.setNewPopupImages();
		} else {
			var objb = null;
			var objbc = null;
			var objtc = null;
			objb = document.getElementById(this.id + "_buttonDIV_contentObj");
			objbc = document.getElementById(this.id + "_buttonCrossDIV_contentObj");
			objtc = document.getElementById(this.id + "_textDIV");

			if (objb) this.setImageSrc(this.resourcesURL + this.buttonSrc, objb);
			if (objbc) this.setImageSrc(this.resourcesURL + this.buttonCrossSrc, objbc);

			if (this._scrollable) {
				objtc.owner = null;
				if (this._vertScrollbars) {
					objtc.style.cssText += '; overflow-x: hidden; overflow-y: auto;';
				} else {
					objtc.style.cssText += '; overflow-x: auto; overflow-y: auto;';
				};
			};
		};
	} else {
		this.text.p_checkMarkers = this.p_checkMarkers;
		this.text.p_checkPNG = this.p_checkPNG;
		this.text.pngFix = this.pngFix;

		this.button.p_checkMarkers = this.p_checkMarkers;
		this.button.p_checkPNG = this.p_checkPNG;
		this.button.pngFix = this.pngFix;

		this.popupTitle.p_checkMarkers = this.p_checkMarkers;
		this.popupTitle.p_checkPNG = this.p_checkPNG;
		this.popupTitle.pngFix = this.pngFix;

		this.buttonCross.p_checkMarkers = this.p_checkMarkers;
		this.buttonCross.p_checkPNG = this.p_checkPNG;
		this.buttonCross.pngFix = this.pngFix;

		this.popupTitle.captureMouseEvents();
		if (this.text.scrollable) {
			this.text.stopPropagation = true;
		};

		if (this.popupTitleVisible) {
			this.buttonCross.captureMouseEvents();
			this.buttonCross.stopPropagation = true;
			this.buttonCross.onMouseDown = function(e) {
				this.parent.setVisible(false);
			};
		};

		if (this.button.visible) {
			this.button.captureMouseEvents();
			this.button.stopPropagation = true;
			this.button.onMouseDown = function(e) {
				this.parent.setVisible(false);
			};
		};

		if (this.standardButton) {
			this.button.mouseOverSrc = this.button.src;
			this.buttonCross.mouseOverSrc = this.buttonCross.src;
		};

		this.text.rtl = this.rtl;

		if (this.text.scrollable) {
			this.text.stopPropagation = true;
		};
	};
};

componentPopup.prototype.beginDrag = function(obj)
{
	PageInterface.Execute("setOnTop", this);
};

componentPopup.prototype.setCompleteArrayInfo = function(style)
{
	if (typeof(style) == 'undefined') return;
	var imagesStr = style;
	var imgArr = imagesStr.split(';');
	for (var i = 0; i < imgArr.length; i++){
		var oneImg = imgArr[i].split(',');
		if (!this.imagesCompleteInfo[oneImg[0]]){
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];
		};
	};
};

componentPopup.prototype.findContentObj = function()
{
	if (this.isNewPopup){
		return this.findContentObjByName(this.id + "_contentObjNew");
	} else {
		return this.findContentObjByName(this.id + "_contentObjOld");
	};
};

componentPopup.prototype.setNewPopupImages = function(obj)
{
	var objb = null;
	var objbc = null;
	objb = document.getElementById(this.id + "_buttonDIV_contentObj");
	if (objb) this.setImageSrc(this.resourcesURL + this.buttonSrc, objb);

	objbc = document.getElementById(this.id + "_buttonCrossDIV_contentObj");
	if (objbc) this.setImageSrc(this.resourcesURL + this.buttonCrossSrc, objbc);

	var mainOldComponent = document.getElementById(this.id + "_mainOldComponent");
	if (mainOldComponent) mainOldComponent.style.visibility = 'hidden';

	var mainNewComponent = document.getElementById(this.id + "_mainNewComponent");
	if (mainNewComponent) mainNewComponent.style.visibility = 'inherit';

	var leftTopImg = document.getElementById(this.id + "_leftTopImg");
	if (leftTopImg)	leftTopImg.src = this.resourcesURL + this.leftTop;
	var centerTopImg = document.getElementById(this.id + "_centerTopImg");
	if (centerTopImg) centerTopImg.src = this.resourcesURL + this.centerTop;

	var rightTopImg = document.getElementById(this.id + "_rightTopImg");
	if (rightTopImg) rightTopImg.src = this.resourcesURL + this.rightTop;

	var leftTop = document.getElementById(this.id + "_leftTop");
	if (leftTop) {
		leftTop.width = this.getImageWidth(this.leftTop, 'leftTop');
		leftTop.height = this.getImageHeight(this.leftTop, 'leftTop');
	};

	var rightTop = document.getElementById(this.id + "_rightTop");
	if (rightTop) {
		rightTop.style.width = this.getImageWidth(this.rightTop, 'rightTop');
		rightTop.style.height = this.getImageHeight(this.rightTop, 'rightTop');
	};

	var centerTop = document.getElementById(this.id + "_centerTop");
	if (centerTop) centerTop.style.height = this.getImageHeight(this.centerTop, 'centerTop');

	var middleTopImg = document.getElementById(this.id + "_middleTopImg");
	if (middleTopImg) {
		middleTopImg.src = this.resourcesURL + this.topMiddle;
		middleTopImg.height = this.getImageHeight(this.topMiddle, 'topMiddle');
	};

	var middleMiddleImg = document.getElementById(this.id + "_middleMiddleImg");
	if (middleMiddleImg) middleMiddleImg.src = this.resourcesURL + this.centerMiddle;

	var middleBottom = document.getElementById(this.id + "_middleBottom"); //pg2
	var middleBottomImg = document.getElementById(this.id + "_middleBottomImg");
	if (middleBottomImg) {
		middleBottomImg.src = this.resourcesURL + this.bottomMiddle;
		middleBottomImg.height = this.getImageHeight(this.leftTop, 'bottomMiddle');
		if (middleBottom) { //pg2
			if (middleBottom.height != middleBottomImg.height && middleBottom.height != "") { //pg2-zabezpieczenie przed pustym
				middleBottomImg.height = middleBottom.height;
			};
		};
	};

	var leftBottomImg = document.getElementById(this.id + "_leftBottomImg");
	if (leftBottomImg) leftBottomImg.src = this.resourcesURL + this.leftBottom;

	var centerBottomImg = document.getElementById(this.id + "_centerBottomImg");
	if (centerBottomImg) centerBottomImg.src = this.resourcesURL + this.centerBottom;

	var rightBottomImg = document.getElementById(this.id + "_rightBottomImg");
	if (rightBottomImg) rightBottomImg.src = this.resourcesURL + this.rightBottom;

	var leftBottomImg = document.getElementById(this.id + "_leftBottomImg");
	if (leftBottomImg) {
		leftBottomImg.style.width = this.getImageWidth(this.leftTop, 'leftTop');
		leftBottomImg.style.height = this.getImageHeight(this.leftTop, 'leftTop');
	};
	var rightBottomImg = document.getElementById(this.id + "_rightBottomImg");
	if (rightBottomImg) {
		rightBottomImg.style.width = this.getImageWidth(this.rightTop, 'rightTop');
		rightBottomImg.style.height = this.getImageHeight(this.rightTop, 'rightTop');
	};

	var centerBottomImg = document.getElementById(this.id + "_centerBottomImg");
	if (centerBottomImg) centerBottomImg.style.height = this.getImageHeight(this.centerTop, 'centerTop');

	var buttonOKImg = document.getElementById(this.id + "_buttonOKImg");
	if (buttonOKImg) buttonOKImg.src = this.resourcesURL + this.buttonSrc;

	var buttonHideImg = document.getElementById(this.id + "_buttonHideImg");
	if (buttonHideImg) {
		buttonHideImg.src = this.resourcesURL + this.buttonCrossSrc;
	/*
		buttonHideImg.width = this.buttonW;
		buttonHideImg.height = this.buttonH;
	*/
	}
};

componentPopup.prototype.componentPopupBaseonPaint = componentPopup.prototype.onPaint;
componentPopup.prototype.onPaint = function(obj)
{
	if (this.execution) {
		this.contentObj = this.findContentObj();

		//pg2-removed, 'cause more elegant and simple soultion was fount- 'font' '...contentObj' transformed into div
		/*var contentDiv = document.getElementById(this.id + "ContentOld"); //pg2-remove content from div - in new Firefox (9) o.innerHTML has at startup empty "" value - __text is modyfied in the same way. Key div is added in bodyEx.html
		if (contentDiv) contentDiv.innerHTML = "";
		contentDiv = document.getElementById(this.id + "ContentNew");
		if (contentDiv) contentDiv.innerHTML = "";*/

		if (this.contentObj) {
			//pg2-new block
			if (this.type == "componentPopup" && typeof(this.invokedFromDetectComponent) != "undefined") { //pg2-in case of feedbacks there would be an exception
				try {
					this.textText = this.text.text; //pg2-after refresh via "window.setTimeout" text it will not be 'Content' (initial) if the component is used (defined text and invoked .show) by another one
				} catch(e) {};
			} else                                  //       for example- all detect components can use now external popup
			this.contentObj.innerHTML = this.initText(this.textText);
			if (!this.wrap) this.contentObj.style.whiteSpace = "nowrap";
		};

		if (this.isNewPopup){
			this.setNewPopupImages();

			var topTableDIV = document.getElementById(this.id + "_topTableDIV");
			var headerTextDIV = document.getElementById(this.id + "_headerTextDIV");
			var buttonHideDIV = document.getElementById(this.id + "_buttonHideDIV");
			var middleTop = document.getElementById(this.id + "_middleTop");
			var middleBottom = document.getElementById(this.id + "_middleBottom");
			var middleTableDIV = document.getElementById(this.id + "_middleTableDIV");
			var mainTextDIV = document.getElementById(this.id + "_mainTextDIV");
			var bottomTableDIV = document.getElementById(this.id + "_bottomTableDIV");
			var leftBottom = document.getElementById(this.id + "_leftBottom");
			var rightBottom = document.getElementById(this.id + "_rightBottom");
			var buttonOKDIV = document.getElementById(this.id + "_buttonOKDIV");
			var buttonOKImg = document.getElementById(this.id + "_buttonOKImg");
			var buttonCrossDIV = document.getElementById(this.id + "_buttonCrossDIV");

			if (this._scrollable && mainTextDIV) {
				mainTextDIV.owner = null;
				if (this._vertScrollbars) {
					mainTextDIV.style.cssText += '; overflow-x: hidden; overflow-y: auto;';
				} else {
					mainTextDIV.style.cssText += '; overflow-x: auto; overflow-y: auto;';
				};
			};
			if (this.type == 'componentFeedback') {
				if (bottomTableDIV) bottomTableDIV.style.visibility = 'hidden';
				if (buttonOKDIV) buttonOKDIV.style.visibility = 'hidden';

				if (headerTextDIV) {
					var headerH = this.getImageHeight(this.centerTop, 'centerTop');
					topTableDIV.style.top = 0;
					topTableDIV.style.height = headerH;
					topTableDIV.style.clip = 'rect(0px '+this.w+'px '+headerH+'px 0px)';
				};

				if (this.type == 'componentFeedback'){
					if (headerTextDIV)
						headerTextDIV.style.visibility = 'hidden';
				} else {
					if (headerTextDIV) {
						if (this.dir == "rtl") {
							headerTextDIV.style.left = 0;
							headerTextDIV.style.width = this.width - this.getImageWidth(this.leftTop, 'leftTop');
						} else {
							headerTextDIV.style.left = this.getImageWidth(this.leftTop, 'leftTop');
						};
					};
				};
				if (buttonHideDIV){
					if (this.buttonCrossVisible) {
						buttonHideDIV.style.top = 0;
						buttonHideDIV.style.width = buttonHideDIV.offsetWidth;
						buttonHideDIV.style.height = buttonHideDIV.offsetHeight;
						buttonHideDIV.style.clip = 'rect(0px '+buttonHideDIV.offsetWidth+'px '+buttonHideDIV.offsetHeight+'px 0px)';
						if (this.dir == "rtl") {
							buttonHideDIV.style.left = 16;
						} else {
							buttonHideDIV.style.left = this.w - buttonHideDIV.offsetWidth - 16;
						};
					} else {
						buttonHideDIV.style.visibility = 'hidden';
					};
				};

				if (middleTop) middleTop.height = this.getImageHeight(this.topMiddle, 'topMiddle');
				if (middleBottom) middleBottom.height = this.getImageHeight(this.bottomMiddle, 'bottomMiddle');

				if (middleTableDIV) {
					var textH = this.h - this.getImageHeight(this.centerTop, 'centerTop');
					middleTableDIV.style.top = this.getImageHeight(this.centerTop, 'centerTop');
					middleTableDIV.style.height = textH;
					middleTableDIV.style.clip = 'rect(0px '+this.w+'px '+textH+'px 0px)';

					mainTextDIV.style.height = textH;
					mainTextDIV.style.clip = 'rect(0px '+this.w+'px '+textH+'px 0px)';
				};
			} else {
				if (topTableDIV){
					var headerH = this.getImageHeight(this.centerTop, 'centerTop');
					topTableDIV.style.top = 0;
					topTableDIV.style.height = headerH;
					topTableDIV.style.clip = 'rect(0px '+this.w+'px '+headerH+'px 0px)';
				}

				if (this.type == 'componentFeedback'){
					if (headerTextDIV)
						headerTextDIV.style.visibility = 'hidden';
				} else {
					if (headerTextDIV) {
						if (this.dir == "rtl") {
							headerTextDIV.style.left = 0;
							headerTextDIV.style.width = this.width - this.getImageWidth(this.leftTop, 'leftTop');
						} else {
							headerTextDIV.style.left = this.getImageWidth(this.leftTop, 'leftTop');
						};
					};
				};

				if (buttonHideDIV){
					if (this.buttonCrossVisible) {
						if (this.buttonPos == 'top') {
							buttonHideDIV.style.top = 0;
						} else {
							buttonHideDIV.style.top = this.h - buttonHideDIV.offsetHeight;
						};
						if (this.dir == 'rtl') {
							buttonHideDIV.style.left = 16;
						} else {
							buttonHideDIV.style.left = this.w - buttonHideDIV.offsetWidth - 16;
						};
						buttonHideDIV.style.width = this.buttonCrossW;
						buttonHideDIV.style.height = this.buttonCrossH;
						buttonHideDIV.style.clip = 'rect(0px '+this.buttonCrossW+'px '+this.buttonCrossH+'px 0px)';
					} else {
						buttonHideDIV.style.visibility = 'hidden';
					};
				};

				if (middleTop) middleTop.height = this.getImageHeight(this.topMiddle, 'topMiddle');
				if (middleBottom) middleBottom.height = this.getImageHeight(this.bottomMiddle, 'bottomMiddle');

				if (buttonOKDIV) {
					if (this.buttonVisible) {
						buttonOKDIV.style.top = this.h - buttonOKDIV.offsetHeight;
					} else {
						buttonOKDIV.style.visibility = 'hidden';
					};
				};

				if (buttonCrossDIV) {
					if (!this.buttonCrossVisible) {
						buttonCrossDIV.style.visibility = 'hidden';
					};
				};

				if (middleTableDIV) {
					var textH = this.h-this.getImageHeight(this.centerTop, 'centerTop')-this.getImageHeight(this.centerBottom, 'centerBottom');
					middleTableDIV.style.top = this.getImageHeight(this.centerTop, 'centerTop');
					middleTableDIV.style.height = textH;
					middleTableDIV.style.clip = 'rect(0px '+this.w+'px '+textH+'px 0px)';

					mainTextDIV.style.height = eval(textH-2);
					mainTextDIV.style.clip = 'rect(0px '+this.w+'px '+eval(textH-2)+'px 0px)';
				};

				if (bottomTableDIV){
					var footerH = this.getImageHeight(this.centerBottom, 'centerBottom');
					bottomTableDIV.style.top = this.h - footerH;
					bottomTableDIV.style.height = footerH;
					bottomTableDIV.style.clip = 'rect(0px '+this.w+'px '+footerH+'px 0px)';
				};

				if (leftBottom) leftBottom.style.width = this.getImageWidth(this.leftBottom, 'leftBottom');
				if (rightBottom) rightBottom.style.width = this.getImageWidth(this.rightBottom, 'rightBottom');
			};
		} else {
			var bor = (is.ns4) ? 0 : this.borderWidth;
			var bor2 = bor * 2;
			var of = (this.padding) ? this.padding : 3;
			var of2 = of * 2;
			var buttonH = (this.buttonVisible) ? (this.buttonH + of) : 0;

			if (this.buttonVisible) {
				var button = document.getElementById(this.id + "_buttonDIV");
				button.style.visibility = 'inherit';
				if (this.buttonAlign == "left") {
					button.style.left = of;
					button.style.top  = this.h - bor2 - of - buttonH;
				} else
				if (this.buttonAlign == "center") {
					button.style.left = this.w/2 - (this.buttonW / 2) - bor;
					button.style.top  = this.h - bor2 - of - buttonH;
				} else {
					button.style.left = this.w - bor2 - of - this.buttonW;
					button.style.top  = this.h - bor2 - of - buttonH;
				};
			} else {
				document.getElementById(this.id + "_buttonDIV").style.visibility = 'hidden';
			};

			if (this.popupTitleVisible) {
				if (document.getElementById(this.id + "_textTitleDIV")) document.getElementById(this.id + "_textTitleDIV").style.visibility = 'inherit';
			} else {
				if (document.getElementById(this.id + "_textTitleDIV")) document.getElementById(this.id + "_textTitleDIV").style.visibility = 'hidden';
			};

			if (this.buttonCrossVisible) {
				if (document.getElementById(this.id + "_buttonCrossDIV")){
					document.getElementById(this.id + "_buttonCrossDIV").style.visibility = 'inherit';
					if (this.buttonCrossW != 13) document.getElementById(this.id + "_buttonCrossDIV").style.left = this.w-this.buttonCrossW-2*this.borderWidth;
				};
			} else {
				if (document.getElementById(this.id + "_buttonCrossDIV")) document.getElementById(this.id + "_buttonCrossDIV").style.visibility = 'hidden';
			};

			var t_t = ((this.popupTitleVisible) ? eval(document.getElementById(this.id + "_textTitleDIV").offsetHeight+3) : 0);
			document.getElementById(this.id + "_textDIV").style.top = t_t;

			var t_h = ((this.popupTitleVisible) ? -parseInt(document.getElementById(this.id + "_textTitleDIV").style.height) : 0);
			if (this.buttonVisible) t_h -= (this.buttonH + this.padding*2 + bor2);
			document.getElementById(this.id + "_textDIV").style.height = (this.h - bor2) + t_h/*<<aw- FF-text cut bug 2014-03-12>> - 2*this.padding*/;

/*<<aw- text cut bug 2014-03-12>>
			document.getElementById(this.id + "_textDIV").style.width = this.obj.offsetWidth - this.padding*2 - bor2;
*/

			document.getElementById(this.id + "_textDIV").style.clip = 'rect(0px '
				+ document.getElementById(this.id + "_textDIV").style.width + ' '
				+ document.getElementById(this.id + "_textDIV").style.height + ' 0px)';
/*<<aw- text cut bug 2014-03-12>>
			if (!is.ie) {
				var obj = document.getElementById(this.id + '_contentObjOld'); //pg2- old courses in new Firefox (line is wrapped outside designated area- it is bigger than parent div
				if (obj) {
					var objTextDiv = document.getElementById(this.id + "_textDIV");
					if (objTextDiv) {
						obj.style.width = objTextDiv.style.width; //this.obj.offsetWidth - this.padding*2 - bor2;
						obj.style.clip = objTextDiv.style.clip;
					};
				};
			};
*/
		};

		if (this.step == 0) {
			if (this.reformatTimer == null) {
				this.reformatTimer = window.setTimeout('pc["' + this.id + '"].onPaint();', 500);
			};
		};
	} else {
		var bor = (is.ns4) ? 0 : this.borderWidth;
		var bor2 = bor * 2;
		var of = this.padding;
		var of2 = of * 2;
		var buttonH = (this.buttonVisible) ? (this.button.h + of) : 0;

		this.popupTitle.setVisible(this.popupTitleVisible);
		if (!this.popupTitleVisible) this.buttonCrossVisible = false;
		this.buttonCross.setVisible(this.buttonCrossVisible);
		this.button.setVisible(this.buttonVisible);

		this.style.cursor = this.cursor;
		this.text.cursor = this.cursor;
		this.popupTitle.font.bold = true;
		this.button.cursor = "pointer";
		this.buttonCross.cursor = "pointer";
		var pth = (this.popupTitleVisible) ? this.popupTitle.h : 0;
		this.buttonCross.step = this.popupTitle.step;

		switch (this.popupTitleAlign) {
			case "left":
			case "right":
			case "top":
				this.text.y = of + pth;
				this.popupTitle.y = 0;
				break;
			case "bottom":
				this.text.y = 0;
				this.popupTitle.y = this.h - bor2 - this.popupTitle.h;
				this.buttonCross.y = this.popupTitle.y + ((this.popupTitle.h - this.buttonCross.h) / 2);
				break;
		};

		this.text.x = of;
		this.text.w = this.w - bor2 - of2;
		this.text.h = this.h - bor2 - of2 - pth;

		this.popupTitle.x = 0;
		this.popupTitle.w = this.w - bor2;

		this.buttonCross.x = this.w - bor2 - 5 - this.buttonCross.w;
		//extraHeaderButtons
		this.createExtraHeaderButtons();

		if (this.buttonVisible) {
			if (this.buttonAlign == "left") {
				this.button.x = of;
				this.button.y = this.h - bor2 - of - buttonH;
			} else
			if (this.buttonAlign == "center") {
				this.button.x = this.w/2 - (this.button.w / 2) - bor;
				this.button.y = this.h - bor2 - of - buttonH;
			} else {
				this.button.x = this.w - bor2 - of - this.button.w;
				this.button.y = this.h - bor2 - of - buttonH;
			};
		};

		if (!this.buttonCrossVisible) {
			var obj = document.getElementById(this.id + "_buttonCrossDIV");
			if (obj) obj.style.visibility = 'hidden';
		};
	};
};

componentPopup.prototype.componentPopupBaseSetSizeScaledElement = componentPopup.prototype.setSizeScaledElement;
componentPopup.prototype.setSizeScaledElement = function (x, y, w, h)
{
	if (this.execution) {
		var tWidth = 0;
		var tHeight = 0;
		if (document.getElementById(this.id + "_textTitleDIV")) {
			//pg2-if feedback too small, page isn't displayed
			tWidth = w-(this.borderWidth*2);
			if (tWidth < 0) tWidth = 0;
			//...
			document.getElementById(this.id + "_textTitleDIV").style.width = tWidth; //w-(this.borderWidth*2); //pg2-if feedback too small, page isn't displayed
			document.getElementById(this.id + "_textTitleDIV").style.clip = 'rect(0px '+eval(w-(this.borderWidth*2))+' 20px 0px)';
		};
		if (document.getElementById(this.id + "_textDIV")) {
			//pg2-if feedback too small, page isn't displayed
			tWidth = w-(this.borderWidth*2);
			if (tWidth < 0) tWidth = 0;
			//...
			document.getElementById(this.id + "_textDIV").style.width = tWidth; //w-(this.borderWidth*2); //pg2-removed
			 //pg2-if feedback too small, page isn't displayed
			tHeight = h-(this.borderWidth*2)-20;
			if (tHeight < 0) tHeight = 0;
			//...
			document.getElementById(this.id + "_textDIV").style.height = tHeight; //h-(this.borderWidth*2)-20; //pg2-if feedback too small, page isn't displayed
			//document.getElementById(this.id + "_textDIV").style.clip = 'rect(0px '+eval(w-(this.borderWidth*2))+' '+eval(h-(this.borderWidth*2)-20)+' 0px)';  //pg2-if feedback too small, page isn't displayed -replaced with the line below
			document.getElementById(this.id + "_textDIV").style.clip = 'rect(0px '+eval(tWidth)+' '+eval(tHeight)+' 0px)';
		};
		if (document.getElementById(this.id + "_buttonCrossDIV"))
			document.getElementById(this.id + "_buttonCrossDIV").style.left = w-(this.borderWidth*2)-18;

		if (document.getElementById(this.id + "_buttonDIV")){
			if (this.buttonAlign == "left") {
				document.getElementById(this.id + "_buttonDIV").style.left = (this.borderWidth*2)+5;
			} else
			if(this.buttonAlign == "center") {
				document.getElementById(this.id + "_buttonDIV").style.left = eval(w/2)-(this.borderWidth*2)-eval(this.buttonW/2);
			} else {
				document.getElementById(this.id + "_buttonDIV").style.left = w-(this.borderWidth*2)-this.buttonW-5;
			};
			document.getElementById(this.id + "_buttonDIV").style.top = h-(this.borderWidth*2)-this.buttonH-5;
		};
	};
	this.componentPopupBaseSetSizeScaledElement(x, y, w, h);
};

componentPopup.prototype.buttonOnMouseOver = function (buttonObj)
{
	if (this.execution) {
		buttonObj.src = resourcesURL + this.buttonMouseOverSrc;
	} else {
		buttonObj.src = resourcesURL + this.buttonSrc;
	};
};

componentPopup.prototype.buttonCrossOnMouseOver = function (buttonObj)
{
	if (this.execution) {
		buttonObj.src = resourcesURL + this.buttonCrossMouseOverSrc;
	} else {
		buttonObj.src = resourcesURL + this.buttonCross.src;
	};
};

componentPopup.prototype.buttonOnMouseOut = function (buttonObj)
{
	if (this.execution) {
		buttonObj.src = this.resourcesURL + this.buttonSrc;
	} else {
		buttonObj.src = this.resourcesURL + this.button.src;
	};
};

componentPopup.prototype.buttonCrossOnMouseOut = function (buttonObj)
{
	if(this.execution){
		buttonObj.src = this.resourcesURL + this.buttonCrossSrc;
	} else {
		buttonObj.src = this.resourcesURL + this.buttonCross.src;
	};
};

componentPopup.prototype.onLoad = function()
{
	if (this.execution) {
	} else {
		var s = "<img id=\"'"+ this.id +"button'\" src=\"" + this.button.resourcesURL + this.button.src + "\" border=\"0\"  onMouseOver=\"page.all['"+this.id+"'].buttonOnMouseOver(this)\" onMouseOut=\"page.all['"+this.id+"'].buttonOnMouseOut(this)\">";
		this.button.setHTML(s);

		s = "<img id=\"'"+ this.id +"buttonCross'\" src=\"" + this.buttonCross.resourcesURL + this.buttonCross.src + "\" border=\"0\"  onMouseOver=\"page.all['"+this.id+"'].buttonCrossOnMouseOver(this)\" onMouseOut=\"page.all['"+this.id+"'].buttonCrossOnMouseOut(this)\">";
		this.buttonCross.setHTML(s);
	};
};

componentPopup.prototype.isReady = function()
{
	if (this.execution) {
		var isLoaded = false
		for (var i=0; i < this.imagesNameArr.length; i++){
			isLoaded = preloadImage(this, "_"+i);
			if (!isLoaded) return false;
		};
		this.isLoaded = isLoaded;
		return this.isLoaded;
	} else {
		return(((this.buttonVisible)?this.button.isReady():true) 
			&& ((this.popupTitleVisible)?this.buttonCross.isReady():true));
	};
};

componentPopup.prototype.addExtraHeaderButton = function(number, name, imgSrc, action, titleH)
{
	this.text.y = this.borderWidth;
	this.text.h = this.h - titleH
	this.popupTitle.h = titleH;
	this.popupTitle.y = this.h-titleH-this.borderWidth;
	this.popupTitle.valign = 'middle'
	this.button.hide();

	var e = this.addChild(new componentButton(this.id + "_" + name));

	var img = new Image();
	img.src = resourcesURL + imgSrc;

	e.w = img.width;
	e.h = img.height;
	e.x = this.buttonCross.x - ((number * this.buttonCross.w) + (number * 10));
	e.y = this.popupTitle.y + ((this.popupTitle.h - e.h) / 2);
	this.buttonCross.y = this.popupTitle.y + ((this.popupTitle.h - e.h) / 2);

	e.src = imgSrc;
	e.cursor = "pointer";
	e.borderColor = "transparent";
	e.borderWidth = 0;
	e.step = this.step;
	e.visibleIf = "";
	e.infoText = "Put an image here";
	e.contentMode = 0;
	e.stayOnTop = false;
	e.alphaOpacity = "100";
	e.altHint = "";
	e.layer = 1;
	e.disableOnlineOfflineMix = false;
	e.automaticHideTimerInterval = 0;

	e.captureMouseEvents();
	e.stopPropagation = true;

	e.onMouseDown = function(e) {
		try {
			eval(action);
		} catch(e) {
			if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.addExtraHeaderButton eval execution error\nMessage:\n' + e.message); //pg2
		};
	};

	e.show();
};

componentPopup.prototype.createExtraHeaderButtons = function()
{
	if (this.popupTitleVisible && this.extraHeaderButtons != "" && typeof(this.extraHeaderButtons) != 'undefined') {
		var arr = this.extraHeaderButtons.split("#|#");
		for (var i=0; i<arr.length; i++) {
			var arrItem = arr[i].split("||");
			var name = "extraBtn" + (i + 1);
			var imgSrc = arrItem[0];
			var action = arrItem[1];
			var headerHeight = arrItem[2];
			this.addExtraHeaderButton(i + 1, name, imgSrc, action, headerHeight);
		};
	};
};

componentPopup.prototype.changeImage = function(objName, fileName)
{
	if (objName) this.setImageSrc(this.resourcesURL + fileName, objName);
};

componentPopup.prototype.setImageSrc = function(value, obj)
{
	value = unescape(value);
	if (obj) {
		if (this.pngFix && is.ie55UP && !is.ie7UP) {
			var is_span = (obj.tagName.toUpperCase() == 'SPAN');
			if (is_span){
				var src = ".." + value.substr(value.lastIndexOf("/resources/"), value.length);
				obj.src = value;

				var psArr = this.getPosSize(obj);

				var png_img = new Image();
				png_img.src = value;
				var loaded = this.waitForImage(png_img, 50);

				var sizingMethod = "scale";
				if (loaded || (!isNaN(png_img.width) && !isNaN(png_img.height))) {
					if (parseInt(png_img.width) == parseInt(psArr[2]) && "" + parseInt(png_img.height) == parseInt(psArr[3])) {
						sizingMethod = "image";
					};
				};

				obj.style.filter = 'progid:DXImageTransform.Microsoft.AlphaImageLoader (src=\'' + src + '\',sizingMethod=\''+sizingMethod+'\'';
			} else {
				obj.src = value;
			};
		} else {
			obj.src = value;
		};
		return true;
	};
	return false;
};

componentPopup.prototype.getImageHeight = function( imgSrc, objName )
{
	var result = "";
	result = parseInt(this.imagesCompleteInfo[objName][1]);
	if (isNaN(result) || result =='undefined' || typeof(result) == 'undefined') {
		return getImageHeight(imgSrc);
	} else {
		return result;
	};
};

componentPopup.prototype.getImageWidth = function( imgSrc, objName )
{
	var result = "";
	result = parseInt(this.imagesCompleteInfo[objName][0]);
	if (isNaN(result) || result =='undefined' || typeof(result) == 'undefined') {
		return getImageWidth(imgSrc);
	} else {
		return result;
	};
};
