﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentRPL = function(name) {
	this.componentElement = componentElement;
	this.componentElement(name);

	this.compAudio = null;

	this._optCount = 0;
	this._lastQuestSize = 0;

	this.points = 0;
	this.maxPoints = 0;
	this.comments = ""; //komentarz do odpowiedzi
	this.numberOfQuestion = 0; //licznik ile pytan zadano
	this.questionList = ''; //lista kolejnych pytan np. 1,4,5,6
	this.lastQuestion = 0;
	this.listQuestionsId = '';
	this.imagesList = '';
	this.preImages = new Array();
	this.preloadTimer = null;
	this.groupList = '';  
	this.listOfUsedGroup = '';  
	this.askedQuestions = 0;
	this.QuestionFont = '';
	this.AnswerFont = '';
	this.QuestionFontEnd = '';
	this.AnswerFontEnd = '';	
	this.defaultContent = "";
	this.idDisplayedQuestion = 0;

	this.kindOfFile = 'image';

	this.cloudsArr = new Array();
	this.rplCloudsArr = new Array();

	this.panelRPLOBJ = null;
	this.answersArrRemember = new Array();
	this.questionRemember = '';

	this.correctAnswersList = "";
	this.interactions = true;
	this.interactionsType = "matching";
	this.usrAns = 0;

	this.resourcesURL = "";
	this.disableOnlineOfflineMix = false;

	this.groupAnswers = new Array();

	this.sceneCreated = false; //pg2-fix_img_height
	this.timerId = null;
	this.timerCounterStartVal = 10; //20; //10;//10; //20;
	this.timerCounter = this.timerCounterStartVal;
	this.timerCounterTimeout = 1;
	
	//this.imgAsBckg = true; //pg2-LEAN_test
};

componentRPL.prototype = new componentElement;
componentRPL.prototype.type = "componentRPL";

componentRPL.prototype.onCreate = function() 
{
	this.captureMouseEvents();
	this.points = 0;	
	this.resourcesURL = resourcesURL;
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
    this.resourcesURL = unescape(this.resourcesURL);
	
	this.makeListOfImages();
	
	if (this.cloudFrom == 'cloudFromPage') {
		this.makeArrOfClouds();
	} else
	if (this.cloudFrom == 'cloudFromRPL') {
		this.makeThreeDialogues();
	};
	if (PageInterface.GetValue("state") != psDesigning) {
		var audioElement = new componentAudio();
		audioElement.myParent = this;
		audioElement.id = this.id+'Audio'; 
		audioElement.src = ""; //this.src; //pg2-rpl_audio
		audioElement.pvWMP64 = false;
		audioElement.pvWMP7up = false;
		audioElement.step = -1;
		audioElement.editorPaint = this.editorPaint;
		this.compAudio = PageInterface.Execute("addChild", audioElement);

		this.compAudio.initPlayer(); //pg2-rpl_audio
		this.compAudio.nextStepWaitToEnd = false; //pg2-IE10 -wait with next step 'till end of audio ain't necessary in RPL
	};
};

componentRPL.prototype.editorPaint = function()
{
	return '';
};

componentRPL.prototype.addSizeDiv = function()
{
	var sizeDiv = '<div id="'+this.id+'SizeDiv" style="visibility: hidden; position: absolute; width:100px; height:100px font-family:' + this.fontFamilyQ +
					'; font-size:' + getFontSize(this.fontSizeQ, "px") + 'px;"></div>';

	var ob = document.getElementById(this.id);
	ob.innerHTML += sizeDiv;

//	document.body.innerHTML += sizeDiv;
};

componentRPL.prototype.makeThreeDialogues_OLD = function() //pg2-LEAN_test2 -removed, it was before
{
	var cloudsSrc = new Array(this.cloudSmall, this.cloudAverage, this.cloudBig)

	for (var i=0; i < 3; i++) {
		var e = new componentDialogue;
		e.myParent = this;
		e.id = this.id + 'Dialogue_' + i; 
		var img = new Image;
		img.src = this.resourcesURL + cloudsSrc[i];

		switch (this.cloudAlign) {
			case 'left' : 
				var tempX = this.x;
				break;
			case 'center' : 
				var tempX = this.x + this.w/2 - img.width/2;
				break;
			case 'right' : 
				var tempX = this.x + this.w - img.width;
				break;
		};
		e.x = tempX;
		e.y = this.y;
		e.w = img.width;
		e.h = img.height;
		if (cloudsSrc[i].indexOf('.png') != -1 && is.ie && is.ie55UP && !is.ie7UP) {
			e.p_checkMarkers = true;		
			e.p_checkPNG = true;		
		} else {
			e.p_checkMarkers = false;		
			e.p_checkPNG = false;	
		};
		e.pngFix = true;	
		e.textFromLeft = 30; 
		e.textFromRight = 50;
		e.textFromUp = 10;
		e.textFromDown = 15;
		e.text.text = "";
		e.text.align = "center";
		e.text.valign = "middle";
		e.text.w = e.w - e.textFromLeft - e.textFromRight;
		e.text.h = e.h - e.textFromUp - e.textFromDown;
		e.cloud.src = cloudsSrc[i];
		e.cloud.x = 0;
		e.cloud.y = 0;
		e.cloud.w = img.width;
		e.cloud.h = img.height;
		e.step = -1;
		this.rplCloudsArr.push(e);
		page.addChild(e);
	};
};

componentRPL.prototype.makeThreeDialogues = function() //pg2-LEAN_test2 -removed, it was before // NEW, method2
{
	var cloudsSrc = new Array(this.cloudSmall, this.cloudAverage, this.cloudBig)
	this.imagesClouds = new Array();

	for (var i=0; i < 3; i++) {
		var e = new componentDialogue;
		e.myParent = this;
		e.id = this.id + 'Dialogue_' + i; 
		var img = new Image;
		img.src = this.resourcesURL + cloudsSrc[i];
		
		this.imagesClouds[i] = img;
		var imgWidth = 10;
		var imgHeight = 10;
		switch(i) {
			case 0: imgWidth = 247; imgHeight = 96; break;
			case 1: imgWidth = 327; imgHeight = 119; break;
			case 2: imgWidth = 343; imgHeight = 166; break;
		};
		//imgWidth = 50; imgHeight = 46;

		switch (this.cloudAlign) {
			case 'left' : 
				var tempX = this.x;
				break;
			case 'center' : 
				var tempX = this.x + this.w/2 - imgWidth/2;
				break;
			case 'right' : 
				var tempX = this.x + this.w - imgWidth;
				break;
		};
		e.x = tempX;
		e.y = this.y;
		e.w = imgWidth;
		e.h = imgHeight;
		if (cloudsSrc[i].indexOf('.png') != -1 && is.ie && is.ie55UP && !is.ie7UP) {
			e.p_checkMarkers = true;		
			e.p_checkPNG = true;		
		} else {
			e.p_checkMarkers = false;		
			e.p_checkPNG = false;	
		};
		e.pngFix = true;	
		e.textFromLeft = 30; 
		e.textFromRight = 50;
		e.textFromUp = 10;
		e.textFromDown = 15;
		e.text.text = "";
		e.text.align = "center";
		e.text.valign = "middle";
		e.text.w = e.w - e.textFromLeft - e.textFromRight;
		e.text.h = e.h - e.textFromUp - e.textFromDown;
		e.cloud.src = cloudsSrc[i];
		e.cloud.x = 0;
		e.cloud.y = 0;
		e.cloud.w = imgWidth;
		e.cloud.h = imgHeight;
		e.step = -1;
		this.rplCloudsArr.push(e);
		page.addChild(e);
	};
	window.setTimeout('pc.' + this.id + '.createThreeDialoguesPostponed();', 1000);
};

componentRPL.prototype.createThreeDialoguesPostponed = function() //pg2-LEAN_test2
{
	var cloudsSrc = new Array(this.cloudSmall, this.cloudAverage, this.cloudBig);
	//var str = '';
	for (var i=0; i < 3; i++) {
		switch (this.cloudAlign) {
			case 'left' : 
				var tempX = this.x;
				break;
			case 'center' : 
				var tempX = this.x + this.w/2 - this.imagesClouds[i].width/2;
				break;
			case 'right' : 
				var tempX = this.x + this.w - this.imagesClouds[i].width;
				break;
		};
		var e = this.rplCloudsArr[i];
		//str += this.imagesClouds[i].width + 'x' + this.imagesClouds[i].height + '\n';
		if (this.imagesClouds[i].width == 0 || this.imagesClouds[i].height == 0) continue;
		e.x = tempX;
		e.y = this.y;
		e.w = this.imagesClouds[i].width;
		e.h = this.imagesClouds[i].height;
		e.text.w = e.w - e.textFromLeft - e.textFromRight;
		e.text.h = e.h - e.textFromUp - e.textFromDown;
		e.cloud.w = this.imagesClouds[i].width;
		e.cloud.h = this.imagesClouds[i].height;
	};
	
	this.showRPLCloud(this.question1);
};

componentRPL.prototype.showRPLCloud = function(text)
{
	var pageDiv = document.getElementById(this.id+'SizeDiv');
	
	//pg2-LEAN_test2
	if (pageDiv) this.pageDiv = pageDiv;
	if (!pageDiv && this.pageDiv) pageDiv = this.pageDiv;
	//...
	
	for (var i=0; i < this.rplCloudsArr.length; i++) {
		this.rplCloudsArr[i].hide();
	};
	for (var i=0; i < this.rplCloudsArr.length; i++) {
		pageDiv.style.width = this.rplCloudsArr[i].text.w;
		pageDiv.innerHTML = text;
		if (pageDiv.offsetHeight < this.rplCloudsArr[i].text.h || i == 2) {
			if (this.rplCloudsArr[i].execution) {
				document.getElementById(this.rplCloudsArr[i].id + "_contentObj").innerHTML = text;
			} else {
				this.rplCloudsArr[i].show();
				var content = this.rplCloudsArr[i].text.findContentObj();
				if (content) content.innerHTML = text;
			};
  			return;
		};		
	};
};

componentRPL.prototype.onPaint = function() 
{
    if (!this.sceneCreated) { //pg2-fix_img_height
		this.setGroupList();
		this.setListQuestionsId();

	    if (this.randomizeQuestions) {
	        var temp = this.listQuestionsId.split("!!");
	        var rand = parseInt(Math.random()*(temp.length-1));
	        this.drawSimulation(temp[rand]);
	    } else {
	        var splitContent = this.content.split("!!");
	        var firstModule = splitContent[0].split("##");
	        var questID = firstModule[0].split("||");
	        this.drawSimulation(questID[0]);
	    };
	};
};

componentRPL.prototype.onHide = function() //pg2-rpl_audio
{
	this.audioStop();
};

componentRPL.prototype.rePaint = function()
{
	return;
};

componentRPL.prototype.preload = function(image) 
{       
	if (image.indexOf('.swf') > -1 || image.indexOf('.avi') > -1) return;
	if (document.images) {
		var img = new Image();
		this.preImages.push(img)
		this.preImages[this.preImages.length-1].src = this.resourcesURL + image;
	};
};   

componentRPL.prototype.makeListOfImages = function() 
{
	var splitContent = this.content.split("!!");//podział na poszczególne pytania
    var secondModule = splitContent[1].split("##");

	for (var i=0; i < secondModule.length-1; i++) {
		var temp = secondModule[i].split(";;");
		this.preload(temp[1]);
	};

	this.preload(this.cloudSmall);
	this.preload(this.cloudAverage);
	this.preload(this.cloudBig);
	this.preload(this.buttonSrc);
	this.preload(this.buttonOkSrc);
	this.preload(this.buttonReset);

	this.preloadCheck(0);
};

componentRPL.prototype.preloadCheck = function(k)
{
	var i = 0;      
	var b = 0;     
	var counter = k+1;
	var length = this.preImages.length;
	var errors = this.preImages[i].complete;

	while (i < length && this.preImages[i].complete || b-->0) {
		i++;   
	};

	if (i >= length || counter == 50) {  //czekaj 30 sek. czy zaladowały się grafiki jak nie to wyświetl błąd
		//if (!errors) showMessage("There was errors during preload images."); //pg2-removed
	} else {
		this.preloadTimer = setTimeout('page.all["'+this.id+'"].preloadCheck('+counter+');',10);
	};
	return;
};

componentRPL.prototype.setGroupList = function()
{
	// wkładanie do grupy np. grA##1##2##!!grB##3##4##5 
    var splitContent = this.content.split("!!");
    var firstModule = splitContent[0].split("##");
    var secondModule = splitContent[1].split("##");
    var groups = new Array();
    var temp = '';
    var index = 0;

    for (var i=0; i < firstModule.length; i++) {
        var ans = secondModule[i].split(";;");
        var answers = ans[0].split("@@");
        var quest = firstModule[i].split("||");

        if (answers[0] != '') {
            if (temp.indexOf(answers[0]) == -1) {
                temp += answers[0] + '!!';
                groups[index] = answers[0];
                groups[index] += '##' + quest[0];             
                index += parseInt(1);
            } else {
                var k = -1;
                do {
                    k += parseInt(1);
                } while ((groups[k].indexOf(answers[0]) == -1) && (answers[0] != ''));
                groups[parseInt(k)] += '##' + quest[0];
            };
        };
    };
    for (var i=0; i < groups.length; i++) {
        this.groupList += groups[i] + '!!';
	};
};

componentRPL.prototype.setListQuestionsId = function()
{
	var splitContent = this.content.split("!!"); // content !! summary    
	var questionArr = splitContent[0].split("##");

    for (var i=0; i < questionArr.length; i++) {
        var oneQuestion = questionArr[i].split("||");
        this.listQuestionsId += oneQuestion[0] + "!!";
    };
    return questionArr.length-1;
};

componentRPL.prototype.getPointsMax = function(module)
{
    if (this.lastQuestion == 0) {
        var max = 0;
        for (var i=2; i < module.length; i++ ) {
            var point = module[i].split("&&");
            if (max < point[2]) max = point[2];
        };
        this.maxPoints += parseInt(max);
        this.numberOfQuestion += 1;
        this.askedQuestions += 1;
    };
};

componentRPL.prototype.rememberGroup = function(qId)
{
	//grA##1##2##!!grB##3##4##5 
	var splited = this.groupList.split('!!');
	var i = -1;

	var splitContent = this.content.split("!!");//podział na poszczególne pytania
    var i = parseInt(-1); 

    var firstModule = splitContent[0].split("##");//firstModule - modul zawierający: numer pytania, tresc pytania i grafikę do pytania;
    do {        
        i += 1;
        var question = firstModule[i].split("||");
    } while (qId != question[0])

	var secondModule = splitContent[1].split("##");     
    var splitedAnswers = secondModule[[parseInt(i)]].split(";;");//odnalezienie odpowiedzi 
    question = firstModule[parseInt(i)].split("||");

	var t = splitedAnswers[0].split('@@');
	if (typeof(t[1]) != 'undefined') this.listOfUsedGroup += t[1] + '##';
};

componentRPL.prototype.audioPlay = function(file)
{
	if (file == '') return;
	var res = false;
	var player = document.getElementById(this.id+'AudioMediaPlayer');

	/*if (player) { //pg2-rpl_audio -removed, ain't working
		player.url = this.resourcesURL + file;
		if (this.compAudio.pvWMP7up) {
			if (player.controls) res = player.controls.play();
		} else if (this.compAudio.pvWMP64) {
			res = player.Play();
		};
	};*/

	if (typeof(this.compAudio) != 'undefined' && this.compAudio != null && page) { //pg2-rpl_audio
		//this.compAudio.stop();
		this.compAudio.src = file;
		this.compAudio.setUrl(resourcesURL + file);
		page.pageIsShow = true;
		this.compAudio.mediaURL = resourcesURL + file;
		this.compAudio.repaint();
		if (is.ie) this.compAudio.play(); else setTimeout('pc.' + this.id + '.compAudio.play();', 400); //pg2-mbr_audio_firefox - 400ms instead of 10
	};
	return res;
};

componentRPL.prototype.audioStop = function()
{
	if (this.compAudio != null) this.compAudio.stop(); //actionMediaStop(); //pg2-rpl_audio
};

componentRPL.prototype.hideAllClouds = function()
{
	for (var i=0; i < this.rplCloudsArr.length; i++) {
		this.rplCloudsArr[i].hide();
	};
	for (var k in this.cloudsArr) {
		this.cloudsArr[k][1].hide();
	};
};

componentRPL.prototype.changeTextInCloud = function(questionNo, text)
{
	if (!this.cloudsArr[questionNo]) return;

	this.hideAllClouds();
	var cloudObj = this.cloudsArr[questionNo][1];
	if (cloudObj.execution) {
		cloudObj.show();
		document.getElementById(cloudObj.id + "_contentObj").innerHTML = text;
	} else {
		cloudObj.text.text = text;
		cloudObj.paint();
	};
};

componentRPL.prototype.getSceneObiekt = function(sceneFile, size) 
{
	var t = '';
	switch(size) {
		case 'userSize' : 
			var width = this.screenImageWidth + 'px'; 
			var height = this.screenImageHeight + 'px'; 
			break;
		case 'orginalSize' : 
			var width = '450px'; //it's nessesery to swf and video 
			var height = '225px'; 
			break;
	};

	if (sceneFile.indexOf('.swf') > -1) {
		t += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="https://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="'+ width +'" height="'+ height +'" id="'+ this.id +'flashPlayer" align="middle">';
		t += '  <param name="movie" value="'+ this.resourcesURL + sceneFile +'">';
		t += '  <param name="allowScriptAccess" value="sameDomain" />';
		t += '  <param name="bgcolor" value="transparent">';
		t += '  <param name="quality" value="high">';
		t += '  <param name="play" value="false">';
		t += '  <param name="loop" value="false">';
		t += '  <param name="WMode" value="transparent">';
		t += '  <param name="scale" value="showall">';
		t += '  <param name="salign" value="L">';
		t += '  <param name="FlashVars" value="">';
		t += '  <embed wmode="transparent" src="'+ this.resourcesURL + sceneFile +'" quality="high" bgcolor="transparent" name="'+ this.id +'flashPlayer" type="application/x-shockwave-flash" pluginspage="https://www.macromedia.com/go/getflashplayer" width="'+ width +'" height="'+ height +'"></embed>';
		t += '</object>';
		this.kindOfFile = 'flash';
	} else
	if ((sceneFile.indexOf('.wmv') > -1) || (sceneFile.indexOf('.avi') > -1) || (sceneFile.indexOf('.mpeg') > -1)) {
		if (is.ie) {
			t +='	<OBJECT id="' + this.id + 'MediaPlayer" ';
			t +='		width="' + width + '" height="' + height + '" ';
			t +='		CLASSID=CLSID:6BF52A52-394A-11D3-B153-00C04F79FAA6 ';
			t +='		standby="Loading Microsoft Windows Media Player components..."';
			t +='		TYPE="application/x-oleobject">';
			t +='		<param name="url" VALUE="' + this.resourcesURL + sceneFile + '" />';		
			t +='		<param name="uiMode" value="none" />';
			t +='		<param name="Volume" value="100" />';
			t +='		<param name="ShowControls" VALUE="true" />';
			t +='		<param name="ShowTracker" VALUE="false" />';
			t +='		<param name="ShowStatusBar" VALUE="false" />';
			t +='		<param name="VideoBorder3D" VALUE="false" />';
			t +='		<param name="VideoBorderWidth" VALUE="false" />';
			t +='		<param name="AutoStart" value="false" />';
			t +='		<param name="AnimationAtStart" value="false" />';
			t +='		<param name="TransparentAtStart" value="false" />';
			t +='	</OBJECT>';
		} else {
			t += '<object id="video1MediaPlayer" width="' + width + '" height="' + height + '" data="' + this.resourcesURL + sceneFile + '" type="application/x-ms-wmp">';
			t +='<param name="url" VALUE="' + this.resourcesURL + sceneFile + '" />';		
			t += '<param value="true" name="autostart"/>';
			t += '<param value="none" name="uiMode"/>';
			t += '<param value="false" name="enableContextMenu"/>';
			t += '<param value="false" name="enabled"/>';
			t += '</object>';
		};
		this.kindOfFile = 'wideo';
	} else {
		if (!this.imgAsBckg) { //pg2-LEAN_test
			//t += '<img id="' + this.id + '_img" border="0" src="'+ this.resourcesURL + sceneFile + '"';
			t += '<div id="' + this.id + '_imgDiv" style="border: 0px solid white;"><img id="' + this.id + '_img" border="0" src="'+ this.resourcesURL + sceneFile + '"'; //pg2-fix_img_height -new3 (smaller image)
			//t += '<div id="' + this.id + '_imgDiv" style="border: 1px solid red;"><img id="' + this.id + '_img" border="0" src="'+ this.resourcesURL + sceneFile + '"'; //pg2-test_AWO_2
			//t += ' style="width:' + width + '; height:' + height + ';">'; //pg2
			//t += '>';
			t += '></div>'; //pg2-fix_img_height -new3 (smaller image)
		};
		this.kindOfFile = 'image';
	};
	return t;
};

componentRPL.prototype.drawSimulation = function(questionNo) 
{
	this.sceneCreated = false; //pg2-fix_img_height
	if (this.timerId != null) {
		window.clearTimeout(this.timerId);
		this.timerId = null;
		this.timerCounter = this.timerCounterStartVal;
	};

	this.audioStop();
	this.addSizeDiv();

	var width = this.w - 2*this.borderWidth - 2;
	var height = this.h - 2*this.borderWidth - 2; 

	this._optCount = 0;

	this.QuestionFont = "<font size='"+this.fontSizeQ+"' face='"+this.fontFamilyQ+"' color='"+this.fontColorQ+"'>";
	this.QuestionFontEnd = "</font>";
    if (parseInt(this.fontBoldQ) == 1) {
		this.QuestionFont += "<b>";
		this.QuestionFontEnd = "</b>" + this.QuestionFontEnd;
	};

    this.AnswerFont = "<font size='"+this.fontSizeA+"' face='"+this.fontFamilyA+"' color='"+this.fontColorA+"'>";
	this.AnswerFontEnd = "</font>";
    if (parseInt(this.fontBoldA) == 1) {
		this.AnswerFont += "<b>";
		this.AnswerFontEnd = "</b>" + this.AnswerFontEnd;
	};
	var splitContent = this.content.split("!!");//podział na poszczególne pytania
    var i = parseInt(-1); 
    var firstModule = splitContent[0].split("##");//firstModule - modul zawierający: numer pytania, tresc pytania i grafikę do pytania;
    do {        
        i += 1;
        var question = firstModule[i].split("||");
        var suppose = question[0];//jak nie znajdzie odpowiednika do konca szukania bierze ostatni z listy
    } while ((questionNo != question[0]) && (i < parseInt(firstModule.length-1)));

    /*
    if ((questionNo != question[0]) && (i >= (firstModule.length-1))){ 
        //i = suppose;  
        i = parseInt(i-1);  
    }
  */
	this.idDisplayedQuestion = question[0];
    var secondModule = splitContent[1].split("##");     

	var separateAnswers = secondModule[[parseInt(i)]].split('#@audioFile=');//odnalezienie odpowiedzi 
	var splitedAnswers = separateAnswers[0].split(";;");//odnalezienie odpowiedzi 
    question = firstModule[parseInt(i)].split("||");//odnalezienie pytania

    this.getPointsMax(splitedAnswers);//secondModule - modul zawierający: grupę, grafikę, odpowiedz1, komentarz1, punkty1, idz do1; ... itd

	if (this.imgAsBckg) { //pg2-LEAN_test -to avoid unecessary changes below
		this.screenImageWidth = 1;
		this.screenImageHeight = 1;
	};
	
	//pg2-test_AWO2
	this.screenImageWidth = 1;
	this.screenImageHeight = 1;
	//...
	
	if (this.screenImageWidth != 1 && this.screenImageHeight != 1) {
		var t = '<table dir="'+this.dir+'" border="0" cellpadding="2" cellspacing="'+this.borderAnswerWidth+'" style="width:' + width + 'px; height:' + height + 'px;" >';
		t += '<tr>';
		t += '<td align="center" colspan="2" valign="' + this.screenImageVAlign + '">';
		t += this.getSceneObiekt(splitedAnswers[1], 'userSize');
		// t += '   <img id="' + this.id + '_img" border="0" src="'+ resourcesURL + splitedAnswers[1] + '"';
		// t += '   style="width:' + this.screenImageWidth + 'px; height:' + this.screenImageHeight + 'px">';
		t += '</td>';
		t += '</tr>';
	} else {
		var t = '<table dir="'+this.dir+'" border="0" cellpadding="2" cellspacing="'+this.borderAnswerWidth+'" style="width:' + (width-3) + 'px; height:' + height + 'px;" >'; //pg2-LEAN_test
		if (this.imgAsBckg) { //pg2-LEAN_test
			t = '<img id="' + this.id + '_img" border="0" src="'+ this.resourcesURL + splitedAnswers[1] + '" style="width:' + this.w + 'px; height:' + this.h + 'px;">' +
			'<div id="' + this.id + '_addDiv" style="position:absolute; border:1px transparent solid; left:2px; bottom:5px; width:' + (this.w-6) + 'px; height:auto; overflow:hidden;">' + t;
		} else {
			t = '<div id="' + this.id + '_addDiv" style="position:absolute; border:1px transparent solid; left:2px; bottom:5px; width:' + (this.w-4) + 'px; height:auto; overflow:hidden;">' + t;
		};
		t += '<tr><td align="center" colspan="2" valign="' + this.screenImageVAlign + '"  style="height:' + this.imageHeight + 'px;">';
		//t += '<img id="' + this.id + '_img" src="'+ resourcesURL + splitedAnswers[1] + '" >';

		t += this.getSceneObiekt(splitedAnswers[1], 'orginalSize'); //pg2-LEAN_test
		t += '</td></tr>';
		// t += '<tr><td colspan="2" valign="top" height="20px" id="' + this.id + '_questionText">' + QuestionFont + question[1] + '</font></td></tr>';
		// t += '<tr style="height: 1px;"><td></td></tr>';
	};

	if (this.cloudFrom == 'noCloud') {
		t += '<tr>';
		if (this.imgAsBckg) { //pg2-LEAN_test
			t += '  <td colspan="2" valign="bottom" style="width: 100%" id="' + this.id + '_questionText">';
		} else {
			t += '  <td colspan="2" valign="top" style="width: 100%" id="' + this.id + '_questionText">';
		};
		t += this.QuestionFont + question[1] + this.QuestionFontEnd + '</div></td>';
		t += '</tr>';
		t += '<tr style="height: 1px;"><td></td></tr>';
	} else
	if (this.cloudFrom == 'cloudFromPage') {
		this.changeTextInCloud(question[0], question[1]);
	} else
	if (this.cloudFrom == 'cloudFromRPL') {
		this.showRPLCloud(question[1]);
		this.question1 = question[1]; //pg2-LEAN_test2
	};
	this.questionRemember = question[1];

	//t += '<table border="2" style="width:' + width + 'px; height:' + height + 'px;" >';
    if (this.randomizeAnswers) {//losuje odpowiedzi !
        //answers, randomQuestion, thisQuestion, imge - parametry
        t += this.randomAnswer(splitedAnswers, this.randomizeQuestions, question[0]);
    } else {
        var color ='';
        var counter = 0;

		var img = new Image();
		img.src = this.resourcesURL + this.buttonSrc;
		var imageWidth = img.width;			

        for (var i=2; i < splitedAnswers.length-1; i++) {
            var answerArr = splitedAnswers[i].split("&&");//0-odp, 1-com,2-points,3-goto
			this.answersArrRemember.push(answerArr[0]);

            if (answerArr[0] == '') answerArr[0] = '';
            if (answerArr[1] == '') answerArr[1] = '';  
            if (answerArr[2] == '') answerArr[2] = 0;  

            if (counter == 0) {
               color = this.answer1Color;
               counter = 1;
            } else {
               color = this.answer2Color;
               counter = 0;
            };

            if (this.randomizeQuestions) {
				var changed = this.changeRabits(answerArr[1]);//zamienia zajaczki tzn " lub ' na \" lub \'
				var commands = question[0] + ',' + answerArr[2] + ',\'' + changed + '\'' + ',\'' + splitedAnswers[1] + '\',' + eval(this.answersArrRemember.length-1);
                //thisQuestion, points, comment, graph
                if (answerArr[0] != '') {
					if (this.isAnswerRollover) {
						t += '<tr style="background: '+color+';" onMouseover="this.style.background=\''+this.answerRolloverColor+'\'" onMouseout="this.style.background=\''+color+'\'">';
					} else {
						t += '<tr style="background: '+color+';">';
					};

					t += '<td id="' + this.id + '_tdopt' + this._optCount + '" valign="' + this.buttonVAlign + '" height="20px">';
					if (this.buttonSrc.indexOf('.png') != -1 && is.ie && is.ie55UP && !is.ie7UP) {
						t += '<span id="' + this.id + '_but3" src="' + this.resourcesURL + this.buttonSrc + '"';
						t += ' style="width:'+imageWidth+'px; height:100%; cursor: pointer;';
						t += ' filter:progid:DXImageTransform.Microsoft.AlphaImageLoader';
						t += '(src=\'' + this.resourcesURL + this.buttonSrc + '\', sizingMethod="scale");" onClick="owner.randomOption(' + commands + ');"></span>';
					} else {
						t += '<img id="' + this.id + '_but3" src="'+ this.resourcesURL + this.buttonSrc + '" style="cursor: pointer" onClick="owner.randomOption(' + commands + ');">';
					};
					t += '</td>';
					t += '<td id="' + this.id + '_opt' + i.toString() + '" style="width:95%; cursor:pointer;"  onClick="owner.randomOption(' + commands + ');">'+ this.AnswerFont + answerArr[0] + this.AnswerFontEnd+'</td></tr>';
                };
            } else {
                //srawdzenie czy jest to skok do pytania czy skok do grupy question[0]
                var groupId = answerArr[3];
                if ((groupId.indexOf("g") != -1) || (groupId.indexOf("End") != -1)) {
                //jesli jest pusty lub jest skok do grupy
                    answerArr[3] = 1;
                    var group = groupId;
                } else {
					if (answerArr[3] == '') answerArr[3] = 0;
                    var group = '';
				};
                //chosenOption (optNo, points, comment, graph, group_name);
				var changed = this.changeRabits(answerArr[1]);//zamienia zajaczki tzn " lub ' na \" lub \'
				var commands = answerArr[3] + ',' + answerArr[2] + ',\'' + changed + '\'' + ',\'' + splitedAnswers[1] + '\'' + ',\'' + group + '\',' + eval(this.answersArrRemember.length-1);
                //var commands = answerArr[3] + ',' + answerArr[2] + ',' + ',\'' + splitedAnswers[1] + '\'' + ',\'' + group + '\'';
                if (answerArr[0] != '') {
					if (this.isAnswerRollover) {
						t += '<tr style="background: '+color+';" onMouseover="this.style.background=\''+this.answerRolloverColor+'\'" onMouseout="this.style.background=\''+color+'\'">';
					} else {
						t += '<tr style="background: '+color+';">';
					};

					t += '<td id="' + this.id + '_tdopt' + this._optCount + '" valign="' + this.buttonVAlign + '" height="20px">';
					if (this.buttonSrc.indexOf('.png') != -1 && is.ie && is.ie55UP && !is.ie7UP) {
						t += '<span id="' + this.id + '_but3" src="' + this.resourcesURL + this.buttonSrc + '"';
						t += ' style="width:'+imageWidth+'px; height:100%; cursor: pointer;';
						t += ' filter:progid:DXImageTransform.Microsoft.AlphaImageLoader';
						t += '(src=\'' + this.resourcesURL + this.buttonSrc + '\', sizingMethod="scale");" onClick="owner.chosenOption(' + commands + ');"></span>';
					} else {
						t += '<img id="' + this.id + '_but3" src="'+ this.resourcesURL + this.buttonSrc + '" style="cursor: pointer" onClick="owner.chosenOption(' + commands + ');">';
					};
					t += '</td>';						
					
					if (this.autofixSceneHeight) { //pg2-test_AWO_2 -do not randomize
						t += '<td id="' + this.id + '_opt' + i.toString() + '" style="width:95%; cursor:pointer;" onClick="owner.chosenOption(' + commands + ');">' +
							'<div id="' + this.id + '_optDiv' + i + '" style="width:auto; height:auto; cursor:pointer;">' +
							this.AnswerFont +
							answerArr[0] +
							this.AnswerFontEnd +
							'</div>' +
							'</td></tr>';
					} else { //previous, default
						t += '<td id="' + this.id + '_opt' + i.toString() + '" style="width:95%; cursor:pointer;" onClick="owner.chosenOption(' + commands + ');">'+ this.AnswerFont + answerArr[0] + this.AnswerFontEnd+'</td></tr>';
					};
                };
            };
			this._optCount++;
        };
    };

	if (!this.imgAsBckg) { //pg2-LEAN_test
	    t += "<tr><td colspan='2'>" +
			 "<div id='" + this.id + "_fixDiv' style='position: absolute; height: 1px; width: " + (this.width-10) + "px;' />" + //pg2-fix_img_height
			 "</td></tr>";
	};
	t += '</table>';
	if (this.imgAsBckg || this.autofixSceneHeight) t += '</div>'; //pg2-LEAN_test //pg2-test_AWO_2_test -stretch options' text

	if (this.compAudio != null) this.compAudio.stop(); //pg2-rpl_audio
	if (typeof(separateAnswers[1]) != 'undefined') this.audioPlay(separateAnswers[1]);	

	this.setHTML(t);
	this.playWideo();
	this.correctSizes(width, height);
};

componentRPL.prototype.playWideo = function(el)
{
	if (this.kindOfFile == 'wideo' ) {
		var player = document.getElementById(this.id + "MediaPlayer");
		if (player) res = player.controls.play();
	};
};

componentRPL.prototype.getPosition = function(el)
{
	var obj = document.getElementById(el);
	if (obj) {
		w = obj.offsetWidth;
		h = obj.offsetHeight;
		if (obj.offsetParent) {
			for (var posX = 0, posY = 0; obj.offsetParent; obj = obj.offsetParent) {
				posX += obj.offsetLeft;
				posY += obj.offsetTop;
			};
			return[posX, posY, w, h];
		} else {
			return[obj.x, obj.y, w, h];
		};
	} else {
		return [0, 0, 0, 0];
	};
};

componentRPL.prototype.correctSizes = function(width, height)
{
	var maxHeight = 0;
	var optCount = this._optCount;

	this._lastQuestSize = -1;

	var questionText = document.getElementById(this.id + "_questionText");
	if (questionText) {
		questionText.style.height = 'auto'; //pg2-fix_img_height
		/*var posArr = this.getPosition(this.id + "_questionText");
		if (posArr[3] < 50)
		{
			this._lastQuestSize = posArr[3];
			
			questionText.style.height = 50;
			maxHeight += 50;
		}else{
			maxHeight += posArr[3];
			this._lastQuestSize = posArr[3];
		}*/
	};

	for (var i=0; i < optCount + 1; i++) {
		var objId = this.id + '_tdopt' + i;
		var posArr = this.getPosition(objId);
		if (posArr[3] != 0) {
			if (posArr[3] < 34) {
				var obj = document.getElementById(objId);
				obj.style.height = 34;
				maxHeight += 34;
			} else {
				maxHeight += posArr[3];
			};
		};
	};

	var offsetH = 20;
	var posArr = this.getPosition(this.id + "_img");

	if (this._lastQuestSize != -1) {
		var questionText = document.getElementById(this.id + "_questionText");
		var arr = this.getPosition(this.id + "_questionText");
		//while (posArr[3] + maxHeight + offsetH > height && questionText.style.height > this._lastQuestSize)
		while (posArr[3] + maxHeight + offsetH > height && arr[3] > this._lastQuestSize) {
			arr = this.getPosition(this.id + "_questionText");
			questionText.style.height = arr[3] - 1;
			maxHeight-=1;
		};
	};

	/*//pg2-fix_img_height -old, removed
	var posArr = this.getPosition(this.id + "_img");
	if (posArr[3] != 0)
	{
		var objt = document.getElementById("__bckg__bg00001_text2"); if (objt) objt.innerHTML = posArr[3] + "," + maxHeight + "," + offsetH + "=" + height;
		if (posArr[3] + maxHeight + offsetH > height)
		{
			var obj = document.getElementById(this.id + "_img");
			obj.style.height = height - maxHeight - offsetH;
		}
	}*/

	this.fixSceneHeight();
	//this.timerId = window.setTimeout("try { pc." + this.id + ".fixSceneHeight(); } catch(e) {};", this.timerCounterTimeout);
};

componentRPL.prototype.fixSceneHeight = function() //pg2-fix_img_height
{
	var isTestAWO = true; //pg2-test_AWO_rem
	var showImgAtTheEnd = (PageInterface.GetValue("state") != psDesigning);
	try {
		if (!this.autofixSceneHeight || this.imgAsBckg) return; //pg2-fix_img_height -new4 -an option to fix it or not
		
		if (this.timerCounter == this.timerCounterStartVal) { //pg2-test_AWO_2 - fix options' width (via additional DIV) for IE purposes
			//var s = '';
			for (var i=0; i<50; i++) {
				var objFontDiv = document.getElementById(this.id + '_optDiv' + i);
				if (objFontDiv) {
					var tdObj = objFontDiv.parentElement;
					if (tdObj) {
						objFontDiv.style.width = (this.w - tdObj.offsetLeft - 5) + 'px';
					};
				};
				
				/* var objTD = document.getElementById(this.id + '_tdopt' + i);
				var objFontDiv = document.getElementById(this.id + '_optDiv' + i);
				//s += '\n' + i + 'tdopt' + i + ': ' + objTD + ', optDiv' + i + ':' + objFontDiv;
				if (objTD && objFontDiv) {
					objFontDiv.style.width = (this.w - (objTD.offsetWidth+(6*objTD.offsetLeft))) + 'px';
					//s += ', ' + objFontDiv.style.width + '\n';
				};// else break; */
			};
			//alert(s);
			
			var commentDiv = document.getElementById(this.id + '_commentDiv');
			var commentBtn = document.getElementById(this.id + '_commentButton');
			if (commentDiv && commentBtn) {
				commentDiv.style.width = this.w - (commentBtn.offsetWidth+(6*commentBtn.offsetLeft)) + 'px';
			};
		};

		var divFixTop = -1;
		var divMainHeight = -1;
		var imgCurrentHeight = -1;
		var newHeight = -1;

		var objMainDiv = document.getElementById(this.id);
		var objFixDiv = document.getElementById(this.id + "_fixDiv");
		var objImg = document.getElementById(this.id + "_img");

		var objImgDiv = document.getElementById(this.id + "_imgDiv"); //pg2-fix_img_height -new3 (smaller image)
		if (this.timerCounter == this.timerCounterStartVal) this.origImageHeight = -1;

		if (objMainDiv && objFixDiv && objImg && objImgDiv) { //pg2-fix_img_height -new3 (smaller image)

			if (objImg && isTestAWO && showImgAtTheEnd) objImg.style.visibility = 'hidden'; //pg2-test_AWO_rem

			if (this.screenImageHeight > 1 && this.screenImageWidth > 1) { //pg2-fix_img_height -new4 -use defined imgHeight
				this.origImageHeigth = this.screenImageHeight; //pg2-test
			} else {
				if (this.timerCounter < this.timerCounterStartVal-5 && this.origImageHeight == -1 && objImg.offsetHeight > 0) {
					this.origImageHeight = objImg.offsetHeight; //pg2-fix_img_height -new3 (smaller image)
				};
				if (this.origImageHeight < objImg.offsetHeight) { //if (this.origImageHeight < objImg.offsetHeight) {
					//alert(this.origImageHeight + ', ' + objImg.offsetHeight);
					this.origImageHeight = objImg.offsetHeight;
				};
			};

			divFixTop = objFixDiv.offsetTop;
			divMainHeight = objMainDiv.offsetHeight;

			var offs = 0;

			if (divFixTop > divMainHeight) {
				//pg2-old one
				imgCurrentHeight = objImg.offsetHeight;
				newHeight = imgCurrentHeight - (divFixTop - divMainHeight);
				//objImg.style.height = newHeight + "px";

				//pg2-fix_img_height -new3 (smaller image)
				offs = objImgDiv.offsetHeight - Math.abs(divFixTop - divMainHeight);
				objImgDiv.style.height = offs + 'px';
			} else
			if (divFixTop < divMainHeight) { //pg2-fix_img_height -new3 (smaller image)
				offs = objImgDiv.offsetHeight + ((divMainHeight-divFixTop)*2);
				objImgDiv.style.height = offs + 'px';
			};

			if (this.origImageHeight != -1 && ((this.timerCounter < 15 && is.ie) || (!is.ie && this.timerCounter == 1)) ) {//this.timerCounter == 1) { //pg2-fix_img_height -new3 (smaller image) -fit image do parent div in last step - speeding up
				if (this.origImageHeight >= objImgDiv.offsetHeight) {
					if (!isTestAWO) objImg.style.height = (objImgDiv.offsetHeight - 2) + 'px'; //pg2-test_AWO_rem
				} else
				if (this.origImageHeight < objImgDiv.offsetHeight) {
					//offs = Math.floor((objImgDiv.offsetHeight-this.origImageHeight-5)/2);
					//offs = Math.floor((objImgDiv.offsetHeight-this.origImageHeight-5)/2);
					objImg.style.position = 'relative';
					objImg.style.top = '1px'; //objImg.style.top = offs + 'px';
				};
			};

			if (divFixTop > divMainHeight && this.timerCounter == 1) {//if (this.timerCounter == 1 && this.origImageHeight < 220) {
				//alert(this.origImageHeight + '\n\n' + divFixTop + '\n\n' + divMainHeight);
				objImgDiv.style.height = objImgDiv.offsetHeight - (divFixTop-divMainHeight);
				//alert(imgCurrentHeight - (divFixTop - divMainHeight) + ' : ' + imgCurrentHeight);
			};
		};

		this.timerCounter--;

		/*var obj = document.getElementById('__bckg__bg00001_text2');
		if (obj) {
			obj.innerHTML = this.timerCounter;
		}*/
		
		if (this.timerCounter <= 0) {
			window.clearTimeout(this.timerId);
			this.timerId = null;
			this.timerCounter = this.timerCounterStartVal;
			if (objImg && objImgDiv) { //
				objImgDiv.style.width = (this.w - (objImgDiv.offsetLeft*4)) + 'px';
				//objImgDiv.style.top = '0px';
				var divHeight = objImgDiv.style.height;
				if (divHeight != '') {
					divHeight = divHeight.replace('px', '');
					objImg.style.height = (parseInt(divHeight)-2) + 'px';
					
					var imgWidth = objImg.offsetWidth;
					//var imgDivWidth = objImgDiv.offsetWidth;
					if (imgWidth > this.w - (objImgDiv.offsetLeft*4)) {
						objImg.style.height = '';
						objImg.style.width = objImgDiv.style.width; //this.w + 'px';
						objImgDiv.parentElement.align = 'left';
						//objImgDiv.parentElement.valign = 'top'; //pg2-test_AWO_rem
					};
				};
				objImgDiv.parentElement.valign = 'top'; //pg2-test_AWO_rem
				//objImgDiv.parentElement.align = 'left'; //pg2-test_AWO_rem
				if (isTestAWO) {
					objImg.style.visibility = 'visible'; //pg2-test_AWO_rem
				};
			};
		} else {
			this.timerId = window.setTimeout("try { pc." + this.id + ".fixSceneHeight(); } catch(e) {};", this.timerCounterTimeout); //1
		};
	} catch(e) {};
};

componentRPL.prototype.changeRabits = function(coment)
{
	coment = coment.replace(/"/g, "&quot;");
	coment = coment.replace(/'/g, "&#146;");
	return coment;
};

componentRPL.prototype.randomAnswer = function(answers, randomQuestion, thisQuestion)
{
    var rand = 0;
    var i = parseInt(0);
    var randomed = '';
    var listUsedAnswers = '';
    var counter = 0;
    var color = '';

	var img = new Image();
	img.src = this.resourcesURL + this.buttonSrc;
	var imageWidth = img.width;			
	var imageHeight = img.height;
    do {
        rand = parseInt(Math.random()*(answers.length-3));
        if (listUsedAnswers.indexOf(rand) == -1) {
            listUsedAnswers += rand;            
            var answersRow = answers[rand+2].split("&&");//0-odp, 1-com,2-points,3-goto
			this.answersArrRemember.push(answersRow[0]);

            if (answersRow[0] == '') answersRow[0] = '';
            if (answersRow[1] == '') answersRow[1] = '';  
            if (answersRow[2] == '') answersRow[2] = 0;
            if (counter == 0) {
               color = this.answer1Color;
               counter = 1;
            } else {
               color = this.answer2Color;
               counter = 0;
            };

			if (randomQuestion == 1) {
                //thisQuestion, points, comment, graph
				var changed = this.changeRabits(answersRow[1]);//zamienia zajaczki tzn " lub ' na \" lub \'
				var commands = thisQuestion + ',' + answersRow[2] + ',\'' + changed + '\'' + ',\'' + answers[1] + '\',' + eval(this.answersArrRemember.length-1);
                if (answersRow[0] != '') {
					if (this.isAnswerRollover) {
						randomed += '<tr style="background: '+color+';" onMouseover="this.style.background=\''+this.answerRolloverColor+'\'" onMouseout="this.style.background=\''+color+'\'">';
					} else {
						randomed += '<tr style="background: '+color+';">';
					};
					randomed += '<td id="' + this.id + '_tdopt' + this._optCount + '" valign="' + this.buttonVAlign + '" height="20px">';
					if (this.buttonSrc.indexOf('.png') != -1 && is.ie && is.ie55UP && !is.ie7UP) {
						randomed += '<span id="' + this.id + '_but3" src="' + this.resourcesURL + this.buttonSrc + '"';
						randomed += ' style="width:'+imageWidth+'px; height:'+imageHeight+'px; cursor: pointer;';
						randomed += ' filter:progid:DXImageTransform.Microsoft.AlphaImageLoader';
						randomed += '(src=\'' + this.resourcesURL + this.buttonSrc + '\', sizingMethod="scale");" onClick="owner.randomOption(' + commands + ');"></span>';
					} else {
						randomed += '<img id="' + this.id + '_but3" src="'+ this.resourcesURL + this.buttonSrc + '" style="cursor: pointer" onClick="owner.randomOption(' + commands + ');">';
					};
					randomed += '</td>';
					randomed += '<td id="' + this.id + '_opt' + i.toString() + '" style="width:95%; cursor:pointer; " onClick="owner.randomOption(' + commands + ');">'+ this.AnswerFont + answersRow[0] + this.AnswerFontEnd+'</td></tr>';
                };
            } else {
                //srawdzenie czy jest to skok do pytania czy skok do grupy
                var groupId = answersRow[3];
                if ((groupId.indexOf("g") != -1) || (groupId.indexOf("End") != -1)) {
                //jesli jest pusty lub jest skok do grupy
                    answersRow[3] = thisQuestion;
                    var group = groupId;
                } else {
                    if (answersRow[3] == '') answersRow[3] = 0; 
                    var group = '';
                };
				var changed = this.changeRabits(answersRow[1]);//zamienia zajaczki tzn " lub ' na \" lub \'
				var commands = answersRow[3] + ',' + answersRow[2] + ',\'' + changed + '\'' + ',\'' + answers[1] + '\'' + ',\'' + group + '\',' + eval(this.answersArrRemember.length-1);
                if (answersRow[0] != '') {
					if (this.isAnswerRollover) {
						randomed += '<tr style="background: '+color+';" onMouseover="this.style.background=\''+this.answerRolloverColor+'\'" onMouseout="this.style.background=\''+color+'\'">';
					} else {
						randomed += '<tr style="background: '+color+';">';
					};

					randomed += '<td id="' + this.id + '_tdopt' + this._optCount + '" valign="' + this.buttonVAlign + '" height="20px">';
					if (this.buttonSrc.indexOf('.png') != -1 && is.ie && is.ie55UP && !is.ie7UP) {
						randomed += '<span id="' + this.id + '_but3" src="' + this.resourcesURL + this.buttonSrc + '"';
						randomed += ' style="width:'+imageWidth+'px; height:'+imageHeight+'; cursor: pointer;';
						randomed += ' filter:progid:DXImageTransform.Microsoft.AlphaImageLoader';
						randomed += '(src=\'' + this.resourcesURL + this.buttonSrc + '\', sizingMethod="scale");" onClick="owner.chosenOption(' + commands + ');"></span>';
					} else {
						randomed += '<img id="' + this.id + '_but3" src="'+ this.resourcesURL + this.buttonSrc + '" style="cursor: pointer" onClick="owner.chosenOption(' + commands + ');">';
					};
					randomed += '</td>';
					
					if (this.autofixSceneHeight) { //pg2-test_AWO_2 -randomized options
						randomed += '<td id="' + this.id + '_opt' + i.toString() + '" style="width:95%; cursor: pointer;" onClick="owner.chosenOption(' + commands + ');">' +
									'<div id="' + this.id + '_optDiv' + i + '" style="width:auto; height:auto; cursor:pointer;">' +
									this.AnswerFont +
									answersRow[0] +
									this.AnswerFontEnd +
									'</div>' +
									'</td></tr>';
					} else { //previous, default
						randomed += '<td id="' + this.id + '_opt' + i.toString() + '" style="width:95%; cursor: pointer;" onClick="owner.chosenOption(' + commands + ');">'+ this.AnswerFont + answersRow[0] + this.AnswerFontEnd+'</td></tr>';
					};
                };
            };
            i += 1;
        };
		this._optCount++;
    } while (i != (answers.length-3));

    return randomed;
};

componentRPL.prototype.chosenOption = function(optNo, points, comment, graph, group_name, answerArrID)
{
	this.points = parseInt(this.points) + parseInt(points);
	
	if (!this.groupAnswers["answer"+points.toString()]) {
		this.groupAnswers["answer"+points.toString()] = 0;
	};
	this.groupAnswers["answer"+points.toString()]++;

	if (this.panelRPLOBJ) {
		this.panelRPLOBJ.showQuestionAndAnswerAtPanel(this.questionRemember, this.answersArrRemember[answerArrID])
	};

	if (this.displayCommentToGroup) {// jak jest komentarz do grup
		this.rememberGroup(this.idDisplayedQuestion);
	} else
	if (this.comments == "") {
		this.comments += comment;
	} else {
		this.comments += "||" + comment;
	};

    if ((group_name != '') && (group_name != 'End')) {
        var gr = this.groupList.split("!!");
        var k = -1;
        //znajdz grupę
        do {
            k += parseInt(1);
        } while ((gr[k].indexOf(group_name) == -1) && (k < (gr.length-2)));

        if ((gr[k].indexOf(group_name) == -1) && (k >= (gr.length-2))) { //jesli nie znalazłeś do 50 razy żadnego pytania różnego od siebie do skocz do siebie
        } else { //jesli znalazłeś skocz do losowego pytania z tej grupy
            var id= gr[k].split("##");
            rand = parseInt(Math.random()*(id.length-1));
            optNo = id[rand+1];
        };
    } else {
        if (group_name == 'End') {
			if (this.displayComment && comment != '') {
				this.showCommment(comment, graph, optNo, group_name);
				//pg2-fix_img_height -new2 (second scene itd)
				window.clearTimeout(this.timerId);
				this.timerId = null;
				this.timerCounter = this.timerCounterStartVal;
				
				this.timerId = window.setTimeout("try { pc." + this.id + ".fixSceneHeight(); } catch(e) {};", this.timerCounterTimeout);
				//...
				this.audioStop(); //pg2-mbr_audio_firefox
				return;
			};
			this.checkIsSummaryDisplay();
			this.audioStop(); //pg2-mbr_audio_firefox
			return;
       };
    };
    //=========================
    if (optNo == 0) optNo = 1; //do testów
	if (this.displayComment && comment != '') {
        this.showCommment(comment, graph, optNo, group_name);
		//pg2-fix_img_height -new2 (second scene itd)
		window.clearTimeout(this.timerId);
		this.timerId = null;
		this.timerCounter = this.timerCounterStartVal;
		this.timerId = window.setTimeout("try { pc." + this.id + ".fixSceneHeight(); } catch(e) {};", this.timerCounterTimeout);
		//...
		this.audioStop(); //pg2-mbr_audio_firefox
        return;
    };

	this.drawSimulation(optNo);
	//pg2-fix_img_height -new2 (second scene itd)
	window.clearTimeout(this.timerId);
	this.timerId = null;
	this.timerCounter = this.timerCounterStartVal;
	this.timerId = window.setTimeout("try { pc." + this.id + ".fixSceneHeight(); } catch(e) {};", this.timerCounterTimeout);
	//...
    return; 
};

componentRPL.prototype.replaceResultText = function() 
{
    if (this.summaryText != '') {
        var tekst = this.summaryText;
		tekst = tekst.replace("[points]", this.points);

		if (this.userMaxPoints == 0) {
			var perc = parseInt((this.points*100)/this.maxPoints);
			tekst = tekst.replace("[percent]", perc);
			tekst = tekst.replace("[max_points]", this.maxPoints);
		} else {
			var perc = parseInt((this.points*100)/this.userMaxPoints);
			tekst = tekst.replace("[percent]", perc);
			tekst = tekst.replace("[max_points]", this.userMaxPoints);
		};
    };
	if (typeof(me['rplSummaryText' + page.p_globalIndex]) != 'undefined') { //pg2-axa_template
		me['rplSummaryText' + page.p_globalIndex] = tekst;
	};
	return tekst;
};

componentRPL.prototype.executeScript = function() 
{
	if (!this.runScript) return;
	try {
		if (this.displayCommentToGroup) {
			if (this.userMaxPoints != 0) {
				if (this.points == this.userMaxPoints) {
					eval(this.script);
				};
			};
		} else {
			if (this.points == this.maxPoints) {
				eval(this.script);
			};
		};
		if (!this.displayCommentToGroup && this.comments == '') eval(this.script);
	} catch(e) {
		if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.executeScript() eval script execution error\nMessage:\n' + e.message); //pg2
	};
	return;
};

componentRPL.prototype.deleteInfo = function() 
{
	this.points = 0;
	this.maxPoints = 0;
	this.comments = ""; //komentarz do odpowiedzi
	this.numberOfQuestion = 0; //licznik ile pytan zadano
	this.questionList = ''; //lista kolejnych pyta np. 1,4,5,6 
	this.lastQuestion = 0;
	this.listQuestionsId = '';
	this.groupList = '';  
	this.listOfUsedGroup = '';  
	this.askedQuestions = 0;
	this.QuestionFont = '';
	this.AnswerFont = '';
	this.defaultContent = "";
	this.idDisplayedQuestion = 0;

	if (this.panelRPLOBJ) {
		this.panelRPLOBJ.deleteAllRows();
	};  
};

componentRPL.prototype.refreshElement = function()
{
	this.deleteInfo();
};

componentRPL.prototype.setTryAgain = function() 
{	
	this.deleteInfo();
	this.onPaint();
};

componentRPL.prototype.getCompareText = function() 
{
	var rplPageGix = this.rplComparePageName.split(":")[0];
	var lastResult = lms.getCourseData('page_'+rplPageGix+'_rpl');
	var lastPoints = 0;
	if (lastResult) lastPoints = parseInt(lastResult.split("::")[0]);
	var actualPoints = this.points;
	var text = "";
	if (actualPoints > lastPoints) text = this.symBetter; else
	if (actualPoints < lastPoints) text = this.symWorse; else
	if (actualPoints == lastPoints) text = this.symSame;

	text = text.replace('[actual]', actualPoints);
	text = text.replace('[last]', lastPoints);
	return text;
};

componentRPL.prototype.onlyPointsSummary = function()
{
	var t = '';
	t += '<table dir="'+this.dir+'" border="0" style="width:100%; height:100%">';
	t += '<tr><td align="center" style="vertical-align: bottom">';

	var color = this.answer1Color;
	//var color = this.answer2Color;
	if (this.allowResetSimulation()) {	
		t += this.getResetButtonTable(color);
	} else {
		t += this.getPointsText(color);		
	};
	t += '</td></tr></table>';

	this.hideAllClouds();
	this.setHTML(t);
	this.points = 0;
	return;
};

componentRPL.prototype.drawCompareSummary = function()
{
	var width = this.w - 2*this.borderWidth - 2;
	var height = this.h - 2*this.borderWidth - 2; 
	height -= 45;

	var t = '';
	t += '<div style="position: relative; width:' + width + 'px; height:' + (height - (this.fontSizeQ*10)) + 'px; overflow: auto;">';
	t += '<table dir="'+this.dir+'" border="0" style="width:100%;">';
	t += "<tr><td valign='middle' align='center' background-color='transparent'>";
	t += this.getCompareText();
	t += "</td></tr>";
	if (this.allowResetSimulation()) {	
		t += this.getResetButtonTable("", "transparent");
	};
	t += "</table></div>";

	this.hideAllClouds();
	this.setHTML(t);
	this.points = 0;
};

componentRPL.prototype.drawSummaryGroup = function()
{
	var splited = this.listOfUsedGroup.split("##");
    var counter = 0;
	var k = -1;

	var width = this.w - 2*this.borderWidth - 2;
	var height = this.h - 2*this.borderWidth - 2; 
	height -= 45;
	var com = '';

	this.executeScript();

	var t = '<table dir="'+this.dir+'" border="0" style="width:100%;">';
	t += "<tr><td colspan='2' align='center' height='20px'>"+ this.QuestionFont + this.summaryTextUp + this.QuestionFontEnd + "</td></tr>";
	t += '</table>';
	//t += '<div style="width:' + width + 'px; height:' + height + 'px; overflow: scroll;">';
	t += '<div style="position: relative; width:' + width + 'px; height:' + (height - (this.fontSizeQ*10)) + 'px; overflow: auto;">';
	t += '<table dir="'+this.dir+'" border="0" style="width:100%;">';

	var printedGroup = '';
	var color = this.answer1Color;

	if (this.groupComment != '') {
		for (var i=0; i < splited.length-1; i++) {
			if (counter == 0) {
			   color = this.answer1Color;
			   counter = 1;
			} else {
			   color = this.answer2Color;
			   counter = 0;
			};

			k = -1;
			var temp = this.groupComment.split('&&');
			do {
				k++;
				var a = temp[k].split('||');
			} while (splited[i] != a[0]);

			if (printedGroup.indexOf(splited[i]) == -1) {
				printedGroup += splited[i] + '##';
				if (splited[i] != '') {
					t += "<tr><td valign='top' align='center' height='20px' bgcolor='"+color+"'>";
					t += this.AnswerFont+splited[i]+this.AnswerFontEnd;
					t += "</td><td style='width:80%' bgcolor='"+color+"'>";
					t += this.AnswerFont+ a[1] +this.AnswerFontEnd+"</td></tr>";
				};
			};
		};
    };
    //t += "<tr><td style='width:95%' colspan='2' align='right' height='20px' bgcolor='"+color+"'>"+ QuestionFont + tekst +"</font></td></tr>";
    t += "<tr><td colspan='2'></td></tr>";
	t += '</table>';
	t += '</div>';

	if (this.allowResetSimulation()) {	
		t += this.getResetButtonTable(color);
	} else {
		t += this.getPointsText(color);		
	};

	this.hideAllClouds();
	this.setHTML(t);
	this.points = 0;
};

componentRPL.prototype.drawSummary = function() {
    
	var splited = this.comments.split("||");
    var counter = 0;
	var width = this.w - 2*this.borderWidth - 2;
	var height = this.h - 2*this.borderWidth - 2; 
	height -= 45;
	var com = '';
	var t = '<table dir="'+this.dir+'" border="0" style="width:100%;">';
	t += "<tr><td colspan='0' align='center' height='20px'>";
	t += this.QuestionFont + this.summaryTextUp + this.QuestionFontEnd +"</td></tr>";
	t += '</table>';
	t += '<div style="position: relative; width:' + width + 'px; height:' + (height - (this.fontSizeQ*10)) + 'px; overflow: auto;">';
	t += '<table dir="'+this.dir+'" border="0" style="width:100%;">';
	//t += "<tr><td colspan='2' align='center' height='20px'>"+ QuestionFont + this.summaryTextUp+"</font></td></tr>";

	var color = this.answer1Color;
	var number = 1;
    for (var i=0; i < splited.length; i++) {
        if (counter == 0) {
           color = this.answer1Color;
           counter = 1;
        } else {
           color = this.answer2Color;
           counter = 0;
        };
        if (splited[i] != '') {
			t += "<tr><td valign='top' align='center' height='20px' bgcolor='"+color+"'>";
			t += this.AnswerFont+(number)+this.AnswerFontEnd+"</td><td style='width:95%' bgcolor='"+color+"'>";
			t += this.AnswerFont+splited[i]+this.AnswerFontEnd+"</td></tr>";
			number++;
		};
    };

    t += "<tr><td colspan='2'></td></tr>";
	t += '</table>';
	t += '</div>';

	if (this.allowResetSimulation()) {	
		t += this.getResetButtonTable(color);
	} else {
		t += this.getPointsText(color);		
	};

	this.hideAllClouds();
	this.setHTML(t);
	this.points = 0;
	return;
};

componentRPL.prototype.getPointsTextCell = function(color) 
{
	var tekst = this.replaceResultText();
	var t = '';
	t += '<td align="right" bgcolor="'+color+'">'+ this.QuestionFont + tekst + this.QuestionFontEnd + '</td>';
	return t;
};

componentRPL.prototype.getPointsText = function(color) 
{
	var t = "";
	t += '<table dir="'+this.dir+'" cellspacing="0" border="0" style="width:100%;"><tr>';
	t += this.getPointsTextCell(color);
	t += '</tr></table>';
	return t;
};

componentRPL.prototype.getResetButtonTable = function(color) 
{
	var t = "";
	t += '<table dir="'+this.dir+'" cellspacing="0" border="0" style="width:100%;">';
	t += '<tr><td valign="middle" bgcolor="'+color+'">';
	t += this.QuestionFont + this.resetText + this.QuestionFontEnd;
	t += '</td><td bgcolor="'+color+'">';
	t += '<img id="' + this.id + '_reset" src="'+ this.resourcesURL + this.buttonReset;
	t += '"  style="cursor: hand" onClick="pc.'+this.id+'.setTryAgain();"></td>';
	t += this.getPointsTextCell(color);
	t += '</tr></table>';
	return t;	
};

componentRPL.prototype.getSimulationResult = function() 
{
	var perc = 0;
	if (this.userMaxPoints == 0) {
		var perc = parseInt((this.points*100)/this.maxPoints);
	} else {
		var perc = parseInt((this.points*100)/this.userMaxPoints);
	};
	return perc;
};

componentRPL.prototype.drawResetButton = function() {
	var color = this.answer1Color;
	var width = this.w - 2*this.borderWidth - 2;
	var height = this.h - 2*this.borderWidth - 2; 	

	var t = '';	
	t += '<table dir="'+this.dir+'" cellspacing="0" border="0" style="width:'+width+'">';
	t += this.getResetButtonTable("", color);
	t += '</table>';
	this.setHTML(t);
};

componentRPL.prototype.invokeEvents = function()
{
	//if (this.allowResetSimulation()) return;
	//this.invokeEvent('Completed'); //pg2
	var resultInPerc = this.getSimulationResult();	
	if ((resultInPerc >= this.range1Open) && (resultInPerc < this.range1Close)) {
		this.invokeEvent('RPL1stRange');
	} else
	if ((resultInPerc >= this.range2Open) && (resultInPerc <= this.range2Close)) {
		this.invokeEvent('RPL2ndRange');
	} else this.executeScript();    
};

componentRPL.prototype.allowResetSimulation = function()
{
	return (this.resetSimulation && !this.checkAnswer() && PageInterface.GetValue("tryLeft") != 0);
};

componentRPL.prototype.storeResult = function() {
	if (this.rememberResult) {
		var thisPageGix = PageInterface.GetValue('pageGix');
		var storeStr = this.points+"::"+((this.userMaxPoints == 0)?this.maxPoints:this.userMaxPoints);
		lms.setCourseData('page_'+thisPageGix+'_rpl', storeStr);
	};
};

componentRPL.prototype.setEndSimulationInProgress = function()
{	
	if (this.panelRPLOBJ) {
		this.panelRPLOBJ.setEndProgressbar();
	};		
};
componentRPL.prototype.checkIsSummaryDisplay = function() {	
	var visible = this.visible;
	if (this.checkExercise) {
		this.lastQuestion = 1;
		PageInterface.Execute("checkAnswer", this);
    };
	this.storeResult(); //pg2-bo przechodzil q... do nastepnej strony przed zapisaniem wynikow
	this.invokeEvents();	
	//this.storeResult();

	if (this.compareSummary) { //pg2- "if" rearange
		this.drawCompareSummary();
	} else {
		if (this.dontDisplaySummary) {//NIE pokazuj podsumowania
			this.onlyPointsSummary();
		} else
		if (this.displaySummary) {//pokaz podsumowanie
			this.drawSummary();
			this.setEndSimulationInProgress();
		} else
		if (this.displayCommentToGroup) {//pokaz podsumowanie dla grup
			this.drawSummaryGroup();
			this.setEndSimulationInProgress();
		} else
		if (visible) {//pokaz scenke
			this.show();
			this.audioStop();
		};
	};
	this.invokeEvent('Completed'); //pg2-przeniesione
};

componentRPL.prototype.randomOption = function(thisQuestion, points, comment, graph, answerArrID)
{
    //goTo, Points, Comment
    this.listQuestionsId = this.listQuestionsId.replace(thisQuestion+'!!',"");
    var avaiableQuestions = this.listQuestionsId.split("!!");    
    var aQLenght = parseInt(avaiableQuestions.length-1);
    var nextQuestion = 0;
    var index = -1;

    this.points = parseInt(this.points) + parseInt(points);

	if (!this.groupAnswers["answer"+points.toString()]) {
		this.groupAnswers["answer"+points.toString()] = 0;
	};
	this.groupAnswers["answer"+points.toString()]++;
	
	if (this.comments == "") this.comments += comment; else this.comments += "||" + comment;   
    
    rand = parseInt(Math.random()*(avaiableQuestions.length-1));//0 - (ilosc pytan -1)
    nextQuestion = avaiableQuestions[rand];      
	
	if (this.panelRPLOBJ) {
		this.panelRPLOBJ.showQuestionAndAnswerAtPanel(this.questionRemember, this.answersArrRemember[answerArrID])
	};
    
    if (this.listQuestionsId == '') {    
		if (this.displayComment && comment != '') {
            this.showCommment(comment, graph, nextQuestion, 'Not_blank');
            return;
        };
		this.checkIsSummaryDisplay();
        return;
    };
    
    if (this.askedQuestions == this.numberOfAskedQuestons) {
        this.lastQuestion = 1;
		if (this.displayComment && comment != '') {
            this.showCommment(comment, graph, nextQuestion, 'Not_blank');
            return;
        };
		this.checkIsSummaryDisplay();
        return;
    };
    
    //=========================    
    if (this.displayComment && comment != '') {
        this.showCommment(comment, graph, nextQuestion, '');
        return;
    };
    
    this.drawSimulation(nextQuestion);  
};

componentRPL.prototype.nextQuest = function(q) {

    if (q != 0) {
        this.drawSimulation(q);  
    } else {
		this.checkIsSummaryDisplay();
        return;
    };
};

componentRPL.prototype.showCommment = function(answerComment, picture, question, gr_name) {

	var width = this.w - 2*this.borderWidth - 2;
	var height = this.h - 2*this.borderWidth - 2; 

	var t = '<table dir="'+this.dir+'" border="0" style="width:' + (this.imgAsBckg?width-3:width) + 'px; height:' + height + 'px;" >'; //pg2-LEAN_test
	if (this.imgAsBckg) { //pg2-LEAN_test
		t = '<img id="' + this.id + '_img" border="0" src="'+ this.resourcesURL + picture + '" style="width:' + this.w + 'px; height:' + this.h + 'px;">' +
			'<div id="' + this.id + '_addDiv" style="position:absolute; border:1px transparent solid; left:2px; bottom:5px; width:' + (this.w-6) + 'px; height:auto; overflow:hidden;">' + t;
	};
	
	if (!this.imgAsBckg) { //pg2-LEAN_test
		//t += '<tr><td align="center" colspan="2" height="100px"><img id="' + this.id + '_img" src="'+ this.resourcesURL + picture + '"></td></tr>';
		t += '<tr><td align="center" colspan="2" height="100px"><div id="' + this.id + '_imgDiv" style="border: 2px solid white;"><img id="' + this.id + '_img" src="'+ this.resourcesURL + picture + '"></div></td></tr>'; //pg2-fix_img_height -new3 (smaller image)
	};

	if (this.imgAsBckg) t += '<tr><td colspan="2" valign="bottom"></td></tr>'; //pg2-LEAN_test
	if (gr_name == '') {
		if (this.autofixSceneHeight) { //pg2-test_AWO_2 -show comment
			t += '<tr><td id="' + this.id + '_commentButton" width="10%" height="100px" ' + (this.imgAsBckg?'align="center"':'') + '><img id="' + this.id + '_but3" src="'+ this.resourcesURL + this.buttonOkSrc + '" style="cursor: hand;" onClick="owner.nextQuest(' + question + ');"></td><td bgcolor='+this.answer1Color+'>' +
			'<div id="' + this.id + '_commentDiv" style="width:auto; height:auto; cursor:pointer;">' +
			this.AnswerFont + answerComment + this.AnswerFontEnd +
			'</div>' +
			'</td></tr>'; 
		} else { //previous, default
			t += '<tr><td width="10%" height="100px" ' + (this.imgAsBckg?'align="center"':'') + '><img id="' + this.id + '_but3" src="'+ this.resourcesURL + this.buttonOkSrc + '" style="cursor: hand;" onClick="owner.nextQuest(' + question + ');"></td><td bgcolor='+this.answer1Color+'>' + this.AnswerFont + answerComment + this.AnswerFontEnd + '</td></tr>'; 
		};
    } else {
		if (this.autofixSceneHeight) { //pg2-test_AWO_2 -show comment
			t += '<tr><td id="' + this.id + '_commentButton" width="10%" height="100px" ' + (this.imgAsBckg?'align="center"':'') + '>' +
				'<img id="' + this.id + '_but3" src="'+ this.resourcesURL + this.buttonOkSrc + '" style="cursor: hand" onClick="owner.nextQuest(0);"></td>' +
				'<td bgcolor='+this.answer1Color+'>' +
				'<div id="' + this.id + '_commentDiv" style="width:auto; height:auto; cursor:pointer;">' +
				this.AnswerFont + answerComment + this.AnswerFontEnd +
				'</div>' +
				'</td></tr>';
		} else { //previous, default
			t += '<tr><td width="10%" height="100px" ' + (this.imgAsBckg?'align="center"':'') + '><img id="' + this.id + '_but3" src="'+ this.resourcesURL + this.buttonOkSrc + '" style="cursor: hand" onClick="owner.nextQuest(0);"></td><td bgcolor='+this.answer1Color+'>' + this.AnswerFont + answerComment + this.AnswerFontEnd + '</td></tr>';
		};
	};
	if (!this.imgAsBckg) { //pg2-LEAN_test
		t += '<tr><td></td></tr>';
		t += "<tr><td colspan='2'>" +
			 "<div id='" + this.id + "_fixDiv' style='position: absolute; height: 1px; width: " + (this.width-10) + "px;' />" + //pg2-fix_img_height
			 "</td></tr>";
	};
    t += '</table>';
	if (this.imgAsBckg) t += '</div>'; //pg2-LEAN_test
	this.setHTML(t);
};

componentRPL.prototype.checkAnswer = function()
{
	var result = this.parseCheckAnswer(this);
	if (typeof(me['rplResult' + page.p_globalIndex]) != 'undefined') { //pg2-axa_template
		me['rplResult' + page.p_globalIndex] = result?1:0;
	};
	return result;
};

componentRPL.prototype.parseCheckAnswer = function() 
{
	var max = 0;
	if (this.userMaxPoints == 0) {
		max = this.maxPoints;
	} else {
		max = this.maxPoints;
	};
	if (((this.points / max) *100) >= this.correctAnswer) { //pg2- ">=" instead of ">"
		return true;
	} else {
		return false;
	};
};

componentRPL.prototype.getAnswer = function() 
{
	if (this.parseCheckAnswer()) {
		return this.correctAnswer;
	} else {
		var max = 0;
		if (this.userMaxPoints == 0) {
			max = this.maxPoints;
		} else {
			max = this.userMaxPoints;
		};
 		var usAnswer = ((this.points / max) *100);
		this.usrAns = parseInt(usAnswer);
		return this.usrAns;
	};
};

componentRPL.prototype.setAnswer = function(valStr, showCorrect) 
{
	if (showCorrect == null || showCorrect == "undefined") showCorrect = true;
	if (showCorrect) {
		this.usrAns = 100;
	} else {
		this.usrAns = valStr;
	};
};

componentRPL.prototype.makeArrOfClouds = function() 
{
	for (var i=0; i < page.children.length; i++) {
		var obj = page.children[i];
		if (obj.type == 'componentDialogue') {
			if (!this.cloudsArr[obj.step]) this.cloudsArr[obj.step] = new Array();
			this.cloudsArr[obj.step][0] = obj.name;
			this.cloudsArr[obj.step][1] = obj;
		};
	};
};

componentRPL.prototype.interactionsCorrectResponsesCount = function()
{
	var answerCount = 1;
	return answerCount;
};

componentRPL.prototype.interactionsCorrectResponses = function()
{
	//return this.correctAnswersList; //pg2-removed
	return this.correctAnswer; //pg2
};

componentRPL.prototype.interactionsStudentResponse = function()
{
	if (PageInterface.GetValue("isExam")) {
		return "rpl:"+this.getAnswer();	
	} else {
		return this.getAnswer();
	};
};

componentRPL.prototype.interactionsCorrectResponsesAsText = function()
{
	//return this.correctAnswersList; //pg2-removed
	return escape(this.correctAnswer); //pg2
};

componentRPL.prototype.interactionsStudentResponseAsText = function()
{
	return escape(this.getAnswer()); //pg2-escape
};
