﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
componentSingleChoice = function(name) {
	this.componentElement = componentElement;
	this.componentElement(name);

	this.resourcesStatus = "online";
	this.resourcesURL = "";
	this.setAnswerFromPage = "";
	this.correctAnswersList = "";
	this.displayIndexes = new Array();
	this.indexAnswers = new Array();
	this.optCount = 0;

	this.interactions = true;
	this.interactionsType = "choice";
	this.interactionsStudentScore = 0;
};

componentSingleChoice.prototype = new componentElement;

componentSingleChoice.prototype.type = "componentSingleChoice";

componentSingleChoice.prototype.onBaseCreate = function(obj) {
	this.captureMouseEvents();
};

componentSingleChoice.prototype.onCreate = function(obj)
{
	//pg2-pga -removed, required to use quotation marks
	//this.choiceValues = this.choiceValues.replace(new RegExp('#&034', "g"), '');
	//this.answerValuesString = this.answerValuesString.replace(new RegExp('#&034', "g"), '');

	if (!this.imgCheckedArrow) this.imgCheckedArrow = this.imgChecked;
	if (!this.imgNotCheckedArrow) this.imgNotCheckedArrow = this.imgNotChecked;
	if (!this.imgCheckedIncorrectSrc) this.imgCheckedIncorrectSrc = this.imgChecked;
	if (!this.imgNotCheckedIncorrectSrc) this.imgNotCheckedIncorrectSrc = this.imgNotChecked;

	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};

	this.resourcesURL = unescape(this.resourcesURL);

	if (this.allowGF && project.globalFormating) {
		this.fontFamily = project.font.family;
		this.fontSize = project.font.size;
		this.fontColor = project.font.color;
	};

	this.imagesNameArr = [	this.imgChecked, this.imgNotChecked, this.imgCheckedArrow, this.imgNotCheckedArrow, this.imgCheckedIncorrectSrc, this.imgNotCheckedIncorrectSrc ];
	this.getPreloadImagesArr();    

	this.correctAnswersList = this.correctAnswer;
};

componentSingleChoice.prototype.onAfterLoad = function()
{
	if (PageInterface.GetValue("state") != psDesigning) {
		if (page.isExec && PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) { //pg2-
			this.showCAI();
		};
	};
};

componentSingleChoice.prototype.onPaint = function(obj)
{
	var changed = unquotedString(this.choiceValues);
	var prevAnswer = this.getAnswer(); //pg2

	var arrOpt = changed.split("||");
	var arrLength = arrOpt.length;

	this.optCount = arrLength;

	var indexes = "";
	var j;
	var brk = "";
	var width = this.w - this.borderWidth * 2;
	var height = this.h - this.borderWidth * 2;
	var colgrB = '<colgroup>';
	var colgrE = '</colgroup>';
	var colW = '<col width="' + this.imageWidth + '"><col width="' + eval(this.w - this.imageWidth) + '">';
	var tableW = 'width:' + width + 'px;';
	var tableH = 'height:' + height + 'px;';
	var trB = '<tr>';
	var trE = '</tr>';

	if (this.elementsAlign == 'horizontally') {
		colW = '<col width="' + this.imageWidth + '"><col width="' + eval(this.colsWidth - this.imageWidth) + '">';
		tableW = '';
		tableH = '';
		trB = '';
		trE = '';
	};
	var t = '<table border="0" style="' + tableW + ' ' + tableH + ' " id="choice_tab_' + this.id + '" >';
	t += colgrB;

	if (this.elementsAlign == 'horizontally') {
		for (var i = 0; i < arrLength; i++) {
			indexes += brk + i.toString();
			brk = "||";
			t += colW;
		};
	} else {
		for (var i = 0; i < arrLength; i++) {
			indexes += brk + i.toString();
			brk = "||";
		};
		t += colW;
	};
	t += colgrE;

	this.indexAnswers = "";
	var tempArr = indexes.split("||");
	brk = "";

	var setAnsArray = this.setAnswerFromPage.split("||");
	var imageSrc = "";    

	if (page.state == psDesigning) {
		var correctAnswerTmp = this.changeFromInt(this.correctAnswer).split("");
		for (var i = 0; i < arrLength; i++) {
			//pg2-rub
			var opt = arrOpt[i];
			if (!this.useHTML_tags) { //pg2-MBR, AF
				while (opt.indexOf('<') > -1) opt = opt.replace('<', '&lt;');
				while (opt.indexOf('>') > -1) opt = opt.replace('>', '&gt;');
			};

			/*while (opt.indexOf('&lt;br&gt;') > -1) opt = opt.replace('&lt;br&gt;', '<br>'); //pg2-MBR
			while (opt.indexOf('&lt;BR&gt;') > -1) opt = opt.replace('&lt;BR&gt;', '<BR>');
			while (opt.indexOf('&lt;br/&gt;') > -1) opt = opt.replace('&lt;br/&gt;', '<br/>');
			while (opt.indexOf('&lt;BR/&gt;') > -1) opt = opt.replace('&lt;BR/&gt;', '<BR/>');

			while (opt.indexOf('&lt;i&gt;') > -1) opt = opt.replace('&lt;i&gt;', '<i>'); //pg2-AF
			while (opt.indexOf('&lt;I&gt;') > -1) opt = opt.replace('&lt;I&gt;', '<I>');
			while (opt.indexOf('&lt;/i&gt;') > -1) opt = opt.replace('&lt;/i&gt;', '</i>');
			while (opt.indexOf('&lt;/I&gt;') > -1) opt = opt.replace('&lt;/I&gt;', '</I>');*/
			//

			t += trB + '<td style="width: ' + this.imageWidth + ' px;"><img src="' + this.resourcesURL +
			((correctAnswerTmp[eval(arrLength - 1 - i)].toString() == '1') ? (this.imgChecked) : (this.imgNotChecked)) +
			'" id="' +
			this.id +
			'_img_' +
			i.toString() +
			'"></td><td style="color:' +
			this.fontColor +
			'; font-family:' +
			this.fontFamily +
			'; font-size:' +
			getFontSize(this.fontSize, "px") +
			'px;" align="left">' +
			opt + //arrOpt[i] + //pg2-rub
			'</td>' +
			trE;
		};
	} else 
	if (this.randAns) {
		for (var i = 0; i < arrLength; i++) {
			j = Math.round(Math.random() * (arrOpt.length - 1));
			imageSrc = this.imgNotChecked;
			if (this.findInArray(tempArr[j], setAnsArray)) {
				imageSrc = this.imgChecked;
			};

			t += trB + '<td style="width: ' + this.imageWidth + ' px; cursor: pointer;" ';
			t += ' onclick="pc.' + this.id + '.singleChoiceChangeImg(document.getElementById(\''+ this.id + '_img_' + tempArr[j].toString() +'\'), ' + tempArr[j] + ', ' + i + '); "';
			t += '>';
			t += '<img src="' + this.resourcesURL + imageSrc + '" id="' + this.id + '_img_' + tempArr[j].toString() + '"></td>';
			t += '<td style="color:' + this.fontColor + '; font-family:' + this.fontFamily + '; font-size:' + getFontSize(this.fontSize, "px") + 'px;"';
			if (this.imageClick == 0) 
				t += ' onclick="pc.' + this.id + '.setImage(this, ' + tempArr[j] + ', ' + i + ');"';

			//pg2-rub
			var opt = arrOpt[j];
			if (!this.useHTML_tags) { //pg2-MBR, AF
				while (opt.indexOf('<') > -1) opt = opt.replace('<', '&lt;');
				while (opt.indexOf('>') > -1) opt = opt.replace('>', '&gt;');
			};

			/*while (opt.indexOf('&lt;br&gt;') > -1) opt = opt.replace('&lt;br&gt;', '<br>'); //pg2-MBR
			while (opt.indexOf('&lt;BR&gt;') > -1) opt = opt.replace('&lt;BR&gt;', '<BR>');
			while (opt.indexOf('&lt;br/&gt;') > -1) opt = opt.replace('&lt;br/&gt;', '<br/>');
			while (opt.indexOf('&lt;BR/&gt;') > -1) opt = opt.replace('&lt;BR/&gt;', '<BR/>');

			while (opt.indexOf('&lt;i&gt;') > -1) opt = opt.replace('&lt;i&gt;', '<i>'); //pg2-AF
			while (opt.indexOf('&lt;I&gt;') > -1) opt = opt.replace('&lt;I&gt;', '<I>');
			while (opt.indexOf('&lt;/i&gt;') > -1) opt = opt.replace('&lt;/i&gt;', '</i>');
			while (opt.indexOf('&lt;/I&gt;') > -1) opt = opt.replace('&lt;/I&gt;', '</I>');*/
			//

			t += ' id="' + this.id + '_text_' + tempArr[j].toString() + '" align="left">' + opt /*arrOpt[j]*/ + '</td>' + trE; //pg2-rub

			this.indexAnswers += brk + tempArr[j];
			this.displayIndexes['opt' + i] = new Array();
			this.displayIndexes['opt' + i][1] = tempArr[j];
			this.displayIndexes['opt' + i][0] = 0;
			brk = "||";
			arrOpt.splice(j, 1);
			tempArr.splice(j, 1);
		};
	} else {
		for (var i = 0; i < arrLength; i++) {
			imageSrc = this.imgNotChecked;
			if (this.findInArray(i, setAnsArray)) 
				imageSrc = this.imgChecked;
			t += trB + '<td style="width: ' + this.imageWidth + 'px; cursor: pointer;"';
			t += ' onclick="pc.' + this.id + '.singleChoiceChangeImg(document.getElementById(\''+ this.id + '_img_' + i +'\'), ' + i + ', ' + i + ');"';
			t += ' >';
			t += '<img src="' + this.resourcesURL + imageSrc + '" id="' + this.id + '_img_' + i.toString() + '" ></td>';
			t += '<td style="color:' + this.fontColor + '; font-family:' + this.fontFamily + '; font-size:' + getFontSize(this.fontSize, "px") + 'px;"';
			if (this.imageClick == 0) 
				t += ' onclick="pc.' + this.id + '.setImage(this, ' + i + ', ' + i + ');"';
				
			//pg2-rub
			var opt = arrOpt[i];
			if (!this.useHTML_tags) { //pg2-MBR, AF
				while (opt.indexOf('<') > -1) opt = opt.replace('<', '&lt;');
				while (opt.indexOf('>') > -1) opt = opt.replace('>', '&gt;');
			};

			/*while (opt.indexOf('&lt;br&gt;') > -1) opt = opt.replace('&lt;br&gt;', '<br>'); //pg2-MBR
			while (opt.indexOf('&lt;BR&gt;') > -1) opt = opt.replace('&lt;BR&gt;', '<BR>');
			while (opt.indexOf('&lt;br/&gt;') > -1) opt = opt.replace('&lt;br/&gt;', '<br/>');
			while (opt.indexOf('&lt;BR/&gt;') > -1) opt = opt.replace('&lt;BR/&gt;', '<BR/>');
			
			while (opt.indexOf('&lt;i&gt;') > -1) opt = opt.replace('&lt;i&gt;', '<i>'); //pg2-AF
			while (opt.indexOf('&lt;I&gt;') > -1) opt = opt.replace('&lt;I&gt;', '<I>');
			while (opt.indexOf('&lt;/i&gt;') > -1) opt = opt.replace('&lt;/i&gt;', '</i>');
			while (opt.indexOf('&lt;/I&gt;') > -1) opt = opt.replace('&lt;/I&gt;', '</I>');*/
			//

			t += ' id="' + this.id + '_text_' + i.toString() + '" align="left">' + opt /*arrOpt[i]*/ + '</td>' + trE; //pg2-rub

			this.indexAnswers = indexes;
			this.displayIndexes['opt' + i] = new Array();
			this.displayIndexes['opt' + i][1] = i;
			this.displayIndexes['opt' + i][0] = 0;
		};
	};
	t += '</table>';
	this.setHTML(t);

	//this.setAnswer(prevAnswer, false); //pg2
};

componentSingleChoice.prototype.showCAI = function() {
	var correctAnswer = this.changeFromInt(this.correctAnswer).split("");
	var checked = false;
	var correct = false;
	var j = 0;

	for (var i = 0; i < this.optCount; i++) {
		obj = document.getElementById(this.id + "_img_" + i.toString());
		if (obj) {
			j = 0;
			while (this.displayIndexes['opt' + j][1] != i.toString() && j < this.optCount) j++;
			
			if (this.displayIndexes['opt' + j][0].toString() == '1') {
				checked = true;
			} else {
				checked = false;
			};

			if (correctAnswer[eval(this.optCount - 1 - i)].toString() == '1') {
				correct = true;
			} else {
				correct = false;
			};

			if (checked && correct) {
				this.setImageSrc(this.resourcesURL + this.imgCheckedArrow, obj);
			} else 
			if (!checked && correct) {
				this.setImageSrc(this.resourcesURL + this.imgNotCheckedIncorrectSrc, obj);
			} else 
			if (!checked && !correct) {
				this.setImageSrc(this.resourcesURL + this.imgNotCheckedArrow, obj);
			} else 
			if (checked && !correct) {
				this.setImageSrc(this.resourcesURL + this.imgCheckedIncorrectSrc, obj);
			};
		};
	};
};

componentSingleChoice.prototype.onRepaint = function(obj) {
	if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) {
		this.showCAI();
	};
};

componentSingleChoice.prototype.findInArray = function(item, itemArray) {
	for (var k = 0; k < itemArray.length; k++) {
		if (itemArray[k].toString() == item.toString()) 
			return true;
	};
	return false;
};

componentSingleChoice.prototype.isInArray = function(array, value) {
	for (var i = 0; i < array.length; i++) {
		if (array[i].toString() == value.toString()) 
			return true;
	};
	return false;
};

componentSingleChoice.prototype.parseCheckAnswer = function(obj) {
	if (!obj) return (false);

	if (obj.getAnswer().toString() == obj.correctAnswer) return true;
	else return false;
};

componentSingleChoice.prototype.checkAnswer = function() {
	return (this.parseCheckAnswer(this));
};
componentSingleChoice.prototype.getAnswer = function()
{
	if (this.ignoreAnswer) return "";
	valStr = "";

	var form = null;
	var j = 0;

	for (var i = 0; i < this.optCount; i++) {
		j = 0;
		while (this.displayIndexes['opt' + j][1] != i.toString() && j < this.optCount) 
			j++;
		valStr = this.displayIndexes['opt' + j][0] + valStr;
	};
	valStr = valStr.split("").join("||");
	valStr = this.changeToInt(valStr);

	return (valStr);
};

componentSingleChoice.prototype.setAnswer = function(valStr, showCorrect)
{
	if (showCorrect == null || showCorrect == "undefined") showCorrect = true; else showCorrect = false;
	//if (!showCorrect && valStr == '') return; //pg2-IE10 -removed again, the problem wasn't here
	//if ((valStr == "" || valStr == null || typeof(valStr) == "undefined" || valStr == "null") && !showCorrect) return (valStr); //pg2- replace with the code below
	if (valStr == "" || valStr == null || typeof(valStr) == "undefined" || valStr == "null") { //pg2
		valStr = "0";
	};

	var obj = null;
	var arrValStr = this.changeFromInt(valStr).split("");
	var correct = this.changeFromInt(this.correctAnswer).split("");

	var checked = false;
	if (showCorrect) {
		arrValStr = correct
	};

	var j = 0;
	for (var i = 0; i < this.optCount; i++) {
		j = 0;
		while (this.displayIndexes['opt' + j][1] != i.toString() && j < this.optCount - 1) j++;
		obj = document.getElementById(this.id + "_img_" + i);
		if (obj) {
			if (arrValStr[ eval(this.optCount-1-i) ].toString() == '1') {
				checked = true;
				this.displayIndexes['opt' + j][0] = 1;
			} else {
				checked = false;
				this.displayIndexes['opt' + j][0] = 0;
			};
			this.setImageSrc(this.resourcesURL + (checked ? this.imgChecked : this.imgNotChecked), obj);
		};
	};
	this.onRepaint();
	return (valStr);
};

componentSingleChoice.prototype.changeToInt = function(str)
{
	var bin = str.split("||");
	if (bin.length == 1 && str.length > 1 && str.indexOf('||') == -1) { //pg2-if the string was delivered without any separators, simply as '0101'...
		delete bin;
		bin = str.split('');
	};
	var dec = 0;
	var tempPow = 0;

	for (var i = bin.length - 1; i > -1; i--) {
		if (bin[i] != '0' && bin[i] != '1') { //pg2-if there was given for example '0105', itsn't binary
			delete bin;
			return -1;
		};
		tempPow = bin[i] * Math.pow(2, bin.length - 1 - i);
		dec += tempPow;
	};
	delete bin; //pg2-clean up
	return dec;
};

componentSingleChoice.prototype.changeFromInt = function(str) {
	if (isNaN(str) || str == null || typeof(str) == "undefined" || str == "null" || str == "") return "";
	if (str == -1 || str == '-1') return ''; //pg2- in case of -1, here would be an "neverending loop"

	var arrTemp = "", brk = "";
	var dec = parseInt(str);
	var oct = "";

	while (dec != 0) {
		oct = (dec % 2) + oct;
		dec = Math.floor(dec / 2);
	};
	while (oct.length < this.optCount) {
		oct = 0 + oct;
	};
	return oct;
};

componentSingleChoice.prototype.lock = function() {
	this.locked = true;
};

componentSingleChoice.prototype.unlock = function() {
	this.locked = false;
};

componentSingleChoice.prototype.checkIsChanged = function() {
	return this.isChanged;
};

componentSingleChoice.prototype.setImage = function(obj, checkId, checkNo) {
	if (this.locked) return false;
	var objImg = null;

	for (var i = 0; i < this.optCount; i++) {
		objImg = document.getElementById(this.id + "_img_" + i.toString());
		if (objImg) {
			this.displayIndexes['opt' + i][0] = 0;
			this.setImageSrc(this.resourcesURL + this.imgNotChecked, objImg);
		};
	};

	var name = obj.id.replace("_text_", "_img_");
	objImg = document.getElementById(name);
	if (objImg) {
		this.singleChoiceChangeImg(objImg, checkId, checkNo);
	};
};

componentSingleChoice.prototype.singleChoiceChangeImg = function(obj, checkId, checkNo) {
	if (this.locked) return false;
	this.isChanged = true;
	var obj_id = obj.id;
	for (var i = 0; i < this.optCount; i++) {
		if (is.ie) {
			objImg = this.obj.all[this.id + "_img_" + i.toString()];
		} else {
			objImg = document.getElementById(this.id + "_img_" + i.toString());
		};
		if (objImg) {
			this.displayIndexes['opt' + i][0] = 0;
			this.setImageSrc(this.resourcesURL + this.imgNotChecked, objImg);
		};
		if (this.toggleName != "") {
			var s = this.toggleName;
			s = s.replace("%answer_num%", (i + 1));
			var o = pc[s];
			if (o) o.hide();
		};
	};
	if (is.ie) obj = this.obj.all[obj_id];
	else obj = document.getElementById(obj_id);

	this.setImageSrc(this.resourcesURL + this.imgChecked, obj);
	this.displayIndexes['opt' + checkNo][0] = 1;
	this.invokeEvent("Marked");

	if (this.toggleName != "") {
		var s = this.toggleName;
		s = s.replace("%answer_num%", (checkId + 1));
		var o = pc[s];
		if (o) o.show();
	};
};
//
// interactions
//

componentSingleChoice.prototype.interactionsCorrectResponsesCount = function() {
	var answerCount = 1;
	return answerCount;
};

componentSingleChoice.prototype.interactionsCorrectResponses = function() {
	return this.correctAnswersList;
};

componentSingleChoice.prototype.interactionsStudentResponse = function() {
	if (this.useCheckboxesSeparately) {
		var arr = this.getUserCorrCheckedAndCorrCount(this);
		return (arr[0] / arr[1]) * 100;
	};
	return this.getAnswer();
};

componentSingleChoice.prototype.interactionsCorrectResponsesAsText = function(index) {
	if (typeof(this.answerValuesString) != "undefined" && this.answerValuesString != "") {
		var ansArr = this.answerValuesString.split("||");
		var corArr = this.changeFromInt(this.correctAnswer).split("");
		var ans = "";
		var len = corArr.length;
		for (var i = 0; i < len; i++) {
			if (corArr[len-1-i] == 1) {
				if (ans != "") ans += " ";
				ans += escape(ansArr[i]);
			};
		};
		if (typeof(ans) != "undefined" && ans != "") {
			return ans;
		} else {
			return this.interactionsCorrectResponses(index);
		};
	} else {
		return this.interactionsCorrectResponses(index);
	};
};

componentSingleChoice.prototype.interactionsStudentResponseAsText = function() {
	if (this.useCheckboxesSeparately) {
		var arr = this.getUserCorrCheckedAndCorrCount(this);
		return (arr[0] / arr[1]) * 100 + '%';
	};
	if (typeof(this.answerValuesString) != "undefined" && this.answerValuesString != "") {
		var ans = "";
		var ansArr = this.answerValuesString.split("||");
		var u_ans = this.interactionsStudentResponse();
		if (u_ans == "" || u_ans == "0") 
			return ans;
		var corArr = this.changeFromInt(this.interactionsStudentResponse());
		var len = corArr.length;
		for (var i = 0; i < len; i++) {
			if (corArr.charAt(len-1-i) == "1") {
				if (ans != "") ans += " ";
				ans += escape(ansArr[i]);
			};
		};
		if (typeof(ans) != "undefined" && ans != "") {
			return ans;
		} else {
			return this.interactionsStudentResponse();
		};
	} else {
		return this.interactionsStudentResponse();
	};
};
