﻿module Quiz {
    export class Quiz extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;
        numberOfChecked: any;

        numberOfCorrect: any;

        Questions: any[];
        
        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }
        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            this.numberOfChecked = 0;
            this.createStaticGraphics();
            this.createStaticTexts();
            this.createQuestions();
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        createStaticGraphics() {
            if (this.Elements.StaticGraphics) {
                for (var i = 0; i < this.Elements.StaticGraphics.length; i++) {
                    var el = this.game.add.image(this.Elements.StaticGraphics[i].pos.x, this.Elements.StaticGraphics[i].pos.y, this.PREFIX + this.Elements.StaticGraphics[i].key);
                    this.addChild(el);
                }
            }
        }

        createStaticTexts() {
            
            for (var i = 0; i < this.Elements.StaticTexts.length; i++) {
                
                var el = this.game.add.text(0, 0, this.Elements.StaticTexts[i].Text, this.Elements.StaticTexts[i].Style);
                this.addChild(el);
                var posX = this.Elements.StaticTexts[i].Position.x;
                var posY = this.Elements.StaticTexts[i].Position.y;
               
                el.position.set(posX + this.getJustedPositionX(this.Elements.StaticTexts[i].Position.JustX, el), posY + this.getJustedPositionY(this.Elements.StaticTexts[i].Position.JustY, el));

                el.align = <string>(this.Elements.StaticTexts[i].Position.JustX).toLowerCase();
            }
            
        }

        createQuestions() {
            this.Questions = [];
            for (var i = 0; i < this.Elements.Questions.length; i++) {
               
                var el = this.game.add.text(0, 0, this.Elements.Questions[i].QuestionText, this.Elements.Questions[i].QuestionStyle);
                this.addChild(el);
                var posX = this.Elements.Questions[i].Position.x;
                var posY = this.Elements.Questions[i].Position.y;
                el.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, el), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, el));
                el.align = <string>(this.Elements.Questions[i].Just).toLowerCase();
                var Answers = [];
                for (var j = 0; j < this.Elements.Questions[i].Answers.length; j++) {
                    var ans = this.game.add.text(0, 0, this.Elements.Questions[i].Answers[j].Text, this.Elements.Questions[i].AnswerFont);
                    this.addChild(ans);
                    ans.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, ans),
                        posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, ans) +
                        (j + 1) * this.Elements.Questions[i].Spacing + el.height + j * ans.height);
                    ans.inputEnabled = true;
                    ans.align = <string>(this.Elements.Questions[i].Just).toLowerCase();
                    ans.events.onInputOver.add(this.onInputOver, this);
                    ans.events.onInputOut.add(this.onInputOut, this);
                    ans.events.onInputDown.add(this.onInputDown, this);
                    Answers.push({
                        "Element": ans,
                        "isTrue": this.Elements.Questions[i].Answers[j].isTrue
                    });
                }
                this.Questions.push({
                    "Text": this.Elements.Questions[i].QuestionText,
                    "Answers": Answers
                });
            }
        }

        private getJustedPositionX(just, element) {
            var posX = 0;
            switch (just) {
                case "Center":
                    posX += (Global.Main.mainContainerDims.wd - 120) / 2 - element.width / 2;
                    break;
                case "Right":
                    posX += Global.Main.mainContainerDims.wd - 120 - element.width;
                    break;
            }
            return posX;
        }

        private getJustedPositionY(just, element) {
            var posY = 0;
            switch (just) {
                case "Center":
                    posY += (Global.Main.mainContainerDims.hg - 65) / 2 - element.height / 2;
                    break;
                case "Bottom":
                    posY += Global.Main.mainContainerDims.hg - 65 - element.height;
                    break;
            } 
            return posY;
        }

        //input

        private onInputOver(el: Phaser.Text, pointer) {
            el.alpha = 0.5;
        }

        private onInputOut(el: Phaser.Text, pointer) {
            el.alpha = 1.0;
        }

        private onInputDown(el: Phaser.Text, pointer) {
            if (el.name == "checked") {
                el.setShadow(0, 0, "black");
                this.numberOfChecked--;
                el.name = "unchecked";
            }
            else {
                el.setShadow(el.height / 25, el.height / 25, "red");
                this.numberOfChecked++;
                el.name = "checked";
            }

           this.checkIfEverythingIsCorrect()
        }


        private checkIfEverythingIsCorrect() {
            var srt = "Points: " + this.calculatePlayerPoints()
                + "/" + this.calculateMaxPoints();
            EU.Log(srt);
            EU.Log("Checked: " + this.numberOfChecked);

            if (this.calculatePlayerPoints() == this.calculateMaxPoints()
                && this.numberOfChecked == this.calculateMaxPoints()) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
          
        }

        private calculateMaxPoints() {
            var points = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j<this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue) points++;
                }
            }    
            return points;      
        }

        private calculatePlayerPoints() {
            var points = 0;
            this.numberOfCorrect = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue && this.Questions[i].Answers[j].Element.name == "checked") points++;
                }
            }    
            return points;
        }

    }
}