var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Coloring;
(function (_Coloring) {
    var Coloring = (function (_super) {
        __extends(Coloring, _super);
        function Coloring(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.activeColor = 0xffffff;
            this.egg = [];
        }
        Coloring.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
        };
        Coloring.prototype.preload = function () {
            _super.prototype.preload.call(this);
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.game.load.start();
        };
        Coloring.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.drawPalette();
            if (MODULE == "MW_I_1")
                this.drawButterfly();
            if (MODULE == "MW_I_5")
                this.drawEgg();
            if (MODULE == "MW_I_9")
                this.drawLeaf();
            if (MODULE == "MW_I_10")
                this.drawShape();
        };
        Coloring.prototype.changeTilt = function (sprite, pointer) {
            sprite.tint = this.activeColor;
            if (MODULE == "MW_I_1")
                if (this.checkButterfly())
                    EU.setGameCompletion(this.parent, 1);
                else
                    EU.setGameCompletion(this.parent, 0);
            if (MODULE == "MW_I_5")
                if (this.checkEgg())
                    EU.setGameCompletion(this.parent, 1);
                else
                    EU.setGameCompletion(this.parent, 0);
            if (MODULE == "MW_I_9")
                if (this.checkLeaf())
                    EU.setGameCompletion(this.parent, 1);
                else
                    EU.setGameCompletion(this.parent, 0);
            if (MODULE == "MW_I_10")
                if (this.checkShape())
                    EU.setGameCompletion(this.parent, 1);
                else
                    EU.setGameCompletion(this.parent, 0);
        };
        Coloring.prototype.drawPalette = function () {
            var paletteRed = this.game.add.sprite(20, 0, 'paletteRed');
            paletteRed.inputEnabled = true;
            paletteRed.input.pixelPerfectClick = true;
            paletteRed.events.onInputDown.add(function () {
                this.activeColor = 0xd4213d;
            }, this);
            this.addChild(paletteRed);
            var paletteGreen = this.game.add.sprite(20, 90, 'paletteGreen');
            paletteGreen.inputEnabled = true;
            paletteGreen.input.pixelPerfectClick = true;
            paletteGreen.events.onInputDown.add(function () {
                this.activeColor = 0x80CE1B;
            }, this);
            this.addChild(paletteGreen);
            var paletteBlue = this.game.add.sprite(20, 180, 'paletteBlue');
            paletteBlue.inputEnabled = true;
            paletteBlue.input.pixelPerfectClick = true;
            paletteBlue.events.onInputDown.add(function () {
                this.activeColor = 0x339EFF;
            }, this);
            this.addChild(paletteBlue);
            var paletteYellow = this.game.add.sprite(20, 270, 'paletteYellow');
            paletteYellow.inputEnabled = true;
            paletteYellow.input.pixelPerfectClick = true;
            paletteYellow.events.onInputDown.add(function () {
                this.activeColor = 0xFFE131;
            }, this);
            this.addChild(paletteYellow);
            var paletteWhite = this.game.add.sprite(20, 360, 'paletteWhite');
            paletteWhite.inputEnabled = true;
            paletteWhite.input.pixelPerfectClick = true;
            paletteWhite.events.onInputDown.add(function () {
                this.activeColor = 0xE9E8E7;
            }, this);
            this.addChild(paletteWhite);
            var palettePink = this.game.add.sprite(20, 450, 'palettePink');
            palettePink.inputEnabled = true;
            palettePink.input.pixelPerfectClick = true;
            palettePink.events.onInputDown.add(function () {
                this.activeColor = 0xff5cae;
            }, this);
            this.addChild(palettePink);
            var paletteViolet = this.game.add.sprite(20, 540, 'paletteViolet');
            paletteViolet.inputEnabled = true;
            paletteViolet.input.pixelPerfectClick = true;
            paletteViolet.events.onInputDown.add(function () {
                this.activeColor = 0x6D2BED;
            }, this);
            this.addChild(paletteViolet);
            var paletteOrange = this.game.add.sprite(20, 630, 'paletteOrange');
            paletteOrange.inputEnabled = true;
            paletteOrange.input.pixelPerfectClick = true;
            paletteOrange.events.onInputDown.add(function () {
                this.activeColor = 0xf28d20;
            }, this);
            this.addChild(paletteOrange);
            var paletteBrown = this.game.add.sprite(20, 720, 'paletteBrown');
            paletteBrown.inputEnabled = true;
            paletteBrown.input.pixelPerfectClick = true;
            paletteBrown.events.onInputDown.add(function () {
                this.activeColor = 0x843617;
            }, this);
            this.addChild(paletteBrown);
        };
        Coloring.prototype.drawButterfly = function () {
            this.butterfly = [];
            for (var i = 1; i < 9; i++) {
                this.butterfly[i] = this.game.add.sprite(400, 0, String('MW_KP_I_motyl_' + i));
                this.butterfly[i].inputEnabled = true;
                this.butterfly[i].input.pixelPerfectClick = true;
                this.butterfly[i].events.onInputDown.add(this.changeTilt, this);
                this.addChild(this.butterfly[i]);
            }
        };
        Coloring.prototype.drawLeaf = function () {
            this.leaf = [];
            for (var i = 1; i < 5; i++) {
                this.leaf[i] = this.game.add.sprite(400, 0, String('liscie_' + i));
                this.leaf[i].inputEnabled = true;
                this.leaf[i].input.pixelPerfectClick = true;
                this.leaf[i].events.onInputDown.add(this.changeTilt, this);
                this.addChild(this.leaf[i]);
            }
        };
        Coloring.prototype.drawShape = function () {
            this.shape = [];
            for (var i = 1; i < 8; i++) {
                this.shape[i] = this.game.add.sprite(400, 0, String('MW_KP_I_10_' + i));
                this.shape[i].inputEnabled = true;
                this.shape[i].input.pixelPerfectClick = true;
                this.shape[i].events.onInputDown.add(this.changeTilt, this);
                this.addChild(this.shape[i]);
            }
        };
        Coloring.prototype.checkButterfly = function () {
            var yellow = false;
            var green = false;
            var violet = false;
            var other = false;
            for (var i = 1; i < 9; i++) {
                if (this.butterfly[i].tint == 0xFFE131)
                    yellow = true;
                if (this.butterfly[i].tint == 0x80CE1B)
                    green = true;
                if (this.butterfly[i].tint == 0x6D2BED)
                    violet = true;
                if (this.butterfly[i].tint != 0xFFE131 && this.butterfly[i].tint != 0x80CE1B && this.butterfly[i].tint != 0x6D2BED && this.butterfly[i].tint != 0xFFFFFF) {
                    other = true;
                }
            }
            if (yellow === true && green === true && violet === true && other === false)
                return true;
            return false;
        };
        Coloring.prototype.drawEgg = function () {
            for (var i = 1; i < 11; i++) {
                this.egg[i] = this.game.add.sprite(400, 0, String('MW_KP_I_5_pisanka_' + i));
                this.egg[i].inputEnabled = true;
                this.egg[i].input.pixelPerfectClick = true;
                this.egg[i].events.onInputDown.add(this.changeTilt, this);
                this.addChild(this.egg[i]);
            }
        };
        Coloring.prototype.checkEgg = function () {
            var red = false;
            var yellow = false;
            var blue = false;
            var green = false;
            for (var i = 1; i < 11; i++) {
                if (this.egg[i].tint == 0xd4213d)
                    red = true;
                if (this.egg[i].tint == 0xFFE131)
                    yellow = true;
                if (this.egg[i].tint == 0x339EFF)
                    blue = true;
                if (this.egg[i].tint == 0x80CE1B)
                    green = true;
            }
            if (red === true && yellow === true && blue === true && green === true)
                return true;
            return false;
        };
        Coloring.prototype.checkLeaf = function () {
            var red = false;
            var orange = false;
            var brown = false;
            for (var i = 1; i < 5; i++) {
                if (this.leaf[i].tint == 0xd4213d)
                    red = true;
                if (this.leaf[i].tint == 0xf28d20)
                    orange = true;
                if (this.leaf[i].tint == 0x843617)
                    brown = true;
            }
            if (red === true && orange === true && brown === true)
                return true;
            return false;
        };
        Coloring.prototype.checkShape = function () {
            var good = 0;
            var bad = 0;
            for (var i = 1; i < 8; i++) {
                if (i != 5)
                    if (this.shape[i].tint != 0xffffff)
                        good++;
                if (i == 5)
                    if (this.shape[i].tint == 0xffffff || this.shape[i].tint == 0xE9E8E7)
                        bad = 1;
                    else
                        bad = 0;
            }
            if (good == 5 && bad == 1)
                return true;
            else
                return false;
        };
        return Coloring;
    })(Base.BasicGroup);
    _Coloring.Coloring = Coloring;
})(Coloring || (Coloring = {}));
//# sourceMappingURL=Coloring.js.map