var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Connect;
(function (_Connect) {
    var colors = ["blue", "red", "green", "orange", "yellow", "pink", "magenta", "purple", "darkred", "lightseagreen"];
    var Connect = (function (_super) {
        __extends(Connect, _super);
        function Connect(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Connect.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        Connect.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Connect.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.GAME_TYPE = this.Elements.GameType;
            this.drawingsAreAnswers = this.Elements.DrawingsAreAnswers;
            this.createStaticElements();
            this.createDrawings();
            this.createAnswers();
        };
        Connect.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.length; i++) {
                    var el = this.game.add.image(this.Elements.StaticElements[i].pos.x, this.Elements.StaticElements[i].pos.y, this.PREFIX + this.Elements.StaticElements[i].key);
                    this.addChild(el);
                }
        };
        Connect.prototype.createDrawings = function () {
            this.shadow = [];
            this.drawings = [];
            this.connections = [];
            for (var i = 0; i < this.Elements.Drawings.el.length; i++) {
                var el = this.game.add.image(this.Elements.Drawings.el[i].pos.x, this.Elements.Drawings.el[i].pos.y, this.PREFIX + this.Elements.Drawings.el[i].key);
                var shad = this.game.add.image(this.Elements.Drawings.el[i].pos.x + 3, this.Elements.Drawings.el[i].pos.y + 10, this.PREFIX + this.Elements.Drawings.el[i].key);
                shad.alpha = 0;
                shad.tint = 0x000000;
                shad.inputEnabled = true;
                el.inputEnabled = true;
                el.events.onInputOver.add(this.onInputOver, this);
                el.events.onInputOut.add(this.onInputOut, this);
                if (this.drawingsAreAnswers) {
                    el.events.onInputDown.add(this.onDrawingAnswerClicked, this);
                }
                else {
                    el.events.onInputDown.add(this.onDrawingClicked, this);
                }
                this.drawings.push({
                    "el": el,
                    "val": this.Elements.Drawings.el[i].val,
                    "lineStyleX": this.Elements.Drawings.el[i].lineStyleX,
                    "lineStyleY": this.Elements.Drawings.el[i].lineStyleY
                });
                this.shadow.push(shad);
                this.addChild(shad);
                this.addChild(el);
            }
        };
        Connect.prototype.createAnswers = function () {
            this.answers = [];
            for (var i = 0; i < this.Elements.Answers.el.length; i++) {
                var el = this.game.add.image(this.Elements.Answers.el[i].pos.x, this.Elements.Answers.el[i].pos.y, this.PREFIX + this.Elements.Answers.el[i].key);
                el.inputEnabled = true;
                el.events.onInputDown.add(this.createConnectionOnClick, this);
                this.answers.push({
                    "el": el,
                    "val": this.Elements.Answers.el[i].val,
                    "lineStyleX": this.Elements.Answers.el[i].lineStyleX,
                    "lineStyleY": this.Elements.Answers.el[i].lineStyleY
                });
                this.addChild(el);
            }
        };
        Connect.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        Connect.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        Connect.prototype.onDrawingClicked = function (el, pointer) {
            var elementIndex = this.getElementIndex(el, this.drawings);
            if ((this.GAME_TYPE == "ManyToMany" || this.GAME_TYPE == "OneToMany" || !this.checkIfDrawingHasConnection(elementIndex))) {
                if (!this.checkIfDrawingMarked()) {
                    this.shadow[elementIndex].alpha = 0.3;
                }
                else {
                    this.shadow[elementIndex].alpha = 0;
                }
            }
        };
        Connect.prototype.onDrawingAnswerClicked = function (el, pointer) {
            var elementIndex = this.getElementIndex(el, this.drawings);
            if ((this.GAME_TYPE == "ManyToMany" || this.GAME_TYPE == "OneToMany") || (!this.checkIfDrawingHasConnection(elementIndex) && !this.checkIfAnswerHasConnection(elementIndex))) {
                if (!this.checkIfDrawingMarked()) {
                    this.shadow[elementIndex].alpha = 0.3;
                }
                else {
                    this.shadow[elementIndex].alpha = 0;
                }
            }
            if (this.shadow[elementIndex].alpha == 0 && (!this.checkIfDrawingHasConnection(elementIndex) && !this.checkIfAnswerHasConnection(elementIndex)) && this.checkIfDrawingMarked()) {
                this.createConnectionIfDaA(el, this.checkIfDrawingMarked().index, elementIndex);
            }
        };
        Connect.prototype.onConnectionClicked = function (el, pointer) {
            for (var i = 0; i < this.connections.length; i++) {
                if (this.connections[i].img == el) {
                    el.destroy();
                    this.connections.splice(i, 1);
                }
            }
        };
        Connect.prototype.createConnectionOnClick = function (el, pointer) {
            var answerIndex = this.getElementIndex(el, this.answers);
            this.createConnection(el, answerIndex);
        };
        Connect.prototype.createConnection = function (element, answerIndex) {
            if (this.GAME_TYPE == "ManyToOne" || this.GAME_TYPE == "ManyToMany" || !this.checkIfAnswerHasConnection(answerIndex)) {
                var img;
                if (img = this.checkIfDrawingMarked()) {
                    var connection = {
                        DrawingIndex: null,
                        AnswerIndex: null,
                        img: null
                    };
                    connection['DrawingIndex'] = img.index;
                    connection['AnswerIndex'] = answerIndex;
                    this.addConnectionToArray(connection, this.connections, this.drawings, this.answers);
                    EU.Log(this.checkIfConnectionIsCorrect(connection, this.drawings, this.answers));
                    this.clearMarkedDrawings();
                    this.debugPoints();
                    this.checkIfEverythingIsCorrect();
                }
            }
        };
        Connect.prototype.createConnectionIfDaA = function (element, answerIndex, drawingIndex) {
            var connection = {
                DrawingIndex: drawingIndex,
                AnswerIndex: answerIndex,
                img: null
            };
            this.addConnectionToArray(connection, this.connections, this.drawings, this.drawings);
            EU.Log(this.checkIfConnectionIsCorrect(connection, this.drawings, this.drawings));
            this.clearMarkedDrawings();
            this.debugPoints();
            this.checkIfEverythingIsCorrect();
        };
        Connect.prototype.clearMarkedDrawings = function () {
            for (var i = 0; i < this.shadow.length; i++) {
                this.shadow[i].alpha = 0;
            }
        };
        Connect.prototype.getElementIndex = function (element, array) {
            for (var i = 0; i < array.length; i++) {
                if (array[i].el.key == element.key)
                    return i;
            }
        };
        Connect.prototype.randomColor = function () {
            return Phaser.Math.getRandom(colors, 0, colors.length);
        };
        Connect.prototype.addConnectionToArray = function (connection, array, drawings, answers) {
            for (var i = 0; i < array.length; i++) {
                if (connection.DrawingIndex == array[i].DrawingIndex && connection.AnswerIndex == array[i].AnswerIndex) {
                    return false;
                }
            }
            connection['img'] = this.drawStyledConnection(drawings[connection.DrawingIndex], answers[connection.AnswerIndex]);
            array.push(connection);
            return true;
        };
        Connect.prototype.drawStyledConnection = function (drawing, answer) {
            var x1, y1, x2, y2;
            y1 = drawing.el.y + drawing.el.height / 2 + drawing.lineStyleY / 200 * drawing.el.height;
            y2 = answer.el.y + answer.el.height / 2 + answer.lineStyleY / 200 * answer.el.height;
            x1 = drawing.el.x + drawing.el.width / 2 + drawing.lineStyleX / 200 * drawing.el.width;
            x2 = answer.el.x + answer.el.width / 2 + answer.lineStyleX / 200 * answer.el.width;
            ;
            return this.drawConnection(x1, y1, x2, y2);
        };
        Connect.prototype.drawConnection = function (x1, y1, x2, y2) {
            var lineWidth = 12;
            var lineLength = Phaser.Math.distance(x1, y1, x2, y2);
            var lineAngle = Phaser.Math.angleBetween(x1, y1, x2, y2);
            this.bmd = this.game.add.bitmapData(lineLength, lineWidth);
            this.bmd.ctx.beginPath();
            this.bmd.ctx.strokeStyle = this.randomColor();
            this.bmd.ctx.stroke();
            this.line = this.game.add.sprite(x1, y1, this.bmd);
            this.line.anchor.y = 0.5;
            this.line.smoothed = true;
            this.line.angle = Phaser.Math.radToDeg(lineAngle);
            this.line.inputEnabled = true;
            this.line.events.onInputOver.add(this.onInputOver, this);
            this.line.events.onInputOut.add(this.onInputOut, this);
            this.line.events.onInputDown.add(this.onConnectionClicked, this);
            this.addChild(this.line);
            this.bmd.ctx.beginPath();
            this.bmd.ctx.moveTo(0, lineWidth / 2);
            this.bmd.ctx.lineTo(lineLength, lineWidth / 2);
            this.bmd.ctx.lineWidth = lineWidth;
            this.bmd.ctx.stroke();
            this.bmd.ctx.closePath();
            this.bmd.render();
            return this.line;
        };
        Connect.prototype.checkIfDrawingMarked = function () {
            for (var i = 0; i < this.shadow.length; i++) {
                if (this.shadow[i].alpha == 0.3) {
                    var temp = {
                        index: i,
                        el: this.shadow[i]
                    };
                    return temp;
                }
            }
        };
        Connect.prototype.checkIfAnswerHasConnection = function (answerIndex) {
            for (var i = 0; i < this.connections.length; i++) {
                if (this.connections[i].AnswerIndex == answerIndex) {
                    return true;
                }
            }
            return false;
        };
        Connect.prototype.checkIfDrawingHasConnection = function (drawingIndex) {
            for (var i = 0; i < this.connections.length; i++) {
                if (this.connections[i].DrawingIndex == drawingIndex) {
                    return true;
                }
            }
            return false;
        };
        Connect.prototype.checkIfConnectionIsCorrect = function (connection, drawings, answers) {
            if (answers[connection.AnswerIndex].val == drawings[connection.DrawingIndex].val) {
                return true;
            }
            return false;
        };
        Connect.prototype.checkIfEverythingIsCorrect = function () {
            if (this.calculateMaxPoints() == this.calculatePlayerPoints() && this.connections.length == this.calculatePlayerPoints()) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Everyting Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        };
        Connect.prototype.calculatePlayerPoints = function () {
            var points = 0;
            if (this.drawingsAreAnswers) {
                for (var i = 0; i < this.connections.length; i++) {
                    if (this.checkIfConnectionIsCorrect(this.connections[i], this.drawings, this.drawings)) {
                        points++;
                    }
                }
            }
            else {
                for (var i = 0; i < this.connections.length; i++) {
                    if (this.checkIfConnectionIsCorrect(this.connections[i], this.drawings, this.answers)) {
                        points++;
                    }
                }
            }
            return points;
        };
        Connect.prototype.calculateMaxPoints = function () {
            var points = 0;
            if (this.drawingsAreAnswers) {
                for (var i = 0; i < this.drawings.length; i++) {
                    for (var j = i + 1; j < this.drawings.length; j++) {
                        if (this.drawings[i].val == this.drawings[j].val) {
                            points++;
                            if (this.GAME_TYPE == "OneToOne" || this.GAME_TYPE == "ManyToOne")
                                break;
                        }
                    }
                }
            }
            else {
                for (var i = 0; i < this.drawings.length; i++) {
                    for (var j = 0; j < this.answers.length; j++) {
                        if (this.drawings[i].val == this.answers[j].val) {
                            points++;
                            if (this.GAME_TYPE == "OneToOne" || this.GAME_TYPE == "ManyToOne")
                                break;
                        }
                    }
                }
            }
            return points;
        };
        Connect.prototype.debugConnections = function () {
            for (var i = 0; i < this.connections.length; i++) {
                EU.Log(this.connections[i].DrawingIndex + " " + this.connections.length);
            }
        };
        Connect.prototype.debugPoints = function () {
            var playerPoints = this.calculatePlayerPoints();
            var maxPoints = this.calculateMaxPoints();
            EU.Log("NumberOfConnections: " + this.connections.length + " Correct: " + playerPoints + " MaxCorrect: " + maxPoints);
        };
        Connect.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        return Connect;
    })(Base.BasicGroup);
    _Connect.Connect = Connect;
})(Connect || (Connect = {}));
//# sourceMappingURL=Connect.js.map