﻿module Blank {
    export class Blank extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            EU.setGameCompletion(this.parent, 1);
            
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        checkIfEverythingIsCorrect() {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this)) EU.Log("Correct!!!");
        }
    }
}