var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var WordSearch;
(function (_WordSearch) {
    var WordSearch = (function (_super) {
        __extends(WordSearch, _super);
        function WordSearch(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        WordSearch.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        WordSearch.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        WordSearch.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.numberOfChecked = 0;
            this.createStaticElements();
            this.createCharTable();
        };
        WordSearch.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        WordSearch.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        };
        WordSearch.prototype.createCharTable = function () {
            this.CharTable = [];
            for (var i = 0; i < this.Elements.TableSize.Rows; i++) {
                for (var j = 0; j < this.Elements.TableSize.Columns; j++) {
                    var el = this.game.add.text(0, 0, this.Elements.CharTable[i * this.Elements.TableSize.Columns + j], this.Elements.Style);
                    var bg = this.drawRect("lightyellow", el.height, el.height);
                    var value = this.Elements.BoolTable[i * this.Elements.TableSize.Columns + j];
                    el.name = (i * this.Elements.TableSize.Columns + j).toString();
                    el.anchor.set(0.5, 0);
                    el.position.set(this.Elements.Position.x + j * bg.width + bg.width / 2, this.Elements.Position.y + i * bg.height);
                    el.inputEnabled = true;
                    el.events.onInputOver.add(this.onInputOver, this);
                    el.events.onInputOut.add(this.onInputOut, this);
                    el.events.onInputDown.add(this.onInputDown, this);
                    bg.position.set(this.Elements.Position.x + j * bg.width, this.Elements.Position.y + i * bg.height);
                    this.addChild(bg);
                    this.addChild(el);
                    this.CharTable.push({
                        "text": el,
                        "bg": bg,
                        "value": value,
                        "state": "unchecked"
                    });
                }
            }
        };
        WordSearch.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        WordSearch.prototype.drawRect = function (color, width, height) {
            var drawnObject;
            var bmd = this.game.add.bitmapData(width, height);
            bmd.ctx.beginPath();
            bmd.ctx.rect(0, 0, width, height);
            bmd.ctx.stroke();
            bmd.ctx.fillStyle = color;
            bmd.ctx.fill();
            bmd.ctx.stroke();
            return this.game.add.sprite(0, 0, bmd);
        };
        WordSearch.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        WordSearch.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        WordSearch.prototype.onInputDown = function (el, pointer) {
            if (this.CharTable[el.name].state == "unchecked") {
                this.CharTable[el.name].bg.tint = "0x99FF99";
                this.CharTable[el.name].state = "checked";
                this.numberOfChecked++;
            }
            else {
                this.CharTable[el.name].bg.tint = "0xFFFFFF";
                this.CharTable[el.name].state = "unchecked";
                this.numberOfChecked--;
            }
            this.checkIfEverythingIsCorrect();
        };
        WordSearch.prototype.checkIfEverythingIsCorrect = function () {
            var srt = "Points: " + this.calculatePlayerPoints() + "/" + this.calculateMaxPoints();
            EU.Log(srt);
            EU.Log("Checked: " + this.numberOfChecked);
            if (this.calculatePlayerPoints() == this.calculateMaxPoints() && this.numberOfChecked == this.calculateMaxPoints()) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        };
        WordSearch.prototype.calculateMaxPoints = function () {
            return (this.Elements.BoolTable.split("1").length - 1);
        };
        WordSearch.prototype.calculatePlayerPoints = function () {
            var points = 0;
            for (var i = 0; i < this.CharTable.length; i++) {
                if (this.CharTable[i].value == "1" && this.CharTable[i].state == "checked") {
                    points++;
                }
            }
            return points;
        };
        return WordSearch;
    })(Base.BasicGroup);
    _WordSearch.WordSearch = WordSearch;
})(WordSearch || (WordSearch = {}));
//# sourceMappingURL=WordSearch.js.map