var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Sequence_mod;
var zad_zaliczone = 0;
(function (_Sequence_mod) {
    var Sequence_mod = (function (_super) {
        __extends(Sequence_mod, _super);
        function Sequence_mod(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.topSeq = [];
            this.bottomSeq = [];
            this.correctSeq = [];
            this.icons = [];
            this.slots = [];
            this.xPos = 0;
        }
        Sequence_mod.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Sequence_mod.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Sequence_mod.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Sequence_mod.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.frames = this.Elements.Icons;
            this.xPos = (1920 / 2 - (this.frames * 300 + (this.frames - 1) * 20) / 2) - 120;
            for (var i = 0; i < this.frames; i++)
                this.addChild(this.slots[i] = new Icon(this.game, this.xPos + i * 300 + i * 20, 40, 'OS_g_II_12_empty', i * -1));
            this.btnStart = this.game.add.button(690, 500, 'button', this.btnHit, this);
            this.addChild(this.btnStart);
        };
        Sequence_mod.prototype.btnHit = function () {
            this.btnStart.visible = false;
            this.prepare();
        };
        Sequence_mod.prototype.prepare = function () {
            for (var i = 0; i < this.frames; i++)
                this.topSeq.push(0);
            for (var i = 1; i < 37; i++)
                this.correctSeq.push(i);
            this.correctSeq = this.shuffle(this.correctSeq);
            this.correctSeq = this.correctSeq.slice(0, this.frames);
            for (var i = 0; i < this.frames; i++) {
                this.icons[i] = new Icon(this.game, this.xPos + i * 300 + i * 20, 40, 'OS_g_II_12_' + this.correctSeq[i].toString(), this.correctSeq[i]);
                this.addChild(this.icons[i]);
            }
            this.game.time.events.add(Phaser.Timer.SECOND * this.frames, this.start, this);
        };
        Sequence_mod.prototype.start = function () {
            for (var i = 0; i < this.frames; i++)
                this.icons[i].kill();
            this.bottomSeq = this.correctSeq.slice();
            this.bottomSeq = this.shuffle(this.bottomSeq);
            for (var i = 0; i < this.frames; i++) {
                this.icons[i] = new Icon(this.game, this.xPos + i * 300 + i * 20, 400, 'OS_g_II_12_' + this.bottomSeq[i].toString(), this.bottomSeq[i]);
                this.icons[i].name = this.bottomSeq[i];
                this.icons[i].inputEnabled = true;
                this.icons[i].input.enableDrag(false, true);
                this.icons[i].events.onDragStop.add(this.stopDrag, this);
                this.addChild(this.icons[i]);
            }
        };
		Sequence_mod.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
        Sequence_mod.prototype.stopDrag = function (item) {
            var out = true;
            for (var slot = 0; slot < this.frames; slot++) {
                if (Phaser.Rectangle.intersects(item.rect, this.slots[slot].rect)) {
                    if (this.topSeq[slot] == 0) {
                        for (var i = 0; i < this.frames; i++)
                            if (this.topSeq[i] == item.id)
                                this.topSeq[i] = 0;
                        this.topSeq[slot] = item.id;
                    }
                    else
                        break;
                    this.game.add.tween(item).to({ x: this.slots[slot].x }, 500, Phaser.Easing.Cubic.Out, true);
                    this.game.add.tween(item).to({ y: this.slots[slot].y }, 500, Phaser.Easing.Cubic.Out, true);
                    out = false;
                    break;
                }
            }
            if (out) {
                for (var i = 0; i < this.frames; i++)
                    if (this.topSeq[i] == item.id) {
                        this.topSeq[i] = 0;
                        break;
                    }
                this.game.add.tween(item).to({ x: item.originX }, 500, Phaser.Easing.Cubic.Out, true);
                this.game.add.tween(item).to({ y: item.originY }, 500, Phaser.Easing.Cubic.Out, true);
            }
            if (this.topSeq.toString() == this.correctSeq.toString()) {
				zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
				var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
				next.scale.setTo(0.8,0.8);
				this.addChild(next);
                _super.prototype.nextTask.call(this);
            }
			else {
				zad_zaliczone = 0;
				console.log("zad_zaliczone = "+zad_zaliczone);
			}
        };
        Sequence_mod.prototype.shuffle = function (o) {
            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x)
                ;
            return o;
        };
        return Sequence_mod;
    })(Base.BasicGroup);
    _Sequence_mod.Sequence_mod = Sequence_mod;
    var Icon = (function (_super) {
        __extends(Icon, _super);
        function Icon(game, x, y, key, id) {
            this.originX = x;
            this.originY = y;
            this.id = id;
            this.rect = new Phaser.Rectangle(x, y, 300, 300);
            _super.call(this, game, x, y, key);
            this.events.onDragStop.add(this.updateCoord, this);
        }
        Icon.prototype.updateCoord = function () {
            this.rect = new Phaser.Rectangle(this.x, this.y, 300, 300);
        };
        return Icon;
    })(Phaser.Sprite);
})(Sequence_mod || (Sequence_mod = {}));
//# sourceMappingURL=Sequence_mod.js.map