﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
componentFlash = function(name)
{
	//inherited	
	this.componentElement = componentElement;
	this.componentElement(name);
	this.resourcesStatus = "online";
	this.resourcesURL = "";
	
	this.bgcolor = "transparent";
	this.quality = "high";
	this.loop = "true";
	this.wmode = "transparent";
	this.scale = "showall";
	this.salign = "CC";
	this.flashVars = "";
	
	this.isOldFlash = false; //pg2-could be local variable, but if preloader is enabled, this.wmode could be initialized during creation
	
	this.timerLoader = null; //pg2-audioOnOff_new
	this.timerCounterStartValue = 6;
	this.timerCounter = this.timerCounterStartValue;
};

componentFlash.prototype = new componentElement;
componentFlash.prototype.type = "componentFlash";

componentFlash.prototype.getFlashMovieObject = function(movieName) 
{
	if (window.document[movieName]) {
		return window.document[movieName];
	};
	if (navigator.appName.indexOf("Microsoft Internet")==-1) {
		if (document.embeds && document.embeds[movieName]) {
			return document.embeds[movieName];
		};
	} else {
		return document.getElementById(movieName);
	};
};

componentFlash.prototype.onBaseCreate = function(obj)
{
	this.disableOnlineOfflineMix = true; //mk: flash CAN'T be loaded from other domain than course
	this.resourcesURL = resourcesURL;
	this.captureMouseEvents();
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
	};
    this.resourcesURL = unescape(this.resourcesURL);
};

componentFlash.prototype.onCreate = function(obj)
{
	if (is.ie) this.captureMouseEvents();
};

componentFlash.prototype.formatVar = function(s)
{
	var o = null;
	try {
		do {
			o = s.match(/%([A-Za-z0-9.\(\)'"]+)%/);
			if (o != null) {
				s = s.replace(o[0], encodeURI(eval(o[1])));
			};
		} while (o != null);
	} catch(e) {
		s = "";
		if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.formatVar() eval execution error\nMessage:\n' + e.message); //pg2
	};
	return s;
};

componentFlash.prototype.createFlashObject = function(obj)
{
	if (PageInterface.GetValue("state") == psDesigning) { //pg2-otherwise in case of new version of FlashPlayer (v11) there is a blank rect
		t = '<img src="' + this.resourcesURL + this.playerBackground + '" width="' + this.w + '" height="' + this.h + '"/>';
		this.setHTML(t);
		this.rendered = true;
		return;
	};

	var movieW = 0;
	var movieH = 0;
	if (this.showScrollbars) {
		movieW = this.movieWidth;
		movieH = this.movieHeight;
		this.obj.style.cssText += '; overflow: auto;';
	} else {
		movieW = this.w;
		movieH = this.h;
	};
	var t = "";
	var fv = "";
	if (PageInterface.GetValue("state") != psDesigning && lms) {
		if (config.FocusManegementForSynthesizer && (this.id.indexOf('flash_checked') > -1 || this.id.indexOf('flash_unchecked') > -1)) { //pg2-aps_test - elements that read if radio/check were checked/unchecked
			fv = "mediaStatus=" + "online" + "&" + this.formatVar(this.flashVars);
		} else
		fv = "mediaStatus=" + lms.mediaStatus() + "&" + this.formatVar(this.flashVars);
	};

	while (fv.indexOf('+') > -1) { //pg2- '+' in .setHTML() is converted in several ways, and finally simple '+' is passed as parameter and is missing in output flash
		fv = fv.replace('+', '_2B_'); //it will be converted to proper value '%2B' in 'element.js'
	};

	var backgroundColor = (this.useDefinedBG?this.bgColor:""); //pg2

	//pg2-scenes of old courses (WBTE v7.0.1.93 etc) exported from new WBTExpress- flash/simpleFlash has few additional properties
	if (typeof(this.wmode) == "undefined") {
		this.wmode = "transparent";
		this.isOldFlash = true;
	};

	if (is.ie) {
		t += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="https://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="'+ movieW +'" height="'+ movieH +'" id="'+ this.id +'flashPlayer" align="middle">';
		t += '  <param name="movie" value="'+ this.resourcesURL + this.src +'">';
		t += '  <param name="allowScriptAccess" value="sameDomain" />';
		t += '  <param name="BGColor" value="' + backgroundColor + '">';
		t += '  <param name="quality" value="' + this.quality + '">';
		t += '  <param name="play" value="false">';
		t += '  <param name="loop" value="' + this.loop + '">';
		t += '  <param name="WMode" value="' + this.wmode + '">';
		t += '  <param name="scale" value="' + this.scale + '">';
		t += '  <param name="salign" value="' + this.salign + '">';
		t += '  <param name="FlashVars" value="' + this.flashVars + '">'; //&veriable_1=value_1&veriable_2=value_2

		t+= '   <param name="allowFullScreen" value="true">';

		t += '</object>';
	} else {
		t += '  <embed ';
		t += 'wmode="' + this.wmode + '" ';
		t += 'src="'+ this.resourcesURL + this.src +'" ';
		t += 'quality="' + this.quality + '" ';
		t += 'BGColor="' + backgroundColor + '" ';
		t += 'id="'+ this.id +'flashPlayer" ';
		t += 'type="application/x-shockwave-flash" pluginspage="https://www.macromedia.com/go/getflashplayer" ';
		t += 'width="'+ movieW +'" ';
		t += 'height="'+ movieH +'" ';
		t += 'FlashVars="' + fv + '" ';

		if (!this.isOldFlash) { //pg2
			t += 'scale="' + this.scale + '" '; //pg2- missing parameters
			t += 'loop="' + this.loop + '" '; 
			t += 'salign="' + this.salign + '" ';
		};
		t += '  allowFullScreen="true" ';

		t += 'allowScriptAccess="sameDomain"> ';
		t += '</embed>';
	};
	this.setHTML(t);
};

componentFlash.prototype.onPaint = function(obj)
{
	if (!this.visible) return; //pg2-in case of FlashAudioPlayer and 'visibleIf=!page.pageVisited' despite page was visited, sound was played
	this.createFlashObject();
	var flashPlayer = document.getElementById(this.id + "flashPlayer");
	try {
		if (this.showAndStop) {
			if (typeof(flashPlayer.Stop) != 'undefined')
			flashPlayer.Stop();
		} else {
			if (typeof(flashPlayer.Play) != 'undefined')
			flashPlayer.Play();
		};
	} catch(e) {};
	this.startTimer(); //pg2-audioOnOff_new
};

componentFlash.prototype.componentFlashBaseSetSizeScaledElement = componentFlash.prototype.setSizeScaledElement;
componentFlash.prototype.setSizeScaledElement = function(x, y, w, h)
{
	var flashPlayer = document.getElementById(this.id + "flashPlayer");
	if (flashPlayer){
		flashPlayer.width = w;
		flashPlayer.height = h;
	};
	this.componentFlashBaseSetSizeScaledElement(x, y, w, h);
};

componentFlash.prototype.actionFlashPlay = function(obj)
{
	var flashPlayer = document.getElementById(this.id + "flashPlayer");
	try {
		if (typeof(flashPlayer.Play) != 'undefined')
		flashPlayer.Play();
	} catch(e) {
		showMessage("This flash file is generated in newest version of Flash Player and does not support Play method. If you want to avoid this message please use component Simple Flash.");
	};
};

componentFlash.prototype.actionFlashPlayAgain = function(obj)
{
	this.createFlashObject();
	
	var flashPlayer = document.getElementById(this.id + "flashPlayer");
	try {
		if (typeof(flashPlayer.Play) != 'undefined')
		flashPlayer.Play();
	} catch(e) {
		showMessage("This flash file is generated in newest version of Flash Player and does not support this method. If you want to avoid this message please use component Simple Flash.");
	};
};

componentFlash.prototype.actionMediaStop = function(obj)
{
	this.actionFlashStop();
};

componentFlash.prototype.actionMediaPlay = function(obj)
{
	this.actionFlashPlay();
};

componentFlash.prototype.actionFlashStop = function(obj)
{
	var flashPlayer = document.getElementById(this.id + "flashPlayer");
	try {
		this.clearObject();
	} catch(e) {
		if (obj == page) {
			this.clearObject();
		} else {
			showMessage("This flash file is generated in newest version of Flash Player and does not support Stop method. If you want to avoid this message please use component Simple Flash.");
		};
	};
};

componentFlash.prototype.clearObject = function(obj)
{
	//window.clearTimeout(this.timerLoader); //pg2-audioOnOff_new
	//this.timerLoader = null;
	
	this.setHTML(" ");
};

componentFlash.prototype.actionFlashRewind = function(obj)
{
	this.createFlashObject();
};

componentFlash.prototype.onFree = function() { //pg2-audioOnOff_new
	if (this.timerLoader != null) {
		window.clearTimeout(this.timerLoader);
		this.timerLoader = null;
	};
};

componentFlash.prototype.onShow = function() //pg2-audioOnOff_new
{
	this.timerCounter += 6;
	this.startTimer();
};

componentFlash.prototype.onHide = function() //pg2-stop plain on the page and within a container 
{
	this.setHTML(" ");
};

componentFlash.prototype.stopTimer = function() //pg2-audioOnOff_new
{
	if (this.timerLoader) {
		if (this.timerLoader != null) {
			window.clearTimeout(this.timerLoader);
			this.timerLoader = null;
		};
	};
};

componentFlash.prototype.startTimer = function() //pg2-audioOnOff_new
{
	this.stopTimer();
	this.timerLoader = window.setTimeout('pc.' + this.id + '.onPaintDelayed()', 500);
};

componentFlash.prototype.onPaintDelayed = function() //pg2-audioOnOff_new
{
	try {
		window.clearTimeout(this.timerLoader);
		this.timerLoader = null;
		
		this.timerCounterStartValue--;
		
		var obj = document.getElementById(this.id + 'flashPlayer');
		if (obj) {
			if (obj.flaFunctionID) {
				if (lms && lms.mediaStatus) {
					var mediaStatus = lms.mediaStatus();
					if (mediaStatus == "online") obj.flaFunctionID('turnOnSound'); else obj.flaFunctionID('turnOffSound');
				};
			};
		};
		if (this.timerCounterStartValue > 0) this.startTimer(); else this.timerCounter = this.timerCounterStartValue;
	} catch(e) {};
};
