﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentTextShadow = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);
	
	if (arguments[1]) {
	} else {
		this.shadowText = this.addChild(new componentText(null));
		this.text = this.addChild(new componentText(null));
	}
};

componentTextShadow.prototype = new componentElement();
componentTextShadow.prototype.type = "componentTextShadow";

componentTextShadow.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();
	if (this.execution) {
		this.shadowTextText = this.shadowTextText.replace(/(<img[^<>]*>)/ig,'<span style="visibility:hidden">$1</span>');
		this.shadowTextText = this.shadowTextText.replace(/(<a)([^<>]*>)/ig,'$1 style="color: '+this.shadowTextFontColor+'"$2');
		this.shadowTextText = this.shadowTextText.replace(/(<font color=#)(.{6})/ig,'<font color='+this.shadowTextFontColor);
		
		this.shadowTextFontFamily = this.textFontFamily;
		this.shadowTextFontSize = this.textFontSize;
		
		document.getElementById(this.id + "_contentObj").style.color = this.shadowTextFontColor;
		var shadow = document.getElementById(this.id + "_divShadowText");
		
		//pg2-izoo_shadowColor
		var shadowContentObj = document.getElementById(this.id + '_contentObj');
		if (shadowContentObj) shadowContentObj.innerHTML = this.shadowTextText;
		//...
		
		switch (this.shadowDirection)
		{
			case 0:
				shadow.style.left = this.shadowDistance;
				shadow.style.top  = this.shadowDistance;
				break;
			case 1:
				shadow.style.left = -this.shadowDistance;
				shadow.style.top = this.shadowDistance;
				break;
			case 2:
				shadow.style.left = this.shadowDistance;
				shadow.style.top = -this.shadowDistance;
				break;
			case 3:
				shadow.style.left = -this.shadowDistance;
				shadow.style.top = -this.shadowDistance;
				break;
			case 4:
				shadow.style.left = this.shadowDistance;
				shadow.style.top  = 0
				break;
			case 5:
				shadow.style.left = -this.shadowDistance;
				shadow.style.top  = 0;
				break;
			case 6:
				shadow.style.left = 0;
				shadow.style.top = -this.shadowDistance;
				break;
			case 7:
				shadow.style.left = 0;
				shadow.style.top = this.shadowDistance;
				break;
		};
	} else {
		this.shadowText.p_checkMarkers = this.p_checkMarkers;
		this.shadowText.p_checkPNG = this.p_checkPNG;
		this.shadowText.pngFix = this.pngFix;
		
		this.text.p_checkMarkers = this.p_checkMarkers;
		this.text.p_checkPNG = this.p_checkPNG;
		this.text.pngFix = this.pngFix;
		
		this.shadowText.text = this.shadowText.text.replace(/(<img[^<>]*>)/ig,'<span style="visibility:hidden">$1</span>');
		this.shadowText.text = this.shadowText.text.replace(/(<a)([^<>]*>)/ig,'$1 style="color: '+this.shadowText.font.color+'"$2');
		this.shadowText.text = this.shadowText.text.replace(/(<font color=#)(.{6})/ig,'<font color='+this.shadowText.font.color);
		
		this.shadowText.font.family = this.text.font.family;
		this.shadowText.font.size = this.text.font.size;
		
		switch (this.shadowDirection)
		{
			case 0:
				this.shadowText.x = this.text.x + this.shadowDistance;
				this.shadowText.y = this.text.y + this.shadowDistance;
				break;
			case 1:
				this.shadowText.x = this.text.x - this.shadowDistance;
				this.shadowText.y = this.text.y + this.shadowDistance;
				break;
			case 2:
				this.shadowText.x = this.text.x + this.shadowDistance;
				this.shadowText.y = this.text.y - this.shadowDistance;
				break;
			case 3:
				this.shadowText.x = this.text.x - this.shadowDistance;
				this.shadowText.y = this.text.y - this.shadowDistance;
				break;
			case 4:
				this.shadowText.x = this.text.x + this.shadowDistance;
				break;
			case 5:
				this.shadowText.x = this.text.x - this.shadowDistance;
				break;
			case 6:
				this.shadowText.y = this.text.y - this.shadowDistance;
				break;
			case 7:
				this.shadowText.y = this.text.y + this.shadowDistance;
				break;
		};
	}
};
